Rem
Rem $Header: netapp_filer_pkgdef.sql 31-mar-2005.04:45:17 ajayshar Exp $
Rem
Rem netapp_filer_pkgdef.sql
Rem
Rem Copyright (c) 2003, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      netapp_filer_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ajayshar    03/29/05 - ONTAP 7.x changes
Rem    ajere       01/11/05 - Add netapp_filer type constant 
Rem    ramalhot    08/31/04 - cutover to new assoc tables 
Rem    rpinnama    06/12/04 - Remove SET ECHO 
Rem    ajere       02/17/04 - Add type_meta_ver check, for backward 
Rem                           compatibility check with EM 4.0 
Rem    ajere       11/13/03 - Fixes for multiple metadata versions 
Rem    ajere       11/03/03 - Customize metrics in the summary page. 
Rem    hsu         06/29/03 - rm exit
Rem    ajere       06/26/03 - ajere_netappfiler1
Rem    ajere       06/26/03 - Created
Rem


CREATE OR REPLACE PACKAGE emd_mntr_filer AS

/* Target Type */
g_netapp_filer_target_type mgmt_targets.target_type%TYPE := 'netapp_filer';

/* Package level Type Definition */
TYPE cursorType IS REF CURSOR;


/*
Get the filer site map related info. This procedure returns all the relevant
information for a given filer target name and filer target type.
The values returned as OUT parameters are used for display in the
filerOverview page
*/

PROCEDURE getFilerSiteMapInfo
          (
            filer_target_name_in          IN  VARCHAR2,
            filer_target_type_in          IN  VARCHAR2,
            filer_type_display_name_out   OUT VARCHAR2,
            filer_avail_status_out        OUT NUMBER,
            filer_avail_pct_out           OUT NUMBER,
            filer_cpu_up_since_out        OUT DATE,
            filer_IP_address_out          OUT cursorType,
            filer_version_out             OUT VARCHAR2,
            filer_vendor_out              OUT NUMBER,
            filer_model_out               OUT VARCHAR2,
            filer_type_out                OUT VARCHAR2,
            filer_productid_out           OUT VARCHAR2,
            filer_cifs_enable_flag_out    OUT NUMBER,
            filer_vol_capacity_used_out   OUT NUMBER,
            filer_vol_capacity_tot_out    OUT NUMBER,
            filer_qtree_capacity_used_out OUT NUMBER,
            filer_qtree_capacity_tot_out  OUT NUMBER,
            filer_qtree_enable_flag_out   OUT NUMBER,
            filer_cluster_part_name_out   OUT VARCHAR2,
            filer_cluster_part_flag_out   OUT NUMBER,
            filer_monitoring_agent_out    OUT VARCHAR2,
            filer_host_name_out           OUT VARCHAR2,
            filer_aggr_cap_total_out      OUT NUMBER,
            filer_aggr_cap_alloc_out      OUT NUMBER,
            filer_flex_vol_cap_total_out  OUT NUMBER,
            filer_flex_vol_cap_alloc_out  OUT NUMBER,
            filer_version_bucket          OUT VARCHAR2
          );

PROCEDURE getFilerSummaryInfo
          (
            target_name_in        IN  VARCHAR2,
            target_type_in        IN  VARCHAR2,
            type_display_name_out OUT VARCHAR2,
            last_load_time_out    OUT DATE,
            emd_url_out           OUT VARCHAR2,
            thresholds_out        OUT cursorType,
            severities_out        OUT cursorType
          );        

PROCEDURE getFilerHealthInfo
          (
            target_name_in IN VARCHAR2,
            target_type_in IN VARCHAR2,
            health_tab_out OUT cursorType
          );

PROCEDURE reportFilerInfo
          (
            filer_target_name_in IN VARCHAR2
          );

PROCEDURE reportFilerSummaryInfo
          (
            target_name_in IN VARCHAR2, 
            target_type_in IN VARCHAR2
          );

PROCEDURE reportFilerHealthInfo
          (
            target_name_in IN VARCHAR2, 
            target_type_in VARCHAR2
          );

PROCEDURE reportFilerVolumeInfo
          (
            target_name_in IN VARCHAR2, 
            target_type_in IN VARCHAR2
          );

PROCEDURE reportFilerQtreesInfo
          (
            target_name_in IN VARCHAR2, 
            target_type_in IN VARCHAR2, 
            volume_name_in IN VARCHAR2
          );

PROCEDURE reportFilerPartnerInfo
          (
            target_name_in IN VARCHAR2, 
            target_type_in IN VARCHAR2
          );

PROCEDURE reportFilerGroupCapacity
          (
            target_name_in  IN VARCHAR2, 
            target_type_in  IN VARCHAR2, 
            mtarget_type_in IN VARCHAR2
          );

PROCEDURE reportFilerGroupTargets
          (
            target_name_in  IN VARCHAR2, 
            target_type_in  IN VARCHAR2, 
            mtarget_type_in IN VARCHAR2
          );

PROCEDURE reportFilerDiskInfo
          (
            target_name_in IN VARCHAR2, 
            target_type_in IN VARCHAR2, 
            volume_name_in IN VARCHAR2
          );


PROCEDURE getFilerGroupCapacity
          (
            target_name_in  IN  mgmt_targets.target_name%TYPE, 
            target_type_in  IN  mgmt_targets.target_type%TYPE,
            mtarget_type_in IN  mgmt_targets.target_type%TYPE,
            volume_tot_out  OUT NUMBER,
            volume_usd_out  OUT NUMBER,
            qtrees_tot_out  OUT NUMBER,
            qtrees_usd_out  OUT NUMBER
          );

PROCEDURE getFilerGroupTargets
          (
            target_name_in  IN  mgmt_targets.target_name%TYPE, 
            target_type_in  IN  mgmt_targets.target_type%TYPE,
            mtarget_type_in IN  mgmt_targets.target_type%TYPE,
            group_tgts_out  OUT cursorType
          );

PROCEDURE getFilerDiskInfo
          (
            target_name_in   IN  mgmt_targets.target_name%TYPE,
            target_type_in   IN  mgmt_targets.target_type%TYPE,
            volume_name_in   IN  mgmt_current_metrics.string_value%TYPE,
            disk_info_out    OUT cursorType
          );

FUNCTION getFilerMetricGuid
         (
           filer_target_type_in   IN mgmt_metrics.target_type%TYPE,
           filer_metric_name_in   IN mgmt_metrics.metric_name%TYPE,
           filer_metric_column_in IN mgmt_metrics.metric_column%TYPE,
           filer_type_meta_ver_in IN mgmt_targets.type_meta_ver%TYPE   DEFAULT ' ',
           l_category_prop1_in    IN mgmt_targets.CATEGORY_PROP_1%TYPE DEFAULT ' ',
           l_category_prop2_in    IN mgmt_targets.CATEGORY_PROP_2%TYPE DEFAULT ' ',
           l_category_prop3_in    IN mgmt_targets.CATEGORY_PROP_3%TYPE DEFAULT ' ',
           l_category_prop4_in    IN mgmt_targets.CATEGORY_PROP_4%TYPE DEFAULT ' ',
           l_category_prop5_in    IN mgmt_targets.CATEGORY_PROP_5%TYPE DEFAULT ' '
           
         ) RETURN mgmt_metrics.metric_guid%TYPE ;

FUNCTION getFilerTargetGuid
         (
           filer_target_type_in IN mgmt_targets.target_type%TYPE,
           filer_target_name_in IN mgmt_targets.target_name%TYPE
         ) RETURN mgmt_targets.target_guid%TYPE;

FUNCTION getFilerCurrentMetricValue
         (
           filer_target_guid_in IN mgmt_current_metrics.target_guid%TYPE,
           filer_metric_guid_in IN mgmt_current_metrics.metric_guid%TYPE
         ) RETURN mgmt_current_metrics.value%TYPE ;

FUNCTION getFilerCurrentMetricStrValue
         (
           filer_target_guid_in IN mgmt_current_metrics.target_guid%TYPE,
           filer_metric_guid_in IN mgmt_current_metrics.metric_guid%TYPE
         ) RETURN mgmt_current_metrics.string_value%TYPE ;

FUNCTION getFilerTotalValue
         (
           filer_target_guid_in IN mgmt_current_metrics.target_guid%TYPE,
           filer_metric_guid_in IN mgmt_current_metrics.metric_guid%TYPE
         ) RETURN mgmt_current_metrics.value%TYPE ;

FUNCTION getFilerVolumeTotalValue
         (
	   filer_target_guid_in IN mgmt_current_metrics.target_guid%TYPE,
	   filer_metric_guid_in IN mgmt_metrics.metric_guid%TYPE
         ) RETURN mgmt_current_metrics.value%TYPE ;

PROCEDURE getFilerVolumeInfo
          (
            target_name_in   IN  mgmt_targets.target_name%TYPE,
            target_type_in   IN  mgmt_targets.target_type%TYPE,
            volume_info_out  OUT cursorType
          );

PROCEDURE getFilerQtreeInfo
          (
            target_name_in   IN  mgmt_targets.target_name%TYPE,
            target_type_in   IN  mgmt_targets.target_type%TYPE,
            volume_name_in   IN  mgmt_current_metrics.string_value%TYPE,
            qtrees_tab_out   OUT cursorType
          );


PROCEDURE getFilerPartnerListInfo
          (
            target_name_in        IN  VARCHAR2,
            target_type_in        IN  VARCHAR2,
            type_display_name_out OUT VARCHAR2,
            target_summary_out    OUT cursorType
          );

PROCEDURE customizeSummaryPageMetrics
         ( user_name_in     IN VARCHAR2,
           callback_type_in IN NUMBER
         );

PROCEDURE getTargetMetadataVersion
          (
            target_name_in    IN  mgmt_targets.target_name%TYPE,
            target_type_in    IN  mgmt_targets.target_type%TYPE,
            metadata_ver_out  OUT mgmt_targets.type_meta_ver%TYPE
          );

PROCEDURE getFilerAlertsInfo
         (
           target_name_in  IN  VARCHAR2,
           target_type_in  IN  VARCHAR2,
           alerts_info_out OUT cursorType
         );

FUNCTION getFilerCollTimeStampCurr
         (
           filer_target_guid_in IN mgmt_current_metrics.target_guid%TYPE,
           filer_metric_guid_in IN mgmt_current_metrics.metric_guid%TYPE
         ) RETURN mgmt_current_metrics.collection_timestamp%TYPE ;

END emd_mntr_filer;
/
