Rem
Rem $Header: gensvc_avail_pkgdef.sql 27-jul-2005.15:44:01 mfidanbo Exp $
Rem
Rem gensvc_avail_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      gensvc_avail_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mfidanbo    07/27/05 - define another period for fast marker move 
Rem    scgrover    07/07/05 - add extended sql trace 
Rem    mfidanbo    05/25/05 - deregister avail api 
Rem    mfidanbo    05/12/05 - change test avail algorithm 
Rem    snakai      01/06/05 - fix reschedule of avail comp 
Rem    rmarripa    11/29/04 - add GET_SVC_EVAL_LOGIC 
Rem    snakai      11/24/04 - snakai_mta_2
Rem    snakai      11/11/04 - Created
Rem


-- Beacon Availability Package -------------------------------------------

CREATE OR REPLACE PACKAGE MGMT_GENSVC_AVAIL AS

--------------------------------------------------------------------------
PROCEDURE SET_BEACONS( p_target_name IN VARCHAR2,
                       p_target_type IN VARCHAR2,
                       p_beacon_list IN MGMT_GENSVC_TGT_NAME_ARRAY );

--------------------------------------------------------------------------
PROCEDURE SET_TESTS ( p_target_name IN VARCHAR2,
                      p_target_type IN VARCHAR2,
                      p_test_list IN MGMT_GENSVC_AV_TEST_ARRAY );

--------------------------------------------------------------------------
PROCEDURE ADD_TEST ( p_target_name IN VARCHAR2,
                     p_target_type IN VARCHAR2,
                     p_test IN MGMT_GENSVC_AV_TEST );

--------------------------------------------------------------------------
PROCEDURE REMOVE_TEST ( p_target_name IN VARCHAR2,
                        p_target_type IN VARCHAR2,
                        p_test IN MGMT_GENSVC_AV_TEST );

--------------------------------------------------------------------------
-- Availability evaluation logic
k_or_eval         CONSTANT NUMBER := 1;
k_and_eval        CONSTANT NUMBER := 2;
PROCEDURE SET_SVC_EVAL_LOGIC( p_target_name IN VARCHAR2,
                              p_target_type IN VARCHAR2,
                              p_eval_logic IN NUMBER );

--------------------------------------------------------------------------
--k_or_eval 
--k_and_eval   
-- -1 for no availability registration
FUNCTION GET_SVC_EVAL_LOGIC( p_target_name IN VARCHAR2,
                              p_target_type IN VARCHAR2) RETURN NUMBER;

--------------------------------------------------------------------------
PROCEDURE ENABLE_AVAIL( p_target_name IN VARCHAR2,
                        p_target_type IN VARCHAR2 );

--------------------------------------------------------------------------
PROCEDURE ENABLE_AVAIL( p_target_name IN VARCHAR2,
                        p_target_type IN VARCHAR2,
                        p_test_list IN MGMT_GENSVC_AV_TEST_ARRAY,
                        p_beacon_list IN MGMT_GENSVC_TGT_NAME_ARRAY,
                        p_eval_logic IN NUMBER);

--------------------------------------------------------------------------
PROCEDURE DEREGISTER_AVAIL( p_target_name IN VARCHAR2,
                            p_target_type IN VARCHAR2 );

--------------------------------------------------------------------------
PROCEDURE DISABLE_AVAIL( p_target_name IN VARCHAR2,
                         p_target_type IN VARCHAR2 );

--------------------------------------------------------------------------
FUNCTION IS_AVAIL_ENABLED( p_target_guid IN RAW )
RETURN BOOLEAN;

--------------------------------------------------------------------------
FUNCTION IS_AVAIL_BEACON( p_target_guid IN RAW, p_beacon_guid IN RAW )
RETURN BOOLEAN;

--------------------------------------------------------------------------
FUNCTION IS_BEACON( p_target_guid IN RAW )
RETURN BOOLEAN;

--------------------------------------------------------------------------
FUNCTION IS_TARGET_AVAIL_VIOL( p_target_guid IN RAW,
                               p_metric_guid IN RAW )
RETURN BOOLEAN;

--------------------------------------------------------------------------
FUNCTION IS_TEST_AVAIL_VIOL( p_target_guid IN RAW,
                             p_metric_guid IN RAW,
                             p_key_value IN VARCHAR2 )
RETURN BOOLEAN;

--------------------------------------------------------------------------
PROCEDURE SCHEDULE_TARGET_AVAIL( p_target_guid IN RAW );

--------------------------------------------------------------------------
PROCEDURE SCHEDULE_TEST_AVAIL( p_target_guid IN RAW,
                               p_key_value IN VARCHAR2 );

--------------------------------------------------------------------------
PROCEDURE BEACON_AVAIL_EVENT( p_beacon_guid IN RAW );

--------------------------------------------------------------------------
-- Events
k_event_change_avail   CONSTANT NUMBER := 1;
k_event_start_monit    CONSTANT NUMBER := 2;
k_event_stop_monit     CONSTANT NUMBER := 3;
PROCEDURE AVAIL_EVENT( p_target_name IN VARCHAR2,
                       p_target_type IN VARCHAR2,
                       p_test_name IN VARCHAR2,
                       p_test_type IN VARCHAR2,
                       p_beacon_name IN VARCHAR2,
                       p_event_code IN NUMBER,
                       p_event_desc IN VARCHAR2 );

--------------------------------------------------------------------------
FUNCTION PROCESS_UNREACHABLE( p_target_guid IN RAW )
RETURN BOOLEAN;

--------------------------------------------------------------------------
PROCEDURE PROCESS_AVAIL_BEACON( p_beacon_guid IN RAW );

--------------------------------------------------------------------------
PROCEDURE PROCESS_BLACKOUT_START ( p_target_guid IN RAW, p_timestamp IN DATE );

--------------------------------------------------------------------------
PROCEDURE PROCESS_BLACKOUT_END ( p_target_guid IN RAW, p_timestamp IN DATE );

--------------------------------------------------------------------------
PROCEDURE PROCESS_METRIC_ERROR ( p_target_guid IN RAW, 
                                 p_metric_guid IN RAW,
                                 p_test_guid IN VARCHAR2 );

--------------------------------------------------------------------------
PROCEDURE METRIC_ERROR_MSG( p_target_guid IN RAW, 
                            p_metric_guid IN RAW, 
                            p_collection_name IN VARCHAR2, 
                            p_agent_guid IN RAW, 
                            p_err_msg IN VARCHAR2, 
                            p_new_err_msg OUT VARCHAR2);

--------------------------------------------------------------------------
PROCEDURE EXEC_AVAIL_JOB;

--------------------------------------------------------------------------
-- Private Methods
--  These functions are not to be called directly.  They are exposed for
--  testing/debugging purposes.
--------------------------------------------------------------------------
PROCEDURE COMPUTE_TEST_AVAIL( p_target_guid IN RAW,
                              p_test_guid IN RAW,
                              p_next_run OUT NUMBER );

--------------------------------------------------------------------------
PROCEDURE COMPUTE_SVC_AVAIL( p_target_guid IN RAW,
                             p_next_run OUT NUMBER );


--------------------------------------------------------------------------
PROCEDURE DBMSJOB_EXTENDED_SQL_TRACE_ON(p_value IN BOOLEAN);

--------------------------------------------------------------------------
k_row_locked  EXCEPTION;
PRAGMA EXCEPTION_INIT(k_row_locked, -54);

--------------------------------------------------------------------------
MODULE_NAME CONSTANT VARCHAR2(32) := 'SVC_TEST_AVAIL';
EMDW_LOG_CTX CONSTANT VARCHAR2(32) := 'SVCTESTAVAIL';

-- Job Sleep Keys
min_job_sleep_key CONSTANT NUMBER := -1;
max_job_sleep_key CONSTANT NUMBER := -2;
init_job_sleep_key CONSTANT NUMBER := -3;
dep_job_sleep_key CONSTANT NUMBER := -4;

-- Default Values
k_min_job_sleep  CONSTANT NUMBER := 1;
k_max_job_sleep  CONSTANT NUMBER := 10;
k_init_job_sleep CONSTANT NUMBER := 5;
k_dep_job_sleep  CONSTANT NUMBER := 3;

-- Variables
v_min_job_sleep  NUMBER;
v_max_job_sleep  NUMBER;
v_init_job_sleep NUMBER;
v_dep_job_sleep  NUMBER;

-- Magic Number ID for No Test
k_no_test RAW(16) := HEXTORAW('FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF');

-- Trace Constants
k_trc_date_format CONSTANT VARCHAR2(32) := 'MM/DD/YY HH24:MI:SS';
k_trc_msg_len CONSTANT NUMBER := 1000;

EST_GENSVC_NAME CONSTANT VARCHAR2(32) := 'EST_GENSVC';

END MGMT_GENSVC_AVAIL;
/
--------------------------------------------------------------------------

SHOW ERRORS;

