Rem
Rem $Header: gensvc_montmpl_pkgdef.sql 26-aug-2005.12:03:15 mvajapey Exp $
Rem
Rem gensvc_montmpl_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      gensvc_montmpl_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mvajapey    08/26/05 - bug 4552869 - add boolean return parameter to 
Rem                           read_template saying if user has privileges on 
Rem                           all beacons. 
Rem    snakai      07/07/05 - remove obsolete apis 
Rem    mvajapey    04/14/05 - Add set_template_beacons api. 
Rem    snakai      02/18/05 - add delete_template api 
Rem    snakai      10/07/04 - snakai_svc_template_2
Rem    snakai      09/30/04 - add apply function 
Rem    snakai      09/28/04 - Created
Rem

CREATE OR REPLACE PACKAGE MGMT_GENSVC_MONTMPL AS


/*
  READ_TEMPLATE
  
  - p_obj_id: may refer to a target guid or a template guid
  - p_test_list: returns a list of txn guids
  - p_beacon_list: returns a list of beacon objects (name, guid, avail); only 
returns beacons for which the EM user has view privileges
  - p_variable_list: returns a list of variable objects (name, default value)
  - p_has_privileges: whether the user has view privileges on all the beacons 
in the template; in other words, whether p_beacon_list is the same as the list of
all beacons
*/
PROCEDURE READ_TEMPLATE ( p_obj_id IN VARCHAR2, 
                          p_test_list OUT MGMT_GENSVC_OBJID_ARRAY, 
                          p_beacon_list OUT MGMT_GENSVC_TMPL_BCN_ARRAY, 
                          p_variable_list OUT MGMT_GENSVC_TMPL_VAR_ARRAY,
                          p_has_privileges OUT VARCHAR2 );
                          
                          

/*
  DELETE_TEMPLATE

*/
PROCEDURE DELETE_TEMPLATE ( p_template_id IN RAW );


PROCEDURE WRITE_TEMPLATE ( p_template_id IN VARCHAR2, 
                           p_test_list IN MGMT_GENSVC_OBJID_ARRAY, 
                           p_variable_list IN MGMT_GENSVC_TMPL_VAR_ARRAY );

PROCEDURE SET_TEMPLATE_BEACONS( p_template_id IN VARCHAR2, 
                                p_beacon_list IN MGMT_GENSVC_TMPL_BCN_ARRAY);


END MGMT_GENSVC_MONTMPL;
/
SHOW ERRORS;
