Rem
Rem $Header: gensvc_tgt_pkgdef.sql 29-apr-2007.16:13:54 andyao Exp $
Rem
Rem gensvc_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      gensvc_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    andyao      04/29/07 - expose assoc beacons API
Rem    eporter     08/01/06 - Backport eporter_bug-5404472 from main
Rem    eporter     07/26/06 - Bug 5404472 
Rem    eporter     03/20/06 - add Business Metrics 
Rem    andyao      08/17/05 - add definition to populate default test 
Rem                           properties 
Rem    mvajapey    07/26/05 - Break set_mntr_states_for_tmpl into two APIs 
Rem                           (one to enable, one to disable). 
Rem    andyao      07/26/05 - fix bug 4518501 
Rem    rmarripa    07/12/05 - add beacon type meta ver update callback 
Rem    andyao      07/01/05 - use collections table for showing promote 
Rem                           metrics 
Rem    mfidanbo    05/06/05 - promotion cli support 
Rem    mvajapey    04/05/05 - Get rid of SET_MNTR_STATES_FOR_TGT. 
Rem    andyao      03/17/05 - add additional parameters to the service 
Rem                           creation 
Rem    mfidanbo    04/04/05 - add post gensvc deletion script 
Rem    mfidanbo    03/03/05 - job prefix should be the same as update beacon 
Rem    mvajapey    02/28/05 - Add function to set template test monitoring 
Rem                           settings. 
Rem    andyao      02/15/05 - fix bug 4126754 
Rem    andyao      02/11/05 - expose getTests 
Rem    andyao      02/07/05 - fix bug 4168678 
Rem    ramalhot    02/02/05 - changed signature for delete_service_callback 
Rem    andyao      12/29/04 - output availability state to system and 
Rem                           tests/bcns page 
Rem    mfidanbo    12/16/04 - add callback for service deletion 
Rem    andyao      12/05/04 - add set local beacon method 
Rem    andyao      12/01/04 - add getting system/tests/bcns for aggregate 
Rem                           metrics 
Rem    andyao      11/17/04 - modify set_svc_agg_metric_thresholds interface to take 
Rem                           6 values for default chart 
Rem    andyao      11/08/04 - add RCA Configuration 
Rem    andyao      10/25/04 - add method to save multiple transactions with 
Rem                           one PL/SQL 
Rem    andyao      10/19/04 - availability
Rem    andyao      10/06/04 - andyao_services2
Rem    rmarripa    09/21/04 - add PL/SQL for system metric promotion 
Rem    rmarripa    09/21/04 - add_set_system_and_props
Rem    rmarripa    09/20/04 - add more PL/SQL 
Rem    rmarripa    09/14/04 - .
Rem    rmarripa    09/14/04 - more sql 
Rem    rmarripa    09/13/04 - Created
Rem

CREATE OR REPLACE PACKAGE gensvc IS



TYPE PROPS_CURSOR IS REF CURSOR;
TYPE SERVICE_AGG_MET_THRESH_CURSOR IS REF CURSOR;
TYPE SERVICE_ASSOC_SYS_MEM_CURSOR IS REF CURSOR;
TYPE TESTS_CURSOR IS REF CURSOR;
TYPE STATES_IDS_CURSOR IS REF CURSOR;
TYPE BEACONS_CURSOR IS REF CURSOR;
TYPE METRIC_COLUMNS_CURSOR IS REF CURSOR;
TYPE METRIC_KEY_COLUMNS_CURSOR IS REF CURSOR;

G_MODULE_NAME constant VARCHAR2(20)          := 'GENSVC';
G_SYSTEM_BASED_AGG_METRIC constant NUMBER    := 1;
G_TEST_BASED_AGG_METRIC constant NUMBER      := 2;

-- PROCEDURE : GET_SYSTEM_COMPS_FOR_METR_PROM
--
-- PURPOSE
--   Retrieves the list of member targets of system from flat list of system associations. 
--   This will igonre the targets that do not have availability, member targets of 
--   targets with "is_cluster" property set. 
--
-- IN PARAMETERS
--   p_service_name              : service name
--   p_service_target_type       : service type
-- OUT PARAMETERS
--   p_system_name              : system name
--   p_system_system_type       : system type
--   p_member_targets           : List of member targets including is key or not
--   targets. 
--
-- EXCEPTION
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--
  
PROCEDURE GET_SYSTEM_COMPS_FOR_METR_PROM (p_service_name IN VARCHAR2, 
                                          p_service_target_type IN VARCHAR2, 
                                          p_system_name OUT VARCHAR2,
                                          p_system_target_type OUT VARCHAR2, 
                                          p_member_targets OUT SERVICE_ASSOC_SYS_MEM_CURSOR);


--
-- PROCEDURE : GET_SYSTEM_COMPS_FOR_AVAIL_SEL
--
-- PURPOSE
--   Retrieves the list of member targets of system from flat list of system associations. 
--   This will igonre the targets that do not have availability, member targets of 
--   targets with "is_cluster" property set. 
--
-- IN PARAMETERS
--   p_system_name              : target name
--   p_system_target_type       : target type
-- OUT PARAMETERS
--   p_system_timezone          : System time zone 
--   p_member_targets           : List of member targets eligible to choose as avaialbility 
--   targets. 
--
-- EXCEPTION
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--
  
PROCEDURE GET_SYSTEM_COMPS_FOR_AVAIL_SEL( p_system_name IN VARCHAR2, 
                                          p_system_target_type IN VARCHAR2, 
                                          p_system_timezone OUT VARCHAR2,
                                          p_member_targets OUT SERVICE_ASSOC_SYS_MEM_CURSOR); 

--
-- PROCEDURE : GET_ASSOC_SYS_COMP_DETAILS
--
-- PURPOSE
--   Retrieves the list of member targets of system from falt associations of system. 
--   This will igonre the targets that do not have availability, member targets of 
--   targets with "is_cluster" property set.  This procedure also retrieves the 
--   number of fault tests defined in the scope of service. It also identifies 
--   previously selected "key" components. 
--
-- IN PARAMETERS
--   p_service_name                : target name
--   p_service_target_type         : target type
-- OUT PARAMETERS
--   p_service_timezone            : Service time zone 
--   p_system_name                 : System target name 
--   p_system_target_type          : System target type 
--   p_system_timezone             : System time zone 
--   p_member_targets              : List of member targets eligible to choose as avaialbility 
--     targets
--   p_key_comps_info              : List of key components with the number of metric tests 
--     defined on each of them. 
--   p_avail_mode                  : The availability mode 
--   p_avail_eval_func             : The availability eval function
--
-- EXCEPTION
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--
  
PROCEDURE GET_SVC_ASSOC_SYS_COMP_DETAILS( p_service_name IN VARCHAR2, 
                                          p_service_target_type IN VARCHAR2,
                                          p_service_timezone OUT VARCHAR2, 
                                          p_service_props OUT PROPS_CURSOR,
                                          p_system_name OUT VARCHAR2, 
                                          p_system_target_type OUT VARCHAR2, 
                                          p_system_timezone OUT VARCHAR2, 
                                          p_system_members OUT SERVICE_ASSOC_SYS_MEM_CURSOR, 
                                          p_key_comps_info OUT SERVICE_ASSOC_SYS_MEM_CURSOR,
                                          p_avail_mode OUT VARCHAR2,
                                          p_avail_eval_func OUT VARCHAR2); 
--
-- PROCEDURE : GET_BUSINESS_SYS_MEMBERS
--
-- PURPOSE
--   For a given service, this function will return all of the member services
--   having business metrics.  For an aggregate service, all members are 
--   examined.  For a generic service, only key components are examined.
--   The customization framework is used. 
--
-- IN PARAMETERS
--   p_service_name                : target name
--   p_service_target_type         : target type
-- OUT PARAMETERS
--   p_member_targets              : List of member targets having business data
--
-- EXCEPTION
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--
  
PROCEDURE GET_BUSINESS_SYS_MEMBERS( p_service_name IN VARCHAR2, 
                                    p_service_target_type IN VARCHAR2,
                                    p_system_members OUT SERVICE_ASSOC_SYS_MEM_CURSOR); 

--
-- PROCEDURE : SET_SVC_AGG_METRIC_THRESHOLDS
--
-- PURPOSE
--   Sets Service aggregate metrics with all dependency metrics. It creates 
--   metric dependencies, deletes old metrics and modify existing dependencies. 
--   It also sets thresholds for the metrics. 
--
-- IN PARAMETERS
--   p_service_name              : target name
--   p_service_target_type       : target type
--   p_add_metrics               : List of new metrics to be added
--   p_delete_metrics            : List of old metrics to be deleted
--   p_modify_metrics            : List of existing metrics with new dependenccy metrics list
--   p_def_chart_perf_metric_name     : Metric name of default performance chart in Service homepage
--   p_def_chart_perf_metric_column   : Metric column of default performance chart in Service homepage
--   p_def_chart_perf_key_value       : Key value of default usage chart in Service homepage
--   p_def_chart_usge_metric_name     : Metric name of default usage chart in Service homepage
--   p_def_chart_usge_metric_column   : Metric column of default usage chart in Service homepage
--   p_def_chart_usge_key_value       : Key value of default usage chart in Service homepage
--
-- EXCEPTION
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--   INSUFFICIENT_PRIVILEGES: user doesn't have TARGET_OPERATOR privilidge on this service
--   INVALID_PARAMS_ERR: Invalid parameters
--
  
PROCEDURE SET_SVC_AGG_METRIC_THRESHOLDS( p_service_name IN VARCHAR2, 
                                         p_service_target_type IN VARCHAR2, 
                                         p_add_metrics IN MGMT_SVC_AGG_MET_THR_ARRAY,
                                         p_delete_metrics IN MGMT_METRIC_INSTANCE_ARRAY,
                                         p_modify_metrics IN MGMT_SVC_AGG_MET_THR_ARRAY,
                                         p_def_chart_perf_metric_name IN VARCHAR2,
                                         p_def_chart_perf_metric_column IN VARCHAR2, 
                                         p_def_chart_perf_key_value IN VARCHAR2,
                                         p_def_chart_usge_metric_name IN VARCHAR2,
                                         p_def_chart_usge_metric_column IN VARCHAR2,
                                         p_def_chart_usge_key_value IN VARCHAR2); 

--
-- PROCEDURE : GET_SVC_AGG_METRIC_THRESHOLDS
--
-- PURPOSE
--   Given service name, service target type and metric category, this procedures 
--   retrieves the list of metric thresholds and defaul chart metric for that 
--   category. 
--
-- IN PARAMETERS
--   p_service_name              : target name
--   p_target_type               : target type
--   p_metric_category           : Metric Category. Example, Usage/Reponse Time 
-- OUT PARAMETERS 
--   p_metric_thresh_list        : List of metrics with thresholds 
--   p_system_name               : The name of the associated system
--   p_system_type               : The type of the associated system
--   p_system_members            : A list of system components
--   p_service_tests             : A list of service tests
--   p_assoc_beacons             : A list of associated beacons
--   p_def_chart_metric_name     : Metric name of default chart in Service homepage
--   p_def_chart_metric_column   : Metric column of default chart in Service homepage
--   p_def_chart_key_value       : Key value of default chart in Service homepage
--
-- EXCEPTION
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--
  
PROCEDURE GET_SVC_AGG_METRIC_THRESHOLDS( p_service_name IN VARCHAR2, 
                                         p_service_target_type IN VARCHAR2, 
                                         p_metric_category IN VARCHAR2,
                                         p_thresholds OUT SERVICE_AGG_MET_THRESH_CURSOR,
                                         p_system_name OUT VARCHAR2,
                                         p_system_type OUT VARCHAR2,
                                         p_system_members OUT SERVICE_ASSOC_SYS_MEM_CURSOR,
                                         p_service_tests OUT TESTS_CURSOR,
                                         p_assoc_beacons OUT BEACONS_CURSOR,
                                         p_def_chart_metric_name OUT VARCHAR2,
                                         p_def_chart_metric_column OUT VARCHAR2, 
                                         p_def_chart_key_value OUT VARCHAR2 ); 

--
-- PROCEDURE : GET_SVC_AGG_METRIC_DEPS
--
-- PURPOSE
--   Given service name, service target type, metric name, metric column and 
--   key value, this procedures returns the aggregate metric type, list 
--   of metric dependencies and the evaluation function. 
--   category. 
--
-- IN PARAMETERS
--   p_source_metric    : Source metric name 
-- OUT PARAMETERS 
--   p_metric_deps      : Metric dependencies 
--
-- EXCEPTION
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--   INVALID_PARAMS_ERR: Invalid parameters
--
  
PROCEDURE GET_SVC_AGG_METRIC_DEPS( p_source_metric IN MGMT_METRIC_INSTANCE, 
                                   p_metric_deps OUT MGMT_SVC_AGG_METRIC_DEP) ; 

--
-- PROCEDURE : GET_SVC_AGG_MET_DTLS_FOR_EDIT 
--
-- PURPOSE
--   Given service name, service target type, metric name, metric column and 
--   key value, this procedures returns the aggregate metric type, list 
--   of metric dependencies, evaluation function and the either the list of 
--   system components or list of all tests. Any one of system components or 
--   tests will be null depending on the aggregate metric type. 
--   category. 
--
-- IN PARAMETERS
--   p_source_metric    : Source metric name 
-- OUT PARAMETERS 
--   p_metric_deps      : Metric dependencies 
--   p_system_members   : System members with key components identified. 
--   p_service_tests    : List of all tests with guids
--   p_assoc_beacons    : Associated beacons with key beacons identified
--   p_dep_column_label : Dependency metric column label for display
--   p_dep_column_nls_id: Dependency column nls id

--
-- EXCEPTION
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--   INVALID_PARAMS_ERR: Invalid parameters
--

PROCEDURE GET_SVC_AGG_MET_DTLS_FOR_EDIT( p_source_metric IN MGMT_METRIC_INSTANCE,
                                         p_system_name OUT VARCHAR2,
                                         p_system_type OUT VARCHAR2,
                                         p_metric_deps OUT MGMT_SVC_AGG_METRIC_DEP,
                                         p_system_members OUT SERVICE_ASSOC_SYS_MEM_CURSOR,
                                         p_service_tests OUT TESTS_CURSOR,
                                         p_assoc_beacons OUT BEACONS_CURSOR,
                                         p_dep_column_label OUT VARCHAR2,
                                         p_dep_column_nls_id OUT VARCHAR2
                                         ); 


--
--PURPOSE: Associates system and critical components with the servie. Also
--         change the properties
--PROCEDURE: SET_SYSTEM_AND_PROPS
--
PROCEDURE SET_SYSTEM_AND_PROPS(p_service_target_name IN VARCHAR2,
                               p_service_target_type IN VARCHAR2,
                               p_system_name IN VARCHAR2,
                               p_system_type IN VARCHAR2,
                               p_critical_components IN SMP_EMD_NVPAIR_ARRAY, 
                               p_service_props IN MGMT_TARGET_PROPERTY_LIST);

--                         
--PURPOSE: Removes the service association with the system and critical 
--         components and also stores properties. 
--PROCEDURE: REMOVE_SYSTEM_AND_SAVE_PROPS
--                         
PROCEDURE REMOVE_SYSTEM_AND_SAVE_PROPS(p_service_target_name IN VARCHAR2,
                                       p_service_target_type IN VARCHAR2,
                                       p_service_props IN MGMT_TARGET_PROPERTY_LIST); 


--
-- PROCEDURE : GET_SVC_DTLS_FOR_AVAIL 
--
-- PURPOSE
--   Given service name, service type, this procedures returns 
--   all the information necessary to render the availability definition page.
-- 
--   This includes the availability mode, avalability evaluation function,
--   the system name, system type, system timezone, system members, 
--   a list of service tests (including name, type, status, key, txnId, and 
--                            excluding the details such as properties)
--   a list of associated beacons.  
--
-- IN PARAMETERS
--   p_service_target_name:  The service name
--   p_service_target_type:  The service type 
--
-- OUT PARAMETERS 
--   p_avail_mode:           The availability mode 
--   p_avail_eval_func:      The availability eval function
--   p_system_name:          The system name
--   p_system_type:          The system type 
--   p_system_timezone:      The system time zone
--   p_system_members:       A list of component members of the associated system
--   p_key_system_members:   A list of key component members of the associated system
--   p_service_tests:        A list of service tests 
--   p_assoc_beacons:        A list of associated beacons 
--
-- EXCEPTION
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--   INVALID_PARAMS_ERR: Invalid parameters
--

PROCEDURE GET_SVC_DTLS_FOR_AVAIL (p_service_target_name IN VARCHAR2,
                                  p_service_target_type IN VARCHAR2,
                                  p_avail_mode         OUT VARCHAR2,
                                  p_avail_eval_func    OUT VARCHAR2,
                                  p_system_name        OUT VARCHAR2, 
                                  p_system_type        OUT VARCHAR2, 
                                  p_system_timezone    OUT VARCHAR2, 
                                  p_system_members     OUT SERVICE_ASSOC_SYS_MEM_CURSOR,
                                  p_key_system_members OUT SERVICE_ASSOC_SYS_MEM_CURSOR,
                                  p_service_tests      OUT TESTS_CURSOR,
                                  p_assoc_beacons      OUT BEACONS_CURSOR);
--
-- PROCEDURE : SET_SVC_DTLS_FOR_AVAIL 
--
-- PURPOSE
--   Update the availability status of the given service,
--   and replace the key tests and the key beacons with the latest set.
--
-- IN PARAMETERS
--   p_service_target_name:  The service name
--   p_service_target_type:  The service type 
--   p_avail_mode:           The availability mode 
--   p_avail_eval_func:      The availability eval function
--   p_service_key_comps:    A list of key system component name/types associated with the service
--   p_service_key_tests:    A list of key test IDs associated with the service 
--   p_service_key_beacons:  A list of key beacon IDs associated with the service
--
-- EXCEPTION
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--   INVALID_PARAMS_ERR: Invalid parameters
--

PROCEDURE SET_SVC_DTLS_FOR_AVAIL (p_service_target_name IN VARCHAR2,
                                  p_service_target_type IN VARCHAR2,
                                  p_avail_mode          IN VARCHAR2,
                                  p_avail_eval_func     IN VARCHAR2,
                                  p_service_key_comps   IN SMP_EMD_NVPAIR_ARRAY,
                                  p_service_key_tests   IN SMP_EMD_STRING_ARRAY,
                                  p_service_key_beacons IN SMP_EMD_STRING_ARRAY);


PROCEDURE SET_TESTS_FOR_SERVICE ( p_tests IN MGMT_GENSVC_TXN_INST_ARRAY,
                                  p_new_version             OUT INTEGER,
                                  p_result                  OUT INTEGER,   
                                  p_err_desc                OUT VARCHAR2);


-- 
-- PROCEDURE: GET_SVC_DTLS_FOR_RCA_CONFIG
-- 
-- PURPOSE
--   Get the RCA Configuration status of the given service.
--
-- IN PARAMETERS
--   p_service_target_name:  The service name
--   p_service_target_type:  The service type
--   p_interactive_rca:      Whether to perform RCA when service fails
--                           if 0 then box is checked, if 1 then box is unchecked
--   p_system_name:          The name of the associated system  
--   p_system_type:          The type of the associated system
--   p_key_system_members:   A list of key component members of the associated system
--
-- EXCEPTION
--   TARGET_DOES_NOT_EXIST:  if the service does not exist
--   INVALID_PARAMS_ERR:     invalid parameters
--

PROCEDURE GET_SVC_DTLS_FOR_RCA_CONFIG (p_service_target_name IN VARCHAR2,
                                       p_service_target_type IN VARCHAR2,
                                       p_interactive_rca    OUT NUMBER,
                                       p_system_name        OUT VARCHAR2, 
                                       p_system_type        OUT VARCHAR2, 
                                       p_key_system_members OUT SERVICE_ASSOC_SYS_MEM_CURSOR);
-- 
-- PROCEDURE: SET_LOCAL_BEACON
-- 
-- PURPOSE
--   Set the specified beacon as the local beacon of the given service.
--
-- IN PARAMETERS
--   p_service_target_name:  The service name
--   p_service_target_type:  The service type
--   p_local_beacon_name:    The name of the local beacon
--
-- EXCEPTION
--   TARGET_DOES_NOT_EXIST:  if the service does not exist
--
PROCEDURE SET_LOCAL_BEACON (p_service_target_name IN VARCHAR2,
                            p_service_target_type IN VARCHAR2,
                            p_local_beacon_name IN VARCHAR2);

-- 
-- PROCEDURE: GET_INFO_FOR_SYS_METRIC_PROM
-- 
-- PURPOSE
--   Retrieve metrics to render the System Based Metric Promotion
--   metric drop down and the key selector popup.
--
-- IN PARAMETERS
--   p_target_names:        A list of targets
--   p_target_type:         The target type
--   p_metric_category:     The metric category, Performance, Usage, Business etc
--   p_show_enabled_only:   'Y' means show enabled collections only. 'N' means show all collections.
--   p_metrics_columns:     Information to render the metric columns
--   p_key_metrics_columns: Information to render the key metric columns 
--
-- EXCEPTION
--
PROCEDURE GET_INFO_FOR_SYS_METRIC_PROM ( p_target_names IN SMP_EMD_STRING_ARRAY,
                                         p_target_type IN VARCHAR2,
                                         p_metric_category   IN VARCHAR2,
                                         p_show_enabled_only IN VARCHAR2,
                                         p_metrics_columns OUT METRIC_COLUMNS_CURSOR,
                                         p_key_metrics_columns OUT METRIC_KEY_COLUMNS_CURSOR);


PROCEDURE  GET_METRIC_INFO_FOR_PROM_CLI( p_target_names IN SMP_EMD_STRING_ARRAY,
                                         p_target_type IN VARCHAR2,
                                         p_metric_column IN VARCHAR2,
                                         p_metric_name IN VARCHAR2,
                                         p_metric_category IN VARCHAR2,
                                         p_show_enabled_only IN VARCHAR2,
                                         p_metrics_columns OUT METRIC_COLUMNS_CURSOR);


--
-- PROCEDURE: DELETE_SERVICE_CALLBACK
--
-- Cleans the collections from all beacons monitoring the service
--
-- IN: target_name, target_type
--

PROCEDURE DELETE_SERVICE_CALLBACK( target_name_in IN VARCHAR2,
                                   target_type_in IN VARCHAR2,
                                   target_guid_in IN RAW);

JOB_TYPE        CONSTANT VARCHAR2(32) := 'UpdateBeaconCollections';
JOB_DESCRIPTION CONSTANT VARCHAR2(64) := 'This job removes the collections of a beacon.';
JOB_NAME_PREFIX CONSTANT VARCHAR2(16) := MGMT_GENSVC_UPDBCN.JOB_NAME_PREFIX;

-- 
-- PROCEDURE: GET_SVC_TESTS_BCNS_DTLS
-- 
-- Gets the service information for the tests and beacons page
-- 
-- IN PARAMETERS
--   p_service_target_name       : The service name
--   p_service_target_type       : The service type
--
-- OUT PARAMETERS
--   p_service_tests             : A list of service tests
--   p_assoc_beacons             : A list of service beacons
--   p_avail_mode                : The availability mode 
--   p_avail_eval_func           : The availability eval function
--
-- EXCEPTION
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--
PROCEDURE GET_SVC_TESTS_BCNS_DTLS ( p_service_target_name IN VARCHAR2,
                                    p_service_target_type IN VARCHAR2,
                                    p_service_tests   OUT TESTS_CURSOR,
                                    p_assoc_beacons   OUT BEACONS_CURSOR,
                                    p_avail_mode      OUT VARCHAR2,
                                    p_avail_eval_func OUT VARCHAR2);

--
-- PROCEDURE: create_service
-- PURPOSE: this is the wrapper of service creation that supports both system based service
-- and test based service. This wrapper API allows the UI to create a system based service
-- with tests and beacons.
--
-- IN PARAMETERS:
--     p_service_target_name: Name of Service target
--     p_service_target_type: Service target type
--     p_target_display_name: Target display name 
--     p_host_name: This will be null for repository only target. If this is not null 
--                  then this host, timezone, agent_url of this host will be used for 
--                  the newly created target. 
--     p_agent_url: This will be null for repository only target. If this is not null
--                  then the host, time zone, agent url of this agent will be used for
--                  the newly created target. 
--     p_tz_rgn: The timezone region that target belongs to. 
--     p_svc_props: Service target level properties
--     p_system: Name of the system to associates the service 
--     p_system_type: system target type
--     p_critical_components: Critical components of the system on which the service depends. 
--     p_avail_mode: The availability mode. 
--     p_avail_eval_func: The availability eval function.
--     p_test_defn_with_props: Test definition with properties. This test will be used for 
--                             determining the availability of service target.  
--     p_test_thresholds: Per beacon and default thresholds defined on response metrics 
--                        collected by the test. 
--     p_use_def_test_type_thresh: The defult thresholds defined as test part of test meta 
--                                 data will be used as thresholds, if this value is 'Y'. This
--                                 value will be ignored if thresholds are specified.
--     p_assoc_bcn_list: List of beacons to monitor the Service tests. This list identify the 
--                       the availability beacons. 
--     p_use_default_met_prom: If the value is 'Y', default metric promotions defined as part 
--                             of test meta data will be used to promote to Service level 
--                             performance metrics. 
--     p_type_meta_ver: Target type meta version
--     p_category_prop_1: Category property 1
--     p_category_prop_2: Category property 2
--     p_category_prop_3: Category property 3
--     p_category_prop_4: Category property 4
--     p_category_prop_5: Category property 5
--     p_repository_only_target: Repository only target 
-- OUT PARAMETERS: none
-- Exception:
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--   
PROCEDURE CREATE_SERVICE ( p_service_target_name IN VARCHAR2,
                           p_service_target_type IN VARCHAR2,
                           p_target_display_name IN VARCHAR2 DEFAULT NULL,
                           p_host_name IN VARCHAR2, 
                           p_agent_url IN VARCHAR2, 
                           p_tz_rgn IN VARCHAR2,  
                           p_svc_props IN MGMT_TARGET_PROPERTY_LIST,
                           p_system IN VARCHAR2, 
                           p_system_type IN VARCHAR2,
                           p_critical_components IN SMP_EMD_NVPAIR_ARRAY,
                           p_avail_mode         IN VARCHAR2,
                           p_avail_eval_func    IN VARCHAR2,
                           p_test_defn_with_props IN MGMT_BCN_TXN_WITH_PROPS,
                           p_steps_defn_with_props IN MGMT_BCN_STEP_WITH_PROPS_ARRAY,
                           p_stepgroups_defn          IN MGMT_BCN_STEPGROUP_ARRAY,
                           p_test_thresholds          IN MGMT_BCN_THRESHOLD_ARRAY,
                           p_steps_thresholds         IN MGMT_BCN_THRESHOLD_ARRAY DEFAULT NULL,
                           p_stepgroups_thresholds    IN MGMT_BCN_THRESHOLD_ARRAY DEFAULT NULL,
                           p_use_def_test_type_thresh IN CHAR DEFAULT 'N',
                           p_assoc_bcn_list IN MGMT_BCN_ASSOC_ARRAY,
                           p_use_default_met_prom IN CHAR DEFAULT 'N',
                           p_type_meta_ver IN VARCHAR2 DEFAULT '1.0',
                           p_category_prop_1 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_2 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_3 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_4 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_5 IN VARCHAR2 DEFAULT ' ', 
                           p_repository_only_target IN NUMBER DEFAULT 1 );

--
-- PROCEDURE: get_tests
--
-- PURPOSE: retrieves basic information about tests for a given service. 
-- information include: txn guid, name, type, monitoring state, and whether it is a key test or not.
--
-- IN PARAMETERS:
-- p_service_target_name: the name of the service
-- p_service_target_type: the type of the service
--
-- OUT PARAMETERS:
-- p_service_tests: a cursor that loops through all the tests and their basic information.
PROCEDURE GET_TESTS (p_service_target_name IN VARCHAR2,
                     p_service_target_type IN VARCHAR2,
                     p_service_tests OUT TESTS_CURSOR);



--
-- PROCEDURE: get_mntr_states_for_tmpl
--
-- PURPOSE: gets the monitoring state for the template's tests.
--
-- IN PARAMETERS:
-- p_template_name: the name of the template
-- p_target_type: the target type on which the template is based
--
-- OUT PARAMETERS:
-- p_test_ids_states: a cursor containing ids and monitoring states for the
--  template tests

PROCEDURE GET_MNTR_STATES_FOR_TMPL ( p_template_name IN VARCHAR2,
                                     p_target_type IN VARCHAR2,
                                     p_test_ids_states OUT STATES_IDS_CURSOR);

--
-- PROCEDURE: set_mntr_states_for_tmpl
--
-- PURPOSE: sets the monitoring state for the template's tests. 
--
-- IN PARAMETERS:
-- p_template_name: the name of the template
-- p_target_type: the target type on which the template is based
-- p_template_testnames: an array of test names
-- p_template_testtypes: an array of test types
-- p_template_teststates: an array of integers (0/1) representing test states (not enabled/enabled)

--Deprecated API
--
--PROCEDURE SET_MNTR_STATES_FOR_TMPL ( p_template_name IN VARCHAR2,
--                                     p_target_type IN VARCHAR2,
--                                     p_template_test_names IN SMP_EMD_STRING_ARRAY,
--                                     p_template_test_types IN SMP_EMD_STRING_ARRAY,
--                                    p_template_test_states IN SMP_EMD_INTEGER_ARRAY );

--
-- PROCEDURE: set_template_tests_mntr_state
--
-- PURPOSE: Enable/Disable the specified list of template tests
--
-- IN PARAMETERS:
-- p_template_name: the name of the template
-- p_template_type: the template type (target type off which the template is based) 
-- p_tests: an array of test name/type pairs
-- p_set: if 'Y', enable the tests in p_tests
--        otherwise, disable the tests p_tests

PROCEDURE SET_TEMPLATE_TESTS_MNTR_STATE ( p_template_name IN VARCHAR2,
                                          p_template_type IN VARCHAR2,
                                          p_tests IN SMP_EMD_NVPAIR_ARRAY,
                                          p_set IN VARCHAR);

-- PROCEDURE: GET_TEST_DEF_THRESH
--
-- PURPOSE: Retrives an array of default test thresholds for a test.
-- Currently, this method is only called in test based service creation, 
-- if the 'p_use_def_test_thresh' parameter is 'Y' and there are no default test thresholds.
PROCEDURE GET_TEST_DEF_THRESH ( p_service_target_name IN VARCHAR2,
                                p_service_target_type IN VARCHAR2,
                                p_test_name IN VARCHAR2,
                                p_test_type IN VARCHAR2,
                                p_thresholds OUT MGMT_BCN_THRESHOLD_ARRAY);

-- PROCEDURE: GET_TEST_DEF_PROPS
--
-- PURPOSE: Retrieves an array of default test properties for a test.
-- If there are no properties with default value, the corresponding array will be null.
-- If there are already properties in the corresponding array, default values will be appended.
--
-- Note: this method is not to be used for creating transaction properties in template mode.
PROCEDURE GET_TEST_DEF_PROPS ( p_test_type       IN VARCHAR2,
                               p_def_test_props OUT MGMT_BCN_NVPAIR_ARRAY,
                               p_def_step_props OUT MGMT_BCN_NVPAIR_ARRAY);

-- PROCEDURE: ADD_TEST_BASED_DEF_PROM
--
-- PURPOSE: Adds test based default promotion to a service.
-- Currently, this method is only called in test based service creation, 
-- if the 'p_use_default_met_prom' parameter is 'Y' and there are associated tests and beacons. 

PROCEDURE ADD_TEST_BASED_DEF_PROM ( p_service_target_name IN VARCHAR2,
                                    p_service_target_type IN VARCHAR2,
                                    p_test_name IN VARCHAR2,
                                    p_test_type IN VARCHAR2);

--
-- PROCEDURE: POST_DELETE_SERVICE_CALLBACK
--
-- Does any post-deletion cleanup for services
--
-- IN: target_name, target_type
--

PROCEDURE POST_DELETE_SERVICE_CALLBACK( target_name_in IN VARCHAR2,
                                        target_type_in IN VARCHAR2,
                                        target_guid_in IN RAW);

--
-- PROCEDURE: BCN_TYPE_METAVER_UPD_CALLBACK
--
-- Callback invoked by repository framework whenever a beacon type 
-- meta version is updated. If the beacon is updated from 1.0 or 2.0 
-- to later versions, this callback will submit a sync job on all 
-- associated service targets. 
--
-- IN: tgt_type_meta_ver_obj 
--

PROCEDURE BCN_TYPE_METAVER_UPD_CALLBACK ( tgt_type_meta_ver_obj IN MGMT_TARGET_META_VER_CBK_OBJ );

-- 
-- FUNCTION: HAS_PROMOTED_METRICS
--
-- Does the target have any metric promotion of the specified metric category.
--
-- IN: p_target_name, p_target_type, p_category
--
FUNCTION HAS_PROMOTED_METRICS ( p_target_name IN VARCHAR2, 
                                p_target_type IN VARCHAR2,
                                p_category    IN VARCHAR2) RETURN BOOLEAN;

-- 
-- FUNCTION: ALLOW_BUSINESS_PROMOTION
--
-- Decides whether or not to show the 'Business Metrics' page on the gensvc
-- Monitoring Configuration page.
-- Only works for generic service/website.  For aggregate service, use the 
-- same function in em_aggsvc_ui (service/aggservice_ui_pkgbody.sql)
--
-- IN: p_target_name, p_target_type,
-- OUT: allow_promotion
--
PROCEDURE ALLOW_BUSINESS_PROMOTION( p_target_name IN VARCHAR2, 
                                    p_target_type IN VARCHAR2, 
                                    allow_promotion OUT INTEGER);

-- 
-- PROCEDURE: GET_ASSOC_BEACONS
-- 
-- Returns the set of beacons associated with a target.
--
PROCEDURE GET_ASSOC_BEACONS (p_service_target_name IN VARCHAR2,
                             p_service_target_type IN VARCHAR2,
                             p_assoc_beacons OUT BEACONS_CURSOR);

END gensvc;
/
show errors;

