Rem
Rem $Header: gensvc_updbcncol_pkgdef.sql 17-aug-2005.12:34:59 rmarripa Exp $
Rem
Rem gensvc_updbcncol_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      gensvc_updbcncol_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rmarripa    07/27/05 - add key values to the job 
Rem    andyao      07/19/05 - 
Rem    rmarripa    07/15/05 - delete pending jobs during sync job 
Rem    andyao      07/14/05 - fix bug 4494243, handle clean up of old status 
Rem                           and error message after a sync job
Rem    mfidanbo    12/16/04 - add new constants for sync and update jobs 
Rem    snakai      09/30/04 - add support for multiple beacons 
Rem    snakai      09/24/04 - snakai_svc_template_1
Rem    snakai      09/21/04 - Created
Rem


CREATE OR REPLACE PACKAGE MGMT_GENSVC_UPDBCN AS

/*
  UPDATE_TESTS

  This function adds/updates/removes the collections for a specific list of 
  tests of a given target.  It updates all beacons associated with the 
  target.

  - p_target_name: the service/webapp target
  - p_target_type:
  - p_tests: list of tests to update (tests may be added/updated or removed)
  - p_incl_rmv_bcns: update collections in beacons in the removing state
  - p_action_desc: user operation that prompted this action
  - p_jobs: list of jobs submitted (one per beacon) 
*/
PROCEDURE UPDATE_TESTS   ( p_target_name   IN VARCHAR2, 
                           p_target_type   IN VARCHAR2,
                           p_tests         IN MGMT_GENSVC_UBJOB_TEST_ARRAY,
                           p_incl_rmv_bcns IN BOOLEAN,
                           p_key_values    IN SMP_EMD_STRING_ARRAY,
                           p_action_desc   IN VARCHAR2,
                           p_jobs          OUT MGMT_GENSVC_UBJOB_JOB_ARRAY );

/*
  SUBMIT_UPDBCN_JOB

  This function adds/updates/removes the collections for a specific beacon
  and target.

  - p_target_name: the service/webapp target
  - p_target_type:
  - p_beacon_name: the beacon to update
  - p_job_type: Type of job (sync/update)
  - p_action_desc: user operation that prompted this action
  - p_job_id: id of the job submitted
*/
PROCEDURE SUBMIT_SYNC_JOB (   p_target_name   IN VARCHAR2, 
                              p_target_type   IN VARCHAR2,
                              p_beacon_name   IN VARCHAR2,
                              p_action_desc   IN VARCHAR2,
                              p_job_id        OUT RAW );

/*
  SUBMIT_UPDBCN_JOB

  This function adds/updates/removes the collections for a specific beacon
  and target.

  - p_target_name: the service/webapp target
  - p_target_type:
  - p_beacon_name: the beacon to update
  - p_tests: the tests to update at the specified beacon
  - p_action_desc: user operation that prompted this action
  - p_job_id: id of the job submitted
*/
PROCEDURE SUBMIT_UPDBCN_JOB ( p_target_name   IN VARCHAR2, 
                              p_target_type   IN VARCHAR2,
                              p_beacon_name   IN VARCHAR2,
                              p_tests         IN MGMT_GENSVC_UBJOB_TEST_ARRAY,
                              p_key_values    IN SMP_EMD_STRING_ARRAY,
                              p_action_desc   IN VARCHAR2,
                              p_job_id        OUT RAW );

/*
  SUBMIT_UPDBCN_JOB

  This function adds/updates/removes the collections for a specific beacon
  and target.  It returns the id of the UPDBCN job submitted.

  - p_target_guid: the service/webapp target
  - p_beacon_guid: the beacon to update
  - p_beacon_name:
  - p_tests: the tests to update at the specified beacon
  - p_action_desc: user operation that prompted this action
*/
FUNCTION SUBMIT_UPDBCN_JOB ( p_target_guid   IN RAW,
                             p_beacon_guid   IN RAW,
                             p_beacon_name   IN VARCHAR2,
                             p_tests         IN MGMT_GENSVC_UBJOB_TEST_ARRAY,
                             p_jobtype       IN INTEGER,
                             p_key_values    IN SMP_EMD_STRING_ARRAY,
                             p_action_desc   IN VARCHAR2)
RETURN RAW;

PROCEDURE CLEANUP_HISTORY_AFTER_SYNC ( p_operation_guid IN VARCHAR2,
                                       p_target_name  IN VARCHAR2,
                                       p_target_type  IN VARCHAR2,
                                       p_beacon_guid  IN VARCHAR2,
                                       p_beacon_name  IN VARCHAR2,
                                       p_jobtype    IN VARCHAR2);
                                       
--This procedures clears open severities and closes metric errors 
-- for transaction/steps/step grops or beacons. 
-- This will be executed as part of beacon update collections job
-- directly or indirectly
-- This procedure will only handle 'updateJob' and 'syncJob' types.
-- 'deleteJob' only executes as part of service deletion. It is not
-- required to delete severities as part of job, if the service is deleted. 
PROCEDURE CLEAR_SEV_METRIC_ERRS ( p_operation_guid IN VARCHAR2,
                        p_target_name    IN VARCHAR2,
                        p_target_type    IN VARCHAR2,
                        p_jobtype    IN VARCHAR2,
                        p_key_values     IN MGMT_JOB_VECTOR_PARAMS );
/*
  CONSTANTS
*/
JOB_TYPE        CONSTANT VARCHAR2(32) := 'UpdateBeaconCollections';
JOB_DESCRIPTION CONSTANT VARCHAR2(64) := 'This job updates the collections of a beacon.';
JOB_NAME_PREFIX CONSTANT VARCHAR2(16) := 'UPDBCNCOL_';

SYNC_JOB CONSTANT INTEGER       :=   1;
UPDATE_JOB CONSTANT INTEGER     :=   2;
DELETE_JOB CONSTANT INTEGER     :=   3;

-- constants defined in UpdateBeaconCollections
STATUS_SCHEDULED CONSTANT INTEGER := 1;
STATUS_EXECUTING CONSTANT INTEGER := 2;
STATUS_ABORTED   CONSTANT INTEGER := 3;
STATUS_FAILED    CONSTANT INTEGER := 4;    
STATUS_COMPLETED CONSTANT INTEGER := 5;
STATUS_RETRY     CONSTANT INTEGER := 6;    
STATUS_FIXED_BY_SYNC CONSTANT INTEGER := 7;

SYNC_BEACON   VARCHAR2(32) := 'Sync Beacon';

END MGMT_GENSVC_UPDBCN;
/
SHOW ERRORS;
