Rem
Rem $Header: group_comp_mntr_pkgdef.sql 16-oct-2003.21:17:18 tjaiswal Exp $
Rem
Rem ocs_comp_mntr_pkgdef.sql
Rem
Rem Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      ocs_comp_mntr_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    tjaiswal    10/16/03 - tjaiswal_ocs_comp_bugs 
Rem    tjaiswal    10/06/03 - Add support for system ui across components 
Rem    tjaiswal    09/16/03 - Support for webapp metrics 
Rem    tjaiswal    05/05/03 - Created
Rem

CREATE OR REPLACE PACKAGE group_comp_mntr AS

-- Package level Type Definition 
   TYPE cursorType IS   REF CURSOR;

--
-- PROCEDURE: get_group_comp_mntr_summary
--
-- PURPOSE:
--   Returns a summary of monitoring details for the members of 
--     a particular target.
--
-- IN Parameters:
--   target_name_in: VARCHAR2 The name of the target 
--   target_type_in: VARCHAR2 The type of the target
--   member_target_type_in: VARCHAR2 The type of the member target
--   timeperiod_in: NUMBER The timeperiod or which we want details
--                         DEFAULTS to MGMT_GLOBAL.G_DAY
--
-- OUT Parameters:
--   summary_out: CURSORTYPE A cursor which returns rows containing:
--     target_name: VARCHAR2 The name of the target
--     target_type: VARCHAR2 The type of the target
--     display_name: VARCHAR2 The display name of the target
--     type_display_name: VARCHAR2 The display name of the target type
--     avail_pct: NUMBER The availability percent over the timeperiod
--     current_status: NUMBER The current availability status - check
--                           mgmt current availability table for definition of values.
--     warning_count: NUMBER The number of currently open warning alerts
--     critical_count: NUMBER The number of currently open critical alerts
--
-- ERROR CODES:
--   TARGET_DOES_NOT_EXIST_ERR: No such target was found. This could also mean
--     that the user does not have access to view this target.
--
PROCEDURE get_group_comp_mntr_summary
  (target_name_in  IN VARCHAR2,
   target_type_in  IN VARCHAR2,
   member_target_type_in IN VARCHAR2,
   met_obj_in IN METRICS_OBJ_ARRAY,
   summary_out OUT cursorType,
   rolled_up_met_sev_out OUT cursorType);

--
-- PROCEDURE: get_group_comp_sev_summary
--
-- PURPOSE:
--   Returns a summary of severity details for the members of 
--     a particular ocs group target.
--
-- ERROR CODES:
--   TARGET_DOES_NOT_EXIST_ERR: No such target was found. This could also mean
--     that the user does not have access to view this target.
--
PROCEDURE get_group_comp_sev_summary
  (target_name_in  IN VARCHAR2,
   target_type_in  IN VARCHAR2,
   member_target_type_in IN VARCHAR2,
   met_obj_in IN METRICS_OBJ_ARRAY,
   metric_cols_cur_out OUT cursorType,
   metric_sevs_cur_out OUT cursorType,
   metric_vals_cur_out OUT cursorType,
   metric_blkout_cur_out OUT cursorType,
   metric_blkout_hist_out OUT cursorType,
   targets_cur_out OUT cursorType);

--
-- PROCEDURE: get_group_comp_ws_sev_summary
--
-- PURPOSE:
--   Returns a summary of severity details for the website members of 
--     a particular ocs group target.
--
-- ERROR CODES:
--   TARGET_DOES_NOT_EXIST_ERR: No such target was found. This could also mean
--     that the user does not have access to view this target.
--
PROCEDURE get_group_comp_ws_sev_summary
  (target_name_in  IN VARCHAR2,
   target_type_in  IN VARCHAR2,   
   targets_sev_cur_out OUT cursorType,
   metric_blkout_hist_out OUT cursorType);

--
-- PROCEDURE: get_met_sev_blkout_status
--
-- PURPOSE:
--   Returns 1  if this metric severity should be shown as a blacked out icon
--           15 if the metric severity should be shown as clear
--           20 if the metric severity should be shown as warning
--           25 if the metric severity should be shown as critical
--
FUNCTION get_met_sev_blkout_status
  (target_name_in  IN VARCHAR2,
   target_type_in  IN VARCHAR2,
   metric_name_in IN VARCHAR2,
   metric_column_in IN VARCHAR2,
   key_value_in IN VARCHAR2)
RETURN NUMBER; 

--
-- PROCEDURE: update_met_sev_blkout_status
--
-- PURPOSE:
--   Update the metrci severity blackout status for the given metric of the
--   given target type. This inserts a record in the table - MET_SEV_BLKOUT
--
PROCEDURE update_met_sev_blkout_status
  (target_name_in  IN VARCHAR2,
   target_type_in  IN VARCHAR2,
   metric_name_in IN VARCHAR2,
   metric_column_in IN VARCHAR2,
   key_value_in IN VARCHAR2,
   sev_code_in IN NUMBER,
   mode_in IN NUMBER);

--
-- PROCEDURE: get_rolled_up_met_sev
--
-- PURPOSE:
--   Get the rolled up metric severity across all the targets of type 
--   member_target_type_in of the composite target - 
--   (target_name_in, target_type_in) for all the summary metrics defined 
--   in met_obj_in 
--
--   Returns 
--           15 if the rolled up metric severity across all the targets of 
--              type member_target_type_in of the composite target - 
--              (target_name_in, target_type_in) for all the summary metrics 
--              defined in met_obj_in is clear
--           20 if the rolled up metric severity across all the targets of 
--              type member_target_type_in of the composite target - 
--              (target_name_in, target_type_in) for all the summary metrics 
--              defined in met_obj_in is warning
--           25 if the rolled up metric severity across all the targets of 
--              type member_target_type_in of the composite target - 
--              (target_name_in, target_type_in) for all the summary metrics 
--              defined in met_obj_in is critical
--
FUNCTION get_rolled_up_met_sev
  (target_name_in  IN VARCHAR2,
   target_type_in  IN VARCHAR2,
   member_target_type_in IN VARCHAR2,
   met_obj_in IN METRICS_OBJ_ARRAY)
RETURN NUMBER; 

--
-- PROCEDURE: get_grp_comp_rolledup_met_sev
--
-- PURPOSE:
--   Returns a summary of the rolled metric severity for every target type
--     of this composite target
--
-- ERROR CODES:
--   TARGET_DOES_NOT_EXIST_ERR: No such target was found. This could also mean
--     that the user does not have access to view this target.
--
PROCEDURE get_grp_comp_rolledup_met_sev
  (target_name_in  IN VARCHAR2,
   target_type_in  IN VARCHAR2,
   member_target_type_in IN VARCHAR2,
   met_obj_in IN METRICS_OBJ_ARRAY,
   rolled_up_met_sev_out OUT cursorType);

--
-- PROCEDURE: get_group_overview_summary
--
-- PURPOSE:
--   Returns a summary of monitoring details for the members of 
--     a particular group target.
--
-- IN Parameters:
--   target_name_in: VARCHAR2 The name of the target 
--   target_type_in: VARCHAR2 The type of the target
--   met_obj_in: METRICS_OBJ_ARRAY The summary metrics for the member targets
--
-- OUT Parameters:
--   rolled_up_data_out: CURSORTYPE A cursor which returns rows containing:
--     target_name: VARCHAR2 The name of the target
--     target_type: VARCHAR2 The type of the target
--     display_name: VARCHAR2 The target display name
--     type_display_name: VARCHAR2 The target type display name
--     rolled_up_status: NUMBER The rolled up status across all the member 
--                              targets
--     rolled_up_severity: NUMBER The rolled up metric severity across all 
--                                the summary metrics of all the member targets
--
-- ERROR CODES:
--   TARGET_DOES_NOT_EXIST_ERR: No such target was found. This could also mean
--     that the user does not have access to view this target.
--
PROCEDURE get_group_overview_summary
  (target_name_in  IN VARCHAR2,
   target_type_in  IN VARCHAR2,
   met_obj_in IN METRICS_OBJ_ARRAY,
   rolled_up_data_out OUT cursorType);

end group_comp_mntr;
/
show errors;

