Rem
Rem $Header: group_comp_tables.sql 08-feb-2005.12:34:51 gsbhatia Exp $
Rem
Rem group_comp_tables.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      group_comp_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    02/08/05 - Removing header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    tjaiswal    10/16/03 - tjaiswal_ocs_comp_bugs 
Rem    tjaiswal    08/05/03 - Created
Rem

rem
rem  PURPOSE
rem
rem     The MET_SEV_BLKOUT table contains the information about when a metric
rem     severity was blacked out and the severity code of the metric severity
rem     when the blackout was initiated. Note that this table and feature
rem     is not related to the EM blackout feature and serves the primary
rem     purpose of being used for showing an additional state(blue state)
rem     for a metric severity in adddition to the current three states -
rem     critical, warning and clear.
rem
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_GUID
rem
rem                 - A unique ID for the metric.  It can be used to associate
rem                   metric information with metric data information during
rem                   reporting.
rem
rem     KEY_VALUE   - If the metric defined at collection time is a TABLE type, the
rem                   value of the column in the table that is designated as the
rem                   key for the row that identifies the value of this metric should
rem                   be written here.  This information is used during reporting to
rem                   uniquely identify the specific value in the table that was
rem                   collected.  KEY_VALUE is the identifying row.  Together with the
rem                   target name, target type, and metric name, the metric value can be
rem                   uniquely identified.  This allows us to flatten tables of metrics into
rem                   simple metric values.  For example, the value in this table might
rem                   be \usr if we were storing the SpaceUsed metric.
rem
rem     BLKOUT_TIMESTAMP
rem
rem                 - the date/time when the blackout was initiated
rem
rem     SEVERITY_CODE
rem
rem                 - The event severity code for error, warning, critical, etc.
rem
rem                        15 - clear
rem                        20 - warning
rem                        25 - alert
rem
rem     MESSAGE      - The content of the alert.  Alerts are sent as messages that
rem                    provide more details about what triggered the condition.
rem
rem     USER_NAME      -  The user who initiated the blackout of the metric 
rem                       severity.
rem

CREATE TABLE MET_SEV_BLKOUT
    (target_guid           RAW(16)         NOT NULL,
     metric_guid           RAW(16)         NOT NULL,
     key_value             VARCHAR2(256)   DEFAULT ' ',
     blkout_timestamp      DATE            NOT NULL,
     severity_code         NUMBER          DEFAULT NULL,
     message               VARCHAR2(4000)  DEFAULT NULL,
     user_name             VARCHAR2(64)    DEFAULT '<SYSTEM>')
  STORAGE
    (FREELISTS 4)
  INITRANS 2
  MONITORING;

