Rem
Rem $Header: group_flat_pkgdef.sql 23-sep-2003.22:44:35 streddy Exp $
Rem
Rem group_flat_pkgdefs.sql
Rem
Rem Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      group_flat_pkgdefs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Group flattening implementation.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    streddy     09/23/03 - streddy_bug-3108368 
Rem    streddy     09/23/03 - Created
Rem

CREATE OR REPLACE PACKAGE em_flat_comptgt AS

---
--- PURPOSE
---    Updates the exploded memberships of the specified 
---    group/composite in MGMT_FLAT_TARGET_MEMBERSHIPS
---    table.
---
PROCEDURE update_flat_memberships(v_composite_guid IN RAW);


---
--- PURPOSE
---   Updates the flattened list for parent groups of the specified
---   composite/group target.
---
PROCEDURE update_parent_flat_memberships(v_composite_guid IN RAW);

---
--- PURPOSE
--- Adds a target to a list of groups
---
PROCEDURE add_target_to_flat_memberships(v_target_name IN VARCHAR2,
                                         v_target_type IN VARCHAR2,
                                         v_target_guid IN RAW,
                                         v_groups IN SMP_EMD_NVPAIR_ARRAY);

---
--- PURPOSE
---    Updates all parent groups upon deletion of a group.
---
PROCEDURE handle_delete_group(v_composite_guid IN RAW);

---
--- PURPOSE
---   Called from loader before inserting rows into
---   MGMT_TARGET_MEMBERSHIPS table      
---
PROCEDURE START_MEMBERSHIPS_ROWSET;

---
--- PURPOSE
---   Called whenever a composite target memberships are modified
---   during a Loader session
---
PROCEDURE COMPOSITE_TARGET_MODIFIED(v_composite_target_name VARCHAR2,
                                    v_composite_target_type VARCHAR2);

---
--- PURPOSE
---   Called from loader when done with inserting rows into
---   MGMT_TARGET_MEMBERSHIPS table      
---
PROCEDURE END_MEMBERSHIPS_ROWSET;


-- new composite members that got updated in this load
p_updated_composite_targets  SMP_EMD_NVPAIR_ARRAY;



END em_flat_comptgt;


/

SHOW ERRORS;