Rem
Rem $Header: group_mntr_pkgdef.sql 15-mar-2005.18:13:32 rpatti Exp $
Rem
Rem group_mntr_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      group_mntr_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpatti      03/15/05 - cleanup
Rem    vagarwal    10/04/04 - add module constant 
Rem    vagarwal    09/29/04 - 
Rem    lyang       09/28/04 - 
Rem    ckumar      07/29/04 - modified update_group proc to take target type param too.
Rem    vagarwal    09/24/04 - 
Rem    nigupta     09/20/04 - move expand_node, get_members_and_associations 
Rem                           and get_target_list_details to groups_ui_pkgdef 
Rem    vagarwal    09/13/04 - 
Rem    nigupta     09/09/04 - add expand_node 
Rem    nigupta     09/01/04 - add procedures get_members_and_associations and 
Rem                           get_target_list_details 
Rem    joguo       11/14/03 - cleanup 
Rem    ancheng     11/07/03 - change get_summary_ui_details
Rem    joguo       11/04/03 - create new group pages
Rem    rpatti      04/03/03 - cleanup sql
Rem    rpatti      04/09/03 - add callback for member target delete
Rem    rpatti      10/31/02 - change get_summary_ui_details
Rem    rpatti      06/12/02 - pass current status as a number
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Restructured.
Rem    tzimmerm    05/09/02 - Fixing website composites in UNION w/ GetAvailability fcn
Rem    edemembe    05/06/02 - Moving comp target package spec
Rem    tzimmerm    05/01/02 - Alter get_cmpt_target_availability to use new composite avail code
Rem    edemembe    04/29/02 - Bug 2278619
Rem    rpatti      04/26/02 - users with full privilege can delete group
Rem    rpatti      04/26/02 - can delete grp even if it is member of a grp
Rem    rpatti      04/26/02 - users with full privilege can delete group
Rem    rpatti      04/25/02 - fix compare metrics
Rem    rpatti      04/12/02 - move recomputing grp availability to api
Rem    tzimmerm    04/10/02 - Adding start & end interval dates to avail_cur_out cursor
Rem    rpatti      04/11/02 - fix from review
Rem    rpatti      04/03/02 - use add_group api
Rem    rpatti      04/05/02 - cleanup data for unwanted summary metrics
Rem    tjaiswal    04/01/02 - Misc group fixes
Rem    dcawley     03/14/02 - New Collection APIs..
Rem    rpatti      02/25/02 - use function to get current user
Rem    rpatti      02/19/02 - fix metrics returned in compare metrics page
Rem    tjaiswal    02/12/02 - Bug 2221227
Rem    tjaiswal    02/08/02 - Fix adding summary met to collections in update_group
Rem    rpatti      01/24/02 - fix build
Rem    rpatti      01/23/02 - fix privilege check
Rem    rpatti      01/23/02 - check premissions for edit or delete
Rem    aholser     01/20/02 - insert IS_GROUP in mgmt_targets on creation
Rem    rpatti      01/17/02 - remove group availability/performance
Rem    rpatti      01/10/02 - support folders for composite page
Rem    rpatti      01/09/02 - make sure username is uppercase
Rem    rpatti      01/08/02 - support custom summary metric columns
Rem    edemembe    01/08/02 - Metrics are now target independent
Rem    rpatti      12/28/01 - use group label
Rem    edemembe    12/27/01 - Removing target name/type and metric name/column references
Rem    rpatti      12/03/01 - support typed groups
Rem    rpatti      11/18/01 - add avail pcts in the query
Rem    rpatti      11/08/01 - redo sql for better perf
Rem    rpatti      11/02/01 - limit availability records to 25
Rem    rpatti      11/01/01 - updates
Rem    rpatti      10/31/01 - perf changes
Rem    tjaiswal    10/29/01 - Remove usage of emtarget_ui_status
Rem    tjaiswal    10/26/01 - Fix critical, warning count
Rem    rpatti      10/25/01 -
Rem    rpinnama    10/15/01 - Rollback TIMESTAMP WITH TIMEZONE changes
Rem    rpatti      10/09/01 - revamp
Rem    rpatti      10/03/01 - improve perf of get timeseries
Rem    rpatti      10/02/01 - insert thresholds correctly
Rem    rpatti      09/26/01 - schema normalization changes
Rem    rpatti      09/20/01 - use new metric label column
Rem    rpatti      09/17/01 - cleanup sql
Rem    rpinnama    09/13/01 - Insert collection_timestamp and collection_ts_utc
Rem    rpatti      08/24/01 - tune sql
Rem    rpatti      08/07/01 - update FOR new UI options
Rem    rpatti      07/20/01 - update FOR repository changes
Rem    skini       07/21/01 - Merge in rpatti transaction
Rem    rpatti      07/10/01 - update FOR schema revamp
Rem    rpatti      06/25/01 - comp target mgmt related pkg
Rem    rpatti      06/25/01 - Created
Rem

CREATE OR REPLACE PACKAGE emd_mntr_comptgt AS

-- Package level Type Definition 
   TYPE cursorType IS   REF CURSOR;
-- Module Name, used in debugging
   MODULE_NAME CONSTANT VARCHAR2(7)  := 'GROUPS';

-- custom column type for groups
   GROUP_CUSTOM_COLTYPE_METRIC 	    NUMBER(1) := 0;
   GROUP_CUSTOM_COLTYPE_STATUS 	    NUMBER(1) := 1;
   GROUP_CUSTOM_COLTYPE_ALERTS 	    NUMBER(1) := 2;
   GROUP_CUSTOM_COLTYPE_POLICY 	    NUMBER(1) := 3;
   GROUP_CUSTOM_COLTYPE_PROPERTY 	NUMBER(1) := 4;

-- chart types. Move some of these to sdk once the sdk registration is
-- provided.

   GROUP_CHART_SELECTED_TARGETS    NUMBER(1) := 1;
   GROUP_CHART_PEAK_TARGETS    NUMBER(1) := 2;
   GROUP_CHART_HIGHEST_TARGETS    NUMBER(1) := 3;
   GROUP_CHART_LOWEST_TARGETS    NUMBER(1) := 4;
   GROUP_CHART_SUMMARY_METRIC    NUMBER(1) := 5;


PROCEDURE getDetailsForGroupMainPage(
                groupTargets OUT cursorType,
                groupTypes   OUT cursorType
                );

PROCEDURE get_cmpt_target_availability(
                target_name_in IN  VARCHAR2,
                target_type_in IN  VARCHAR2,
                num_of_days_in IN  NUMBER,
                disp_type_in   IN  VARCHAR2,
                compare_type_in  IN  VARCHAR2,
                start_time_out OUT DATE,
                end_time_out   OUT DATE,
                avail_pcts_out  OUT cursorType,
                avail_cur_out  OUT cursorType
);

-- PURPOSE:
--   Cleanup groups when a member target is deleted
--    if this member target is the last of this type
--    in a group and there are summary metrics defined 
--    for that type - we need to clean the summary
--    metric definitions.
--
--   IN Parameters:
--     target_name_in : target name of the deleted target
--     target_type_in : target type of the deleted target
--     target_guid_in : target guid of the deleted target
--
--
--   OUT Parameters:
--     NONE
PROCEDURE clean_group_on_mem_tgt_del
   (target_name_in IN VARCHAR2,
    target_type_in IN VARCHAR2,
    target_guid_in IN RAW);

TYPE TargetGUIDList IS TABLE OF RAW(16) INDEX BY BINARY_INTEGER;
TYPE CurrentStatusList IS TABLE OF NUMBER INDEX BY BINARY_INTEGER;
TYPE MemberListType IS
  RECORD
  (
    targetGUID     TargetGUIDList,
    currentStatus  CurrentStatusList
  );

FUNCTION GetAvailability(compositeGUID RAW, numDays NUMBER DEFAULT 1)
      RETURN MgmtAvailTableType;

end emd_mntr_comptgt;
/
show errors;
