Rem
Rem $Header: group_pkgdef.sql 02-dec-2005.12:37:34 gan Exp $
Rem
Rem group_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      group_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gan         12/02/05  - Backport gan_bug-4669119 from main 
Rem    ramalhot    03/11/05 -  added create/modify group 
Rem    neearora    02/23/05 - Added new procedure upsert_group 
Rem    pmodi       02/03/05 - Group to system conversion api support 
Rem    ramalhot    01/10/05 - ramalhot_goup_migration
Rem    ramalhot    12/30/04 - Created
Rem

CREATE OR REPLACE PACKAGE em_group IS

  -- Module name used for logging 
  MODULE_NAME CONSTANT VARCHAR2(8) := 'em.group';

-- Summary metric name, key column , metric column names
  SUM_METRIC        CONSTANT VARCHAR2(15) := 'Summary Metrics';
  SUM_METRIC_KEY    CONSTANT VARCHAR2(19) := 'Summary Metric Name';
  SUM_METRIC_COLUMN CONSTANT VARCHAR2(20) := 'Summary Metric Value';

-- coll property name used for calculating summary metrics
   MEM_METRIC_GUID_PROP_NAME CONSTANT VARCHAR2(11) := 'metric_guid';

  --
  -- PROCEDURE: create_charts 
  --
  -- PURPOSE
  --   Create charts for a specified target 
  -- IN Parameters:
  --   p_target_name : VARCHAR2
  --       The name of the target
  --   p_target_type : VARCHAR2
  --       The type of arget
  --   p_charts_list : MGMT_GRP_CHART_ARRAY
  --       Collection containing the charts tobe created 
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters 
  --   TARGET_DOES_NOT_EXIST_ERR : For invalid Target 
  PROCEDURE create_charts
  (
    p_target_name IN mgmt_targets.target_name%TYPE,
    p_target_type IN mgmt_targets.target_type%TYPE,
    p_charts_list IN MGMT_GRP_CHART_ARRAY
  );

  --
  -- PROCEDURE: delete_charts 
  --
  -- PURPOSE
  --   Deletes all the charts for a specified target 
  -- IN Parameters:
  --   p_target_name : VARCHAR2
  --       The name of the target
  --   p_target_type : VARCHAR2
  --       The type of arget
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters 
  --   TARGET_DOES_NOT_EXIST_ERR : For invalid Target 
  PROCEDURE delete_charts
  (
    p_target_name IN mgmt_targets.target_name%TYPE,
    p_target_type IN mgmt_targets.target_type%TYPE
  );

  --
  -- PROCEDURE: modify_charts 
  --
  -- PURPOSE
  --   It first delete all the charts for a specified target and then 
  --   creates specified charts for that target 
  -- IN Parameters:
  --   p_target_name : VARCHAR2
  --       The name of the target
  --   p_target_type : VARCHAR2
  --       The type of arget
  --   p_charts_list : MGMT_GRP_CHART_ARRAY
  --       Collection containing the charts tobe created 
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters 
  --   TARGET_DOES_NOT_EXIST_ERR : For invalid Target 
  PROCEDURE modify_charts
  (
    p_target_name IN mgmt_targets.target_name%TYPE,
    p_target_type IN mgmt_targets.target_type%TYPE,
    p_charts_list IN MGMT_GRP_CHART_ARRAY
  );


  -- 
  -- PROCEDURE : create_group_custom_columns
  --
  -- PURPOSE : To create a custom columns for given target type and target name
  --
  -- IN parameter :
  --   p_target_name : Target name for which columns needs to be created
  --   p_target_type : Target type of target for which columns needs to be created
  --
  -- OUT paremter :
  --   None
  --

  PROCEDURE create_group_custom_columns
  (
    p_target_name IN mgmt_targets.target_name%type,
    p_target_type IN mgmt_targets.target_type%type,
    p_column_list IN MGMT_GRP_COLUMN_ARRAY 
  ) ;

 
  -- 
  -- PROCEDURE : delete_group_custom_columns
  --
  -- PURPOSE : To delete a custom columns for given target type and target name
  --
  -- IN parameter :
  --   p_target_name : Target name for which columns needs to be deleted
  --   p_target_type : Target type of target for which columns needs to be deleted
  --
  -- OUT paremter :
  --   None
  --

  PROCEDURE delete_group_custom_columns
  (
    p_target_name IN mgmt_targets.target_name%type,
    p_target_type IN mgmt_targets.target_type%type 
  ) ;


  --
  -- PROCEDURE : modify_group_custom_columns
  --
  -- PURPOSE : To modify a custom columns for given target type and target name
  --
  -- IN parameter :
  --   p_target_name : Target name for which columns needs to be modified
  --   p_target_type : Target type of target for which columns needs to be modified
  --   p_colun_list  : Updated column list as MGMT_GRP_COLUMN_ARRAY
  --
  -- OUT paremter :
  --   None
  --

  PROCEDURE modify_group_custom_columns
  (
    p_target_name IN mgmt_targets.target_name%type,
    p_target_type IN mgmt_targets.target_type%type,
    p_column_list IN MGMT_GRP_COLUMN_ARRAY
  ) ;

  --
  -- PROCEDURE : create_system_from_group
  --
  -- PURPOSE : To create system from group. Given group would not be deleted.
  --           It calls another internal method with DELETE_GROUP = 0
  --           It will not copy or alter blackout/job/parent membership for given group 
  --
  -- IN parameter :
  --   p_group_name : Target name of Group from which system needs to be created
  --   p_group_type : Traget type of Group type from which system needs to be created
  --   p_system_name : Target name for new system. If not specified then it would be same as Group name
  --   p_system_type : Target type of new system.
  --
  -- OUT parameter :
  --   None
  --

  PROCEDURE create_system_from_group
  (
    p_group_name  IN VARCHAR2,
    p_group_type  IN VARCHAR2,
    p_system_name IN VARCHAR2 DEFAULT NULL,
    p_system_type IN VARCHAR2 DEFAULT MGMT_GLOBAL.G_GENERIC_SYSTEM_TYPE
  );

  --
  -- PROCEDURE : migrate_group_to_system
  --
  -- PURPOSE : To migrate group to system. Given group would be deleted.
  --           It calls another internal method with DELETE_GROUP = 1
  --           It will alter blackout/job/parent membership for given group 
  --
  -- IN parameter :
  --   p_group_name : Target name of Group from which system needs to be migrated
  --   p_group_type : Traget type of Group type from which system needs to be migrated
  --   p_system_name : Target name for new system. If not specified then it would be same as Group name
  --   p_system_type : Target type of new system.
  --
  -- OUT parameter :
  --   None
  --

  PROCEDURE migrate_group_to_system 
  (
    p_group_name  IN VARCHAR2,
    p_group_type  IN VARCHAR2,
    p_system_name IN VARCHAR2 DEFAULT NULL,
    p_system_type IN VARCHAR2 DEFAULT MGMT_GLOBAL.G_GENERIC_SYSTEM_TYPE
  );

  --
  -- PROCEDURE: upsert_group 
  -- PURPOSE
  --   this procedure will be used by emctl to create/update the group. If the group with the
  --   given name and type is not present then it will create a new group otherwise it will update 
  --   the existing group, members will merge with existing ones.
  PROCEDURE upsert_group
  (
    p_upsert IN NUMBER,
    p_group_name IN VARCHAR2,
    p_group_type IN VARCHAR2,
    p_member_targets IN SMP_EMD_NVPAIR_ARRAY,
    p_timezone_region IN VARCHAR2
  );

  PROCEDURE create_group
  (
    p_group_name  IN mgmt_targets.target_name%TYPE,
    p_group_type  IN mgmt_targets.target_type%TYPE,
    p_member_targets IN SMP_EMD_NVPAIR_ARRAY 
                          DEFAULT NULL,
    p_group_owner    IN mgmt_targets.owner%TYPE 
                          DEFAULT NULL,
    p_timezone_rgn   IN mgmt_targets.timezone_region%TYPE
                          DEFAULT NULL 
  );

  PROCEDURE modify_group
  (
    p_group_name        IN mgmt_targets.target_name%TYPE,
    p_group_type        IN mgmt_targets.target_type%TYPE,
    p_targets_to_add    IN SMP_EMD_NVPAIR_ARRAY 
                             DEFAULT NULL,
    p_targets_to_remove IN SMP_EMD_NVPAIR_ARRAY
                             DEFAULT NULL,
    p_group_owner       IN mgmt_targets.owner%TYPE
                             DEFAULT NULL
  );


END em_group; 
/
