Rem drv: <create type="post_creation" pos="host/host_post_creation.sql-"/>
Rem
Rem $Header: group_post_creation.sql 30-jul-2005.03:26:05 vesriniv Exp $
Rem
Rem group_post_creation.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      group_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    vesriniv    07/30/05 - Add customization support 
Rem    gsbhatia    07/03/05 - New repmgr header impl 
Rem    rpatti      06/29/05 - reinstate db grp/hostgrp 
Rem    rpatti      06/27/05 - disallow template creation for groups 
Rem    dtsao       06/23/05 - Remove isComposite property for group type 
Rem    rkpandey    05/17/05 - Moving register system type to 
Rem                           system_post_creation 
Rem    ramalhot    03/14/05 - is_group property removed for red_group & system 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    streddy     11/08/04 - Change redundancy group to exclusion mechanism 
Rem    rpatti      10/22/04 - cleanup
Rem    rpatti      10/13/04 - summary metric support 
Rem    rpinnama    10/05/04 - Support new constructor for mgmt_metric_column_obj
Rem    vagarwal    10/01/04 - 
Rem    ckumar      08/24/04 - Incorporated review comments
Rem    ckumar      07/21/04 - Registered Redundancy Group Type and added its properties
Rem    rpinnama    09/25/03 - Use register_target_type API
Rem    skini       09/08/03 - cluster_member properties 
Rem    skini       05/27/03 - Add type properties for clusters
Rem    rpatti      04/09/03 - add callback for member target delete
Rem    jpyang      04/16/03 - add groups in mgmt_target_types
Rem    rpinnama    07/11/02 - Use constants 
Rem    njagathe    07/05/02 - Changing type display name
Rem    rpinnama    05/16/02 - rpinnama_reorg_rep_scripts_2
Rem    rpinnama    05/16/02 - Created
Rem
--Create the data required from 10.2BETA to 10.2
@@&&EM_SQL_ROOT/core/v102020/group/group_common_init.sql

--
-- Insert group info
--
-- typeDisplayName - the Display name for this type..
-- baseMemberType - the base member type for a typed group
-- memberDerivedStatus - if the status of this type is derived from the members
-- memberDerivedAlert - if the alert of this type is derived from the members
-- is_group - is this target type a group
-- is_composite - is this target type a composite
-- 
-- NOTE : 
-- 1. The is_composite property *must* be set for all composite target types
-- 2. The is_group type property *must* be set for all group types
-- 3. The is_cluster property must be set for all clusters

BEGIN
DECLARE l_type_properties SMP_EMD_NVPAIR_ARRAY;
BEGIN

  -- Composite target type with type properties
  -- typeDisplayName = 'Group'
  -- memberDerivedStatus = '0'
  -- memberDerivedAlert = '0'
  -- is_group = '1'
  -- disallow_redundancy_group = '1'
  l_type_properties := SMP_EMD_NVPAIR_ARRAY (
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DISPLAY_NAME_PROP, 'Group'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DERIVED_STATUS_PROP, '0'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DERIVED_ALERT_PROP, '0'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DISALLOW_REDUNDANCY_GROUP, '1'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DISALLOW_TEMPLATE_PROP, '1'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_IS_GROUP_PROP, '1'));

  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_COMPOSITE_TARGET_TYPE,
                              'Group', 'composite_name',
			      l_type_properties);
 
  l_type_properties.delete;


  -- Host group target type with properties
  -- typeDisplayName = 'Host Group'
  -- baseMemberType = 'host'
  -- memberDerivedStatus = '0'
  -- memberDerivedAlert = '0'
  -- is_group = '1'
  l_type_properties := SMP_EMD_NVPAIR_ARRAY (
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DISPLAY_NAME_PROP, 'Host Group'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_MEMBER_TYPE_PROP, MGMT_GLOBAL.G_HOST_TARGET_TYPE),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DERIVED_STATUS_PROP, '0'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DERIVED_ALERT_PROP, '0'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DISALLOW_REDUNDANCY_GROUP, '1'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_IS_GROUP_PROP, '1'));

  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_HOST_GROUP_TARGET_TYPE,
                              'Host Group', 'host_group_name',
			      l_type_properties);
  l_type_properties.delete;


  -- Database group target type
  -- typeDisplayName = 'Database Group'
  -- baseMemberType = 'oracle_database'
  -- memberDerivedStatus = '0'
  -- memberDerivedAlert = '0'
  -- is_group = '1'
  l_type_properties := SMP_EMD_NVPAIR_ARRAY (
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DISPLAY_NAME_PROP, 'Database Group'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_MEMBER_TYPE_PROP, 
                         MGMT_GLOBAL.G_DATABASE_TARGET_TYPE), 
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DERIVED_STATUS_PROP, '0'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DERIVED_ALERT_PROP, '0'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DISALLOW_REDUNDANCY_GROUP, '1'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_IS_GROUP_PROP, '1'));

  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_DATABASE_GROUP_TARGET_TYPE,
                              'Database Group', 'oracle_database_group_name',
			      l_type_properties);
  l_type_properties.delete;

  -- Cluster target type
  -- is_cluster = '1'
  -- cluster_memeber = 'host'
  l_type_properties := SMP_EMD_NVPAIR_ARRAY (
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_IS_CLUSTER_PROP, '1'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DISALLOW_REDUNDANCY_GROUP, '1'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_CLUSTER_MEMBER_TYPE_PROP, 
                           MGMT_GLOBAL.G_HOST_TARGET_TYPE));

  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_CLUSTER_TARGET_TYPE,
                              'Cluster', 'cluster_name',
			      l_type_properties);
  l_type_properties.delete;

  -- RAC database target type
  -- is_cluster = '1'
  -- cluster_memeber = 'oracle_database'
  l_type_properties := SMP_EMD_NVPAIR_ARRAY (
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_IS_CLUSTER_PROP, '1'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DISALLOW_REDUNDANCY_GROUP, '1'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_CLUSTER_MEMBER_TYPE_PROP, 
                           MGMT_GLOBAL.G_DATABASE_TARGET_TYPE));

  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_RAC_DATABASE_TARGET_TYPE,
                              'Cluster Database', 'rac_database_name',
			      l_type_properties);
  l_type_properties.delete;


  --
  -- 'oracle_apps_system' target type
  --
  -- memberDerivedStatus = '0'
  -- memberDerivedAlert = '0'
  -- is_composite = '1'
  l_type_properties := SMP_EMD_NVPAIR_ARRAY (
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DERIVED_STATUS_PROP, '0'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DERIVED_ALERT_PROP, '0'),
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_IS_COMPOSITE_PROP, '1') );

  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_APPS_SYSTEM_TARGET_TYPE,
                            'Oralce Apps', 'oracle_apps_system_name',
			    l_type_properties);
  l_type_properties.delete;
  
  -- Redundancy Group target type
    l_type_properties := SMP_EMD_NVPAIR_ARRAY (
           SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DERIVED_STATUS_PROP, '0'),
           SMP_EMD_NVPAIR(MGMT_GLOBAL.G_IS_CLUSTER_PROP, '1'),
           SMP_EMD_NVPAIR(MGMT_GLOBAL.G_IS_AGGREGATE_PROP, '1'),
      	   SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DISALLOW_REDUNDANCY_GROUP, '1'));

    MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_REDUNDANCY_GROUP_TARGET_TYPE,
                                'Redundancy Group', 'redundancy_group_name',
                                l_type_properties);
  l_type_properties.delete;
  
  --
  -- target type properties for 'oracle_application' target type
  --
  -- is_composite = '1'
  l_type_properties := SMP_EMD_NVPAIR_ARRAY (
      SMP_EMD_NVPAIR(MGMT_GLOBAL.G_IS_COMPOSITE_PROP, '1') );
  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_APPLICATION_TARGET_TYPE,
                            'Oralce Application', 'oracle_application_name',
			    l_type_properties);
  l_type_properties.delete;

END;
END;
/

-- insert a callback for deletion - so we cleanup summary metric definitions
-- when the last member of particular type is deleted.
BEGIN
  MGMT_ADMIN.add_target_deletion_callback('emd_mntr_comptgt.clean_group_on_mem_tgt_del');
END;
/

-- initialization for group types..
BEGIN
  EM_GROUPS_UI.initialize_group_type(MGMT_GLOBAL.G_REDUNDANCY_GROUP_TARGET_TYPE);
  EM_GROUPS_UI.initialize_group_type(MGMT_GLOBAL.G_GENERIC_SYSTEM_TYPE);
  EM_GROUPS_UI.initialize_group_type(MGMT_GLOBAL.G_COMPOSITE_TARGET_TYPE);
END;
/

COMMIT; 
