Rem
Rem $Header: group_red_mntr_pkgbody.sql 11-mar-2005.10:02:58 ramalhot Exp $
Rem
Rem group_red_mntr_pkgbody.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      group_red_mntr_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      The update_redundancy_group procedure is used to create/modify 
Rem	redundancy groups.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ramalhot  03/11/05 - create/modify red group now uses add/modify 
Rem                         aggregate target 
Rem    dtsao     11/16/04 - Disallow empty red_group in editing mode 
Rem    streddy   11/08/04 - Add new APIs
Rem    ckumar    09/27/04 - ckumar_rgtrans
Rem    ckumar	   08/24/04 - Review comments incorporated
Rem    ckumar      07/20/04 - Created
Rem

CREATE OR REPLACE PACKAGE BODY emd_redundancy_group AS


-- Create a new redundancy group
PROCEDURE create_redundancy_group(p_rgroup_name IN VARCHAR2,
                                  p_rgroup_type IN VARCHAR2,
                                  p_member_targets IN SMP_EMD_NVPAIR_ARRAY
                                              DEFAULT NULL,
                                  p_rgroup_owner IN VARCHAR2
                                              DEFAULT NULL,
                                  p_timezone_rgn IN VARCHAR2 
                                              DEFAULT NULL)
IS
  l_type_count  NUMBER(3);
  l_defined     NUMBER(1);
  l_memb_type   mgmt_targets.target_type%TYPE;
  l_target_guid mgmt_targets.target_guid%TYPE;
  l_rs_metric MGMT_METRIC_INSTANCE; 
  l_rs_dep_list  MGMT_METRIC_INSTANCE_ARRAY := MGMT_METRIC_INSTANCE_ARRAY();
BEGIN
  --
  -- Make sure all member types are of the same type
  -- 
  IF (p_member_targets IS NULL OR p_member_targets.COUNT = 0) THEN
    raise_application_error(MGMT_GLOBAL.NOT_SAME_TARGET_TYPE_ERR,
          'Empty members list passed to create_redundancy_group');
  END IF;

  SELECT COUNT (DISTINCT value)
    INTO l_type_count
    FROM TABLE(CAST(p_member_targets AS SMP_EMD_NVPAIR_ARRAY));

  IF (l_type_count > 1) THEN
    raise_application_error(MGMT_GLOBAL.NOT_SAME_TARGET_TYPE_ERR,
                            MGMT_GLOBAL.NOT_SAME_TARGET_TYPE_ERR_M);
  END IF;

  l_memb_type := p_member_targets(1).value;
 
  --
  -- For generic redundancy group type, check for disallowed types
  --
  IF (p_rgroup_type = mgmt_global.G_REDUNDANCY_GROUP_TARGET_TYPE)
  THEN
     SELECT count(*)
       INTO l_defined
       FROM mgmt_type_properties
      WHERE target_type    = l_memb_type
        AND property_name  = mgmt_global.G_DISALLOW_REDUNDANCY_GROUP 
        AND property_value = mgmt_global.G_TRUE;
     IF (l_defined > 0) THEN
       raise_application_error(MGMT_GLOBAL.NON_ALLOWED_TARGET_TYPE_ERR,
          MGMT_GLOBAL.NON_ALLOWED_TARGET_TYPE_ERR_M || l_memb_type);
     END IF;
  END IF;

  EM_TARGET.add_aggregate_target(p_target_guid => l_target_guid,
                                   p_target_name => p_rgroup_name,
                                   p_target_type => p_rgroup_type,
                                   p_member_targets => p_member_targets,
                                   p_target_owner => p_rgroup_owner,
                                   p_tz_rgn => p_timezone_rgn,
                                   p_required_member_priv => MGMT_USER.VIEW_TARGET
                                  );


  INSERT INTO mgmt_target_properties
     (target_guid, property_name, property_value) 
  VALUES
     (l_target_guid, mgmt_global.G_CLUSTER_MEMBER_TYPE_PROP, l_memb_type);


  -- Register the response/status metric evaluation
  l_rs_metric := MGMT_METRIC_INSTANCE.NEW(p_rgroup_name,p_rgroup_type,
                                          mgmt_global.G_AVAIL_METRIC_NAME,
                                          mgmt_global.G_AVAIL_METRIC_COLUMN,
                                          ' ');
  FOR i IN 1..p_member_targets.COUNT
  LOOP
     l_rs_dep_list.extend(1);
     l_rs_dep_list(i) := 
          MGMT_METRIC_INSTANCE(p_member_targets(i).name,
                               p_member_targets(i).value,
                               mgmt_global.G_AVAIL_METRIC_NAME,
                               mgmt_global.G_AVAIL_METRIC_COLUMN,
                              ' ');
  END LOOP;
  mgmt_target.add_repo_metric_collection(l_rs_metric, 
      mgmt_severity_helper.G_OR_AVAIL_EVAL_PROC_NAME,
                                       l_rs_dep_list);
                                         
END create_redundancy_group;

			       
-- Modifies an existing redundancy group
PROCEDURE modify_redundancy_group(p_rgroup_name IN VARCHAR2,
                                  p_rgroup_type IN VARCHAR2,
                                  p_member_targets IN SMP_EMD_NVPAIR_ARRAY,
                                  p_rgroup_owner IN VARCHAR2 DEFAULT NULL)
IS
 l_targets_to_add  SMP_EMD_NVPAIR_ARRAY;
 l_targets_to_remove SMP_EMD_NVPAIR_ARRAY;
 l_type_count NUMBER(3);
BEGIN
  IF (p_member_targets IS NULL OR p_member_targets.COUNT = 0) THEN
    raise_application_error(MGMT_GLOBAL.NOT_SAME_TARGET_TYPE_ERR,
          'Empty members list passed to modify_redundancy_group');
  END IF;
  SELECT COUNT (DISTINCT value)
    INTO l_type_count
    FROM TABLE(CAST(p_member_targets AS SMP_EMD_NVPAIR_ARRAY));

  IF (l_type_count > 1) THEN
    raise_application_error(MGMT_GLOBAL.NOT_SAME_TARGET_TYPE_ERR,
                            MGMT_GLOBAL.NOT_SAME_TARGET_TYPE_ERR_M);
  END IF;

  SELECT SMP_EMD_NVPAIR(target_name, p_member_targets(1).value)
    BULK COLLECT INTO l_targets_to_add
    FROM
       (SELECT name as target_name
          FROM TABLE(CAST(p_member_targets AS SMP_EMD_NVPAIR_ARRAY))
        MINUS
        SELECT t2.target_name target_name
          FROM mgmt_targets t1,
               mgmt_targets t2,
               mgmt_flat_target_assoc a
         WHERE t1.target_name = p_rgroup_name
           AND t1.target_type = p_rgroup_type
           AND t1.target_guid = a.source_target_guid
           AND t2.target_guid = a.assoc_target_guid
           AND a.is_membership = 1
        );


  SELECT SMP_EMD_NVPAIR(target_name, p_member_targets(1).value)
    BULK COLLECT INTO l_targets_to_remove
    FROM
        (SELECT t2.target_name target_name
           FROM mgmt_targets t1,
                mgmt_targets t2,
                mgmt_flat_target_assoc a
          WHERE t1.target_name = p_rgroup_name
            AND t1.target_type = p_rgroup_type
            AND t1.target_guid = a.source_target_guid
            AND t2.target_guid = a.assoc_target_guid
            AND a.is_membership = 1
         MINUS
         SELECT name as target_name
           FROM TABLE(CAST(p_member_targets AS SMP_EMD_NVPAIR_ARRAY))
        );

   modify_redundancy_group(p_rgroup_name, p_rgroup_type, 
                           l_targets_to_add, l_targets_to_remove,
                           p_rgroup_owner);

END modify_redundancy_group;

-- Modifies an existing redundancy group
PROCEDURE modify_redundancy_group(p_rgroup_name IN VARCHAR2,
                                  p_rgroup_type IN VARCHAR2,
                                  p_targets_to_add IN SMP_EMD_NVPAIR_ARRAY,
                                  p_targets_to_remove IN SMP_EMD_NVPAIR_ARRAY,
                                  p_rgroup_owner IN VARCHAR2 DEFAULT NULL)

IS
  l_type_count  NUMBER(3);
  l_memb_type   mgmt_targets.target_type%TYPE;
  l_temp_type   mgmt_targets.target_type%TYPE;
  l_target_guid mgmt_targets.target_guid%TYPE;
  l_rs_metric MGMT_METRIC_INSTANCE; 
  l_rs_deps_to_add  MGMT_METRIC_INSTANCE_ARRAY := MGMT_METRIC_INSTANCE_ARRAY();
  l_rs_deps_to_del  MGMT_METRIC_INSTANCE_ARRAY := MGMT_METRIC_INSTANCE_ARRAY();
BEGIN
  BEGIN
    SELECT target_guid
      INTO l_target_guid
      FROM mgmt_targets
     WHERE target_name = p_rgroup_name
       AND target_type = p_rgroup_type;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      raise_application_error(mgmt_global.INVALID_PARAMS_ERR,
        'Invalid redundancy group name or type ( ' ||
        p_rgroup_name  || ',' || p_rgroup_type || ')');
  END;

  SELECT property_value
    INTO l_memb_type
    FROM mgmt_target_properties
   WHERE target_guid = l_target_guid
     AND property_name =  mgmt_global.G_CLUSTER_MEMBER_TYPE_PROP;

  -- Make sure that the new targets being added are of the
  -- same type as the existing cluster member type
  IF (p_targets_to_add IS NOT NULL AND 
      p_targets_to_add.COUNT > 1)
  THEN
    SELECT COUNT (DISTINCT value)
      INTO l_type_count
      FROM TABLE(CAST(p_targets_to_add AS SMP_EMD_NVPAIR_ARRAY));

    IF (l_type_count > 1 OR
        l_memb_type <> p_targets_to_add(1).value) 
    THEN
      raise_application_error(MGMT_GLOBAL.NOT_SAME_TARGET_TYPE_ERR,
                              MGMT_GLOBAL.NOT_SAME_TARGET_TYPE_ERR_M);
    END IF;
  END IF;

  EM_TARGET.modify_aggregate_target(p_target_guid => l_target_guid,
                                    p_target_name => p_rgroup_name,
                                    p_target_type => p_rgroup_type,
                                    p_member_targets_to_add => p_targets_to_add,
                                    p_member_targets_to_remove => p_targets_to_remove,
                                    p_target_owner => p_rgroup_owner,
                                    p_required_target_priv => MGMT_USER.OPERATOR_TARGET
                                   );


  -- Update the response/status metric evaluation
  l_rs_metric := MGMT_METRIC_INSTANCE.NEW(p_rgroup_name,p_rgroup_type,
                                          mgmt_global.G_AVAIL_METRIC_NAME,
                                          mgmt_global.G_AVAIL_METRIC_COLUMN,
                                          ' ');
  IF (p_targets_to_remove IS NOT NULL) THEN
    FOR i IN 1..p_targets_to_remove.COUNT
    LOOP
     l_rs_deps_to_del.extend(1);
     l_rs_deps_to_del(i) := 
          MGMT_METRIC_INSTANCE(p_targets_to_remove(i).name,
                               p_targets_to_remove(i).value,
                               mgmt_global.G_AVAIL_METRIC_NAME,
                               mgmt_global.G_AVAIL_METRIC_COLUMN,
                              ' ');
    END LOOP;
  END IF;

  IF (p_targets_to_add IS NOT NULL) THEN
    FOR i IN 1..p_targets_to_add.COUNT
    LOOP
     l_rs_deps_to_add.extend(1);
     l_rs_deps_to_add(i) := 
          MGMT_METRIC_INSTANCE(p_targets_to_add(i).name,
                               p_targets_to_add(i).value,
                               mgmt_global.G_AVAIL_METRIC_NAME,
                               mgmt_global.G_AVAIL_METRIC_COLUMN,
                              ' ');
    END LOOP;
  END IF;

  mgmt_target.modify_repo_metric_deps(l_rs_metric, l_rs_deps_to_add, 
                                      l_rs_deps_to_del);

END modify_redundancy_group;


END emd_redundancy_group;
/

show errors;

