Rem
Rem $Header: group_red_mntr_pkgdef.sql 11-mar-2005.10:03:07 ramalhot Exp $
Rem
Rem red_group_mntr_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      red_group_mntr_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ramalhot    03/11/05 - create/modify red group now uses add/modify 
Rem                           aggregate target 
Rem    streddy     11/08/04 - Add new APIs
Rem    ckumar      09/27/04 - ckumar_rgtrans
Rem    ckumar      07/20/04 - Created
Rem

CREATE OR REPLACE PACKAGE emd_redundancy_group AS

--
-- PROCEDURE: create_redundancy_group
--
-- PURPOSE:
--   Create a new redundancy group with the specified name and member
--   targets. The valid target types that can be passed to this call
--   are types that have the type property is_cluster set to 1 and
--   is_group set to 1. In addition, all the member targets must be
--   of the same type. 
--
-- IN Parameters:
--   p_rgroup_name: The name of the redundancy group
--   p_rgroup_type: The type of the redundancy group
--   p_member_targets: The member targets to add to the group
--   p_group_owner : the owner of the group if not specified it is 
--                   default to G_DEFAULT_TARGET_OWNER <SYSTEM>
--  p_timezone_rgn: timezone region
--
-- OUT Parameters:
--    NONE
-- EXCEPTIONS:
--    NOT_SAME_TARGET_TYPE_ERR_M : If the members are not of the same
--                                 type
--
PROCEDURE create_redundancy_group(p_rgroup_name IN VARCHAR2,
                                  p_rgroup_type IN VARCHAR2,
                                  p_member_targets IN SMP_EMD_NVPAIR_ARRAY
                                             DEFAULT NULL,
                                  p_rgroup_owner IN VARCHAR2 DEFAULT NULL,
                                  p_timezone_rgn IN VARCHAR2 DEFAULT NULL);

--
-- PROCEDURE: modify_redundancy_group
--
-- PURPOSE:
--   Modify the specified redundancy group with a set of targets to 
--   add and/or delete. 
--
-- IN Parameters:
--   p_rgroup_name: The name of the group
--   p_rgroup_type: The type of the group
--   p_member_targets: The member targets to add to the group
--   p_rgroup_owner : the new owner of the group
--
-- OUT Parameters:
--    NONE
--
PROCEDURE modify_redundancy_group(p_rgroup_name IN VARCHAR2,
                                  p_rgroup_type IN VARCHAR2,
                                  p_member_targets IN SMP_EMD_NVPAIR_ARRAY,
                                  p_rgroup_owner IN VARCHAR2 DEFAULT NULL);


--
-- PROCEDURE: modify_redundancy_group
--
-- PURPOSE:
--   Modify the specified redundancy group with a set of targets 
--   to add and/or delete. 
--
-- IN Parameters:
--   p_group_name: The name of the group
--   p_group_type: The type of the group
--   p_targets_to_add: The member targets to add to the group
--   p_targets_to_remove: The member targets to remove from the group
--   p_group_owner : the new owner of the group. If NULL, the owner of
--                   the group is unchanged.
--
-- OUT Parameters:
--    NONE
--
PROCEDURE modify_redundancy_group(p_rgroup_name IN VARCHAR2,
                                  p_rgroup_type IN VARCHAR2,
                                  p_targets_to_add IN SMP_EMD_NVPAIR_ARRAY,
                                  p_targets_to_remove IN SMP_EMD_NVPAIR_ARRAY,
                                  p_rgroup_owner IN VARCHAR2 DEFAULT NULL);

END emd_redundancy_group;
/
show errors;


