Rem drv: <create type="types"/>
Rem
Rem $Header: group_types.sql 12-jul-2006.05:41:37 bram Exp $
Rem
Rem group_types.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      group_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    bram        04/06/06 - fix for bug 5137855
Rem    bram        07/12/06 - Backport bram_bug-5137855 from main 
Rem    rpatti      02/23/06 - Backport rpatti_scnd-fix-4608945 from main 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    nigupta     01/21/05 - add MGMT_AGGR_MEMBERS 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    dtsao       12/15/04 - Change the limit of abbreviation of column from 
Rem                           10 to 64 
Rem    rpatti      11/03/04 - add column cust. support 
Rem    rpatti      10/25/04 - support for group chart display 
Rem    rpatti      10/13/04 - support for custom charts 
Rem    streddy     04/09/03 - Add history support
Rem    streddy     03/18/03 - Add mgmt_member_guids
Rem    rpatti      04/03/03 - add custom type
Rem    skini       07/12/02 - Change in target_name column size
Rem    rpinnama    05/14/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/14/02 - Created
Rem

create or replace type COMP_DEF_AVAIL_REC as OBJECT (
    target_name VARCHAR2(256),
    target_type VARCHAR2(64),
    avail_pct  NUMBER(15,2)
);
/

create or replace type COMP_DEF_AVAIL_REC_ARRAY as TABLE of COMP_DEF_AVAIL_REC;
/

create or replace type SMP_EMD_TARGET_REC as OBJECT (
    targetName VARCHAR2(64),
    targetType VARCHAR2(64),
    metricName VARCHAR2(64),
    metricColumn  VARCHAR2(64)
);
/

create or replace type SMP_EMD_TARGET_REC_ARRAY as TABLE of SMP_EMD_TARGET_REC;
/

CREATE OR REPLACE TYPE MgmtAvailRowType AS OBJECT
    (target_guid                RAW(16),
     severity_guid              RAW(16),
     current_status             NUMBER,
     start_collection_timestamp DATE,
     end_collection_timestamp   DATE);
/

CREATE OR REPLACE TYPE MgmtAvailTableType AS TABLE OF MgmtAvailRowType;
/


CREATE OR REPLACE TYPE mgmt_member_guids AS TABLE OF RAW(16);
/

-- type for compare metrics on group
create or replace type MGMT_GRP_COMPARE_OBJ as OBJECT (
    target_guid RAW(16),
    metric_guid RAW(16),
    target_name VARCHAR2(256),
    timezone_region VARCHAR2(64)
);
/

create or replace type MGMT_GRP_COMPARE_ARRAY as TABLE of MGMT_GRP_COMPARE_OBJ;
/

-- type for custom chart for a group
create or replace type MGMT_GRP_CHART as OBJECT (
    target_type    VARCHAR2(64),
    metric_name    VARCHAR2(64),
    metric_column  VARCHAR2(64),
    chart_type     NUMBER(1),
    display_order  NUMBER(3),
    targets_count  NUMBER(4),
    min_column     NUMBER(1),
    max_column     NUMBER(1),
    avg_column     NUMBER(1),
    sum_column     NUMBER(1),
    stdev_column   NUMBER(1),
    sel_targets    SMP_EMD_NVPAIR_ARRAY
);
/

create or replace type MGMT_GRP_CHART_ARRAY as TABLE of MGMT_GRP_CHART;
/

-- type for display the custom chart
create or replace type MGMT_GRP_CHART_DISP_OBJ as OBJECT (
    target_guid RAW(16),
    metric_guid RAW(16),
    key_value VARCHAR2(256),
    target_name VARCHAR2(256),
    timezone_region VARCHAR2(64)
);
/
                                                                               
create or replace type MGMT_GRP_CHART_DISP_ARRAY as TABLE of MGMT_GRP_CHART_DISP_OBJ;
/

-- improved type for displaying custom chart including tz details
create or replace type MGMT_GRP_CHART_DISP_TZ_OBJ as OBJECT (
    target_guid RAW(16),
    metric_guid RAW(16),
    key_value VARCHAR2(4000),
    target_name VARCHAR2(256),
    timezone_region VARCHAR2(64),
    time_stamp DATE,   -- store target systimestamp 
    time_delta NUMBER  -- delta between group tz and target tz
);
/

create or replace type MGMT_GRP_CHART_DISP_TZ_ARRAY as TABLE of MGMT_GRP_CHART_DISP_TZ_OBJ;
/


-- type for custom column for a group
create or replace type MGMT_GRP_COLUMN as OBJECT (
    target_type    VARCHAR2(64),
    metric_name    VARCHAR2(64),
    metric_column  VARCHAR2(64),
    metric_guid    RAW(16),
    column_type    NUMBER(2),
    display_order  NUMBER(3),
    property_name  VARCHAR2(64),
    abbreviation   VARCHAR2(64)
);
/

create or replace type MGMT_GRP_COLUMN_ARRAY as TABLE of MGMT_GRP_COLUMN;
/

CREATE OR REPLACE TYPE MGMT_AGGR_MEMBERS AS OBJECT 
(
   source_target_name VARCHAR(256),
   source_target_type VARCHAR(64),
   source_target_guid RAW(16),
   assoc_target_name VARCHAR(256),
   assoc_target_type VARCHAR(64),
   assoc_target_guid RAW(16) 
);
/

CREATE OR REPLACE TYPE MGMT_AGGR_MEMBERS_ARRAY AS TABLE OF MGMT_AGGR_MEMBERS;
/

CREATE OR REPLACE TYPE TARGET_DETAILS AS OBJECT
(
   target_guid RAW(16),
   target_name VARCHAR(256),
   target_type VARCHAR(64),
   warning_alerts NUMBER, 
   critical_alerts NUMBER,
   information_pv NUMBER,
   warning_pv NUMBER,
   critical_pv NUMBER,
   current_status NUMBER,
   host_name VARCHAR(256),
   metrics_defined NUMBER,
   response_defined NUMBER
);
/

CREATE OR REPLACE TYPE GUID_ARRAY AS TABLE OF RAW(16);
/

CREATE OR REPLACE TYPE ROLLED_UP_DETAILS AS OBJECT
(
   target_guid RAW(16),
   target_name VARCHAR(256),
   target_type VARCHAR(64),
   num_members NUMBER,
   num_up NUMBER,
   num_down NUMBER,
   num_blacked_out NUMBER, 
   num_unknown NUMBER,
   warning_alerts NUMBER,
   critical_alerts NUMBER,
   information_pv NUMBER,
   warning_pv NUMBER,
   critical_pv NUMBER,
   current_status NUMBER,
   host_name VARCHAR(256),
   mem_count_guids GUID_ARRAY,
   alerts_pv_guids GUID_ARRAY
);
/

CREATE OR REPLACE TYPE ROLLED_UP_DETAILS_ARRAY AS TABLE OF ROLLED_UP_DETAILS;
/

@&EM_SQL_ROOT/core/10.2.0.3/group/groups_types.sql
