Rem
Rem $Header: groups_ui_pkgdef.sql 07-apr-2007.10:30:28 acgopala Exp $
Rem
Rem groups_ui_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      groups_ui_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    acgopala    04/07/07 - bug 5979009 adding get_applicable_member_targets procedure
Rem    vkarpura    09/27/06 - Expose updating charts
Rem    dtsao       08/03/05 - modify get_chart_data to return metric unit 
Rem    dtsao       05/19/05 - Add get_removed_type procedure 
Rem    dtsao       05/16/05 - add proc to get group member types 
Rem    dtsao       05/12/05 - continue
Rem    vagarwal    05/11/05 - add type and instance initialization APIs 
Rem    dtsao       04/29/05 - continue
Rem    dtsao       03/29/05 - Change param names 
Rem    dtsao       03/22/05 - Add apply_default_chart procedure 
Rem    nigupta     01/21/05 - add rollup procedure 
Rem    nigupta     01/06/05 - modify get_system_def to get topology related 
Rem                           data for create/edit 
Rem    ramalhot    12/30/04 - Removed constants that are not required 
Rem    vagarwal    12/13/04 - remove get_group_ingo 
Rem    yaofeng     11/15/04 - add get_applicable_mem_tgt_types 
Rem    yaofeng     11/11/04 - customize columns 
Rem    rpatti      11/05/04 - continue
Rem    rpatti      11/03/04 - add column cust. support 
Rem    streddy     11/04/04 - Added default chart API  
Rem    jpyang      11/02/04 - redundancy group status segment  
Rem    rpatti      10/25/04 - continue
Rem    yaofeng     10/19/04 - pass in query string 
Rem    yaofeng     10/15/04 - Search
Rem    rpatti      10/22/04 - add more update APIs 
Rem    rpatti      10/13/04 - add create/edit APIs 
Rem    vagarwal    10/04/04 - add module name constant 
Rem    vagarwal    09/30/04 - 
Rem    nigupta     09/21/04 - add get_summary_info 
Rem    nigupta     09/20/04 - move expand_node, get_members_and_associations 
Rem                           and get_target_list_details from 
Rem                           group_mntr_pkgdef 
Rem    vagarwal    09/14/04 - vagarwal_groups_0823
Rem    vagarwal    09/02/04 - Created
Rem

CREATE OR REPLACE PACKAGE em_groups_ui AS

-- Package level Type Definition 
   TYPE cursorType IS REF CURSOR;
-- Module Name, used in debugging
   MODULE_NAME CONSTANT VARCHAR2(7)     := 'GROUPS';

-- Summary metric name, key column , metric column names
   G_SUM_METRIC        VARCHAR2(30) := EM_GROUP.SUM_METRIC;
   G_SUM_METRIC_KEY    VARCHAR2(30) := EM_GROUP.SUM_METRIC_KEY;
   G_SUM_METRIC_COLUMN VARCHAR2(30) := EM_GROUP.SUM_METRIC_COLUMN;

-- coll property name used for calculating summary metrics
   G_MEM_METRIC_GUID_PROP_NAME VARCHAR2(64) := EM_GROUP.MEM_METRIC_GUID_PROP_NAME;

-- chart types. 
   G_CHART_SELECTED_TARGETS    NUMBER(1) := 1;
   G_CHART_PEAK_TARGETS        NUMBER(1) := 2;
   G_CHART_HIGHEST_TARGETS     NUMBER(1) := 3;
   G_CHART_LOWEST_TARGETS      NUMBER(1) := 4;
   G_CHART_SUMMARY_METRIC      NUMBER(1) := 5;

-- column type 
   G_COLUMN_TYPE_METRIC        NUMBER(1) := 0;
   G_COLUMN_TYPE_PROPERTY      NUMBER(1) := 1;
   G_COLUMN_TYPE_GEN_PROPERTY  NUMBER(1) := 2;
   G_COLUMN_TYPE_GENERAL       NUMBER(1) := 3;

-- ui pref names
   G_DASHBOARD_REFRESH_TIME_PROP VARCHAR2(64) := 'Dashboard_Refresh_Time';
   G_DASHBOARD_VIEW_TYPE_PROP VARCHAR2(64) := 'Dashboard_Target_View_Type';

--
-- PURPOSE:
--  The following set of functions are used to generate the 
--   appropriate key value for the summary metric evaluation 
--   given a member metric guid. They are also used to generate
--   the appropriate custom chart.
--
-- INPUT:
--  metric_guid_in: Metric guid for a target/metric/metric column combo
--
-- OUTPUT:
--  the string represents the Key Value generated.
--   It is used to uniquely identify a metric - and to provide
--    a key value readable by end users.
--  the string includes the metric name constructed out the default
--   target type and metric column labels.
--   It doesn't account for internationalization.
--

--
FUNCTION get_avg_metric_label
             (metric_guid_in IN RAW)
RETURN VARCHAR2;

FUNCTION get_min_metric_label
             (metric_guid_in IN RAW)
RETURN VARCHAR2;

FUNCTION get_max_metric_label
             (metric_guid_in IN RAW)
RETURN VARCHAR2;

FUNCTION get_sum_metric_label
             (metric_guid_in IN RAW)
RETURN VARCHAR2;

FUNCTION get_stdev_metric_label
             (metric_guid_in IN RAW)
RETURN VARCHAR2;

-- temporary home - till we move to SDK?
-- PROCEDURE
-- 
-- PURPOSE:
--  Initialize metadata for Group type
--    applies to any group type, redundancy group type,
--        system
--
-- INPUT:
--   target_type_in: The target type. 
--
-- OUT Parameters:
--   NONE.
--
PROCEDURE initialize_group_type(target_type_in IN VARCHAR2);

-- PROCEDURE
--
-- PURPOSE:
--  Add a default custom chart
--    applies to any group type, redundancy group type,
--        system
--
-- INPUT:
--   target_type_in: The target type (of the group)
--   chart_type_in: chart type can be:
--      EM_GROUPS_UI.G_CHART_PEAK_TARGETS
--      EM_GROUPS_UI.G_CHART_HIGHEST_TARGETS
--      EM_GROUPS_UI.G_CHART_LOWEST_TARGETS
--      EM_GROUPS_UI.G_CHART_SUMMARY_METRIC
--   member_type_in: The member target type
--   member_metric_in: The member metric
--   member_column_in: The member column
--   targets_count_in: number of targets to be shown in the chart
--    ONLY applicable if chart type is 
--      mgmt_group.G_CHART_PEAK_TARGETS
--      mgmt_group.G_CHART_HIGHEST_TARGETS
--      mgmt_group.G_CHART_LOWEST_TARGETS
--   The following parameters only apply to:
--     chart type : mgmt_group.G_CHART_SUMMARY_METRIC
--   min_column_in: should we show Minimum column
--   max_column_in: should we show Maximum column
--   avg_column_in: should we show Average column
--   sum_column_in: should we show Sum column
--   stdev_column_in: should we show Standard Deviation column
--
-- OUT Parameters:
--   NONE.
--
PROCEDURE add_default_chart(target_type_in   IN VARCHAR2,
                            chart_type_in    IN NUMBER,
                            member_type_in   IN VARCHAR2,
                            member_metric_in IN VARCHAR2,
                            member_column_in IN VARCHAR2,
                            targets_count_in IN NUMBER DEFAULT 2,
                            min_column_in    IN NUMBER DEFAULT 0,
                            max_column_in    IN NUMBER DEFAULT 0,
                            avg_column_in    IN NUMBER DEFAULT 0,
                            sum_column_in    IN NUMBER DEFAULT 0,
                            stdev_column_in  IN NUMBER DEFAULT 0
);

--
-- PROCEDURE: apply_default_charts
--
-- PURPOSE:
--   Apply default chart to the aggregate target. The default charts of new target
--   type will be added, and the default charts of removed target type will be 
--   removed.
--   Please note: This procedure must be called AFTER create_group or modify_group
--   procedure.
--
-- IN Parameters:
--   p_aggr_target_name: The name of the aggregate target
--   p_aggr_target_type: The type of the aggregate target
--   p_targets_to_add: The member targets to add to the aggregate target
--   p_targets_to_remove: The member targets to remove from the aggregate target
--
-- OUT Parameters:
--    NONE
--
PROCEDURE apply_default_charts(p_aggr_target_name IN VARCHAR2,
                       p_aggr_target_type IN VARCHAR2,
                       p_targets_to_add IN SMP_EMD_NVPAIR_ARRAY,
                       p_targets_to_remove IN SMP_EMD_NVPAIR_ARRAY
);

--
-- PROCEDURE: SETUP_TYPE_UI_METADATA
--
-- PURPOSE:
--   Sets up type specific UI metadata for the specified type
--   The API in this package supports the types with is_group/
--   is_redundancy_group/is_system type property set. 
--   This API must be called  immediately after the type is registered.
--
-- IN Parameters:
--   p_target_type_in: The type of the aggregate target 
--
-- OUT Parameters:
--    NONE
--
PROCEDURE setup_type_ui_metadata(p_target_type_in IN VARCHAR2);

--
-- PROCEDURE: APPLY_TARGET_UI_DEFAULTS
--
-- PURPOSE:
--   Applies UI specific customizations to the target instance specified.
--   Intended to be called immediately after target creation/modification
--   The API in this package supports target instances of types with
--   is_group/is_redundancy/is_system type properties set.
--
-- IN Parameters:
--   p_target_name: The name of the aggregate target
--   p_target_type: The type of the aggregate target
--   p_targets_to_add: If called after creation, use the same value 
--                     specified in the p_member_targets param during creation.
--                     If called after modification, use the same value 
--                     specified in p_targets_to_add param during modification
--   p_targets_to_remove: only applicable after modification, use the same 
--                    value specified in p_targets_to_remove param during 
--                    modification
--
-- OUT Parameters:
--    NONE
--
PROCEDURE apply_target_ui_defaults(
    p_target_name         IN mgmt_targets.target_name%TYPE,
    p_target_type         IN mgmt_targets.target_type%TYPE,
    p_targets_to_add      IN SMP_EMD_NVPAIR_ARRAY,
    p_targets_to_remove   IN SMP_EMD_NVPAIR_ARRAY);

------------------------------------------------------------------------
--  Admin Related API
------------------------------------------------------------------------
                                                                               
--
-- PROCEDURE: update_group
--
-- PURPOSE:
--   This procedure supports edit/create of a group
--
-- IN Parameters:
--   target_name_in: The group target name
--   target_type_in: The target type. 
--   timezone_rgn_in: timezone of this target
--   mode_in: is this edit(1) or create(0)
--   member_targets_in: List of member targets
--   charts_list_in: List of custom charts
--   columns_list_in: List of custom columns
--
-- OUT Parameters:
--   NONE.
--
PROCEDURE update_group(
                target_name_in    IN  VARCHAR2,
                target_type_in    IN  VARCHAR2,
                edit_mode_in      IN  INTEGER,
                timezone_rgn_in   IN  VARCHAR2,
                member_targets_in IN  SMP_EMD_NVPAIR_ARRAY,
                charts_list_in    IN  MGMT_GRP_CHART_ARRAY,
                columns_list_in   IN  MGMT_GRP_COLUMN_ARRAY,
                prefs_in          IN  SMP_EMD_NVPAIR_ARRAY
);

--
--
-- PROCEDURE: update_redundancy_group
--
-- PURPOSE:
--   This procedure supports edit/create of a redundancy group
--
-- IN Parameters:
--   target_name_in: The group target name
--   target_type_in: The target type.
--   timezone_rgn_in: timezone of this target
--   mode_in: is this edit(1) or create(0)
--   member_targets_in: List of member targets
--   charts_list_in: List of custom charts
--   columns_list_in: List of custom columns
--
-- OUT Parameters:
--   NONE.
--
PROCEDURE update_redundancy_group (
                target_name_in    IN  VARCHAR2,
                target_type_in    IN  VARCHAR2,
                edit_mode_in      IN  INTEGER,
                timezone_rgn_in   IN  VARCHAR2,
                member_targets_in IN  SMP_EMD_NVPAIR_ARRAY,
                charts_list_in    IN  MGMT_GRP_CHART_ARRAY,
                columns_list_in   IN  MGMT_GRP_COLUMN_ARRAY,
                prefs_in          IN  SMP_EMD_NVPAIR_ARRAY
);


--
-- PURPOSE:
--   This procedure supports edit/create of a system
--
-- IN Parameters:
--   target_name_in: The system target name
--   target_type_in: The target type.
--   timezone_rgn_in: timezone of this target
--   mode_in: is this edit(1) or create(0)
--   member_targets_in: List of member targets
--   assoc_list_in: List of associations between the members
--   charts_list_in: List of custom charts
--   columns_list_in: List of custom columns
--   topo_prefs_in: name/value pairs of graph properties
--   node_pos_in: list of node ids and their coordinates
--   image_name_in: the name of the system topology background image
--   image_data_in: the data for the system topology background image
-- OUT Parameters:
--   NONE.
--
PROCEDURE update_system (
                target_name_in    IN  VARCHAR2,
                target_type_in    IN  VARCHAR2,
                edit_mode_in      IN  INTEGER,
                timezone_rgn_in   IN  VARCHAR2,
                member_targets_in IN  SMP_EMD_NVPAIR_ARRAY,
                assoc_list_in     IN  MGMT_NVPAIR_TUPLE_LIST,
                charts_list_in    IN  MGMT_GRP_CHART_ARRAY,
                columns_list_in   IN  MGMT_GRP_COLUMN_ARRAY,
                prefs_in          IN  SMP_EMD_NVPAIR_ARRAY,
                topo_prefs_in     IN  SMP_EMD_NVPAIR_ARRAY,
                node_pos_in       IN  TOPO_NODE_POS_ARRAY, 
                image_name_in     IN  mgmt_topo_page_bg_image.image_name%TYPE,
                image_data_in     IN  mgmt_topo_page_bg_image.image_data%TYPE
);
                                                                               
--
-- PROCEDURE: get_group_def
--
-- PURPOSE:
--   This procedure returns the definition of a group
--     Also used for a redundancy group.
--
-- IN Parameters:
--   target_name_in: The group target name
--   target_type_in: The target type. 
--
-- OUT Parameters:
--   timezone_rgn_out: timezone of this target
--   members_out: CURSOR_TYPE A cursor with rows containing:
--     target_guid: The target guid of a member target
--     target_name: The target name of a member target
--     target_type: The target type of a member target
--     timezone_region: The timezone region of a member target
--
--   charts_list_out: CURSOR_TYPE A cursor with custom chart defns
--   charts_sel_tgt_out: CURSOR_TYPE A cursor with list of targets
--             to be used for charts with selected targets
--
PROCEDURE get_group_def(
                target_name_in      IN   VARCHAR2,
                target_type_in      IN   VARCHAR2,
                timezone_rgn_out    OUT  VARCHAR2,
                members_out         OUT  cursorType,
                charts_list_out     OUT  cursorType,
                charts_sel_tgt_out  OUT  cursorType,
                columns_list_out    OUT  cursorType,
                prefs_list_out      OUT  cursorType
);

--
-- PROCEDURE: get_system_def
--
-- PURPOSE:
--   This procedure returns the definition of a system
--
-- IN Parameters:
--   target_name_in: The group target name
--   target_type_in: The target type. 
--
-- OUT Parameters:
--   timezone_rgn_out: timezone of this target
--   members_out: A cursor with rows containing:
--     target_guid: The target guid of a member target
--     target_name: The target name of a member target
--     target_type: The target type of a member target
--     timezone_region: The timezone region of a member target
--
--   charts_list_out: A cursor with custom chart defns
--   charts_sel_tgt_out: A cursor with list of targets
--             to be used for charts with selected targets
--   assoc_list_out: A cursor with list of any associations
--             between the members of a system, contains:
--     source_target_guid -
--     assoc_target_guid -
--     source_target_name -
--     source_target_type -
--     assoc_target_name - associated (destination) target name
--     assoc_target_type - associated (destination) target type
--     assoc_guid - association guid
--     association_type - association type
--     assoc_def_name - association name
--     name_nlsid  - association name nls id
--     system_scope - is this association in the scope of this system
--          1 if in scope of the system
--          0 if in GLOBAL scope
--   topo_prefs_list_out: A cursor with list of preferences for 
--                        this system's topology, contains:
--     preference_name: the name of the preference
--     preference_value: the value for the preference
--   node_pos_list_out: A cursor with the coordinates for nodes corresponding
--                      to members of system, contains:
--     node_id: the id for the node
--     x: the x coordinate
--     y: the y coordinate 
--   image_data_out: A cursor with the image data for the background image for
--                   topology, contains: 
--     image_name: the name of the image
--     image_data: the image data  
PROCEDURE get_system_def(
                target_name_in      IN   VARCHAR2,
                target_type_in      IN   VARCHAR2,
                timezone_rgn_out    OUT  VARCHAR2,
                members_out         OUT  cursorType,
                assoc_list_out      OUT  cursorType,
                topo_prefs_list_out OUT  cursorType,
                node_pos_list_out   OUT  cursorType,
                image_data_out      OUT  cursorType,
                charts_list_out     OUT  cursorType,
                charts_sel_tgt_out  OUT  cursorType,
                columns_list_out    OUT  cursorType,
                prefs_list_out      OUT  cursorType
);

--
-- PURPOSE:
--   This procedure returns the list of default charts 
--   applicable for a list of member types
--
-- IN Parameters:
--   target_type_in: the composite target type
--   member_types_in: list of member types
--
-- OUT Parameters:
--   charts_list_out: A cursor with custom chart defns

PROCEDURE get_default_charts_list (
                target_type_in  IN   VARCHAR2,
                members_in      IN   SMP_EMD_NVPAIR_ARRAY,
                charts_list_out OUT  cursorType
);

--
-- PURPOSE:
--   This procedure returns the list of available columns
--   for a list of member types
--
-- IN Parameters:
--   member_types_in: list of member types
--
-- OUT Parameters:
--   columns_list_out: A cursor with column defns
                                                                                
PROCEDURE get_avail_columns_list (
                target_type_in  IN  VARCHAR2,
                members_in      IN  SMP_EMD_NVPAIR_ARRAY,
                columns_list_out     OUT  cursorType
);

--
-- PURPOSE:
--   This procedure returns the list of applicable
--   member types given the top level members of a group
--
-- IN Parameters:
--   member_in: list of target
--
-- OUT Parameters:
--   types_out: A cursor with target types
                                                                                
PROCEDURE get_applicable_mem_tgt_types (
                members_in      IN  SMP_EMD_NVPAIR_ARRAY,
                types_out      OUT  cursorType
);

--
-- PURPOSE:
--   This procedure returns the list of applicable
--   member targets given the top level members of a group
--
-- IN Parameters:
--   member_in: list of target
--
-- OUT Parameters:
--   targets_out: A cursor with target types
                                                                                
PROCEDURE get_applicable_member_targets (
                members_in      IN  SMP_EMD_NVPAIR_ARRAY,
                targets_out      OUT  cursorType
);
------------------------------------------------------------------------
--  Homepage Related API
------------------------------------------------------------------------
-- PROCEDURE: get_group_alerts_info
--
-- PURPOSE:
--   This procedure returns the alerts for the specified group.
--   Used by the Alerts segment.
--
-- IN Parameters:
--   target_name_in: The group target name
--   target_type_in: The group target type. 
--
-- OUT Parameters:
--   severity_cur_out: The cursor containing target severities information
--   metric_error_cur_out: The cursor containing metric errors information
--
PROCEDURE get_group_alerts_info(  target_name_in VARCHAR2,
                           target_type_in IN VARCHAR2,
                           severity_cur_out OUT cursorType,
                           metric_error_cur_out OUT cursorType);

-- PROCEDURE: get_group_members_info
--
-- PURPOSE:
--   This procedure returns the membership information  for the specified group
--
-- IN Parameters:
--   target_name_in: The group target name
--   target_type_in: The group target type. 
--   member_target_type_in: If set, only member target of this type would be ret
--   urned.
--   member_target_name_in: If set, only member target has name like this 
--   would be returned.
--
-- OUT Parameters:
--   target_types_cur_out:  The cursor containing target types of member targets
--   members_details_out:   Cursor containing member information
--
PROCEDURE get_group_members_info(
              target_name_in        IN  VARCHAR2,
              target_type_in        IN  VARCHAR2,
              member_target_type_in IN  VARCHAR2 DEFAULT NULL,
              member_target_name_in IN  VARCHAR2 DEFAULT NULL,
              target_types_out      OUT cursorType,
              member_targets_out    OUT cursorType,
              columns_info_out      OUT cursorType,
              status_info_out       OUT cursorType,
              alerts_info_out       OUT cursorType,
              policy_info_out       OUT cursorType,
              prop_columns_out      OUT cursorType,
              metric_values_out     OUT cursorType,
              metric_sev_out        OUT cursorType);

-- PROCEDURE: get_group_availability_info
--
-- PURPOSE:
--   This procedure returns the availability information  for the specified group
--   Used by the groups status segment
--
-- IN Parameters:
--   target_name_in: The group target name
--   target_type_in: The group target type. 
--
-- OUT Parameters:
--   availability_cur_out: The cursor containing member targets availability 
--   information. group targets are excluded.
--
PROCEDURE get_group_availability_info(  target_name_in VARCHAR2,
                           target_type_in IN VARCHAR2,
                           avail_cur_out OUT cursorType
                           );
                                                                               

-- PROCEDURE: get_redundant_group_availability_info
--
-- PURPOSE:
--   This procedure returns the availability information  for the specified group
--   Used by the groups status segment
-- 
-- IN Parameters:
--   target_name_in: The group target name
--   target_type_in: The group target type. 
--
-- OUT Parameters:
--   availability_cur_out: The cursor containing member targets availability 
--   information. group targets are excluded.
--   status_section_out: The cursor containing status, up since, availability
--   %, and member type information.
--
PROCEDURE get_red_group_avail_info(  target_name_in VARCHAR2,
                               target_type_in IN VARCHAR2,
                               avail_cur_out OUT cursorType,
                               status_section_out OUT cursorType);

--
-- PROCEDURE: get_summary_info
-- 
-- PURPOSE:
--   Returns the total number of critical alerts, warning alerts and policy 
--   violations for the members of a group/system.
--
-- IN Parameters:
--   target_name_in: mgmt_targets.target_name%TYPE
--                   The name of the group/system
--   target_type_in: mgmt_targets.target_type%TYPE
--                   The type of the group/system
--
-- OUT Parameters:
--   critical_alerts_out: NUMBER The number of critical alerts for the members
--                        of this group/system
--   warning_alerts_out: NUMBER The number of warning alerts for the members
--                        of this group/system
--   policy_vc_out: NUMBER The number of policy violations for the members
--                        of this group/system
--   num_targets_out: NUMBER The number of member targets for this 
--                    group/system   
PROCEDURE get_summary_info
  (target_name_in IN mgmt_targets.target_name%TYPE,
   target_type_in IN mgmt_targets.target_type%TYPE,
   critical_alerts_out OUT NUMBER,
   warning_alerts_out OUT NUMBER,
   policy_vc_out OUT NUMBER,
   num_targets_out OUT NUMBER);

--
-- PROCEDURE: get_group_charts_list
--
-- PURPOSE:
--   Returns the list of custom charts for a group and necessary
--    info to luanch the charts on the homepage.
--
-- IN Parameters:
--   target_name_in: mgmt_targets.target_name%TYPE
--                   The name of the group/system
--   target_type_in: mgmt_targets.target_type%TYPE
--                   The type of the group/system
--
-- OUT Parameters:
--   charts_list_out : cursor containing ordered list of
--    chart definitions for this group/system
--     comp_chart_guid: the unique guid of the chart
--     chart_type: type of the chart
--     display_order: the order in which the charts should show up
--     target_type : member target type this chart applies to
--     metric_guid : member metric guid this chart applies to
--     metric_name : member metric name this chart applies to
--     metric_column : member metric column this chart applies to
--     column_label_nlsid : member metric column nls id this chart applies to
--
PROCEDURE get_group_charts_list(
                target_name_in      IN   VARCHAR2,
                target_type_in      IN   VARCHAR2,
                charts_list_out     OUT  cursorType);

--
-- PROCEDURE: get_chart_data
--
-- PURPOSE:
--   Returns the timeseries data for the relevant chart
--
-- IN Parameters:
--   target_name_in: mgmt_targets.target_name%TYPE
--                   The name of the group/system
--   target_type_in: mgmt_targets.target_type%TYPE
--                   The type of the group/system
--   chart_guid_in: Unique GUID for the chart
--   timeperiod_in: Time period of the timeseries
--
-- OUT Parameters:
--   timeseries_out : cursor containing ordered list of
--   metric_unit_out: The Unit NLSID of member metric

PROCEDURE get_chart_data(
              target_name_in     IN  VARCHAR2,
              target_type_in     IN  VARCHAR2,
              chart_guid_in      IN  RAW,
              time_period_in     IN  VARCHAR2,
              timeseries_out     OUT cursorType,
              metric_unit_out    OUT cursorType);

------------------------------------------------------------------------
--  Topology Related API
------------------------------------------------------------------------
                                                                               
--
-- PROCEDURE: get_members_and_associations
-- 
-- PURPOSE:
--   Gets the members and the associations between the members for a given 
--   target
--
-- IN Parameters:
--   p_target_name: mgmt_targets.target_name%TYPE The name of the target
--   p_target_type: mgmt_targes.target_type%TYPE The type of the target
--
-- OUT Parameters:
--   members_out: CURSOR_TYPE A cursor with rows containing:
--     target_guid: mgmt_targets.target_guid%TYPE The target guid for a member
--                  target
--   associations_out: CURSOR_TYPE A cursor with rows containing:
--     source_target_guid: mgmt_targets.target_guid%TYPE The target guid for 
--                         the source target for this association
--     assoc_target_guid: mgmt_targets.target_guid%TYPE The target guid for 
--                        the associated target for this assocition
--     association_type: mgmt_target_assoc_defs%TYPE The association type for 
--                       this association
PROCEDURE get_members_and_associations
  (p_target_name IN mgmt_targets.target_name%TYPE,
   p_target_type IN mgmt_targets.target_type%TYPE,
   members_out OUT cursorType,
   associations_out OUT cursorType);


--
-- PROCEDURE: get_target_list_details
-- 
-- PURPOSE:
--   Returns a summary of monitoring details for a list of targets
--
-- IN Parameters:
--   target_guid_list_in: MGMT_TARGET_GUID_ARRAY
--                        The target_guid_list_in will consist of target guids
--                        for which the details are to be obtained
-- OUT Parameters:
--   details_out: CURSOR_TYPE A cursor which contains rows containing:
-- 
PROCEDURE get_target_list_details
  (target_guid_list_in IN MGMT_TARGET_GUID_ARRAY,
   details_out OUT cursorType);


PROCEDURE expand_node
  (parent_guid_in IN mgmt_targets.target_guid%TYPE,
   sys_tgt_name_in IN mgmt_targets.target_name%TYPE,
   sys_tgt_type_in IN mgmt_targets.target_type%TYPE,
   existing_guids_in IN MGMT_TARGET_GUID_ARRAY,
   updated_guids_out OUT cursorType,
   associations_out OUT cursorType,
   outgoing_link_count_out OUT cursorType);

-- 
-- PROCEDURE: rollup
--
-- PURPOSE:
--   Rolls up various values like alerts, policy violations, etc. for an 
--   aggregate target and its members.
--  
-- IN Parameters:
--   aggr_target_name_in: MGMT_TARGETS.TARGET_NAME%TYPE the target name of the
--                        aggregate target for which the values are to be rolled
--                        up
--   aggr_target_type_in: MGMT_TARGETS.TARGET_TYPE%TYPE the target type of the
--                        aggregate target for which the values are to be rolled
--                        up
--   members_details: NUMBER determines whether the details are to be obtained
--                    only for the aggregate target itself or its members as 
--                    well. A value of 0 implies that the values are to be 
--                    obtained for the aggregate target only. A 1 value implies
--                    that the values are to obtained for the members as well.
-- 
-- OUT Parameters:
--   rolled_up_details_out: CURSOR_TYPE A cursor containing rows (only 1 row
--                          if members_details is 0) containing:
--     target_guid: MGMT_TARGETS.TARGET_GUID%TYPE the target guid of the target
--     target_name: MGMT_TARGETS.TARGET_NAME%TYPE the target name of the target
--     target_type: MGMT_TARGETS.TARGET_TYPE%TYPE the target type of the target
--     num_members: NUMBER the rolled up value for the number of members for 
--                  this target. This value is valid only for an aggregate 
--                  target.
--     num_up: NUMBER the rolled up value for the number of members that are in 
--             the up state. This value is valid only for an aggregate target.
--     num_down: NUMBER the rolled up value for the number of members that are 
--               in the down state. This value is valid only for an aggregate 
--               target.
--     num_blacked_out: NUMBER the rolled up value for the number of members 
--                      that are in blacked out state. This value is valid only
--                      for an aggregate target.
--     num_unknown: NUMBER the rolled up value for the number of members that 
--                  are in unknown state (i.e. not up, down or blacked out). 
--                  This value is valid only for an aggregate target. 
--     warning_alerts: NUMBER the number of warning alerts for this target. If
--                     this is an aggregate target, then this is the rolled up
--                     value.
--     critical_alerts: NUMBER the number of critical alerts for this target. 
--                      Same comments as warning alerts apply.
--     information_pv: NUMBER the number of information policy violations for
--                     this target. Same comments as warning_alerts apply.
--     warning_pv: NUMBER the number of warning policy violations for this 
--                 target. Same comments as warning_alerts apply.
--     critical_pv: NUMBER the number of critical policy violations for this
--                  target. Same comments as warning alerts apply.
--     current_status: NUMBER the status of the target. If the status is not
--                     defined for the target, then -1 is returned
--     host_name: MGMT_TARGETS.HOST_NAME%TYPE the host name for the target. If 
--                there is no host for this target (eg. for aggregate targets)
--                then it is NULL
--
PROCEDURE rollup
  (aggr_target_name_in IN mgmt_targets.target_name%TYPE,
   aggr_target_type_in IN mgmt_targets.target_type%TYPE,
   member_details IN NUMBER,
   rolled_up_details_out OUT cursorType);

--
-- Name: get_targets
--
-- Package: emd_mntr
--
-- Purpose: 
--   Wrapper function to be used as a table function. Runs the provided query
-- and returns its results pipelined as SMP_EMD_TGT_OBJECT_TBL
--
-- IN parameters:
--   comp_target_name: VARCHAR2 target_name of the composite target
--   comp_target_type: VARCHAR2 target_type of the composite target
--   member_target_type: VARCHAR2 If provided, only return member targets of this type
--   member_target_name: VARCHAR2 If provided, only return member targets whose --    name is like this
--
-- OUT parameters:
--
-- ERROR codes:
--
FUNCTION get_targets(comp_target_name IN VARCHAR2,
                     comp_target_type IN VARCHAR2,
                     member_target_type IN VARCHAR2 DEFAULT NULL,
                     member_target_name IN VARCHAR2 DEFAULT NULL)
            RETURN SMP_EMD_TGT_OBJECT_TBL PIPELINED;

PROCEDURE GET_GROUP_MEMBER_TARGET_TYPES(p_aggr_name IN VARCHAR2,
    p_aggr_type IN VARCHAR2 , member_types_out OUT cursorType);


----
-- Name : get_removed_type
--
-- Purpose : Given the removed member targets and new member list, return
--  removed member target type.
--
-- IN parameters : 
--         p_targets_to_remove : Removed targets
--         member_targets_in   : New member target list
--
-- Out parameters :
--    target type that exists before removing but not in the new list.
PROCEDURE get_removed_type(
                p_targets_to_remove IN SMP_EMD_NVPAIR_ARRAY,
                member_targets_in IN  SMP_EMD_NVPAIR_ARRAY,
                removed_types_out    OUT  cursorType
);

PROCEDURE update_columns
(
                target_name_in    IN  VARCHAR2,
                target_type_in    IN  VARCHAR2,
                edit_mode_in      IN  INTEGER,
                columns_list_in   IN  MGMT_GRP_COLUMN_ARRAY
);


end em_groups_ui;

/

show errors;
