Rem
Rem $Header: host_admin_pkgdef.sql 25-may-2005.16:03:52 ajdsouza Exp $
Rem
Rem host_admin_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      host_admin_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ajdsouza    05/25/05 - move types ddl to a different file
Rem    ajere       04/11/05 - Add getTargetTimeZone 
Rem    ajere       11/08/04 - Add a procedure getExecutionID for Abort functionality 
Rem    ajere       10/22/04 - Add a procedure getTargetHostName 
Rem    ajere       08/13/04 - Network Shell Page procedures 
Rem    ajere       06/16/04 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100


CREATE OR REPLACE PACKAGE HOST_ADMIN AS

  /* Package level Type Definition */
  TYPE cursorType IS REF CURSOR;

  PROCEDURE getCmdShell (
              target_name_in  IN  mgmt_targets.target_name%TYPE,
              target_type_in  IN  mgmt_targets.target_type%TYPE,
              cmd_shell_out   OUT VARCHAR2
            );
  
  PROCEDURE checkPrefCreds (
              target_name_in  IN  mgmt_targets.target_name%TYPE,
              target_type_in  IN  mgmt_targets.target_type%TYPE,
              em_user_in      IN  mgmt_target_credentials.user_name%TYPE,
              normal_exist    OUT BOOLEAN,
              priv_exist      OUT BOOLEAN
            );

  PROCEDURE getPrefCreds (
              target_name_in  IN  mgmt_targets.target_name%TYPE,
              target_type_in  IN  mgmt_targets.target_type%TYPE,
              em_user_in      IN  mgmt_target_credentials.user_name%TYPE,
              credentials_out OUT HA_HOST_CREDS_ARR
            );

  PROCEDURE getPrefCreds (
              target_name_in     IN  mgmt_targets.target_name%TYPE,
              target_type_in     IN  mgmt_targets.target_type%TYPE,
              em_user_in         IN  mgmt_target_credentials.user_name%TYPE,
              cred_set_name_in IN  mgmt_target_credentials.credential_set_name%TYPE,
              user_name_out      OUT mgmt_credentials2.credential_value%TYPE,
              password_out       OUT mgmt_credentials2.credential_value%TYPE
            );

  FUNCTION getCredColumn (
             cred_guid_in       IN  mgmt_target_credentials.credential_guid%TYPE,
             cred_set_column_in IN  mgmt_credentials2.credential_set_column%TYPE
           ) RETURN mgmt_credentials2.credential_value%TYPE;


  PROCEDURE checkCmdShellAndPrefCreds (
              target_name_in  IN  mgmt_targets.target_name%TYPE,
              target_type_in  IN  mgmt_targets.target_type%TYPE,
              em_user_in      IN  mgmt_target_credentials.user_name%TYPE,
              cmd_shell_out   OUT VARCHAR2,
              normal_exist    OUT BOOLEAN,
              priv_exist      OUT BOOLEAN
            );

  PROCEDURE getCmdShellAndPrefCreds (
              target_name_in  IN  mgmt_targets.target_name%TYPE,
              target_type_in  IN  mgmt_targets.target_type%TYPE,
              em_user_in      IN  mgmt_target_credentials.user_name%TYPE,
              cmd_shell_out   OUT VARCHAR2,
              credentials_out OUT HA_HOST_CREDS_ARR
            );

  FUNCTION getTargetGuid (
             target_name_in IN mgmt_targets.target_name%TYPE,
             target_type_in IN mgmt_targets.target_type%TYPE
           ) RETURN mgmt_targets.target_guid%TYPE;
  
	FUNCTION getCredentialGuid (
             target_guid_in            IN mgmt_targets.target_guid%TYPE,
             em_user_in                IN mgmt_target_credentials.user_name%TYPE,
             cred_set_name_in          IN mgmt_target_credentials.credential_set_name%TYPE,
             get_target_level_creds_in IN BOOLEAN DEFAULT TRUE
           ) RETURN mgmt_target_credentials.credential_guid%TYPE;

  PROCEDURE saveAsPreferredCreds (
              target_name_in  IN  mgmt_targets.target_name%TYPE,
              target_type_in  IN  mgmt_targets.target_type%TYPE,
              em_user_in      IN  mgmt_target_credentials.user_name%TYPE,
              user_name_in    IN mgmt_credentials2.credential_value%TYPE,
              password_in     IN mgmt_credentials2.credential_value%TYPE,
              cred_set_name_in IN  mgmt_target_credentials.credential_set_name%TYPE
            );

  PROCEDURE getMemberHosts (
              group_target_name_in IN  mgmt_targets.target_name%TYPE,
              member_host_list_out OUT cursorType
            );

  PROCEDURE getTargetHostName (
              target_name_in  IN  mgmt_targets.target_name%TYPE,
              target_type_in  IN  mgmt_targets.target_type%TYPE,
              host_name_out   OUT VARCHAR2
            );
  
  PROCEDURE getExecutionID (
              execution_id_out OUT NUMBER
            );
  
  PROCEDURE getTargetTimeZone (
              target_name_in  IN  mgmt_targets.target_name%TYPE,
              target_type_in  IN  mgmt_targets.target_type%TYPE,
              time_zone_out   OUT VARCHAR2
            );
  
END HOST_ADMIN;
/
