Rem
Rem $Header: host_ui_pkgdef.sql 29-jul-2007.14:15:39 qsong Exp $
Rem
Rem host_ui_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      host_ui_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    qsong       07/29/07 - XbranchMerge qsong_bug-6279839 from main
Rem    aptrived    03/09/06 - Bug#4742179, Adding constants
Rem    ajayshar    07/14/05 - Bug-4448722- CSA Collector status pending
Rem    rpatti      04/26/05 - remove obsolete sql 
Rem    ajdsouza    03/01/05 - add constants for metric columns
Rem                           cpuUtil memUsedPct, totIO, Load
Rem    groyal      11/02/04 - Update getHostSiteMapInfo 
Rem    asawant     09/27/04 - Cutting over user prefs 
Rem    asawant     09/13/04 - Adding more user prefered columns 
Rem    xuliu       08/29/03 - cluster name 
Rem    kcheng      08/28/03 - 
Rem    kcheng      08/13/03 - get os info for host pages
Rem    groyal      07/08/03 - Add policy violations support
Rem    lhan        06/17/03 - Add osm diskgroups query
Rem    rpatti      04/14/03 - fix for timezone issues
Rem    rpatti      01/09/03 - support def summary metrics
Rem    kcheng      10/22/02 - update getHostSiteMapInfo
Rem    njuillar    10/14/02 - Get rid of Host Group availability concept
Rem    rpatti      06/26/02 - rpatti_support_netapp_plsql_pkg
Rem    rpatti      06/26/02 - Moving to new file
Rem    rpatti      06/13/02 - support new avail states
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Restructured.
Rem    rpatti      04/10/02 - show detailed availability numbers
Rem    tjaiswal    04/01/02 - Misc group fixes
Rem    rpatti      02/25/02 - use function to get current user
Rem    rpatti      01/24/02 - fix build
Rem    kcheng      01/22/02 - split host page
Rem    rpatti      01/21/02 - more optimizations
Rem    rpatti      01/18/02 - more changes
Rem    rpatti      01/17/02 - config values moved to properties
Rem    rpatti      01/09/02 - make sure username is uppercase
Rem    rpatti      01/08/02 - suport customization of metrics
Rem    rpatti      01/07/02 - perf changes
Rem    rpatti      01/03/02 - separate out summary metric query
Rem    edemembe    01/08/02 - Metrics are now target independent
Rem    rpatti      12/26/01 - inventory pages for host group
Rem    ancheng     12/18/01 - change getHostSiteMapInfo
Rem    agor        12/17/01 - get target Oracle Home
Rem    ancheng     12/13/01 - modify getHostSiteMapInfo
Rem    rpatti      12/12/01 - Merged rpatti_host_groups_1
Rem    rpatti      12/11/01 - Created
Rem

CREATE OR REPLACE PACKAGE emd_mntr_host AS

-- Package level Type Definition 
   TYPE cursorType IS REF CURSOR;

-- Constants for some host metrics 
G_LOAD_METRIC_NAME            CONSTANT VARCHAR2(32) := 'Load';
G_CPU_UTIL_METRIC_COLUMN      CONSTANT VARCHAR2(32) := 'cpuUtil';
G_MEM_USED_METRIC_COLUMN      CONSTANT VARCHAR2(32) := 'memUsedPct';
G_TOT_IO_METRIC_COLUMN        CONSTANT VARCHAR2(32) := 'totIO';

G_DATE_TIME_TIME_FORMAT       CONSTANT VARCHAR2(32) := 'YYYY-MM-DD HH24:MI:SS';
G_DATE_TIME_TIMEZONE_FORMAT   CONSTANT VARCHAR2(32) := 'YYYY-MM-DD HH24:MI:SS TZH:TZM';
G_BOOTTIME                    CONSTANT VARCHAR2(16) := 'Boottime';

/*
 * set_default_metric_preferences - set the default metrics to show up in the
 *                                  summary for a given user
 *
 *   p_user_name     - the user being modified
 *   p_callback_type - type of modification; may be one of:
 *                       MGMT_USER.USER_CREATED_CALLBACK
 *                       MGMT_USER.USER_DROPPED_CALLBACK
 */
PROCEDURE set_default_subtab_preferences(p_user_name     IN VARCHAR2,
                                         p_callback_type IN NUMBER);

/*
Get the host site map related info. This procedure returns all the relevant
information for a given host target name and host target type.
The values returned as OUT parameters are used for display in the
hostOverview page
*/
procedure getHostSiteMapInfo(
                                target_name_in IN VARCHAR2,
                                target_type_in IN VARCHAR2,
                                type_display_name_out OUT VARCHAR2,
                                avail_status_out OUT INTEGER,
                                avail_pct_out OUT NUMBER,
                                time_zone_out OUT VARCHAR2,
                                os_info_out OUT VARCHAR2,
                                hw_info_out OUT VARCHAR2,
                                start_timestamp_out OUT Date,
                                config_values_out OUT cursorType,
                                osm_target_name_out OUT VARCHAR2,
                                ofs_total_out OUT NUMBER,
                                osm_diskgroups_total_out OUT NUMBER,
                                os_name_out OUT VARCHAR2,
                                cpu_count_out OUT NUMBER,
                                memory_size_out OUT NUMBER,
                                disk_space_out OUT NUMBER,
                                cluster_name_out OUT VARCHAR2,
                                cluster_display_type_out OUT VARCHAR2
);

PROCEDURE getHostTargetListInfo(
                                target_name_in IN VARCHAR2,
                                target_type_in IN VARCHAR2,
                                type_display_name_out OUT VARCHAR2,
                                target_summary_out OUT cursorType
);

/*
Get the host summary related info. This procedure returns all the relevant
information for a given host target name and host target type.
The values returned as OUT parameters are used for display in the
hostSummary page
*/
procedure getHostSummaryInfo(
                                target_name_in IN VARCHAR2,
                                target_type_in IN VARCHAR2,
                                type_display_name_out OUT VARCHAR2,
                                last_load_time_out OUT DATE,
                                emd_url_out OUT VARCHAR2,
                                thresholds_out OUT cursorType,
                                severities_out OUT cursorType,
                                os_name_out OUT VARCHAR2
);


PROCEDURE getTypedGroupMembersInfo(
                                target_name_in IN VARCHAR2,
                                target_type_in IN VARCHAR2,
                                member_type_in IN VARCHAR2,
                                type_display_name_out OUT VARCHAR2,
                                summary_cols_out OUT cursorType,
                                summary_vals_out OUT cursorType,
                                summary_sevs_out OUT cursorType,
                                target_summary_out OUT cursorType
);

/**
 This procedure takes as input a target type and returns a list of summary 
 metrics, non-hidden properties, and generic columns that a user may display
 in the sub-tab for the target type in question. The current choice setting
 is also returned.
 */
PROCEDURE getSubTabPreferrences (
              p_target_type_in     IN  VARCHAR2,
              p_user_prefs_cur_out OUT cursorType,
              p_def_prefs_cur_out  OUT cursorType);

/**
  Insert the preferences of the user - for metrics to be shown 
  in the dense UI for a given type
 */
PROCEDURE saveSummaryMetricsInfo (
              p_target_type_in     IN  VARCHAR2,
              p_sel_metrics_in     IN  MGMT_SUBTAB_PREF_ARRAY
);
/*
 Get the list of hosts that have consistently had high values for a metric.
The metric depends on whether we are interested in cpu, memory or io.
*/
PROCEDURE getHostPerfInfo(
              target_name_in     IN  VARCHAR2,
              target_type_in     IN  VARCHAR2,
              metric_name_in     IN  VARCHAR2,
              metric_column_in   IN  VARCHAR2,
              target_names_out   OUT cursorType
);

--
-- FUNCTION: get_target_avail_status
--
-- PURPOSE:
--   This function returns the availability current status of the given target
--   guid. If the status is MGMT_GLOBAL.G_STATUS_UNKNOWN, it returns
--   100 if availability is not defined for the target. Given target_guid
--   should have threshold defined on {Response Metric/Status Column}
--   to have availability statistic.
--
--

FUNCTION get_target_avail_status
  (target_guid_in  IN  mgmt_targets.target_guid%TYPE)
  RETURN NUMBER;   

end emd_mntr_host;
/

show errors;

