Rem
Rem $Header: mgmt_host_mgmt_pkgdef.sql 04-sep-2003.10:58:47 ipoddar Exp $
Rem
Rem mgmt_host_mgmt_pkgdef.sql
Rem
Rem Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      mgmt_host_mgmt_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ipoddar     09/04/03 - ipoddar_host_mgmt_enhancements 
Rem    ipoddar     08/28/03 - change defs 
Rem    ipoddar     08/27/03 - Created
Rem

CREATE OR REPLACE PACKAGE mgmt_host_mgmt AS

-- Package level Type Definition 
   TYPE cursorType IS REF CURSOR;

-- Procedure: get_collection_item_info
--
-- Purpose:
--  Returns information from the emd_collection tables:
--  mgmt_metric_collections, mgmt_collection_properties and 
--  mgmt_metric_thresholds pertaining to a CollectionItem.
--
--  IN PARAMETERS:
--   target_name_in: VARCHAR2  target name
--   target_type_in: VARCHAR2  target type
--   metric_name_in: VARCHAR2  metric name
--   collection_name_in: VARCHAR2  CollectionItem name.
--
--  OUT PARAMETERS:
--   schedule_out: NUMBER   the schedule interval length 
--   properties_out: cursorType  A cursor containg columns name and value
--                               representing property name value pairs.
--   metric_thresholds_out: cursorType A cursor containing columns:
--                                     key_column, key_value,
--                                     critical_operator, warning_operator,
--                                     critical_threshold, warning_threshold,
--                                     fixit_job
   PROCEDURE get_collection_item_info(target_name_in IN VARCHAR2,
                                      target_type_in IN VARCHAR2,
                                      collection_name_in IN VARCHAR2,
                                      properties_out OUT cursorType,
                                      metric_thresholds_out OUT cursorType);
-- Procedure: set_collection_item_info
--
-- Purpose:
--  saves information into the emd_collection tables:
--  mgmt_metric_collections, mgmt_collection_properties and 
--  mgmt_metric_thresholds pertaining to a CollectionItem.
--
--  IN PARAMETERS:
--   target_name_in: VARCHAR2  target name
--   target_type_in: VARCHAR2  target type
--   metric_name_in: VARCHAR2  metric name
--   collection_name_in: VARCHAR2  CollectionItem name.
--   schedule_in: NUMBER the interval schedule of the CollectionItem
--   properties_in: MGMT_NAME_VALUES an array of ItemProperty name
--                                   value pairs.
--   metric_thresholds_in: MGMT_METRIC_THR_OBJ_ARRAY an array of metric threshold
--                                                   information
   PROCEDURE set_collection_item_info(target_name_in IN VARCHAR2,
                                      target_type_in IN VARCHAR2,
                                      collection_name_in IN VARCHAR2,
                                      properties_in IN MGMT_ITEM_PROPERTIES,
                                      metric_thresholds_in IN MGMT_METRIC_THR_OBJ_ARRAY);

end mgmt_host_mgmt;
/

show errors;
