Rem drv: <create type="pkgbodys" pos="swlib/swlib_pkgbody.sql+"/>
Rem
Rem $Header: http_session_pkgbody.sql 01-jul-2005.21:27:00 gsbhatia Exp $
Rem
Rem http_session_pkgbody.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      http_session_pkgbody.sql - 
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      This package has routines that support association of backend 
Rem      objects with http sessions, and their removal when the session
Rem      expires
Rem
Rem    MODIFIED  
Rem       gsbhatia   07/01/05 - New repmgr header impl 
Rem       skini      09/17/04 - skini_interactive_jobs
Rem       skini      09/14/04 - Deal with oms death 
Rem

CREATE OR REPLACE PACKAGE BODY MGMT_HTTP_SESSION AS

-- Associate the specified object with the specified http session.
-- The object will be cleaned up when the session expires.
PROCEDURE associate_object(p_object_type VARCHAR2, p_object_guid RAW,
                           p_http_session VARCHAR2,
                           p_oms_id NUMBER) IS
BEGIN
    INSERT INTO MGMT_HTTP_SESSION_OBJECTS(session_id, object_type, 
                                          object_guid, oms_failover_id)
    VALUES (p_http_session, p_object_type, p_object_guid, p_oms_id);

EXCEPTION
WHEN DUP_VAL_ON_INDEX THEN
    -- Shouldn't happen, ignore if it does
    NULL;
END;


-- Call this procedure from the console when a http session expires
PROCEDURE session_expired(p_http_session VARCHAR2) IS
l_object_types SMP_EMD_STRING_ARRAY;
l_callbacks SMP_EMD_STRING_ARRAY;
BEGIN
    SELECT  DISTINCT object_type BULK COLLECT INTO l_object_types
    FROM    MGMT_HTTP_SESSION_OBJECTS
    WHERE   session_id=p_http_session;

    IF l_object_types IS NOT NULL AND l_object_types.COUNT > 0 THEN
        FOR i IN 1..l_object_types.COUNT LOOP
            IF l_callbacks IS NOT NULL THEN
                l_callbacks.DELETE;                
                l_callbacks := null;
            END IF;

            SELECT  callback_name BULK COLLECT INTO l_callbacks
            FROM    MGMT_HTTP_SESSION_CALLBACKS
            WHERE   object_type=l_object_types(i);
    
            IF l_callbacks IS NOT NULL AND l_callbacks.COUNT > 0 THEN
                FOR j IN 1..l_callbacks.COUNT LOOP
                    EXECUTE IMMEDIATE 
                    'BEGIN ' || l_callbacks(j) || '(:1,:2); END;'
                    USING   l_object_types(i), p_http_session;
                END LOOP;
            END IF;
        END LOOP;

        DELETE  FROM MGMT_HTTP_SESSION_OBJECTS
        WHERE   session_id=p_http_session;
    END IF;
    
END;

PROCEDURE handle_oms_death(p_oms_id INTEGER, p_last_timestamp DATE) IS
l_sessions SMP_EMD_STRING_ARRAY;
BEGIN
    SELECT  DISTINCT session_id BULK COLLECT INTO l_sessions
    FROM    MGMT_HTTP_SESSION_OBJECTS
    WHERE   oms_failover_id=p_oms_id;

    IF l_sessions IS NULL OR l_sessions.COUNT = 0 THEN
        RETURN;
    END IF;

    FOR i IN 1..l_sessions.COUNT LOOP
        session_expired(l_sessions(i));
    END LOOP;
END;

-- Register a callback for the specified object type
-- The callback should have the following signature:
--    PROCEDURE callback(p_object_type VARCHAR2, p_http_session VARCHAR2);
--
PROCEDURE register_expiry_callback(p_object_type VARCHAR2,
                                   p_callback VARCHAR2) IS
BEGIN
    INSERT INTO MGMT_HTTP_SESSION_CALLBACKS(object_type, callback_name)
    VALUES  (p_object_type, p_callback);
END;

END MGMT_HTTP_SESSION;
/
show errors;

