Rem drv: <create type="pkgdefs" pos="swlib/swlib_pkgdef.sql+"/>
Rem
Rem $Header: http_session_pkgdef.sql 01-jul-2005.17:28:50 gsbhatia Exp $
Rem
Rem http_session_pkgdefs.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      http_session_pkgdefs.sql - Manages objects associated with
Rem            http sessions
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      This package has routines that support association of backend 
Rem      objects with http sessions, and their removal when the session
Rem      expires
Rem
Rem    MODIFIED  
Rem       gsbhatia   07/01/05 - New repmgr header impl 
Rem       skini      09/17/04 - skini_interactive_jobs
Rem       skini      09/14/04 - Deal with oms death 
Rem

CREATE OR REPLACE PACKAGE MGMT_HTTP_SESSION AS

-- Associate the specified object with the specified http session.
-- The object will be cleaned up when the session expires.
PROCEDURE associate_object(p_object_type VARCHAR2, p_object_guid RAW,
                           p_http_session VARCHAR2,
                           p_oms_id NUMBER);

-- Call this procedure from the console when a http session expires
PROCEDURE session_expired(p_http_session VARCHAR2);

-- Register a callback for the specified object type
-- The callback should have the following signature:
--    PROCEDURE callback(p_object_type VARCHAR2, p_http_session VARCHAR2);
--
PROCEDURE register_expiry_callback(p_object_type VARCHAR2,
                                   p_callback VARCHAR2);

-- Callback for when an oms dies
PROCEDURE handle_oms_death(p_oms_id INTEGER, p_last_timestamp DATE);

END MGMT_HTTP_SESSION;
/
show errors;

