Rem drv: <create type="tables" pos="emx/emx_tables.sql+"/>
Rem
Rem $Header: http_session_tables.sql 29-jun-2005.01:47:57 gsbhatia Exp $
Rem
Rem http_session_tables.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      http_session_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED
Rem       gsbhatia   06/26/05 - New repmgr header impl 
Rem       gsbhatia   02/13/05 - updating repmgr header 
Rem       gsbhatia   02/09/05 - updating repmgr header 
Rem       gsbhatia   02/07/05 - updating repmgr header 
Rem       ktlaw      01/11/05 - add repmgr header 
Rem       skini      09/17/04 - skini_interactive_jobs
Rem       skini      09/14/04 - Deal with oms death 
Rem

Rem
Rem A table that holds all backend objects associated with a http session.
Rem These objects need to be cleaned up when the session expires
Rem 
Rem session_id The http session id
Rem object_type The object type eg., JOB, BLACKOUT, etc
Rem object_guid The object guid
Rem
CREATE TABLE MGMT_HTTP_SESSION_OBJECTS (
    session_id VARCHAR2(256),
    oms_failover_id NUMBER,
    object_type VARCHAR2(32),
    object_guid RAW(16),
    CONSTRAINT PK_MGMT_HTTP_SESS_OBJS 
        PRIMARY KEY(session_id, object_type, object_guid)
);


Rem
Rem A set of callbacks that need to be called whenever a session
Rem expires. A callback can be registered multiple times for
Rem different object type. The signature of the callback is
Rem    PROCEDURE callback(object_type VARCHAR2, p_http_session VARCHAR2);
Rem
CREATE TABLE MGMT_HTTP_SESSION_CALLBACKS (
    object_type VARCHAR2(32),
    callback_name VARCHAR2(64),
    CONSTRAINT PK_MGMT_HTTP_SESS_CBS
        PRIMARY KEY(object_type, callback_name)
);
