Rem drv: <create type="pkgbodys" pos="service_level/service_level_pkgbody.sql+"/>
Rem 456789012345678901234567890123456789012345678901234567890123456789
----------------------------------------------------------------------
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/ip/dashboard_service/dashboard_service_pkgbody.sql /st_emcore_10.2.0.4.1db11/2 2008/07/21 08:51:45 nmathuri Exp $
Rem
Rem dashboard_service_pkgbody.sql
Rem
Rem Copyright (c) 2002, 2008, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem       dashboard_pkgbody.sql
Rem
Rem    DESCRIPTION
Rem       PL/SQL package body of Services Dashboard Reporting Elements
Rem
Rem    NOTES
Rem       Data collection for dashboard are defined in this package
Rem
Rem    MODIFIED    (MM/DD/YY)
Rem    nmathuri     07/19/08 - Fix the Bug#7148257, Remove email reference from comments
Rem    jashukla     06/03/08 - Bug 7144619 remove internal identifiers
Rem    mswamyt      02/07/07 - fix for bug 5705867
Rem    tsubrama     05/22/07 - Backport mswamyt_bug-5705867 from main
Rem    akmahesh     04/03/07 - Fix for bug 5970761
Rem    rrawat       01/11/07 - Fix for bug 5706403
Rem    rrawat       02/19/07 - Backport rrawat_bug-5706403 from main
Rem    spatiban     11/18/06 - Fix for bug 5670106
Rem    spatiban     10/05/06 - Dashboard changes to merge usage and business
Rem                            columns
Rem    spatiban     10/10/06 - Fix for bug 5584370
Rem    spatiban     09/28/06 - Bug 5570448
Rem    spatiban     08/23/06 - KPI Name fix
Rem    skotha       07/26/06 - Support of Namespaces for Busines Metrics 
Rem    rvijjapu     07/14/06 - 
Rem    skotha       06/29/06 - Service Dashboard enhancements 
Rem                            for BAM Integration
Rem    mkm          03/09/06 - fix
Rem    mkm          03/09/06 - fix
Rem    tsubrama     02/23/06 - renaming Down Times to Availability 
Rem    mswamyt      12/06/05 - 
Rem    mkm          11/30/05 - Fix for bug 4507741 
Rem    nanand       09/09/05 - adding system_report=1 to report guid query 
Rem    mkm          08/26/05 - Bug 4566808 
Rem    nanand       08/08/05 - duplicate output in get_sl_history 
Rem    mkm          08/02/05 - checking for type_meta_ver in mgmt_category_map 
Rem    mkm          07/26/05 - check l_old_targetguid for null 
Rem    mkm          07/21/05 - workaround for 3037197 
Rem    mkm          07/19/05 - performance fix for get_metric_list 
Rem    mkm          07/13/05 - fixing transposed metric part in 
Rem                            get_metric_list 
Rem    mkm          07/11/05 - get value from metrics table instead of 
Rem                            violations table 
Rem    gsbhatia     07/01/05 - New repmgr header impl 
Rem    mkm          06/28/05 - adding get_guids_privs 
Rem    mkm          06/17/05 - fixing end_date tgt_sys_date diff in 
Rem                            get_sl_history 
Rem    mkm          06/13/05 - nls translation for metric label in 
Rem                            get_alert_data 
Rem    mkm          06/01/05 - fixing severity calculation of clear in 
Rem                            get_metric_dif 
Rem    nanand       05/17/05 - Added new constants 
Rem    kajayapr     05/20/05 - Validate violation_duration check 
Rem    kajayapr     05/19/05 - validate violation_duration for change of def 
Rem                            value to NULL 
Rem    nanand       05/11/05 - changing violation_duration check 
Rem    nanand       05/09/05 - Fix violation_duration 
Rem    mswamyt      05/03/05 - Fix calls to sl_metrics 
Rem    mkm          04/26/05 - Fix code review comments 
Rem    mkm          04/25/05 - Fix code review comments 
Rem    mkm          04/22/05 - fixing the first no data record timezone issue 
Rem                            in get_sl_history 
Rem    mkm          04/14/05 - fix
Rem    mkm          03/28/05 - test members fix 
Rem    mswamyt      04/05/05 - Fixing ADJUST_TZ Exception 
Rem    mswamyt      03/29/05 - tests member fix
Rem    jmenon       02/28/05 - changing get_current_status 
Rem    mswamyt      02/14/05 - Making sl -1 when for future dates
Rem    jmenon       01/31/05 - moving internal procedures/functions to top 
Rem    ramalhot     01/17/05 - g_member_guid --> g_contains_guid 
Rem    jmenon       01/27/05 - code cleanup 
Rem    mswamyt      01/25/05 - Fix debug statement 
Rem    mswamyt      12/15/04 - key_value fix 
Rem    verangan     11/29/04 - severity to violations change
Rem    mkm          11/17/04 - fix in build_status_string function
Rem    mswamyt      11/08/04 - Fix severity duration 
Rem    verangan     10/27/04 - Added total hours to sla_pie_rec 
Rem    snathan      10/21/04 - snathan_svclvl_merge
Rem    snathan      10/20/04 - Fix errors 
Rem    snathan      10/20/04 - ORA-06502: PL/SQL: numeric or value error fix 
Rem    snathan      10/14/04 - Code review changes
Rem    verangan     08/26/04 - re-wrote based on new FS
Rem    verangan     07/20/04 - created
Rem
----------------------------------------------------------------------

CREATE OR REPLACE PACKAGE BODY em_dashboard_service AS

PROCEDURE validate_is_service(guid_in IN MGMT_TARGETS.target_guid%TYPE)
IS
l_count NUMBER;
BEGIN
   SELECT count(*) INTO l_count
   FROM
          mgmt_targets tgt,    mgmt_type_properties typ
   WHERE
          tgt.target_guid    = guid_in
      AND tgt.target_type    = typ.target_type
      AND typ.property_name  = MGMT_GLOBAL.G_IS_SERVICE_PROP
      AND typ.property_value = 1;

   IF ( l_count != 1 )
   THEN
      raise_application_error (
         MGMT_GLOBAL.INVALID_PARAMS_ERR,
         'Invalid Service guid passed : ');
   END IF;
END validate_is_service;
----------------------------------------------------------------------
-- PROCEDURE   : get_current_status
----------------------------------------------------------------------
--
-- PURPOSE     : Obtain current status of Services
--
-- DESCRIPTION :
--    This procedure obtains the current status of Services
--
-- PARAMETERS  :
--    INPUT    guids_in            - GUID Array for Services
--    OUTPUT   service_status_out  - Cursor of Service guid and status
----------------------------------------------------------------------

-- Internal procedure called by get_statuses
PROCEDURE get_current_status (
   guids_in           IN  MGMT_USER_GUID_ARRAY,
   service_status_out OUT SMP_EMD_NVPAIR_ARRAY )
IS
   l_current_status   NUMBER;
   l_index            NUMBER;
   l_count            NUMBER;
   PROC_NAME          VARCHAR2(18) := 'get_current_status';
BEGIN

   service_status_out := SMP_EMD_NVPAIR_ARRAY();

   FOR l_index IN 1..guids_in.LAST
   LOOP
      l_count := 0;
      service_status_out.extend();
      IF guids_in(l_index) IS NULL
      THEN
         IF (emdw_log.p_is_debug_set)
         THEN
            emdw_log.debug('null target_guid', G_PKG_NAME || '.' || PROC_NAME);
         END IF;
         service_status_out(l_index) :=
            SMP_EMD_NVPAIR(guids_in(l_index), NULL);
            -- Changed to remove GOTO logic..
         --GOTO end_loop;
       ELSE   
       

      -- *********************************************** --
      --            Validate Input Parameters            --
      -- *********************************************** --

      -- Check whether Target guid is that of a Service

      -- Dont want to error out if one guid is invalid in the list
      -- Will send back null for invalid guid. So commenting
      -- the following line and modifying the sql query below
      -- validate_is_service(guids_in(l_index));
      -- *********************************************** --

      --If one of the target_guids does not have an entry
      --in mgmt_current_availability, setting that alone
      --to null
      BEGIN
         SELECT current_status INTO l_current_status
         FROM mgmt_current_availability avail, mgmt_targets tgt,
              mgmt_type_properties props
         WHERE tgt.target_guid = guids_in(l_index)
           AND tgt.target_type = props.target_type
           AND props.property_name  = MGMT_GLOBAL.G_IS_SERVICE_PROP
           AND props.property_value = 1
           AND avail.target_guid = tgt.target_guid;


         --Status can be up/down or unknown. We dont need to show slow status.
         --update from snathan on Jan 26'05.
         service_status_out(l_index) :=
           SMP_EMD_NVPAIR(guids_in(l_index), l_current_status);
      EXCEPTION
         WHEN NO_DATA_FOUND
         THEN
            IF (emdw_log.p_is_debug_set)
            THEN
               emdw_log.debug('Invalid service guid or no records in mgmt_current_availability' ||
                              'for target_guid: ' || guids_in(l_index),
                              G_PKG_NAME || '.' || PROC_NAME);
            END IF;
 -- we are passing null for this guid. This null is processed in java. 
 -- null here means that targets avail record is not found..
            service_status_out(l_index) :=
              SMP_EMD_NVPAIR(guids_in(l_index), NULL);
      END;
    END IF;
    -- <<end_loop>>
     NULL;
   END LOOP; -- 1..guids_in.LAST

EXCEPTION
   WHEN OTHERS THEN
      DBMS_OUTPUT.PUT_LINE (
         'ERROR: Procedure get_current_status: Procedure failed.');

END get_current_status;
----------------------------------------------------------------------


----------------------------------------------------------------------
-- PROCEDURE   : get_member_names
----------------------------------------------------------------------
--
-- PURPOSE     : Obtain list of Members for a Service
--
-- DESCRIPTION :
--    This procedure obtains the list of Members for a Service
--
-- PARAMETERS  :
--    INPUT    guid_in               - Target GUID for Service
--    OUTPUT   member_name_cur_out   - Cursor with Member names
--             total_member_out      - Total number of Members
--             up_member_count_out   - Number of Members that are UP
--             down_member_count_out - Number of Members that are DOWN
----------------------------------------------------------------------
-- This is a internal procedure which is called by get_statuses.
-- We dont do error check because of this..
PROCEDURE get_member_status (
   guid_in               IN  MGMT_TARGETS.target_guid%TYPE,
   total_member_out      OUT NUMBER,
   up_member_count_out   OUT NUMBER,
   down_member_count_out OUT NUMBER,
   unknown_member_count_out OUT NUMBER)
IS
   l_count               NUMBER;
   l_target_name         mgmt_targets.target_name%TYPE;
   l_target_type         mgmt_targets.target_type%TYPE;
   l_avail_selector      VARCHAR2(256);
   l_assoc_guid          mgmt_target_assocs.assoc_guid%TYPE;
   l_value               mgmt_type_properties.property_value%TYPE;
   PROC_NAME             VARCHAR2(20) := 'get_member_status';
BEGIN

   -- *********************************************** --
   --            Validate Input Parameters            --
   -- *********************************************** --

   -- Check whether Target guid is that of a Service
   validate_is_service(guid_in);
   -- *********************************************** --

   SELECT target_name, target_type
     INTO l_target_name, l_target_type
     FROM mgmt_targets
    WHERE target_guid = guid_in;
    
  
   l_avail_selector := mgmt_service.GET_SVC_AVAIL_COMP_METHOD(l_target_name, 
                                        l_target_type);
   IF (emdw_log.p_is_debug_set)
   THEN
      emdw_log.debug('service avail based on: ' 
                   || l_avail_selector, G_PKG_NAME || '.' || PROC_NAME);
   END IF;
   
   IF ( l_avail_selector = MGMT_SERVICE.G_TEST_BASED_AVAIL_COMP )
   THEN

   SELECT count(current_status),
          sum(decode(current_status, MGMT_GLOBAL.G_STATUS_UP, 1,0)),
          sum(decode(current_status, MGMT_GLOBAL.G_STATUS_ERROR, 1, 
                                     MGMT_GLOBAL.G_STATUS_AGENT_DOWN, 1,
                                     MGMT_GLOBAL.G_STATUS_UNREACHABLE, 1, 
                                     MGMT_GLOBAL.G_STATUS_BLACKOUT, 1, 
                                     MGMT_GLOBAL.G_STATUS_UNKNOWN, 1, 
                                     0)),
          sum(decode(current_status, MGMT_GLOBAL.G_STATUS_DOWN, 1, 0))
   INTO
          total_member_out,
          up_member_count_out,
          unknown_member_count_out,
          down_member_count_out
   FROM
          MGMT_GENSVC_TEST_CUR_AVAIL
   WHERE
          target_guid = guid_in
          and test_guid IN (
             SELECT txn_guid
             FROM
                    MGMT_BCN_TXN_DEFN
             WHERE
                    target_guid = guid_in
                AND is_representative = 'Y'
          );
   ELSE

     l_value := is_aggregate_service(target_type_in => l_target_type);

     --bug 4672042 .. For aggregate service we should use the contains assocs
     -- For generic service we should use depends_on..
     IF (l_value = 1)  THEN
     --- target is a aggregate service.
        l_assoc_guid := mgmt_assoc.g_contains_guid;
     ELSE
      --- target is a generic service.
        l_assoc_guid := mgmt_assoc.g_depends_on_guid;
     END IF;
   
   
   
   SELECT count(current_status),
          sum(decode(current_status, MGMT_GLOBAL.G_STATUS_UP, 1,0)),
          sum(decode(current_status, MGMT_GLOBAL.G_STATUS_ERROR, 1, 
                                     MGMT_GLOBAL.G_STATUS_AGENT_DOWN, 1,
                                     MGMT_GLOBAL.G_STATUS_UNREACHABLE, 1, 
                                     MGMT_GLOBAL.G_STATUS_BLACKOUT, 1, 
                                     MGMT_GLOBAL.G_STATUS_UNKNOWN, 1, 
                                     0)),
          sum(decode(current_status, MGMT_GLOBAL.G_STATUS_DOWN, 1, 0))
   INTO
          total_member_out,
          up_member_count_out,
          unknown_member_count_out,
          down_member_count_out
   FROM
          mgmt_current_availability
   WHERE
          target_guid IN (
             SELECT mem.assoc_target_guid
             FROM
                    mgmt_target_assocs mem
             WHERE
                    mem.source_target_guid = guid_in
                AND mem.assoc_guid         = l_assoc_guid
          );

-- aggregate functions not requiring error check..
   END IF;

EXCEPTION
   WHEN OTHERS THEN
      DBMS_OUTPUT.PUT_LINE (
         'ERROR: Procedure get_member_status: Procedure failed.');

END get_member_status;
----------------------------------------------------------------------

--Returns NULL for
--invalid target_guid
--avail end time cannot be found
--- Internal functions
FUNCTION get_avail_start_time(target_guid_in IN MGMT_TARGETS.target_guid%TYPE,
                              tgt_sysdate_in IN DATE DEFAULT NULL)
RETURN DATE
IS
l_start_time DATE;
l_tgt_timezone MGMT_TARGETS.timezone_region%TYPE;
l_tgt_sysdate DATE;
PROC_NAME VARCHAR2(25) := 'get_avail_start_time';
BEGIN
   BEGIN
      SELECT timezone_region
        INTO l_tgt_timezone
        FROM mgmt_targets
        WHERE target_guid = target_guid_in;
   EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
         IF (emdw_log.p_is_debug_set)
         THEN
            emdw_log.debug('Invalid target_guid: ' || target_guid_in, 
                             G_PKG_NAME || '.' || PROC_NAME);
         END IF;
   END;

   IF tgt_sysdate_in IS NOT NULL
   THEN
      l_tgt_sysdate := tgt_sysdate_in;
   ELSE
      l_tgt_sysdate := MGMT_GLOBAL.SYSDATE_TZRGN(l_tgt_timezone);
   END IF;

   SELECT 
          NVL(
              (SELECT  MIN(NVL(end_collection_timestamp, l_tgt_sysdate))
                FROM  mgmt_availability 
               WHERE  target_guid=target_guid_in),
             (SELECT  load_timestamp
                FROM  mgmt_targets
               WHERE  target_guid= target_guid_in)
            )
   INTO l_start_time
   FROM DUAL;
 
   RETURN l_start_time;

END get_avail_start_time;

--Returns NULL for
--invalid target_guid
--avail end time cannot be found
--- Internal functions
FUNCTION get_avail_end_time(target_guid_in IN MGMT_TARGETS.target_guid%TYPE,
                            tgt_sysdate_in IN DATE DEFAULT NULL)
RETURN DATE
IS
l_ret_date DATE;
l_tgt_timezone MGMT_TARGETS.timezone_region%TYPE;
l_tgt_sysdate DATE;
PROC_NAME VARCHAR2(20) := 'get_avail_end_time';
BEGIN
   BEGIN
      SELECT timezone_region
        INTO l_tgt_timezone
        FROM mgmt_targets
        WHERE target_guid = target_guid_in;
   EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
         IF (emdw_log.p_is_debug_set)
         THEN
            emdw_log.debug('Invalid target_guid: ' || target_guid_in, G_PKG_NAME || '.' || PROC_NAME);
         END IF;
   END;

   IF tgt_sysdate_in IS NOT NULL
   THEN
      l_tgt_sysdate := tgt_sysdate_in;
   ELSE
      l_tgt_sysdate := MGMT_GLOBAL.SYSDATE_TZRGN(l_tgt_timezone);
   END IF;

     SELECT MAX(nvl(end_collection_timestamp, l_tgt_sysdate))
     INTO l_ret_date
     FROM mgmt_availability
     WHERE target_guid=target_guid_in;

   RETURN l_ret_date;
END get_avail_end_time;

--Internal Function
--Returns NULL for invalid target_guid/metric_guid
FUNCTION get_is_transposed(v_target_guid IN MGMT_TARGETS.target_guid%TYPE,
                          v_metric_guid IN MGMT_METRICS.metric_guid%TYPE)
RETURN NUMBER
IS
l_transposed NUMBER;
PROC_NAME VARCHAR2(20) := 'get_is_transposed';
BEGIN
   BEGIN
      SELECT is_transposed INTO l_transposed
      FROM mgmt_targets tgt, mgmt_metrics met
      WHERE tgt.target_guid = v_target_guid
      AND met.target_type = tgt.target_type
      AND met.metric_guid = v_metric_guid
      AND met.type_meta_ver = tgt.type_meta_ver
      AND ( met.CATEGORY_PROP_1 = tgt.CATEGORY_PROP_1
              OR met.category_prop_1 = ' ' )
      AND ( met.CATEGORY_PROP_2 = tgt.CATEGORY_PROP_2
              OR met.category_prop_2 = ' ' )
      AND ( met.CATEGORY_PROP_3 = tgt.CATEGORY_PROP_3
              OR met.category_prop_3 = ' ' )
      AND ( met.CATEGORY_PROP_4 = tgt.CATEGORY_PROP_4
              OR met.category_prop_4 = ' ' )
      AND ( met.CATEGORY_PROP_5 = tgt.CATEGORY_PROP_5
              OR met.category_prop_5 = ' ' );
   EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
         IF (emdw_log.p_is_debug_set)
         THEN
            emdw_log.debug('Invalid target_guid/metric_guid: ' || 
              v_target_guid || '/' || v_metric_guid, G_PKG_NAME || '.' || PROC_NAME);
         END IF;
   END;

   RETURN l_transposed;
END get_is_transposed;

FUNCTION get_metric_diff(v_target_guid IN MGMT_TARGETS.target_guid%TYPE,
                         v_metric_guid IN MGMT_METRICS.metric_guid%TYPE,
                         v_key_value IN MGMT_CURRENT_METRICS.key_value%TYPE,
                         v_value IN MGMT_CURRENT_METRICS.value%TYPE,
                         v_viol_level IN MGMT_CURRENT_VIOLATION.violation_level%TYPE)
RETURN NUMBER
IS
l_warn_thresh mgmt_metric_thresholds.warning_threshold%TYPE;
l_crit_thresh mgmt_metric_thresholds.critical_threshold%TYPE;
l_warn_operator NUMBER;
l_crit_operator NUMBER;
l_diff_number NUMBER;
l_sev_unknown NUMBER := 0;
l_thresh_diff NUMBER;
PROC_NAME VARCHAR2(20) := 'get_metric_diff';
BEGIN

  IF (emdw_log.p_is_debug_set)
  THEN
     emdw_log.debug('For target_guid/metric_guid/key_value: ' || 
       v_target_guid || '/' || v_metric_guid || '/' || v_key_value,
        G_PKG_NAME || '.' || PROC_NAME);
  END IF;

  IF v_value IS NULL
  THEN
    RETURN l_sev_unknown;
  END IF; 

  BEGIN
    SELECT warning_threshold, warning_operator,
           critical_threshold, critical_operator
      INTO l_warn_thresh, l_warn_operator,
           l_crit_thresh, l_crit_operator
      FROM mgmt_metric_thresholds
     WHERE target_guid=v_target_guid
       AND metric_guid=v_metric_guid
       AND key_value=v_key_value;

  EXCEPTION
    WHEN NO_DATA_FOUND
    THEN
      IF (emdw_log.p_is_debug_set)
      THEN
         emdw_log.debug('No record in mgmt_metric_thresholds', G_PKG_NAME || '.' || PROC_NAME);
      END IF;
      RETURN l_sev_unknown;
  END;

  IF (emdw_log.p_is_debug_set)
  THEN
     emdw_log.debug('value: ' || v_value ||
                    ' warnoper: ' || l_warn_operator || ' warnthresh: ' 
                    || l_warn_thresh || ' critoper: ' || l_crit_operator || 
                    ' critthresh: ' || l_crit_thresh, G_PKG_NAME || '.' || PROC_NAME);
  END IF;

  IF v_viol_level = MGMT_GLOBAL.G_SEVERITY_CLEAR
  THEN
    IF (l_warn_operator IS NOT NULL AND l_warn_thresh IS NOT NULL AND
        v_value != l_warn_thresh AND (l_warn_operator = 0 OR l_warn_operator BETWEEN 2 AND 4))
    THEN
      --l_diff_number := ABS((v_value - l_warn_thresh)/l_warn_thresh);
      l_diff_number := ABS(l_warn_thresh/(v_value - l_warn_thresh));
    ELSE
      RETURN l_sev_unknown;
    END IF;
  END IF;

  IF v_viol_level = MGMT_GLOBAL.G_SEVERITY_WARNING
  THEN
    IF (l_crit_operator IS NOT NULL AND l_warn_thresh IS NOT NULL AND l_crit_thresh IS NOT NULL AND
        l_crit_thresh != l_warn_thresh AND (l_crit_operator = 0 OR l_crit_operator BETWEEN 2 AND 4))
    THEN
      l_thresh_diff := ABS(l_crit_thresh - l_warn_thresh);
      l_diff_number := ABS(l_warn_thresh - v_value)/l_thresh_diff;
    ELSE
      RETURN l_sev_unknown;
    END IF;
  END IF;

  IF v_viol_level = MGMT_GLOBAL.G_SEVERITY_CRITICAL
  THEN
    IF (l_crit_operator IS NOT NULL AND l_crit_thresh IS NOT NULL AND l_crit_thresh != 0 AND
        (l_crit_operator = 0 OR l_crit_operator BETWEEN 2 AND 4))
    THEN
      l_diff_number := ABS((l_crit_thresh - v_value)/l_crit_thresh);
    ELSE
      RETURN l_sev_unknown;
    END IF;
  END IF;

  IF (emdw_log.p_is_debug_set)
  THEN
     emdw_log.debug('diffnumber: ' || l_diff_number, G_PKG_NAME || '.' || PROC_NAME);
  END IF;

  RETURN l_diff_number;

  EXCEPTION
     WHEN VALUE_ERROR
     THEN
        RETURN l_sev_unknown;
END;


--Internal Function
FUNCTION str2tbl( p_str IN VARCHAR2 ) RETURN charTableType
AS
   l_str      LONG DEFAULT p_str || ',';
   l_n        NUMBER;
   l_data    charTableType := charTabletype();
BEGIN
  LOOP
    l_n := instr( l_str, ',' );
    exit when (nvl(l_n,0) = 0);
    l_data.extend;
    l_data( l_data.count ) := ltrim(rtrim(substr(l_str,1,l_n-1)));
    l_str := substr( l_str, l_n+1 );
  END LOOP;
  RETURN l_data;
END str2tbl;

-- Internal functions used for SLA calculations..
--  This is used to get total slow times (severity violations)
--  within the business hours
FUNCTION get_severity_duration (v_target_guid IN MGMT_TARGETS.target_guid%TYPE,
                        v_start_collection_timestamp IN DATE,
                        v_end_collection_timestamp IN DATE,
                        v_clock_in  IN NUMBER,
                        v_clock_out IN NUMBER,
                        v_ignore_days IN VARCHAR2)
RETURN NUMBER
AS
l_slow_hours NUMBER := 0;
l_total_hours NUMBER := 0;
l_tgt_timezone VARCHAR2(64);
l_tgt_sysdate DATE;
l_target_type mgmt_targets.target_type%TYPE;
temp_sev_array sla_sev_rec_array;
greatest_rec sla_sev_rec;
start_time DATE;
end_time DATE;
i NUMBER;
BEGIN
  temp_sev_array := sla_sev_rec_array();
  SELECT timezone_region, target_type
    INTO l_tgt_timezone, l_target_type
    FROM MGMT_TARGETS
    WHERE target_guid=v_target_guid;
  l_tgt_sysdate := MGMT_GLOBAL.SYSDATE_TZRGN(l_tgt_timezone);
  SELECT 
   sla_sev_rec(
           greatest(collection_timestamp,v_start_collection_timestamp),
           least(DECODE(violation_duration, NULL, l_tgt_sysdate,
               collection_timestamp + violation_duration / 24), 
                  v_end_collection_timestamp))
  BULK COLLECT INTO temp_sev_array
    FROM mgmt_violations viol, mgmt_sl_metrics slm
   WHERE viol.target_guid  =  v_target_guid
     AND slm.target_guid   =  viol.target_guid
     AND violation_level   =  MGMT_GLOBAL.G_SEVERITY_CRITICAL
     AND viol.policy_guid  =  slm.metric_guid
     AND viol.key_value    =  slm.key_value
     AND verify_metric_type(slm.metric_guid, MGMT_GLOBAL.G_SERVICE_CATEGORY_PERFORMANCE, v_target_guid) = 1
     AND (v_start_collection_timestamp
         BETWEEN collection_timestamp AND 
	 DECODE(violation_duration, NULL, l_tgt_sysdate,collection_timestamp + violation_duration / 24) 
	 OR  collection_timestamp >=
         v_start_collection_timestamp )
     AND (v_end_collection_timestamp
         BETWEEN collection_timestamp AND 
         DECODE(violation_duration, NULL, l_tgt_sysdate,collection_timestamp + violation_duration / 24)  OR
         v_end_collection_timestamp >= 
         DECODE(violation_duration, NULL, l_tgt_sysdate,collection_timestamp + violation_duration / 24))
     ORDER BY collection_timestamp;
 IF (temp_sev_array.FIRST IS NOT NULL )
 THEN
   
   -- This is where we removed overlapped intervals...
 FOR i in to_number(temp_sev_array.FIRST) .. to_number(temp_sev_array.LAST)
  LOOP
     l_slow_hours := 0;
     IF( i = temp_sev_array.FIRST)
     THEN
        l_slow_hours := hours_worked(temp_sev_array(i).sev_start_time,
                                   temp_sev_array(i).sev_end_time,
                                v_ignore_days,v_clock_in,v_clock_out);
        greatest_rec := sla_sev_rec(temp_sev_array(i).sev_start_time,
                                temp_sev_array(i).sev_end_time);

     ELSE 
           IF (temp_sev_array(i).sev_end_time >
              greatest_rec.sev_end_time )
           THEN
           start_time := greatest(temp_sev_array(i).sev_start_time,
                                  greatest_rec.sev_end_time);
                                  
           end_time := temp_sev_array(i).sev_end_time;
           
           l_slow_hours := hours_worked(start_time,end_time,v_ignore_days,
                        v_clock_in, v_clock_out);
           greatest_rec := sla_sev_rec(start_time,end_time);
          ELSE
           l_slow_hours := 0;
          END IF;
     END IF;
     l_total_hours := l_slow_hours + l_total_hours;
  END LOOP;
END IF;
    return l_total_hours;
END;

----------------------------------------------------------------------
-- FUNCTION    : hours_worked
----------------------------------------------------------------------
--
-- PURPOSE     : Returns the Business hours
--
-- DESCRIPTION :
--    This procedure returns the number of business hours within a
--    time-period under consideration.
--
-- PARAMETERS  :
--    INPUT    v_start_collection_timestamp - Start of Period
--             v_end_collection_timestamp   - End of Period
--             v_ignore_days                - Non Business Days
--             v_clock_in                   - Start of Business hour
--             v_clock_out                  - End of Business hour
--    OUTPUT   Number of Business hours 
----------------------------------------------------------------------

FUNCTION hours_worked (
   v_start_collection_timestamp IN DATE,
   v_end_collection_timestamp   IN DATE,
   v_ignore_days                IN VARCHAR2,
   v_clock_in                   IN NUMBER,
   v_clock_out                  IN NUMBER)
RETURN NUMBER IS
   l_total_hours                NUMBER := 0;
   l_business_hours             NUMBER := 0;
   l_ignore_days                LONG   := '/'||upper(v_ignore_days)||'/';
BEGIN
   IF NOT (   v_end_collection_timestamp   IS NULL
           OR
              v_start_collection_timestamp IS NULL )
   THEN
      FOR i in 0 .. trunc(v_end_collection_timestamp) -
                          trunc(v_start_collection_timestamp)
      LOOP
         l_business_hours := 0;
         IF (instr(l_ignore_days,
                '/'||to_char(v_start_collection_timestamp + i,'D')||'/')
            = 0
            )
         THEN
            l_business_hours  :=
               greatest (
                  least    (
                     trunc(v_start_collection_timestamp) + i + v_clock_out/24,
                     v_end_collection_timestamp
                           ) -- end least
                  -
                  greatest (
                     v_start_collection_timestamp,
                     trunc(v_start_collection_timestamp) + i +v_clock_in/24
                           ) -- end greatest
                 ,0     );
         END IF;

         l_total_hours := l_total_hours + l_business_hours;

      END LOOP;
   END IF;

   RETURN l_total_hours*24;

END hours_worked;
----------------------------------------------------------------------

----------------------------------------------------------------------
-- PROCEDURE   : get_services_list
----------------------------------------------------------------------
--
-- PURPOSE     : Obtain list of Services defined in EM
--
-- DESCRIPTION :
--    This procedure obtains the list of Services defined in EM.
--    Only those Services defined using Services interface are
--    obtained, and not Targets implemented as a Service.
--
-- PARAMETERS  :
--    INPUT    -None-
--    OUTPUT   service_cur_out - Cursor with list of Services


PROCEDURE get_services_list (
   service_cur_out OUT CURSORTYPE )
IS
BEGIN
   OPEN service_cur_out FOR
      SELECT tgt.target_guid, tgt.target_name, tgt.target_type
        FROM mgmt_targets tgt,    mgmt_type_properties typ
       WHERE typ.property_name  = MGMT_GLOBAL.G_IS_SERVICE_PROP
         AND typ.property_value = '1'
         AND tgt.target_type    = typ.target_type;
EXCEPTION
   WHEN OTHERS
      THEN
         DBMS_OUTPUT.PUT_LINE (
            'ERROR: Procedure get_services_list: Procedure failed.');

END get_services_list;

--Returns null if target_guid is invalid
FUNCTION is_aggregate_service(target_guid_in IN MGMT_TARGETS.target_guid%TYPE)
RETURN NUMBER
IS
l_type MGMT_TARGETS.target_type%TYPE;
PROC_NAME VARCHAR2(20) := 'is_aggregate_service';
BEGIN
  SELECT target_type
    INTO l_type
    FROM mgmt_targets
   WHERE target_guid = target_guid_in;

  RETURN is_aggregate_service(target_type_in => l_type);

EXCEPTION
  WHEN NO_DATA_FOUND
    THEN
      RETURN NULL;
      IF (emdw_log.p_is_debug_set)
      THEN
        emdw_log.debug('Invalid target_guid: ' || target_guid_in, G_PKG_NAME || '.' || PROC_NAME);
      END IF;
END is_aggregate_service;

FUNCTION is_aggregate_service(target_type_in IN MGMT_TARGETS.target_type%TYPE)
RETURN NUMBER
IS
l_value NUMBER;
BEGIN
  BEGIN
  SELECT DECODE(property_value,'1',1,0) INTO l_value
  FROM mgmt_type_properties
  WHERE property_name = MGMT_GLOBAL.G_IS_AGGREGATE_SERVICE_PROP
  AND target_type = target_type_in;
  EXCEPTION
     WHEN NO_DATA_FOUND
        THEN
          l_value := 0;
  END;

  RETURN l_value;
END is_aggregate_service;

PROCEDURE generate_metric_list(
  guids_in IN MGMT_USER_GUID_ARRAY,
  metric_type_in IN MGMT_CATEGORY_MAP.category_name%TYPE,
  metric_rec_array_out OUT METRIC_REC_ARRAY_ARRAY)
IS
l_index NUMBER;
l_metric_index NUMBER;
l_target_guid MGMT_TARGETS.target_guid%TYPE;
l_old_target_guid MGMT_TARGETS.target_guid%TYPE;
l_metric_guid MGMT_METRICS.metric_guid%TYPE;
l_metric_name MGMT_METRICS.metric_name%TYPE;
l_metric_column MGMT_METRICS.metric_column%TYPE;
l_key_value MGMT_METRICS_RAW.key_value%TYPE;
l_label MGMT_METRICS.column_label%TYPE;
l_label_nlsid MGMT_METRICS.column_label_nlsid%TYPE;
l_short_name MGMT_METRICS.short_name%TYPE;
l_short_name_nlsid MGMT_METRICS.short_name_nlsid%TYPE;
l_key_part_values VARCHAR2(512);
l_metric_value NUMBER;
l_sev_code NUMBER;
l_diff NUMBER;
l_metric_cur CURSORTYPE;
l_metric_rec_array METRIC_REC_ARRAY;
l_metric_rec_array_table metric_rec_array_table;
PROC_NAME VARCHAR2(20) := 'generate_metric_list';
BEGIN
   metric_rec_array_out := METRIC_REC_ARRAY_ARRAY();

   get_metric_list(guids_in, metric_type_in,
                    l_metric_cur);
                    
   LOOP
   FETCH l_metric_cur INTO l_target_guid, l_metric_guid, l_key_value,
               l_metric_name, l_metric_column, l_label, l_label_nlsid,
               l_short_name, l_short_name_nlsid, l_key_part_values,
               l_metric_value, l_sev_code, l_diff;
   EXIT WHEN l_metric_cur%NOTFOUND;
    
      IF l_old_target_guid IS NULL OR l_target_guid != l_old_target_guid
      THEN
         IF l_old_target_guid IS NOT NULL
         THEN
            l_metric_rec_array_table(l_old_target_guid) := l_metric_rec_array;
         END IF;
         l_old_target_guid := l_target_guid;
         l_metric_rec_array := METRIC_REC_ARRAY();
         l_metric_index := 0;
      END IF;
      l_metric_index := l_metric_index + 1;
      l_metric_rec_array.extend();
      l_metric_rec_array(l_metric_index) :=
             METRIC_REC(l_metric_guid, l_metric_name, l_metric_column,
                l_label, l_label_nlsid, l_short_name, l_short_name_nlsid,
                l_key_part_values, l_metric_value, l_sev_code);
                
   END LOOP;
   IF l_old_target_guid IS NOT NULL
   THEN
      l_metric_rec_array_table(l_old_target_guid) := l_metric_rec_array;
   END IF;

   FOR l_index IN guids_in.FIRST .. guids_in.LAST
   LOOP
      metric_rec_array_out.extend();
      IF guids_in(l_index) IS NOT NULL
      THEN
         BEGIN
            metric_rec_array_out(l_index) := l_metric_rec_array_table(guids_in(l_index));
         EXCEPTION WHEN NO_DATA_FOUND
         THEN
            metric_rec_array_out(l_index) := METRIC_REC_ARRAY();
         END;
      END IF;
   END LOOP;
END generate_metric_list;

PROCEDURE get_metric_list(
  service_namestypes_in      IN  SMP_EMD_NVPAIR_ARRAY,
  usage_metric_rec_array_out OUT METRIC_REC_ARRAY_ARRAY,
  resp_metric_rec_array_out OUT METRIC_REC_ARRAY_ARRAY)
IS
l_guids MGMT_USER_GUID_ARRAY;
PROC_NAME VARCHAR2(20) := 'get_metric_list';
BEGIN
   get_serviceguids_from_names(service_namestypes_in, l_guids);

   generate_metric_list(l_guids, MGMT_GLOBAL.G_SERVICE_CATEGORY_USAGE, 
                        usage_metric_rec_array_out);
   generate_metric_list(l_guids, MGMT_GLOBAL.G_SERVICE_CATEGORY_PERFORMANCE,
                        resp_metric_rec_array_out);
END get_metric_list;

----------------------------------------------------------------------

PROCEDURE get_metric_list(
  service_namestypes_in      IN  SMP_EMD_NVPAIR_ARRAY,
  usage_metric_rec_array_out OUT METRIC_REC_ARRAY_ARRAY,
  resp_metric_rec_array_out OUT METRIC_REC_ARRAY_ARRAY,
  bus_metric_rec_array_out OUT METRIC_REC_ARRAY_ARRAY)
IS
l_guids MGMT_USER_GUID_ARRAY;
PROC_NAME VARCHAR2(20) := 'get_metric_list';
BEGIN
   get_serviceguids_from_names(service_namestypes_in, l_guids);

   generate_metric_list(l_guids, MGMT_GLOBAL.G_SERVICE_CATEGORY_USAGE, 
                        usage_metric_rec_array_out);
   generate_metric_list(l_guids, MGMT_GLOBAL.G_SERVICE_CATEGORY_PERFORMANCE,
                        resp_metric_rec_array_out);
   generate_metric_list(l_guids,MGMT_GLOBAL.G_SERVICE_CATEGORY_BUSINESS,
                       bus_metric_rec_array_out);
    
END get_metric_list;

----------------------------------------------------------------------
-- PROCEDURE   : get_metric_list
----------------------------------------------------------------------
--
-- PURPOSE     : Obtain list of Metrics for a Service
--
-- DESCRIPTION :
--    This procedure obtains the list of Metrics for a Service.
--
-- PARAMETERS  :
--    INPUT    target_guid_in  - Target GUID for Service
--             metric_type_in  - Metric Type (Performance or Usage)
--    OUTPUT   metric_cur_out  - Cursor with list of Metrics
----------------------------------------------------------------------

--This procedure is used by ASLM reports team
--Inform ASLM Team if any change is done to this
PROCEDURE get_metric_list( target_guid_in IN MGMT_TARGETS.target_guid%TYPE,
                           metric_type_in IN MGMT_CATEGORY_MAP.category_name%TYPE,
                           metric_cursor_out  OUT CURSORTYPE)
IS
BEGIN
   validate_is_service(target_guid_in);
   get_metric_list(MGMT_USER_GUID_ARRAY(target_guid_in),
                   metric_type_in,
                   metric_cursor_out);
END;

--workaround for 3037197
FUNCTION get_guids
RETURN MGMT_USER_GUID_ARRAY
IS
BEGIN
   RETURN G_GUIDS;
END get_guids;


PROCEDURE get_metric_list (
   guids_in           IN  MGMT_USER_GUID_ARRAY,
   metric_type_in     IN  MGMT_CATEGORY_MAP.category_name%TYPE,
   metric_cursor_out  OUT CURSORTYPE )
IS
  -- l_count            NUMBER;
  -- l_guid_array MGMT_USER_GUID_ARRAY;
   metric_type_2 VARCHAR2(64);
BEGIN
   -- *********************************************** --
   --            Validate Input Parameters            --
   -- *********************************************** --

   -- Check whether valid Metric type is passed
   IF ( metric_type_in != MGMT_GLOBAL.G_SERVICE_CATEGORY_USAGE
        AND
        metric_type_in != MGMT_GLOBAL.G_SERVICE_CATEGORY_PERFORMANCE 
        AND
        metric_type_in != MGMT_GLOBAL.G_SERVICE_CATEGORY_BUSINESS) 
   THEN
      raise_application_error (
         MGMT_GLOBAL.INVALID_PARAMS_ERR,
         'Invalid Metric type passed : ' || metric_type_in);
   END IF;

   metric_type_2 := metric_type_in;
   IF (metric_type_in = MGMT_GLOBAL.G_SERVICE_CATEGORY_USAGE) THEN
      metric_type_2 := MGMT_GLOBAL.G_SERVICE_CATEGORY_BUSINESS;
   END IF;
      

   -- Check whether Target guid is that of a Service
   --validate_is_service(target_guid_in);
   -- *********************************************** --

   --workaround for 3037197
   G_GUIDS := guids_in;
   OPEN  metric_cursor_out FOR
      WITH curr_met AS (
         SELECT target_guid, metric_guid, key_value,
                value
           FROM mgmt_current_metrics
          WHERE target_guid IN (SELECT *
                                  FROM THE (SELECT CAST(get_guids as MGMT_USER_GUID_ARRAY)
                                          FROM DUAL
                                       )
                               )
      ),
      curr_viol AS (
         SELECT target_guid, policy_guid, key_value,
                value, violation_level
           FROM mgmt_current_violation
          WHERE target_guid IN (SELECT *
                                  FROM THE (SELECT CAST(get_guids as MGMT_USER_GUID_ARRAY)
                                          FROM DUAL
                                       )
                               )
      ),
      metrics AS(

         SELECT met_tab.target_guid, met_tab.metric_guid, met_tab.metric_name,
                met_tab.metric_column, met_tab.column_label, met_tab.column_label_nlsid,
                met_tab.short_name, met_tab.short_name_nlsid, met_tab.num_keys,
                met_tab.is_transposed, curr_met_viol.key_value, curr_met_viol.value,
                NVL(curr_met_viol.violation_level, MGMT_GLOBAL.G_SEVERITY_CLEAR) violation_level
           FROM (
   
            SELECT tgt.target_guid,  met.metric_guid,
                   met.metric_name,  met.metric_column,
                   met.column_label, met.column_label_nlsid,
                   met.short_name, met.short_name_nlsid,
                   met.num_keys, met.is_transposed
            FROM
                   mgmt_metrics met,    mgmt_targets tgt,
                   mgmt_category_map map
            WHERE
                   tgt.target_guid IN (SELECT *
                                         FROM THE (SELECT CAST(get_guids as MGMT_USER_GUID_ARRAY)
                                                 FROM DUAL
                                               )
                                      )
               AND met.target_type    = tgt.target_type
               AND met.type_meta_ver  = tgt.type_meta_ver
               AND met.key_order      = 0
               AND met.metric_column != ' '
               AND
                   (   met.CATEGORY_PROP_1 = tgt.CATEGORY_PROP_1
                    OR met.category_prop_1 = ' ' )
               AND (   met.CATEGORY_PROP_2 = tgt.CATEGORY_PROP_2
                    OR met.category_prop_2 = ' ' )
               AND (   met.CATEGORY_PROP_3 = tgt.CATEGORY_PROP_3
                    OR met.category_prop_3 = ' ' )
               AND (   met.CATEGORY_PROP_4 = tgt.CATEGORY_PROP_4
                    OR met.category_prop_4 = ' ' )
               AND (   met.CATEGORY_PROP_5 = tgt.CATEGORY_PROP_5
                    OR met.category_prop_5 = ' ' )
               AND (map.category_name  =  metric_type_in OR map.category_name = metric_type_2)
               AND map.object_guid    = met.metric_guid
               AND map.class_name     = mgmt_global.G_CATEGORY_CLASS_SERVICE
               AND map.type_meta_ver  = tgt.type_meta_ver
               AND met.metric_type IN 
                    (mgmt_global.G_METRIC_TYPE_NUMBER, 
                     mgmt_global.G_METRIC_TYPE_REPOS_NUMBER)
                ) met_tab,
                (
            SELECT NVL(curr_met.target_guid, curr_viol.target_guid) target_guid,
                   NVL(curr_met.metric_guid, curr_viol.policy_guid) metric_guid,
                   NVL(curr_met.key_value, curr_viol.key_value) key_value,
                   NVL(curr_met.value, curr_viol.value) value,
                   curr_viol.violation_level
              FROM curr_met FULL OUTER JOIN curr_viol
                ON curr_met.target_guid   = curr_viol.target_guid 
               AND curr_met.metric_guid   = curr_viol.policy_guid
               AND curr_met.key_value     = curr_viol.key_value
                ) curr_met_viol

          WHERE met_tab.target_guid   = curr_met_viol.target_guid (+)
            AND met_tab.metric_guid   = curr_met_viol.metric_guid (+)
      ),

      metric_dep AS (
         SELECT dep.target_guid, dep.metric_guid, dep.key_value,
                met.metric_name, met.metric_column
           FROM mgmt_metric_dependency dep, mgmt_metrics met,
                mgmt_targets tgt, mgmt_category_map map
          WHERE dep.target_guid IN (SELECT *
                                      FROM THE (SELECT CAST(get_guids as MGMT_USER_GUID_ARRAY)
                                              FROM DUAL
                                           )
                                   )
            AND tgt.target_guid = dep.target_guid
            AND met.target_type = tgt.target_type
            AND met.metric_guid = dep.metric_guid
            AND met.is_transposed = 1 --this check is probably not necessary but trying to be more safe
            AND met.type_meta_ver = tgt.type_meta_ver
            AND  (   met.CATEGORY_PROP_1 = tgt.CATEGORY_PROP_1
                 OR met.category_prop_1 = ' ' )
            AND (   met.CATEGORY_PROP_2 = tgt.CATEGORY_PROP_2
                 OR met.category_prop_2 = ' ' )
            AND (   met.CATEGORY_PROP_3 = tgt.CATEGORY_PROP_3
                 OR met.category_prop_3 = ' ' )
            AND (   met.CATEGORY_PROP_4 = tgt.CATEGORY_PROP_4
                 OR met.category_prop_4 = ' ' )
            AND (   met.CATEGORY_PROP_5 = tgt.CATEGORY_PROP_5
                 OR met.category_prop_5 = ' ' )
            AND (map.category_name  =  metric_type_in OR map.category_name = metric_type_2)
            AND map.object_guid    = met.metric_guid
            AND map.class_name     = mgmt_global.G_CATEGORY_CLASS_SERVICE
            AND map.type_meta_ver  = tgt.type_meta_ver
      )

      --is_transposed = 1
      SELECT dep.target_guid, dep.metric_guid, dep.key_value,
             dep.metric_name, dep.metric_column, dep.key_value label,
             NULL, NULL, NULL, NULL,
             met.value, NVL(met.violation_level, MGMT_GLOBAL.G_SEVERITY_CLEAR) violation_level,
             DECODE(met.value, NULL, 0,
                    get_metric_diff(dep.target_guid, dep.metric_guid, dep.key_value, met.value, met.violation_level)) diff
        FROM metric_dep dep, metrics met
       WHERE dep.target_guid = met.target_guid (+)
         AND dep.metric_guid = met.metric_guid (+)
         AND dep.key_value = met.key_value (+)
      UNION ALL
      -- business metrics
      SELECT DISTINCT BUS_KPIS.TARGET_GUID, MT.METRIC_GUID, 
             BUS_KPIS.NEW_KPI_NAME,
             MT.METRIC_NAME, MT.METRIC_COLUMN, 
             BUS_KPIS.NEW_KPI_NAME, BUS_KPIS.NEW_KPI_NAME,
	     NULL, NULL,
             -- SUBSTR(BUS_KPIS.NEW_KPI_NAME,1,40), BUS_KPIS.NEW_KPI_NAME,
             NULL, met.value,NVL(met.violation_level,MGMT_GLOBAL.G_SEVERITY_CLEAR) violation_level,
             DECODE(met.value,NULL,0,get_metric_diff (
                met.target_guid,  met.metric_guid, ' ', met.value, met.violation_level)) diff
       FROM MGMT_BAM_ISESSION_KPIS KPI, MGMT_BAM_DATA_ISESSIONS ISES,
            MGMT_METRICS MT, MGMT_TARGETS TGT, METRICS MET,
            (SELECT DS2.TARGET_GUID, DS2.SESSION_GUID, 
              KPI2.KPI_NAME AS OLD_KPI_NAME,
              DS2.DATASOURCE_NAME || '_' || KPI2.KPI_NAME AS NEW_KPI_NAME
             FROM MGMT_BAM_ISESSION_DATASOURCE DS2, MGMT_BAM_ISESSION_KPIS KPI2,
                  MGMT_BAM_DATA_ISESSIONS ISES2
             WHERE KPI2.SESSION_GUID = ISES2.SESSION_GUID
	     AND DS2.DATASOURCE_NAME = KPI2.DATASOURCE_NAME
             AND DS2.SESSION_GUID = ISES2.SESSION_GUID) BUS_KPIS
       WHERE KPI.SESSION_GUID = ISES.SESSION_GUID
         AND MT.METRIC_NAME = 'Business'
         AND MT.TARGET_TYPE = TGT.TARGET_TYPE
         AND MT.TYPE_META_VER = TGT.TYPE_META_VER
         AND MT.METRIC_COLUMN = 'BusinessValue'
         AND metric_type_in IN (MGMT_GLOBAL.G_SERVICE_CATEGORY_BUSINESS,MGMT_GLOBAL.G_SERVICE_CATEGORY_USAGE)
         AND TGT.TARGET_GUID IN
             (SELECT * FROM THE (SELECT CAST(get_guids as MGMT_USER_GUID_ARRAY) FROM DUAL))
         AND BUS_KPIS.SESSION_GUID = ISES.SESSION_GUID
         AND BUS_KPIS.OLD_KPI_NAME = KPI.KPI_NAME
         AND BUS_KPIS.TARGET_GUID = TGT.TARGET_GUID
	 AND BUS_KPIS.TARGET_GUID = MET.TARGET_GUID (+)  -- added to fix bug 5584370
         AND BUS_KPIS.NEW_KPI_NAME = met.key_value (+)
      UNION ALL
      --is_transposed = 0 AND num_keys = 0
      SELECT met.target_guid, met.metric_guid, ' ',
             met.metric_name, met.metric_column, met.column_label label,
             met.column_label_nlsid, met.short_name, met.short_name_nlsid, NULL,
             met.value, met.violation_level,
             get_metric_diff (
                met.target_guid,  met.metric_guid, ' ', met.value, met.violation_level) diff
        FROM metrics met
       WHERE met.is_transposed = 0
         AND met.num_keys = 0
      UNION ALL
      --is_transposed = 0 AND num_keys = 1
      SELECT met.target_guid, met.metric_guid, met.key_value,
             met.metric_name, met.metric_column, met.column_label label,
             met.column_label_nlsid, met.short_name, met.short_name_nlsid, met.key_value key_part_values,
             met.value, met.violation_level,
             get_metric_diff (
                met.target_guid,  met.metric_guid, met.key_value, met.value, met.violation_level) diff
        FROM metrics met
       WHERE met.is_transposed = 0
         AND met.num_keys = 1
         AND met.key_value IS NOT NULL
      UNION ALL
      --is_transposed = 0 AND num_keys > 1
      SELECT met.target_guid, met.metric_guid, RAWTOHEX(mck.composite_key),
             met.metric_name, met.metric_column, met.column_label label,
             met.column_label_nlsid, met.short_name, met.short_name_nlsid,
             mck.key_part1_value || G_SEPARATOR || mck.key_part2_value
                || DECODE(mck.key_part3_value, NULL, NULL,
                           G_SEPARATOR || mck.key_part3_value)
                || DECODE(mck.key_part4_value, NULL, NULL, 
                              G_SEPARATOR || mck.key_part4_value)
                || DECODE(mck.key_part5_value, NULL, NULL, 
                         G_SEPARATOR || mck.key_part5_value) key_part_values,
             met.value, met.violation_level,
             get_metric_diff (
                met.target_guid,  met.metric_guid, 
                       mck.composite_key, met.value, met.violation_level) diff
        FROM metrics met, mgmt_metrics_composite_keys mck
       WHERE met.is_transposed = 0
         AND met.num_keys > 1
         AND met.key_value IS NOT NULL
         AND met.target_guid = mck.target_guid
         AND met.key_value   = mck.composite_key
    ORDER BY target_guid, violation_level DESC, diff DESC, label;
/*
EXCEPTION
   WHEN OTHERS THEN
      DBMS_OUTPUT.PUT_LINE (
         'ERROR: Procedure get_metric_list: Procedure failed.');
*/
END get_metric_list;
----------------------------------------------------------------------

--Returns a blank cursor for invalid target_name and type
PROCEDURE get_metric_list( target_name_in IN MGMT_TARGETS.target_name%TYPE,
                           target_type_in IN MGMT_TARGETS.target_type%TYPE,
                           metric_type_in IN MGMT_CATEGORY_MAP.category_name%TYPE,
                           metric_cursor_out  OUT CURSORTYPE)
IS
l_target_guid MGMT_TARGETS.target_guid%TYPE;
PROC_NAME VARCHAR2(20) := 'get_metric_list';
BEGIN
   BEGIN
      SELECT target_guid
        INTO l_target_guid
        FROM mgmt_targets
       WHERE target_name=target_name_in
         AND target_type=target_type_in;
   EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
         IF (emdw_log.p_is_debug_set)
         THEN
            emdw_log.debug('Invalid target_name/target_type: ' ||
            target_name_in || '/' ||target_type_in, G_PKG_NAME||'.'|| PROC_NAME);
         END IF;
   END;

   get_metric_list(MGMT_USER_GUID_ARRAY(l_target_guid), metric_type_in, metric_cursor_out);

END get_metric_list;

FUNCTION verify_metric_type(p_metric_guid mgmt_metrics.metric_guid%TYPE,
  p_metric_type VARCHAR2,
  p_target_guid mgmt_targets.target_guid%TYPE)
RETURN NUMBER IS
  l_count NUMBER;
BEGIN
  SELECT count(*) into l_count
    FROM mgmt_category_map cat, mgmt_targets tar
    WHERE tar.type_meta_ver = cat.type_meta_ver
      AND tar.target_type = cat.target_type
      AND tar.target_guid = p_target_guid
      AND cat.category_name = p_metric_type
      AND cat.object_guid = p_metric_guid;
  IF l_count > 0 THEN
    RETURN 1;
  ELSE
    RETURN 0;
  END IF;
END verify_metric_type;

PROCEDURE get_statuses(
  service_namestypes_in IN SMP_EMD_NVPAIR_ARRAY,
  status_out         OUT SMP_EMD_NVPAIR_ARRAY,
  total_member_count_out OUT SMP_EMD_NVPAIR_ARRAY,
  up_member_count_out OUT SMP_EMD_NVPAIR_ARRAY,
  down_member_count_out OUT SMP_EMD_NVPAIR_ARRAY,  
  unknown_member_count_out OUT SMP_EMD_NVPAIR_ARRAY,
  timezones_out OUT SMP_EMD_NVPAIR_ARRAY)
IS
  l_guids MGMT_USER_GUID_ARRAY;
  l_index NUMBER;
  l_total_count NUMBER;
  l_up_count NUMBER;
  l_down_count NUMBER;
  l_unknown_count NUMBER;
  l_timezone mgmt_targets.timezone_region%TYPE;
  PROC_NAME VARCHAR2(20) := 'get_statuses';
BEGIN
  get_serviceguids_from_names(service_namestypes_in, l_guids);
  get_current_status(l_guids, status_out);

  total_member_count_out := SMP_EMD_NVPAIR_ARRAY();
  up_member_count_out := SMP_EMD_NVPAIR_ARRAY();
  down_member_count_out := SMP_EMD_NVPAIR_ARRAY(); 
  unknown_member_count_out := SMP_EMD_NVPAIR_ARRAY();
  timezones_out := SMP_EMD_NVPAIR_ARRAY();

  FOR l_index IN l_guids.FIRST .. l_guids.LAST
  LOOP
    total_member_count_out.extend();
    up_member_count_out.extend();
    down_member_count_out.extend();
    unknown_member_count_out.extend();
    timezones_out.extend();

    IF l_guids(l_index) IS NULL
    THEN
      IF (emdw_log.p_is_debug_set)
      THEN
         emdw_log.debug('guid at index ' || l_index || ' is null', 
                         G_PKG_NAME || '.' || PROC_NAME);
      END IF;
      total_member_count_out(l_index) := 
                    SMP_EMD_NVPAIR(l_guids(l_index), NULL);
      up_member_count_out(l_index)    := 
                    SMP_EMD_NVPAIR(l_guids(l_index), NULL);
      down_member_count_out(l_index) := 
                    SMP_EMD_NVPAIR(l_guids(l_index), NULL);
      unknown_member_count_out(l_index):= 
                    SMP_EMD_NVPAIR(l_guids(l_index),NULL);
      timezones_out(l_index) := 
                    SMP_EMD_NVPAIR(l_guids(l_index), NULL);
    ELSE
      get_member_status(l_guids(l_index), l_total_count, l_up_count,
                       l_down_count,l_unknown_count);
      total_member_count_out(l_index) := SMP_EMD_NVPAIR(l_guids(l_index),
                       l_total_count);
      up_member_count_out(l_index) := SMP_EMD_NVPAIR(l_guids(l_index), 
                      NVL(l_up_count,0));
      down_member_count_out(l_index) := SMP_EMD_NVPAIR(l_guids(l_index), 
                      NVL(l_down_count,0));
      unknown_member_count_out(l_index):= SMP_EMD_NVPAIR(l_guids(l_index),
                      NVL(l_unknown_count,0));

      SELECT timezone_region INTO l_timezone
      FROM mgmt_targets
      WHERE target_guid = l_guids(l_index);
      timezones_out(l_index) := SMP_EMD_NVPAIR(l_guids(l_index), l_timezone);
    END IF;
  END LOOP;
END get_statuses;




----------------------------------------------------------------------
-- PROCEDURE   : get_serviceguids_from_names
----------------------------------------------------------------------
--
-- PURPOSE     : Obtain the guids of Services
--
-- DESCRIPTION :
--    This procedure obtains the names of Services
--
-- PARAMETERS  :
--    INPUT    svcnamestypes_in - Array of Service names and target types
--    OUTPUT   svcguids_out     - Array of target guids
----------------------------------------------------------------------

PROCEDURE get_serviceguids_from_names (
   svcnamestypes_in IN  SMP_EMD_NVPAIR_ARRAY,
   svcguids_out OUT MGMT_USER_GUID_ARRAY)
IS
l_target_guid MGMT_TARGETS.target_guid%TYPE;
BEGIN
  svcguids_out := MGMT_USER_GUID_ARRAY();

  FOR l_count in svcnamestypes_in.FIRST ..
                 svcnamestypes_in.LAST
  LOOP

    BEGIN

    SELECT target_guid INTO l_target_guid
    FROM mgmt_targets tgt, mgmt_type_properties typ
    WHERE tgt.target_name=svcnamestypes_in(l_count).name
      AND tgt.target_type=svcnamestypes_in(l_count).value
      AND tgt.target_type    = typ.target_type
      AND typ.property_name  = MGMT_GLOBAL.G_IS_SERVICE_PROP
      AND typ.property_value = 1;

    EXCEPTION
       WHEN NO_DATA_FOUND
          THEN
            l_target_guid := NULL;
    END;

    svcguids_out.extend(1);
    svcguids_out(l_count) := l_target_guid;
  END LOOP;
END get_serviceguids_from_names;
----------------------------------------------------------------------

--l_target_guid and l_haspriv will be null if
--the target does not exist or
--the current user does not have view access to the target

--In the REPORTS context
--owner        viewer      render-context   result
--has access   no access   viewer           l_target_guid and l_haspriv will be null
--has access   no access   owner            l_target_guid not null / l_haspriv will be either 0 or 1
--no access    has access  viewer           l_target_guid not null / l_haspriv will be either 0 or 1
--no access    has access  owner            l_target_guid and l_haspriv will be null
PROCEDURE get_guids_privs (
  namestypes_in IN  SMP_EMD_NVPAIR_ARRAY,
  username_in IN VARCHAR2,
  privname_in IN VARCHAR2,
  guids_privs_out OUT SMP_EMD_NVPAIR_ARRAY)
IS
l_count NUMBER;
l_haspriv NUMBER;
l_target_guid mgmt_targets.target_guid%TYPE;
BEGIN
   guids_privs_out := SMP_EMD_NVPAIR_ARRAY();

   FOR l_count in namestypes_in.FIRST ..
                  namestypes_in.LAST
   LOOP
      BEGIN
         l_target_guid := mgmt_target.get_target_guid(namestypes_in(l_count).name,
                                                      namestypes_in(l_count).value);

         l_haspriv := NULL;
         IF username_in IS NOT NULL AND privname_in IS NOT NULL
         THEN
            l_haspriv := 0;
            IF MGMT_USER.has_priv(username_in,
                                  privname_in,
                                  namestypes_in(l_count).name,
                                  namestypes_in(l_count).value) = MGMT_USER.USER_HAS_PRIV
            THEN
               l_haspriv := 1;
            END IF;
         END IF;

      EXCEPTION
         WHEN MGMT_GLOBAL.target_does_not_exist
         THEN
            l_target_guid := NULL;
            l_haspriv := NULL;
      END;

      guids_privs_out.extend();
      guids_privs_out(l_count) := SMP_EMD_NVPAIR(l_target_guid, l_haspriv); 

   END LOOP;

END get_guids_privs;


-- Internal functions..
-- Flag value 1 indicates Down statuses
-- 2 indicates valid Up statuses

FUNCTION bld_status_str (
      v_target_guid IN MGMT_TARGETS.target_guid%TYPE,
      flag IN NUMBER)
RETURN VARCHAR2 IS
l_error_statuses VARCHAR2(7);
l_statuses VARCHAR2(20);
l_avail_includes  NUMBER(1);

BEGIN
  IF (flag != 1 AND flag != 2) THEN
    raise_application_error (
        MGMT_GLOBAL.INVALID_PARAMS_ERR ,
        'Invalid flag to build_status_string : 
        build_status_string' ) ;
  END IF;
  
  l_error_statuses := TO_CHAR(MGMT_GLOBAL.G_STATUS_ERROR)
                    || ',' || TO_CHAR(MGMT_GLOBAL.G_STATUS_UNREACHABLE)
                    || ',' || TO_CHAR(MGMT_GLOBAL.G_STATUS_UNKNOWN)
                    || ',' || TO_CHAR(MGMT_GLOBAL.G_STATUS_AGENT_DOWN);
  BEGIN
     SELECT avail_includes
       INTO l_avail_includes
       FROM MGMT_SL_RULES
      WHERE target_guid=v_target_guid;
  EXCEPTION
    WHEN NO_DATA_FOUND
    THEN
      l_avail_includes := -1;
  END;

  IF (flag = 1)
  THEN
     l_statuses :=
           CASE l_avail_includes
              WHEN EM_SL.G_BLACKOUT_AGENT_INCL 
                  THEN  TO_CHAR(MGMT_GLOBAL.G_STATUS_DOWN)
              WHEN EM_SL.G_NOT_BLACKOUT_AGENT_INCL 
                  THEN  TO_CHAR(MGMT_GLOBAL.G_STATUS_DOWN) || ','
                        || TO_CHAR(MGMT_GLOBAL.G_STATUS_BLACKOUT)
              WHEN EM_SL.G_BLACKOUT_NOT_AGENT_INCL 
                  THEN  TO_CHAR(MGMT_GLOBAL.G_STATUS_DOWN) || ','
                        || l_error_statuses
              WHEN EM_SL.G_NOT_BLACKOUT_NOT_AGENT_INCL 
                  THEN  TO_CHAR(MGMT_GLOBAL.G_STATUS_DOWN) || ','
                        || l_error_statuses || ','
                        || TO_CHAR(MGMT_GLOBAL.G_STATUS_BLACKOUT)
              WHEN -1
                  --NO SL Rule. So no down statuses
                  THEN ''
            END;
   ELSE
     l_statuses :=
           CASE l_avail_includes
              WHEN EM_SL.G_NOT_BLACKOUT_NOT_AGENT_INCL 
                  THEN  TO_CHAR(MGMT_GLOBAL.G_STATUS_UP)
              WHEN EM_SL.G_BLACKOUT_NOT_AGENT_INCL 
                  THEN  TO_CHAR(MGMT_GLOBAL.G_STATUS_UP) || ','
                        || TO_CHAR(MGMT_GLOBAL.G_STATUS_BLACKOUT)
              WHEN EM_SL.G_NOT_BLACKOUT_AGENT_INCL 
                  THEN  TO_CHAR(MGMT_GLOBAL.G_STATUS_UP) || ','
                        || l_error_statuses
              WHEN EM_SL.G_BLACKOUT_AGENT_INCL 
                  THEN  TO_CHAR(MGMT_GLOBAL.G_STATUS_UP) || ','
                        || l_error_statuses || ','
                        || TO_CHAR(MGMT_GLOBAL.G_STATUS_BLACKOUT)
              WHEN -1
                  --NO SL Rule. So all are up statuses
                  THEN TO_CHAR(MGMT_GLOBAL.G_STATUS_DOWN) || ','
                       || TO_CHAR(MGMT_GLOBAL.G_STATUS_UP) || ','
                       || TO_CHAR(MGMT_GLOBAL.G_STATUS_BLACKOUT) || ','
                       || l_error_statuses
                
            END;
  END IF;
  RETURN l_statuses;
END  bld_status_str;

FUNCTION build_status_string (
      v_target_guid IN MGMT_TARGETS.target_guid%TYPE,
      flag IN NUMBER)
     return charTableType IS
l_statuses VARCHAR2(20);
l_avail_includes  NUMBER(1);
l_avail_table charTableType := charTableType();
BEGIN
  IF (flag != 1 AND flag != 2) THEN
    raise_application_error (
        MGMT_GLOBAL.INVALID_PARAMS_ERR ,
        'Invalid flag to build_status_string : 
        build_status_string' ) ;
  END IF;
  l_statuses := bld_status_str(v_target_guid, flag);
  l_avail_table := str2tbl(l_statuses);
    return l_avail_table;
END build_status_string;

-- Function to build non business days based on SL defn
-- Input Targetguid
-- output - List of non business days


FUNCTION build_non_businessdays (v_target_guid IN MGMT_TARGETS.target_guid%TYPE)
return VARCHAR2 IS

l_nonbusinessdays VARCHAR2(28);
BEGIN

 SELECT (DECODE(SUBSTR(sl.date_sequence,1,1),0,'2/',NULL)
         || DECODE(SUBSTR(sl.date_sequence,2,1),0,'3/',NULL)
         || DECODE(SUBSTR(sl.date_sequence,3,1),0,'4/',NULL)
         || DECODE(SUBSTR(sl.date_sequence,4,1),0,'5/',NULL)
         || DECODE(SUBSTR(sl.date_sequence,5,1),0,'6/',NULL)
         || DECODE(SUBSTR(sl.date_sequence,6,1),0,'7/',NULL)
         || DECODE(SUBSTR(sl.date_sequence,7,1),0,'1/',NULL))
         INTO l_nonbusinessdays FROM mgmt_sl_rules sl WHERE
             target_guid=v_target_guid;

 RETURN l_nonbusinessdays;
 EXCEPTION
    WHEN NO_DATA_FOUND
    THEN
       --No SL Rule. So no business days
       RETURN ''; 
END build_non_businessdays;



/*
The order of guids in service_sla_out, service_name_arr_out
and service_exp_sl_arr_out should be same and match
the order in guid_array_in
*/
PROCEDURE get_services_sla_value (guid_array_in IN target_guid_array,
                     start_date_in IN VARCHAR2,
                     end_date_in IN VARCHAR2,
                     timezone_in IN VARCHAR2,
                     service_sla_out OUT SMP_EMD_NVPAIR_ARRAY,
                     service_name_arr_out OUT SMP_EMD_NVPAIR_ARRAY,
                     service_sla_time_arr_out OUT pie_time_record_array,
                     service_exp_sl_arr_out OUT SMP_EMD_NVPAIR_ARRAY) IS
l_avail_includes CHAR(2);
l_date_sequence  mgmt_sl_rules.date_sequence%TYPE;
l_start_time     mgmt_sl_rules.start_time%type;
l_end_time     mgmt_sl_rules.start_time%type;
l_row_count      NUMBER;
l_sla_computed NUMBER;
l_exclude_str VARCHAR2(20);
l_include_str VARCHAR2(20);
l_total_hours NUMBER;
l_uptime_hours NUMBER;
l_downtime_hours NUMBER;
l_pie_downtime_hours NUMBER;
l_non_business_days VARCHAR2(28);
l_severe_hours NUMBER;
l_total_severe_hours NUMBER;
l_bus_severe_hours NUMBER;
l_total_unavailable_time NUMBER;
l_start_hour NUMBER;
l_end_hour NUMBER;
l_start_date DATE;
l_end_date DATE;
l_expected_sl NUMBER;
l_service_name MGMT_TARGETS.target_name%TYPE;
l_target_guid mgmt_targets.target_guid%TYPE;
l_tgt_timezone VARCHAR2(64);
l_tgt_sysdate DATE;
l_status_rec_arr status_rec_arr;
l_status NUMBER;
l_hours NUMBER;
l_blackout_hours NUMBER;
l_unknown_hours NUMBER;
l_format VARCHAR(21) := 'MM-DD-YYYY HH24:MI:SS';
PROC_NAME VARCHAR2(22) := 'get_services_sla_value';
BEGIN

 service_sla_out := SMP_EMD_NVPAIR_ARRAY();
 service_name_arr_out := SMP_EMD_NVPAIR_ARRAY();
 service_exp_sl_arr_out := SMP_EMD_NVPAIR_ARRAY();
 service_sla_time_arr_out := pie_time_record_array();

-- Loop through the input target guid array
 FOR i IN  guid_array_in.FIRST .. guid_array_in.LAST
 LOOP

-- Initialize the values
    l_total_hours := 0;
    l_uptime_hours := 0;
    l_downtime_hours := 0;
    l_pie_downtime_hours := 0;
    l_severe_hours := 0;
    l_bus_severe_hours := 0;
    l_total_unavailable_time := 0;
    l_blackout_hours := -1;
    l_unknown_hours := -1;
    l_target_guid := HEXTORAW(guid_array_in(i));
    

    BEGIN
      SELECT target_name,    timezone_region
      INTO
             l_service_name, l_tgt_timezone
      FROM
             mgmt_targets tgt, mgmt_type_properties props
      WHERE
             tgt.target_guid = l_target_guid
        AND  tgt.target_type = props.target_type
        AND  props.property_name  = MGMT_GLOBAL.G_IS_SERVICE_PROP
        AND  props.property_value = 1;

    EXCEPTION
       WHEN NO_DATA_FOUND
       THEN
          IF (emdw_log.p_is_debug_set)THEN
             emdw_log.debug('Invalid service guid: ' || guid_array_in(i), 
                            G_PKG_NAME || '.' || PROC_NAME);
          END IF;
          l_sla_computed := NULL;
          l_service_name := NULL;
          l_expected_sl := NULL;
          GOTO next_iteration;
    END;

    l_start_date := MGMT_GLOBAL.ADJUST_TZ(
           TO_DATE(start_date_in, l_format), 
                   timezone_in, l_tgt_timezone);

    l_end_date := MGMT_GLOBAL.ADJUST_TZ(
           TO_DATE(end_date_in, l_format), 
                   timezone_in, l_tgt_timezone);

    IF (l_start_date > l_end_date ) THEN
       RAISE_APPLICATION_ERROR(-20000,'Invalid Date
             ranges passed to the procedure');
    END IF;

    l_start_date := GREATEST(l_start_date, 
                   get_avail_start_time(l_target_guid));

    l_end_date := LEAST(l_end_date, get_avail_end_time(l_target_guid));

    IF (emdw_log.p_is_debug_set)THEN
       emdw_log.debug('GUID: ' || guid_array_in(i), G_PKG_NAME || '.' || PROC_NAME);
       emdw_log.debug('Original: StartDate: ' || start_date_in ||
                      'EndDate: ' || end_date_in, G_PKG_NAME || '.' || PROC_NAME);
       emdw_log.debug('Computed: StartDate: ' || TO_CHAR(l_start_date, l_format) ||
                      'EndDate: ' || TO_CHAR(l_end_date, l_format),
                       G_PKG_NAME || '.' || PROC_NAME);
    END IF;

    l_tgt_sysdate := MGMT_GLOBAL.SYSDATE_TZRGN(l_tgt_timezone);

-- Get the rules defined for this target_guid
-- Make sure we have only one rule for the service guid passed
     SELECT count(*) 
       INTO l_row_count 
       FROM mgmt_sl_rules
      WHERE target_guid= l_target_guid;

  IF ( l_row_count != 1 )
  THEN
      IF (emdw_log.p_is_debug_set)
      THEN
         emdw_log.debug('No SL Rule', G_PKG_NAME || '.' || PROC_NAME);
      END IF;

      l_pie_downtime_hours := 0; --l_downtime_hours;
      l_expected_sl := 0;
      l_start_time := '0000';
      l_end_time := '2400';
      l_date_sequence :='1111111';

    --NULL checks take care of no records in mgmt_availability
  IF (l_start_date IS NULL OR l_end_date IS NULL OR l_start_date >= l_end_date)
    THEN
      l_sla_computed := -1;
    ELSE
      l_sla_computed := 100;
      l_total_hours := (l_end_date - l_start_date) *24;
    END IF;
    goto next_iteration;

  ELSE

--Build as string. Build statuses as include and exclude statuses..
    l_include_str :=  bld_status_str (l_target_guid,2);

    l_exclude_str := bld_status_str(l_target_guid,1);

    IF (emdw_log.p_is_debug_set)
    THEN
       emdw_log.debug(' include str: ' || l_include_str || ' exclude str: ' ||
                  l_exclude_str, G_PKG_NAME || '.' || PROC_NAME);
    END IF;

    IF (instr (l_exclude_str, MGMT_GLOBAL.G_STATUS_BLACKOUT) > 0 ) THEN
      l_blackout_hours := 0;
    END IF;
    IF (instr (l_exclude_str, MGMT_GLOBAL.G_STATUS_AGENT_DOWN) > 0 ) THEN
      l_unknown_hours := 0;
    END IF;
-- Get the service level rule definition for this service.

    SELECT start_time, end_time, date_sequence, expected_sl
      INTO l_start_time, l_end_time, l_date_sequence, l_expected_sl
      FROM mgmt_sl_rules 
     WHERE target_guid = l_target_guid;

      IF (emdw_log.p_is_debug_set)
      THEN
         emdw_log.debug('SL Rule: StartTime: ' || l_start_time ||
                        ' EndTime: ' || l_end_time ||
                        ' DateSeq: ' || l_date_sequence, G_PKG_NAME || '.' || PROC_NAME);
      END IF;

    --NULL checks take care of no records in mgmt_availability
    IF (l_start_date IS NULL OR l_end_date IS NULL OR l_start_date >= l_end_date)
    THEN
     l_sla_computed := -1;
      goto next_iteration;
   END IF;
-- Non business hours for this service.

    l_non_business_days := build_non_businessdays(l_target_guid);

    l_start_hour := TO_NUMBER(SUBSTR(l_start_time, 1, 2)) +
                    TO_NUMBER(SUBSTR(l_start_time, 3, 2)) / 60;

    l_end_hour := TO_NUMBER(SUBSTR(l_end_time, 1, 2)) +
                  TO_NUMBER(SUBSTR(l_end_time, 3, 2)) / 60;

-- Calculate total business hours
   l_total_hours := hours_worked(l_start_date,l_end_date,
                    l_non_business_days, l_start_hour,l_end_hour);

   IF (emdw_log.p_is_debug_set)
   THEN
      emdw_log.debug('Total Business Hours: ' || l_total_hours, G_PKG_NAME || 
              '.' || PROC_NAME);
   END IF;

   IF (l_total_hours = 0 )
   THEN
      l_sla_computed := 100;
      goto next_iteration;
   END IF;


-- Up time

-- Should we add this outside of PLSQL .
-- We can group by current status and then
-- add the values outside if needed

    BEGIN
    SELECT status_rec(current_status, 
          sum(hours_worked(greatest(start_collection_timestamp,
          l_start_date), least(NVL(end_collection_timestamp,
          l_tgt_sysdate),l_end_date) ,l_non_business_days,
          l_start_hour,l_end_hour))) 
    BULK COLLECT 
    INTO l_status_rec_arr  
    FROM mgmt_availability
   WHERE (l_start_date 
          BETWEEN start_collection_timestamp AND
          NVL(end_collection_timestamp,l_tgt_sysdate) OR
          start_collection_timestamp  >= l_start_date)
     AND ( l_end_date BETWEEN start_collection_timestamp   AND
          NVL(end_collection_timestamp , l_tgt_sysdate) OR
          l_end_date >= NVL(end_collection_timestamp , l_tgt_sysdate) )
     AND target_guid = l_target_guid
    GROUP BY CURRENT_STATUS;

    EXCEPTION
       WHEN NO_DATA_FOUND
          THEN
            l_total_hours := 0;
            l_sla_computed := 100;
            goto next_iteration;
    END;

    IF l_status_rec_arr IS NULL OR l_status_rec_arr.COUNT = 0
    THEN
            l_total_hours := 0;
            l_sla_computed := 100;
            goto next_iteration;
    END IF;

     FOR i in l_status_rec_arr.FIRST .. l_status_rec_arr.LAST 
     LOOP
      l_status := l_status_rec_arr(i).status;
      l_hours  := l_status_rec_arr(i).hrs;
      IF l_status = MGMT_GLOBAL.G_STATUS_UP THEN
        l_uptime_hours := l_uptime_hours + l_hours;
      END IF;

      IF (l_status = MGMT_GLOBAL.G_STATUS_DOWN) THEN
        l_downtime_hours := l_downtime_hours + l_hours;
        l_pie_downtime_hours := l_pie_downtime_hours + l_hours;
      END IF;

      IF (l_status = MGMT_GLOBAL.G_STATUS_ERROR  OR
          l_status = MGMT_GLOBAL.G_STATUS_UNREACHABLE OR
          l_status = MGMT_GLOBAL.G_STATUS_UNKNOWN OR 
          l_status = MGMT_GLOBAL.G_STATUS_AGENT_DOWN) THEN

         IF (instr (l_exclude_str,l_status) > 0 ) THEN
                 --collection errors are considered as down
                 l_unknown_hours := l_unknown_hours + l_hours;
                 l_downtime_hours := l_downtime_hours + l_hours;
         ELSE
                 --collection errors are considered as up
                 l_uptime_hours := l_uptime_hours + l_hours;
         END IF;
      END IF;

      IF (l_status = MGMT_GLOBAL.G_STATUS_BLACKOUT) THEN
         IF (instr (l_exclude_str,l_status) > 0 ) THEN
                 --blackout is considered as down
                 l_blackout_hours := l_hours ;
                 l_downtime_hours := l_downtime_hours + l_hours;
         ELSE
                 --blackout is considered as up
                 l_uptime_hours := l_uptime_hours + l_hours;
         END IF;
      END IF;
     END LOOP;


-- Severity Duration.
-- We are joining with mgmt_metrics so that we wont use the metric
-- that is  deleted.
-- We already have added the function to delete the metric when the svc
-- is deleted.
   SELECT count(*) INTO l_row_count 
     FROM mgmt_sl_metrics sl--, mgmt_metrics met
    WHERE sl.target_guid = l_target_guid;
      --AND sl.metric_guid = met.metric_guid;
      
   IF (l_row_count > 0 ) THEN
     BEGIN
     SELECT sum(get_severity_duration(l_target_guid,
               greatest(start_collection_timestamp,l_start_date),
               least(NVL(end_collection_timestamp,l_tgt_sysdate),l_end_date),
               l_start_hour, l_end_hour,l_non_business_days))
       INTO l_severe_hours
       FROM mgmt_availability
      WHERE ( l_start_date between start_collection_timestamp AND
               NVL(end_collection_timestamp,l_tgt_sysdate) OR
               start_collection_timestamp  >= l_start_date)
        AND ( l_end_date between start_collection_timestamp   AND
               NVL(end_collection_timestamp , l_tgt_sysdate) OR
               l_end_date >= NVL(end_collection_timestamp , l_tgt_sysdate) )
        AND target_guid = l_target_guid
        AND current_status = MGMT_GLOBAL.G_STATUS_UP;

     SELECT sum(get_total_severity_duration(l_target_guid,
               greatest(start_collection_timestamp,l_start_date),
               least(NVL(end_collection_timestamp,l_tgt_sysdate),l_end_date),
               l_start_hour, l_end_hour,l_non_business_days))
       INTO l_total_severe_hours
       FROM mgmt_availability
      WHERE ( l_start_date between start_collection_timestamp AND
               NVL(end_collection_timestamp,l_tgt_sysdate) OR
               start_collection_timestamp  >= l_start_date)
        AND ( l_end_date between start_collection_timestamp   AND
               NVL(end_collection_timestamp , l_tgt_sysdate) OR
               l_end_date >= NVL(end_collection_timestamp , l_tgt_sysdate) )
        AND target_guid = l_target_guid
        AND current_status = MGMT_GLOBAL.G_STATUS_UP;

     EXCEPTION
        WHEN NO_DATA_FOUND
           THEN
              l_severe_hours := 0;
              l_total_severe_hours := 0;
     END;

      IF ( l_severe_hours is NULL ) THEN
        l_severe_hours := 0;
      END IF;

      IF ( l_total_severe_hours is NULL ) THEN
        l_total_severe_hours := 0;
      END IF;

      l_bus_severe_hours := l_total_severe_hours - l_severe_hours;
    END IF;
       l_uptime_hours := l_uptime_hours - l_severe_hours - l_bus_severe_hours;
       l_total_unavailable_time := l_severe_hours + l_bus_severe_hours + l_downtime_hours;
       l_sla_computed := (1 - l_total_unavailable_time /
                           l_total_hours) * 100;
   IF (emdw_log.p_is_debug_set)
   THEN
      emdw_log.debug('Up Hours: ' || l_uptime_hours ||
                     ' Unavailable Hours: ' || l_total_unavailable_time ||
                     ' SL: ' || l_sla_computed, G_PKG_NAME || '.' || PROC_NAME);
   END IF;

  END IF;
  <<next_iteration>>

      service_sla_out.extend(1);
      service_sla_out(i) := SMP_EMD_NVPAIR(guid_array_in(i),
                  l_sla_computed );

      service_name_arr_out.extend(1);
      service_name_arr_out(i) := SMP_EMD_NVPAIR(guid_array_in(i),
                 l_service_name);

      service_exp_sl_arr_out.extend(1);
      service_exp_sl_arr_out(i) := SMP_EMD_NVPAIR(guid_array_in(i),
                  l_expected_sl);

      service_sla_time_arr_out.extend();
      service_sla_time_arr_out(i) :=  sla_pie_rec(l_target_guid,
              l_uptime_hours,l_pie_downtime_hours,l_blackout_hours,
              l_unknown_hours,l_severe_hours,l_bus_severe_hours,l_total_hours,l_start_time,
              l_end_time,l_date_sequence,
              l_tgt_timezone);

-- Get the total avail based on the rule
-- For each times when the service was available check if we had any
-- serverity for the response metric selected in the SLA rule
  END LOOP ;

END get_services_sla_value;

--This procedure is used by ASLM reports team
PROCEDURE get_avail_for_pie_chart (v_target_guid IN MGMT_TARGETS.target_guid%TYPE,
                                   v_start_date IN VARCHAR2,
                                   v_end_date IN VARCHAR2,
                                   v_timezone IN VARCHAR2,
                                   v_status_dur_cur  OUT CURSORTYPE) IS
l_start_date DATE;
l_end_date DATE;
l_tgt_timezone VARCHAR2(64);
BEGIN
 
  SELECT timezone_region
    INTO l_tgt_timezone
    FROM MGMT_TARGETS
   WHERE target_guid=v_target_guid;

  l_start_date := MGMT_GLOBAL.ADJUST_TZ(
             TO_DATE(v_start_date, 'MM-DD-YYYY HH24:MI:SS'), 
             v_timezone, l_tgt_timezone);

  l_end_date := MGMT_GLOBAL.ADJUST_TZ(
                TO_DATE(v_end_date, 'MM-DD-YYYY HH24:MI:SS'), 
                v_timezone, l_tgt_timezone);

  OPEN v_status_dur_cur FOR
    SELECT sum(least(NVL(end_collection_timestamp,
             MGMT_GLOBAL.SYSDATE_TZRGN(l_tgt_timezone)),l_end_date)
             - GREATEST(l_start_date, start_collection_timestamp))*24,
           current_status
      FROM mgmt_availability
     WHERE target_guid = v_target_guid
       AND (  l_start_date BETWEEN start_collection_timestamp
              AND NVL(end_collection_timestamp, 
                    MGMT_GLOBAL.SYSDATE_TZRGN(l_tgt_timezone))
              OR
              start_collection_timestamp > l_start_date
           )
       AND (  l_end_date BETWEEN start_collection_timestamp AND
              NVL(end_collection_timestamp,
                  MGMT_GLOBAL.SYSDATE_TZRGN(l_tgt_timezone))
              OR
              l_end_date >= NVL(end_collection_timestamp,
                              MGMT_GLOBAL.SYSDATE_TZRGN(l_tgt_timezone))
           )
       AND GREATEST(start_collection_timestamp,l_start_date) !=
              LEAST(NVL(end_collection_timestamp,
                    MGMT_GLOBAL.SYSDATE_TZRGN(l_tgt_timezone)),l_end_date)
  GROUP BY current_status;

END get_avail_for_pie_chart;




--This procedure is used by ASLM reports team
PROCEDURE get_avail_for_cigar_chart (v_target_guid IN MGMT_TARGETS.target_guid%TYPE,
                                     v_start_date IN VARCHAR2,
                                     v_end_date IN VARCHAR2,
                                     v_timezone IN VARCHAR2,
                                     v_status_det_cur OUT CURSORTYPE)
IS
l_start_date DATE;
l_end_date DATE;
l_tgt_timezone MGMT_TARGETS.timezone_region%TYPE;
l_tgt_sysdate DATE;
BEGIN
  SELECT timezone_region
    INTO l_tgt_timezone
    FROM MGMT_TARGETS
   WHERE target_guid=v_target_guid;
  l_start_date := MGMT_GLOBAL.ADJUST_TZ(
             TO_DATE(v_start_date, 'MM-DD-YYYY HH24:MI:SS'), 
             v_timezone, l_tgt_timezone);

  l_end_date := MGMT_GLOBAL.ADJUST_TZ(
                TO_DATE(v_end_date, 'MM-DD-YYYY HH24:MI:SS'), 
                v_timezone, l_tgt_timezone);

  l_tgt_sysdate := MGMT_GLOBAL.SYSDATE_TZRGN(l_tgt_timezone);

    OPEN v_status_det_cur FOR
      SELECT MGMT_GLOBAL.ADJUST_TZ(
                  greatest(start_collection_timestamp,l_start_date),
                  l_tgt_timezone,v_timezone),
             least(NVL(end_collection_timestamp,l_tgt_sysdate),l_end_date)
                    - greatest(start_collection_timestamp,l_start_date),
             current_status,
             MGMT_GLOBAL.ADJUST_TZ(least(
                      NVL(end_collection_timestamp,l_tgt_sysdate), l_end_date),
                    l_tgt_timezone,v_timezone),
             severity_guid
        FROM mgmt_availability
       WHERE target_guid=v_target_guid
         AND (   l_start_date BETWEEN start_collection_timestamp  AND
                 NVL(end_collection_timestamp,l_tgt_sysdate)
                 OR
                 start_collection_timestamp > l_start_date
             )
         AND (  l_end_date BETWEEN start_collection_timestamp AND
                NVL(end_collection_timestamp,l_tgt_sysdate)
                OR
                l_end_date >= NVL(end_collection_timestamp,l_tgt_sysdate)
             )
         AND GREATEST(start_collection_timestamp,l_start_date) !=
                least(NVL(end_collection_timestamp,l_tgt_sysdate),l_end_date);

END;

FUNCTION get_avail_pct(target_type IN VARCHAR2,
                       up_time     IN NUMBER,
                       down_time   IN NUMBER,
                       agent_down_time IN NUMBER,
                       total_time  IN NUMBER)
RETURN NUMBER
IS
l_avail_formula NUMBER;
avail_pct_value NUMBER;
l_numerator NUMBER;
l_denominator NUMBER;
BEGIN
   BEGIN
     SELECT parameter_value into l_avail_formula
       FROM MGMT_PARAMETERS p
      WHERE p.parameter_name = 'avail_formula';

   EXCEPTION
     WHEN NO_DATA_FOUND
     THEN
       l_avail_formula := 0;
   END;
       IF(l_avail_formula = 1 AND target_type != MGMT_GLOBAL.G_AGENT_TARGET_TYPE)
       THEN
         -- The Availability Percentage Calculation is:
         -- -------------------------------------------
         --    Hosts: [ 1 - (agent down time / number of days) ]*100
         --    Others (non-agent): [ 1 - (downtime / number of days) ]*100
         -------------------------------------------------------------

         -- numerator is downtime, but since the host target doesn't have 
         -- downtime, use agent down time instead
         IF(target_type = MGMT_GLOBAL.G_HOST_TARGET_TYPE)
         THEN
           l_numerator := agent_down_time;
         ELSE
           l_numerator := down_time;
         END IF;

         -- denominator is number of days
         l_denominator := total_time;

         IF(l_denominator != 0)
         THEN
           avail_pct_value := (1 - l_numerator/l_denominator) * 100;
         END IF;

       -- Default
       ELSE
         -- The Availability Percentage Calculation is:
         -- -------------------------------------------
         --    [ uptime / (uptime + downtime + agent down time) ]*100
         -------------------------------------------------------------

         -- numerator is uptime
         l_numerator := up_time;

         -- denominator is (uptime + downtime + agent down time)
         l_denominator := up_time + down_time + agent_down_time;

         IF( l_denominator != 0 )
         THEN
           avail_pct_value := (l_numerator/l_denominator) * 100;
         END IF;
       END IF;

    RETURN avail_pct_value;

END;

--**********IMPORTANT**********
--when this procedure is called via jdbc
--check for not null(wasNull()) for v_avail_percent before
--trying to get the v_status_dur_cur CURSOR
PROCEDURE get_avail_details(v_target_name IN VARCHAR2,
                            v_target_type IN VARCHAR2,
                            v_start_date IN VARCHAR2,
                            v_end_date IN VARCHAR2,
                            v_timezone IN VARCHAR2,
                            v_tgt_timezone OUT VARCHAR2,
                            v_curr_status OUT NUMBER,
                            v_status_since OUT DATE,
                            v_avail_percent OUT NUMBER,
                            v_status_dur_cur  OUT CURSORTYPE)
                            
IS
l_format VARCHAR2(21) := 'MM-DD-YYYY HH24:MI:SS';
l_target_guid mgmt_targets.target_guid%TYPE;
l_duration NUMBER;
l_status NUMBER;
l_uptime NUMBER := 0;
l_downtime NUMBER := 0;
l_agent_downtime NUMBER := 0;
l_start_date DATE;
l_end_date DATE;
l_tgt_start_date DATE;
l_tgt_end_date DATE;
l_total_hours NUMBER;
l_status_since DATE;
l_status_dur_cur CURSORTYPE;
PROC_NAME VARCHAR2(20) := 'get_avail_details';
BEGIN
  SELECT target_guid, timezone_region
    INTO l_target_guid, v_tgt_timezone
    FROM mgmt_targets
   WHERE target_name = v_target_name
     AND target_type = v_target_type;

  l_tgt_start_date := MGMT_GLOBAL.ADJUST_TZ(
             TO_DATE(v_start_date, l_format), 
             v_timezone,
             v_tgt_timezone);

  l_tgt_end_date := MGMT_GLOBAL.ADJUST_TZ(
                TO_DATE(v_end_date, l_format), 
                v_timezone,
                v_tgt_timezone);

  l_tgt_start_date := GREATEST(l_tgt_start_date, 
              get_avail_start_time(l_target_guid));

  l_tgt_end_date := LEAST(l_tgt_end_date, 
              get_avail_end_time(l_target_guid));

  SELECT current_status, start_collection_timestamp
    INTO v_curr_status, l_status_since
    FROM mgmt_current_availability
   WHERE target_guid = l_target_guid;

  v_status_since := MGMT_GLOBAL.ADJUST_TZ(l_status_since,
                      v_tgt_timezone, v_timezone);

  IF (emdw_log.p_is_debug_set)THEN
          emdw_log.debug('Original: StartDate: ' || v_start_date ||
                         'EndDate: ' || v_end_date, G_PKG_NAME || '.' || PROC_NAME);
          emdw_log.debug('Computed: StartDate: ' || 
                          TO_CHAR(l_tgt_start_date, l_format) ||
                         'EndDate: ' || TO_CHAR(l_tgt_end_date, l_format), 
                          G_PKG_NAME || '.' || PROC_NAME);
  END IF;

  --NULL checks take care of no records in mgmt_availability
  IF (l_tgt_start_date IS NULL OR l_tgt_end_date IS NULL OR 
        l_tgt_start_date >= l_tgt_end_date)
  THEN
    RETURN;
  END IF; 

  l_start_date := MGMT_GLOBAL.ADJUST_TZ(l_tgt_start_date,
                        v_tgt_timezone, v_timezone);
  l_end_date := MGMT_GLOBAL.ADJUST_TZ(l_tgt_end_date, 
                        v_tgt_timezone, v_timezone);

  get_avail_for_pie_chart(l_target_guid, TO_CHAR(l_start_date, l_format),
                          TO_CHAR(l_end_date, l_format),
                          v_timezone, v_status_dur_cur);

  get_avail_for_pie_chart(l_target_guid, TO_CHAR(l_start_date, l_format),
                          TO_CHAR(l_end_date, l_format),
                          v_timezone, l_status_dur_cur);

  LOOP
  FETCH l_status_dur_cur INTO l_duration, l_status;
  EXIT WHEN l_status_dur_cur%NOTFOUND;
    --dbms_output.put_line('In l_status_dur_cur - ' || l_duration || ' ' || l_status);
    IF l_status = MGMT_GLOBAL.G_STATUS_DOWN
    THEN
      l_downtime := l_duration;
    END IF;
    IF l_status = MGMT_GLOBAL.G_STATUS_UP
    THEN
      l_uptime := l_duration;
    END IF;
    IF l_status = MGMT_GLOBAL.G_STATUS_AGENT_DOWN
    THEN
      l_agent_downtime := l_duration;
    END IF;
  END LOOP;
  CLOSE l_status_dur_cur;

  v_avail_percent := get_avail_pct(v_target_type, l_uptime, 
              l_downtime, l_agent_downtime, l_total_hours);
END;
                         

PROCEDURE get_sl_history(v_target_guid in MGMT_TARGETS.target_guid%TYPE,
                   v_start_date IN VARCHAR2,
                   v_end_date IN VARCHAR2,
                   v_timezone IN VARCHAR2,
                   v_out_timezone IN VARCHAR2,
                   sl_violations_arr_out OUT violations_record_array,
                   sl_violtable_arr_out OUT violations_record_array)
IS
l_out_timezone mgmt_targets.timezone_region%TYPE;
l_format VARCHAR2(21) := 'MM-DD-YYYY HH24:MI:SS';
BEGIN
   l_out_timezone := v_out_timezone;
   IF l_out_timezone IS NULL
   THEN
      SELECT timezone_region
        INTO l_out_timezone
        FROM mgmt_targets
       WHERE target_guid = v_target_guid;
   END IF;

   get_sl_history(v_target_guid,
                  TO_CHAR(MGMT_GLOBAL.ADJUST_TZ(TO_DATE(v_start_date, l_format), v_timezone, l_out_timezone), l_format),
                  TO_CHAR(MGMT_GLOBAL.ADJUST_TZ(TO_DATE(v_end_date, l_format), v_timezone, l_out_timezone), l_format),
                  l_out_timezone,
                  sl_violations_arr_out,
                  sl_violtable_arr_out);

END get_sl_history;


PROCEDURE get_sl_history(v_target_guid in MGMT_TARGETS.target_guid%TYPE,
                   v_start_date IN VARCHAR2,
                   v_end_date IN VARCHAR2,
                   v_timezone IN VARCHAR2,
                   sl_violations_arr_out OUT violations_record_array,
                   sl_violtable_arr_out OUT violations_record_array)
IS
l_sl_violtable_arr_out violations_record_array;
l_sl_violations_arr_out violations_record_array;
l_new_sl_violations_arr_out violations_record_array;
l_rec violations_record;
l_modified_bus_rec violations_record;
l_bus_rec violations_record;
l_splitted_bus_rec violations_record;
l_first_time NUMBER;
greatest_slow_rec sla_sev_rec;
start_time DATE;
end_time DATE;
l_count NUMBER;
l_rule_count NUMBER;
l_target_guid MGMT_TARGETS.target_guid%TYPE;
l_user_name MGMT_SEVERITY.user_name%TYPE;
l_message MGMT_SEVERITY.message%TYPE;
l_outage_type NUMBER;
i NUMBER;
j NUMBER;
l_include_statuses charTableType;
l_exclude_statuses charTableType;
l_include_status_string VARCHAR2(20);
l_exclude_status_string VARCHAR2(20);
l_non_business_days VARCHAR2(28);
l_business_days VARCHAR2(28);
l_next_business_days VARCHAR2(28);
l_st_downtime DATE;
l_end_downtime DATE;
l_st_uptime DATE;
l_end_uptime DATE;
l_down_sev_guid MGMT_VIOLATIONS.violation_guid%TYPE;
l_severity_guid MGMT_VIOLATIONS.violation_guid%TYPE;
l_start_viol_time DATE;
l_end_viol_time DATE;
l_username MGMT_VIOLATIONS.user_name%TYPE;
l_metric_guid MGMT_METRICS.metric_GUID%TYPE;
l_start_date DATE;
l_end_date DATE;
l_orig_start_date DATE;
l_orig_end_date DATE;
l_start_time mgmt_sl_rules.start_time%TYPE;
l_end_time mgmt_sl_rules.end_time%TYPE;
l_clockin NUMBER;
l_clockout NUMBER;
l_start_collection_timestamp DATE;
l_end_collection_timestamp DATE;
l_viol_end_coll_tstmp DATE;
l_viol_strt_coll_tstmp DATE;
l_bh_start DATE;
l_bh_end  DATE;
l_wkend_start DATE;
l_curr_date DATE;
l_wkend_end DATE;
l_target_name MGMT_TARGETS.target_name%TYPE;
l_up_sev_guid MGMT_VIOLATIONS.violation_guid%TYPE;
l_row_count  NUMBER;
l_current_status NUMBER ;
l_st_valid_time DATE;
l_end_valid_time DATE;
l_st_invalid_time DATE;
l_end_invalid_time DATE;
l_new_count NUMBER;
l_tgt_timezone MGMT_TARGETS.timezone_region%TYPE;
l_tgt_sysdate DATE;
l_format VARCHAR2(21);
PROC_NAME VARCHAR2(20);


-- Status cursors
-- Up cursor

CURSOR up_status_cursor  (tguid in MGMT_TARGETS.target_guid%TYPE,
                          strt_date in DATE,
                          end_date in DATE, tgt_sysdate IN DATE,
                          l_clockin IN NUMBER, l_clockout IN NUMBER)
IS
  SELECT target_guid,
         severity_guid,
         greatest(start_collection_timestamp,strt_date),
         least(NVL(end_collection_timestamp,tgt_sysdate),end_date),
         current_status
    FROM mgmt_availability
   WHERE target_guid=tguid
     AND (  strt_date BETWEEN start_collection_timestamp AND
            NVL(end_collection_timestamp,tgt_sysdate)
            OR
            start_collection_timestamp >= strt_date
         )
     AND (  end_date BETWEEN start_collection_timestamp   AND
            NVL(end_collection_timestamp , tgt_sysdate)
            OR
            end_date >= NVL(end_collection_timestamp , tgt_sysdate)
         )
     AND (greatest(start_collection_timestamp,strt_date) !=
         least(NVL(end_collection_timestamp,tgt_sysdate),end_date))
     AND current_status = MGMT_GLOBAL.G_STATUS_UP 
ORDER BY start_collection_timestamp;



  CURSOR down_cursor  (tguid in MGMT_TARGETS.target_guid%TYPE, strt_date in DATE,
                         end_date in DATE, tgt_sysdate IN DATE,
                         l_clockin IN NUMBER, l_clockout IN NUMBER,
                         l_excl_status IN charTableType)
  IS
  SELECT target_guid,
         severity_guid,
         current_status,
         greatest(start_collection_timestamp,strt_date),
         least(NVL(end_collection_timestamp,tgt_sysdate),end_date),
         current_status
    FROM mgmt_availability
   WHERE target_guid=tguid
     AND (  strt_date BETWEEN start_collection_timestamp AND
            NVL(end_collection_timestamp,tgt_sysdate)
            OR
            start_collection_timestamp >= strt_date
         )
     AND (  end_date BETWEEN start_collection_timestamp   AND
            NVL(end_collection_timestamp , tgt_sysdate)
            OR
            end_date >= NVL(end_collection_timestamp , tgt_sysdate)
         )
     AND current_status IN (SELECT *
                          FROM THE (SELECT CAST(l_excl_status as charTableType)
                                      FROM DUAL)
                           )
ORDER BY start_collection_timestamp;

  -- Violations cursor
  
  CURSOR violations_cursor (tguid in MGMT_TARGETS.target_guid%TYPE, strt_date in DATE,
                         end_date in DATE,tgt_sysdate IN DATE)
  IS
  SELECT sl.target_guid,
         violation_guid,
         policy_guid,
         greatest(collection_timestamp,strt_date),
         least(DECODE(violation_duration, NULL, tgt_sysdate,
	 collection_timestamp + violation_duration / 24) ,end_date),
         user_name,
         message
    FROM mgmt_violations viol, mgmt_sl_metrics sl
   WHERE viol.target_guid=tguid
     AND viol.target_guid=sl.target_guid
     AND sl.metric_guid=viol.policy_guid 
     AND viol.key_value=sl.key_value 
     AND verify_metric_type(sl.metric_guid, MGMT_GLOBAL.G_SERVICE_CATEGORY_PERFORMANCE, tguid) = 1
     AND (  strt_date between collection_timestamp AND
            DECODE(violation_duration, NULL, tgt_sysdate,collection_timestamp + violation_duration / 24)
            OR
            collection_timestamp  >= strt_date
         )
     AND (  end_date between collection_timestamp AND
            DECODE(violation_duration, NULL, tgt_sysdate,collection_timestamp + violation_duration / 24)
            OR
            end_date >= DECODE(violation_duration, NULL, tgt_sysdate,collection_timestamp + violation_duration / 24)
         )
    AND violation_level = MGMT_GLOBAL.G_SEVERITY_CRITICAL
  ORDER by collection_timestamp;

  -- Bus Violations cursor
  
  CURSOR bus_violations_cursor (tguid in MGMT_TARGETS.target_guid%TYPE, strt_date in DATE,
                         end_date in DATE,tgt_sysdate IN DATE)
  IS
  SELECT sl.target_guid,
         violation_guid,
         policy_guid,
         greatest(collection_timestamp,strt_date),
         least(DECODE(violation_duration, NULL, tgt_sysdate,
	 collection_timestamp + violation_duration / 24) ,end_date),
         user_name,
         message
    FROM mgmt_violations viol, mgmt_sl_metrics sl
   WHERE viol.target_guid=tguid
     AND viol.target_guid=sl.target_guid
     AND sl.metric_guid=viol.policy_guid 
     AND viol.key_value=sl.key_value 
     AND verify_metric_type(sl.metric_guid, MGMT_GLOBAL.G_SERVICE_CATEGORY_BUSINESS, tguid) = 1
     AND (  strt_date between collection_timestamp AND
            DECODE(violation_duration, NULL, tgt_sysdate,collection_timestamp + violation_duration / 24)
            OR
            collection_timestamp  >= strt_date
         )
     AND (  end_date between collection_timestamp AND
            DECODE(violation_duration, NULL, tgt_sysdate,collection_timestamp + violation_duration / 24)
            OR
            end_date >= DECODE(violation_duration, NULL, tgt_sysdate,collection_timestamp + violation_duration / 24)
         )
    AND violation_level = MGMT_GLOBAL.G_SEVERITY_CRITICAL
  ORDER by collection_timestamp;

-- This cursor will split all records into business
-- and non-business_records.


CURSOR sla_cursor (strt_coll_time in DATE,
                   end_coll_time in DATE,l_clockin in number ,
                   l_clockout in number )
IS
   SELECT greatest(strt_coll_time, trunc (strt_coll_time) + l_clockin/24 + r),
          least(trunc(strt_coll_time)+ r + l_clockout/24, end_coll_time)
     FROM DUAL,
          (SELECT rownum - 1 r
             FROM all_objects
            WHERE ROWNUM <= trunc(end_coll_time) - trunc(strt_coll_time) + 1
          );
BEGIN
l_format := 'MM-DD-YYYY HH24:MI:SS';
PROC_NAME := 'get_sl_history';

  -- Check whether Target guid is that of a Service
  validate_is_service(v_target_guid);

  SELECT timezone_region
    INTO l_tgt_timezone
    FROM MGMT_TARGETS
   WHERE target_guid=v_target_guid;

  l_orig_start_date := MGMT_GLOBAL.ADJUST_TZ(
             TO_DATE(v_start_date, l_format), 
             v_timezone,
             l_tgt_timezone);

  l_orig_end_date := MGMT_GLOBAL.ADJUST_TZ(
                TO_DATE(v_end_date, l_format), 
                v_timezone,
                l_tgt_timezone);

  l_tgt_sysdate := MGMT_GLOBAL.SYSDATE_TZRGN(l_tgt_timezone);

  l_start_date := GREATEST(l_orig_start_date, 
              get_avail_start_time(v_target_guid, l_tgt_sysdate));

  l_end_date := LEAST(l_orig_end_date, 
              get_avail_end_time(v_target_guid, l_tgt_sysdate));

  IF (emdw_log.p_is_debug_set)THEN
          emdw_log.debug('GUID: ' || v_target_guid, 
                          G_PKG_NAME || '.' || PROC_NAME);
          emdw_log.debug('Original: StartDate: ' ||
                          TO_CHAR(l_orig_start_date, l_format) ||
                         'EndDate: ' || TO_CHAR(l_orig_end_date, l_format),
                          G_PKG_NAME || '.' || PROC_NAME);
          emdw_log.debug('Computed: StartDate: ' || 
                          TO_CHAR(l_start_date, l_format) ||
                         'EndDate: ' || TO_CHAR(l_end_date, l_format), 
                          G_PKG_NAME || '.' || PROC_NAME);
  END IF;

    --This will take care of past and future dates
    --basically and dates where in em does not have data for the service
    --NULL checks take care of no records in mgmt_availability
    IF (l_start_date IS NULL OR l_end_date IS NULL 
        OR l_start_date >= l_end_date)
    THEN
      RETURN;
    END IF;
    

-- Intialize the Arrays
  sl_violations_arr_out        := violations_record_array();
  l_sl_violations_arr_out      := violations_record_array();
  sl_violtable_arr_out         := violations_record_array();
  l_sl_violtable_arr_out       := violations_record_array();
  l_new_sl_violations_arr_out  := violations_record_array();

  i := 0;
  j := 0;

-- Check to see if SL rule is defined..
 SELECT count(*) 
   INTO l_rule_count 
   FROM MGMT_SL_RULES 
  WHERE target_guid=v_target_guid;

IF l_rule_count = 1
THEN

-- Build Valid statuses
  l_exclude_statuses :=  build_status_string(v_target_guid,1);
  l_include_statuses :=  build_status_string(v_target_guid,2);

SELECT start_time, end_time
  INTO l_start_time, l_end_time
  FROM mgmt_sl_rules
 WHERE target_guid = v_target_guid;

l_clockin := TO_NUMBER(SUBSTR(l_start_time, 1, 2)) +
             TO_NUMBER(SUBSTR(l_start_time, 3, 2)) / 60;
l_clockout := TO_NUMBER(SUBSTR(l_end_time, 1, 2)) +
             TO_NUMBER(SUBSTR(l_end_time, 3, 2)) / 60;

l_non_business_days := '/' || build_non_businessdays(v_target_guid) || '/' ;

IF (emdw_log.p_is_debug_set)
THEN
   emdw_log.debug('SL Rule: StartTime: ' || l_start_time || 
                  ' EndTime: ' || l_end_time,
                  G_PKG_NAME || '.' || PROC_NAME);
END IF;

SELECT target_name 
  INTO l_target_name 
  FROM mgmt_targets
 WHERE target_guid = v_target_guid;

-- Only Slow times info . Slow times will be picked only from up times.
SELECT count(*) 
  INTO l_row_count 
  FROM mgmt_sl_metrics sl--, mgmt_metrics met
 WHERE sl.target_guid  = v_target_guid;
   --AND met.metric_guid = sl.metric_guid;

IF (l_row_count > 0  ) THEN

  open up_status_cursor (v_target_guid,l_start_date,
                         l_end_date, l_tgt_sysdate,
                         l_clockin,l_clockout);
  LOOP
    FETCH up_status_cursor
     INTO l_target_guid,l_severity_guid,
          l_start_collection_timestamp,
          l_end_collection_timestamp,l_current_status;
    EXIT WHEN up_status_cursor%NOTFOUND;

    OPEN violations_cursor (v_target_guid,l_start_collection_timestamp,
                    l_end_collection_timestamp,l_tgt_sysdate);
      LOOP
        FETCH violations_cursor
         INTO l_target_guid, l_severity_guid,
              l_metric_guid, l_viol_strt_coll_tstmp,
              l_viol_end_coll_tstmp,l_username,l_message;
        EXIT WHEN violations_cursor%NOTFOUND;

        OPEN sla_cursor (l_viol_strt_coll_tstmp,
                l_viol_end_coll_tstmp,l_clockin,l_clockout);
          LOOP
            FETCH sla_cursor
             INTO l_st_valid_time, l_end_valid_time;
            EXIT WHEN sla_cursor%NOTFOUND;
            IF (l_st_valid_time IS NOT NULL AND
                  instr(l_non_business_days ,'/'
                  || to_char(l_st_valid_time,'D') || '/' ) = 0 AND
                  l_st_valid_time < l_end_valid_time 
                )  
            THEN
              j := j+1;
              l_sl_violtable_arr_out.extend(1);
              IF l_message IS NULL
              THEN
                l_message := null;--'<PERFORMANCE_NLS_ID>';
              END IF;
              l_sl_violtable_arr_out(j) :=
              violations_record(v_target_guid,l_target_name,
                l_st_valid_time, l_end_valid_time,
                G_SLOW_STATUS,'System',  l_message, l_severity_guid);

-- Logic for merging slow records..
-- This logic is reproduced from an earlier procedure get_severity_duration..
              IF (j =1 ) THEN
                i := i+1;
                l_sl_violations_arr_out.extend(1);
                l_sl_violations_arr_out(i) := l_sl_violtable_arr_out(j);
                greatest_slow_rec := sla_sev_rec (l_st_valid_time,
                  l_end_valid_time);

              ELSE
              IF (l_end_valid_time > greatest_slow_rec.sev_end_time)
              THEN
                start_time := greatest(greatest_slow_rec.sev_end_time,
                   l_st_valid_time);
                end_time  := l_end_valid_time;
                greatest_slow_rec := sla_sev_rec(start_time,end_time);
                i := i+1;
                l_sl_violations_arr_out.extend(1);
                l_sl_violations_arr_out(i) :=
                  violations_record(v_target_guid,l_target_name,
                  start_time, end_time,
                  G_SLOW_STATUS,'System',  l_message, l_severity_guid);
              END IF;
            END IF;
        
           END IF;
          END LOOP;
       CLOSE sla_cursor;
     END LOOP; -- Violations cursor loop
    close violations_cursor;
  END LOOP;
  CLOSE up_status_cursor;

  l_first_time := 1;
  open up_status_cursor (v_target_guid,l_start_date,
                         l_end_date, l_tgt_sysdate,
                         l_clockin,l_clockout);
  LOOP
    FETCH up_status_cursor
     INTO l_target_guid,l_severity_guid,
          l_start_collection_timestamp,
          l_end_collection_timestamp,l_current_status;
    EXIT WHEN up_status_cursor%NOTFOUND;

    OPEN bus_violations_cursor (v_target_guid,l_start_collection_timestamp,
                    l_end_collection_timestamp,l_tgt_sysdate);
      LOOP
        FETCH bus_violations_cursor
         INTO l_target_guid, l_severity_guid,
              l_metric_guid, l_viol_strt_coll_tstmp,
              l_viol_end_coll_tstmp,l_username,l_message;
        EXIT WHEN bus_violations_cursor%NOTFOUND;

        OPEN sla_cursor (l_viol_strt_coll_tstmp,
                l_viol_end_coll_tstmp,l_clockin,l_clockout);
          LOOP
            FETCH sla_cursor
             INTO l_st_valid_time, l_end_valid_time;
            EXIT WHEN sla_cursor%NOTFOUND;
            IF (l_st_valid_time IS NOT NULL AND
                  instr(l_non_business_days ,'/'
                  || to_char(l_st_valid_time,'D') || '/' ) = 0 AND
                  l_st_valid_time < l_end_valid_time 
                )  
            THEN
              LOOP
                IF l_splitted_bus_rec IS NOT NULL THEN
                  l_bus_rec := l_splitted_bus_rec;
                  l_splitted_bus_rec := NULL;
                ELSE
                  l_bus_rec := violations_record(
                                v_target_guid, l_target_name, l_st_valid_time, 
                                l_end_valid_time, G_BUS_ISSUE_STATUS, 'System',
                                l_message, l_severity_guid);
                END IF;
                truncate_performance_hours(l_sl_violations_arr_out, l_bus_rec, 
                         l_modified_bus_rec, l_splitted_bus_rec);

                IF l_modified_bus_rec IS NOT NULL THEN
                  l_st_valid_time := l_modified_bus_rec.start_time;
                  l_end_valid_time := l_modified_bus_rec.end_time;

                  j := j + 1;
                  l_sl_violtable_arr_out.extend(1);
                  l_sl_violtable_arr_out(j) := l_modified_bus_rec;
  
                  -- Logic for merging business issue records..
                  -- This logic is reproduced from an earlier procedure get_severity_duration..
                  IF (l_first_time = 1) THEN
                    l_first_time := 0;
                    i := i + 1;
                    l_sl_violations_arr_out.extend(1);
                    l_sl_violations_arr_out(i) := l_sl_violtable_arr_out(j);
                    greatest_slow_rec := sla_sev_rec (l_st_valid_time, l_end_valid_time);
                  ELSE
                    IF (l_end_valid_time > greatest_slow_rec.sev_end_time) THEN
                      start_time := greatest(greatest_slow_rec.sev_end_time, l_st_valid_time);
                      end_time  := l_end_valid_time;
                      greatest_slow_rec := sla_sev_rec(start_time,end_time);
                      i := i + 1;
                      l_sl_violations_arr_out.extend(1);
                      l_sl_violations_arr_out(i) := violations_record(v_target_guid, l_target_name,
                        start_time, end_time, G_BUS_ISSUE_STATUS, 'System', l_message, l_severity_guid);
                    END IF;
                  END IF;
                END IF;
                EXIT WHEN l_splitted_bus_rec IS NULL;
              END LOOP;
            END IF;
          END LOOP;
       CLOSE sla_cursor;
     END LOOP; -- Business Violations cursor loop
    close bus_violations_cursor;
  END LOOP;
  CLOSE up_status_cursor;
 END IF;

-- Down times.
 
  l_message := null;--'<AVAILABILITY_NLS_ID>';
  open down_cursor (v_target_guid,l_start_date,
                    l_end_date, l_tgt_sysdate, l_clockin,l_clockout,
                    l_exclude_statuses);
  LOOP
    FETCH down_cursor INTO l_target_guid,l_severity_guid,
        l_outage_type,l_start_collection_timestamp,
        l_end_collection_timestamp,l_current_status;

    EXIT WHEN down_cursor%NOTFOUND;
    open sla_cursor (l_start_collection_timestamp,l_end_collection_timestamp,
                   l_clockin,l_clockout);
    LOOP
         FETCH sla_cursor INTO l_st_valid_time, l_end_valid_time;
         EXIT WHEN sla_cursor%NOTFOUND;
         IF (l_st_valid_time IS NOT NULL AND
           instr(l_non_business_days ,'/'
           || to_char(l_st_valid_time,'D') || '/' ) = 0 AND
           l_st_valid_time < l_end_valid_time )
         THEN
           i := i+1;
           l_sl_violations_arr_out.extend(1);
           l_sl_violations_arr_out(i) :=
           violations_record(v_target_guid,l_target_name,
                             l_st_valid_time, l_end_valid_time,
                             l_outage_type,'System',
                             l_message, l_severity_guid);
           
           IF (l_outage_type = 0 --for Availability and Performance
               OR l_outage_type = 5 --Blackout
               OR l_outage_type = 2 --Unkown
               OR l_outage_type = 3 --Unkown 
               OR l_outage_type = 4 --Unkown 
               OR l_outage_type = 6 --Unkown
          ) THEN
                 j := j+1;
                 l_sl_violtable_arr_out.extend(1);
                 l_sl_violtable_arr_out(j) :=
                 violations_record(v_target_guid,l_target_name,
                    l_st_valid_time, l_end_valid_time,
                     l_outage_type,'System',  l_message, l_severity_guid);
	  END IF;
         END IF;
     END LOOP;
    CLOSE sla_cursor;
   END LOOP;
   CLOSE down_cursor;

-- Weekend and non business hours
-- We will replace this into a function..
For j in 0..(trunc(l_end_date ) - trunc(l_start_date))
LOOP
   l_curr_date := trunc(l_start_date) + j;
   IF ( instr(l_non_business_days,'/' ||
        to_char(l_curr_date, 'D') || '/' )  > 0 )
   THEN
    i:= i + 1;
    l_wkend_start := greatest(l_start_date,l_curr_date);
    l_sl_violations_arr_out.extend(1);
    l_sl_violations_arr_out(i) :=
      violations_record(v_target_guid,l_target_name,l_wkend_start,
      least(l_end_date,trunc(l_wkend_start) +1) ,G_NON_BUSINESS_STATUS,
      'System','wkend',NULL);
   ELSE
    IF (trunc(l_curr_date) = trunc(l_end_date) )
    THEN

-- Weekend status set to 12

       IF ( l_end_date != l_curr_date AND l_clockin != 0
           AND greatest(l_curr_date,l_start_date) < 
          least(l_end_date,trunc(l_curr_date) + l_clockin/24)
        ) THEN
         i := i+1 ;
         l_sl_violations_arr_out.extend(1);
         l_sl_violations_arr_out(i) :=
         violations_record(v_target_guid,l_target_name,
       greatest(l_curr_date,l_start_date),
       least(l_end_date,trunc(l_curr_date) + l_clockin/24)
       ,G_NON_BUSINESS_STATUS,'System','non-buss hrs',NULL);
      END IF;

      IF ( l_end_date > l_curr_date + l_clockout/24  AND 
           l_clockout != 24)
       THEN
       i := i+1 ;
       l_sl_violations_arr_out.extend(1);
       l_sl_violations_arr_out(i) :=
         violations_record(v_target_guid,l_target_name,
         greatest(l_start_date,trunc(l_curr_date) + l_clockout/24) ,
         least(l_end_date,trunc(l_curr_date) + 1)
         ,G_NON_BUSINESS_STATUS,'System','non-buss hrs',NULL);
       END IF;

    END IF;

    IF (trunc(l_curr_date) = trunc(l_start_date) AND 
         trunc(l_curr_date) != trunc(l_end_date))
      THEN
                           
        IF ( l_start_date <= trunc(l_curr_date) + l_clockin/24  AND
             l_clockin != 0 )
        THEN
        i := i+1 ;
        l_sl_violations_arr_out.extend(1);
        l_sl_violations_arr_out(i) :=
          violations_record(v_target_guid,l_target_name,
          greatest(l_start_date,l_curr_date) ,greatest(l_start_date,
          trunc(l_curr_date) + l_clockin/24) ,G_NON_BUSINESS_STATUS,
          'System','non-buss hrs',NULL);
       END IF;
 
        IF (l_clockout != 24) THEN
        i := i+1 ;
        l_sl_violations_arr_out.extend(1);
        l_sl_violations_arr_out(i) :=
          violations_record(v_target_guid,l_target_name,
          greatest(trunc(l_curr_date) + l_clockout/24,l_start_date) ,
          least(trunc(l_curr_date) + 1,l_end_date) ,
          G_NON_BUSINESS_STATUS, 'System','non-buss hrs',NULL);
        END IF;

       END IF;


      IF ( trunc(l_curr_date) != trunc(l_start_date) AND
         trunc(l_curr_date) != trunc(l_end_date) )
      THEN
       IF (l_clockin != 0 ) THEN
       i := i+1 ;
       l_sl_violations_arr_out.extend(1);
       l_sl_violations_arr_out(i) :=
           violations_record(v_target_guid,l_target_name,l_curr_date,
           trunc(l_curr_date) + l_clockin/24
           ,G_NON_BUSINESS_STATUS,'System','non-buss hrs',NULL);
       END IF;


       IF (l_clockout != 24) THEN
       i := i+1 ;
       l_sl_violations_arr_out.extend(1);
       l_sl_violations_arr_out(i) :=
         violations_record(v_target_guid,l_target_name,
           trunc(l_curr_date) + l_clockout/24,
           trunc(l_curr_date) + 1 ,G_NON_BUSINESS_STATUS,'System',
           'non-buss2 hrs',NULL);
       END IF;
      END IF;
     END IF;

END LOOP;



-- To sort through the l_sl_violations_arr_out
l_count := 0;
--l_rec := violations_record();
FOR l_rec IN
 (SELECT *
    FROM TABLE(CAST(l_sl_violations_arr_out AS violations_record_array))
   WHERE start_time IS NOT NULL
ORDER BY start_time)
LOOP
--Below IF condition is added to avoid same start_time/end_time issue
--which happens in very rare cases
IF ( l_rec.start_time != l_rec.end_time )
THEN
 l_new_sl_violations_arr_out.extend(1);
 l_count := l_count +1;
  l_new_sl_violations_arr_out(l_count) :=
    violations_record (l_rec.svc_guid,l_rec.target_name,
      l_rec.start_time,
      l_rec.end_time,
      l_rec.outage_type,
      l_rec.user_name,l_rec.message,l_rec.severity_guid);
END IF;
END LOOP;

-- To sort through the l_sl_violtable_arr_out
l_count := 0;
FOR l_rec IN
 (SELECT *
    FROM TABLE(CAST(l_sl_violtable_arr_out AS violations_record_array))
   WHERE start_time IS NOT NULL
ORDER BY start_time)
LOOP
--Below IF condition is added to avoid same start_time/end_time issue
--which happens in very rare cases
IF ( l_rec.start_time != l_rec.end_time )
THEN
 sl_violtable_arr_out.extend(1);
 l_count := l_count +1;
 sl_violtable_arr_out(l_count) :=
    violations_record (l_rec.svc_guid,l_rec.target_name,
      MGMT_GLOBAL.ADJUST_TZ(l_rec.start_time,l_tgt_timezone,v_timezone),
      MGMT_GLOBAL.ADJUST_TZ(l_rec.end_time,l_tgt_timezone,v_timezone),
      l_rec.outage_type,
      l_rec.user_name,l_rec.message,l_rec.severity_guid);
END IF;
END LOOP;
END IF; --IF l_rule_count = 1

IF l_new_sl_violations_arr_out.COUNT = 0
THEN
    --Either the sl rule is not set or no violations
    --Setting Up for the whole period
    i := i + 1 ;
    l_new_sl_violations_arr_out.extend(1);
    l_new_sl_violations_arr_out(i) :=
      violations_record (v_target_guid,l_target_name,
      l_start_date, l_end_date,
      G_UP_STATUS, 'Sytem', 'UP', NULL);
END IF;

IF (l_new_sl_violations_arr_out(l_new_sl_violations_arr_out.LAST).end_time 
      <  l_end_date)
THEN
     i := i +1 ;
     l_new_sl_violations_arr_out.extend(1);
     l_new_sl_violations_arr_out(i) := 
      violations_record (v_target_guid,l_target_name,
      l_new_sl_violations_arr_out(i-1).end_time,
      l_end_date,
      G_UP_STATUS , 'Sytem', 'UP',
     l_new_sl_violations_arr_out(i-1).severity_guid);
END IF;

--Decision taken on 8th March 2004 that
--service level cigar should show no data also
IF (l_end_date < l_orig_end_date)
THEN
  i := i + 1 ;
  l_new_sl_violations_arr_out.extend(1);
  l_new_sl_violations_arr_out(i) :=
      violations_record (v_target_guid, l_target_name,
                         l_end_date, l_orig_end_date, G_NO_DATA_STATUS,
                         'System', 'No Data', NULL);
END IF;

-- Get another temporary array and update the array with uptimes for
-- all times which are not slow and
-- Down and nonbusiness_array
-- Up status is set to 1  as from the current_status code in mgmt_availability 
l_count := 0;
l_new_count := 0;

-- Adding the first record. 
--Decision taken on 8th March 2004 that
--service level cigar should show no data also
IF (l_start_date > l_orig_start_date)
THEN
  l_new_count := l_new_count+1 ;
  sl_violations_arr_out.extend(1);
  sl_violations_arr_out(l_new_count) :=
      violations_record (v_target_guid, l_target_name,
                         MGMT_GLOBAL.ADJUST_TZ(l_orig_start_date, l_tgt_timezone, v_timezone),
                         MGMT_GLOBAL.ADJUST_TZ(l_start_date, l_tgt_timezone, v_timezone),
                         G_NO_DATA_STATUS, 'System', 'No Data', NULL);
END IF;
IF (l_new_sl_violations_arr_out(l_new_sl_violations_arr_out.FIRST).start_time 
        > l_start_date )
THEN
     l_new_count := l_new_count+1 ;
     sl_violations_arr_out.extend(1);
     sl_violations_arr_out(l_new_count) :=
     violations_record (v_target_guid,l_target_name,
     MGMT_GLOBAL.ADJUST_TZ(l_start_date, l_tgt_timezone, v_timezone),
     MGMT_GLOBAL.ADJUST_TZ(l_new_sl_violations_arr_out(
                 l_new_sl_violations_arr_out.FIRST).start_time,
                 l_tgt_timezone, v_timezone),
     G_UP_STATUS , 'Sytem', 'UP',
     l_new_sl_violations_arr_out(
            l_new_sl_violations_arr_out.FIRST).severity_guid);
END IF;

FOR l_count in l_new_sl_violations_arr_out.FIRST ..
               l_new_sl_violations_arr_out.LAST
LOOP
  IF (l_count > l_new_sl_violations_arr_out.FIRST AND
      l_new_sl_violations_arr_out(l_count).start_time !=
      l_new_sl_violations_arr_out(l_count-1).end_time AND
      l_new_sl_violations_arr_out(l_count).start_time !=
      l_new_sl_violations_arr_out(l_count-1).start_time AND
      l_new_sl_violations_arr_out(l_count).start_time >
      l_new_sl_violations_arr_out(l_count-1).end_time)
   THEN
     l_new_count := l_new_count+1 ;
     sl_violations_arr_out.extend(1);
     sl_violations_arr_out(l_new_count) :=
      violations_record (v_target_guid,l_target_name,
      MGMT_GLOBAL.ADJUST_TZ(l_new_sl_violations_arr_out(l_count -1).end_time,
              l_tgt_timezone, v_timezone),
      MGMT_GLOBAL.ADJUST_TZ(l_new_sl_violations_arr_out(l_count).start_time,
              l_tgt_timezone, v_timezone),
      G_UP_STATUS , 'Sytem', 'UP', 
      l_new_sl_violations_arr_out(l_count).severity_guid);
    END IF;



   l_new_count := l_new_count +1 ;
   sl_violations_arr_out.extend(1);
   sl_violations_arr_out(l_new_count) :=
     violations_record (v_target_guid,l_target_name,
      MGMT_GLOBAL.ADJUST_TZ(l_new_sl_violations_arr_out(l_count).start_time,
            l_tgt_timezone, v_timezone),
      MGMT_GLOBAL.ADJUST_TZ(l_new_sl_violations_arr_out(l_count).end_time, 
            l_tgt_timezone, v_timezone),
      l_new_sl_violations_arr_out(l_count).outage_type,
      l_new_sl_violations_arr_out(l_count).user_name,
      l_new_sl_violations_arr_out(l_count).message,
      l_new_sl_violations_arr_out(l_count).severity_guid);

END LOOP;
END get_sl_history;

--This procedure is used by ASLM reports team
PROCEDURE get_metric_data(p_target_guid IN VARCHAR2,
                          p_metric_guid IN VARCHAR2,
                          v_key_value IN VARCHAR2,
                          v_start_date IN VARCHAR2,
                          v_end_date IN VARCHAR2,
                          v_timezone IN VARCHAR2,
                          v_warning_operator OUT NUMBER,
                          v_critical_operator OUT NUMBER,
                          v_warning_threshold OUT VARCHAR2,
                          v_critical_threshold OUT VARCHAR2,
                          v_metric_data_cur OUT CURSORTYPE,
                          v_downtime_cur OUT CURSORTYPE)

IS
l_start_date DATE;
l_end_date DATE;
l_diff NUMBER;
l_row_count NUMBER;
--l_transposed NUMBER;
l_tgt_timezone MGMT_TARGETS.timezone_region%TYPE;
l_tgt_sysdate DATE;
--- Fix for performance issue in metrics page. 
--- Indexes on mgmt_metrics dont work if we dont
--- pass RAW type in the query.
v_target_guid mgmt_targets.target_guid%TYPE;
v_metric_guid mgmt_metrics.metric_guid%TYPE;
BEGIN

  v_target_guid := HEXTORAW(p_target_guid);
  v_metric_guid := HEXTORAW(p_metric_guid);
  -- Check whether Target guid is that of a Service
  validate_is_service(v_target_guid);

  SELECT timezone_region
    INTO l_tgt_timezone
    FROM MGMT_TARGETS
   WHERE target_guid=v_target_guid;

  l_start_date := MGMT_GLOBAL.ADJUST_TZ(
             TO_DATE(v_start_date, 'MM-DD-YYYY HH24:MI:SS'), 
             v_timezone, l_tgt_timezone);

  l_end_date := MGMT_GLOBAL.ADJUST_TZ(
                TO_DATE(v_end_date, 'MM-DD-YYYY HH24:MI:SS'), 
                v_timezone, l_tgt_timezone);

  l_tgt_sysdate := MGMT_GLOBAL.SYSDATE_TZRGN(l_tgt_timezone);
 l_diff := l_end_date - l_start_date;
 --Find whether the metric is a transposed metric
 --l_transposed := get_is_transposed(v_target_guid, v_metric_guid);

 IF (l_diff <= 1) THEN

   OPEN v_metric_data_cur FOR
   SELECT MGMT_GLOBAL.ADJUST_TZ(collection_timestamp,l_tgt_timezone,v_timezone),
          value
     FROM mgmt_metrics_raw
    WHERE target_guid=v_target_guid
      AND metric_guid=v_metric_guid
      AND key_value=v_key_value
      AND collection_timestamp BETWEEN l_start_date AND l_end_date;

 ELSIF (l_diff <= 15) THEN


   OPEN v_metric_data_cur FOR
   SELECT MGMT_GLOBAL.ADJUST_TZ(rollup_timestamp,l_tgt_timezone,v_timezone),
          value_average
     from mgmt_metrics_1hour
    WHERE target_guid=v_target_guid
      AND metric_guid=v_metric_guid
      AND key_value=v_key_value
      AND rollup_timestamp BETWEEN l_start_date AND l_end_date;


  ELSE


     OPEN v_metric_data_cur FOR
     SELECT MGMT_GLOBAL.ADJUST_TZ(rollup_timestamp,l_tgt_timezone,v_timezone),
            value_average
       from mgmt_metrics_1day
      WHERE target_guid=v_target_guid
        AND metric_guid=v_metric_guid
        AND key_value=v_key_value
        AND rollup_timestamp BETWEEN l_start_date AND l_end_date;


  END IF;


   SELECT COUNT(*)
     INTO l_row_count
     FROM mgmt_metric_thresholds
    WHERE target_guid=v_target_guid
      AND metric_guid=v_metric_guid
      AND key_value=v_key_value;


  IF (l_row_count = 1) THEN

     SELECT warning_operator, warning_threshold,
            critical_operator, critical_threshold
       INTO v_warning_operator, v_warning_threshold,
            v_critical_operator,v_critical_threshold
       FROM mgmt_metric_thresholds
      where target_guid=v_target_guid
        AND key_value=v_key_value
        AND metric_guid=v_metric_guid;

  END IF;

  OPEN v_downtime_cur FOR
  SELECT MGMT_GLOBAL.ADJUST_TZ(greatest(l_start_date, start_collection_timestamp),
            l_tgt_timezone,v_timezone),
         MGMT_GLOBAL.ADJUST_TZ(least(NVL(end_collection_timestamp, l_tgt_sysdate),
            l_end_date),l_tgt_timezone,v_timezone)
    FROM mgmt_availability
   WHERE current_status = MGMT_GLOBAL.G_STATUS_DOWN
     AND target_guid=v_target_guid
     AND (  start_collection_timestamp BETWEEN l_start_date AND l_end_date
            OR
            NVL(end_collection_timestamp, l_tgt_sysdate) BETWEEN
            l_start_date AND l_end_date
            OR
            (  start_collection_timestamp < l_start_date
               AND
               NVL(end_collection_timestamp, l_tgt_sysdate) > l_end_date
            )
         );

END get_metric_data;



PROCEDURE get_alert_data(p_target_guid IN VARCHAR2,
                         v_start_date IN VARCHAR2,
                         v_end_date IN VARCHAR2,
                         v_timezone IN VARCHAR2,
                         v_alert_data_cur OUT CURSORTYPE)

IS
l_start_date DATE;
l_end_date DATE;
l_tgt_sysdate DATE;
l_tgt_timezone VARCHAR2(64);
l_null_date DATE;
l_null_number NUMBER;
--- performance fix for charts page.
v_target_guid mgmt_targets.target_guid%TYPE;
BEGIN

--- Fix for performance issue in metrics page. 
--- Indexes on tables dont work if we dont
--- pass RAW type in the query.
   v_target_guid := HEXTORAW(p_target_guid);

  -- Check whether Target guid is that of a Service
  validate_is_service(v_target_guid);

  -- Convert the start and end date to target time zone.
  SELECT timezone_region
    INTO l_tgt_timezone
    FROM MGMT_TARGETS
   WHERE target_guid=v_target_guid;

  

  l_start_date := MGMT_GLOBAL.ADJUST_TZ(
                TO_DATE(v_start_date, 'MM-DD-YYYY HH24:MI:SS'),
                    v_timezone, l_tgt_timezone);

  --dbms_output.put_line('l_start_date: ' || TO_CHAR(l_start_date, 'MM-DD-YYYY HH24:MI:SS'));

  l_end_date := MGMT_GLOBAL.ADJUST_TZ(
                TO_DATE(v_end_date, 'MM-DD-YYYY HH24:MI:SS'),
                    v_timezone, l_tgt_timezone);

  --dbms_output.put_line('l_end_date: ' || TO_CHAR(l_end_date, 'MM-DD-YYYY HH24:MI:SS'));

  l_tgt_sysdate := MGMT_GLOBAL.SYSDATE_TZRGN(l_tgt_timezone);

--dbms_output.put_line('l_end_date: ' || TO_CHAR(l_end_date, 'MM-DD-YYYY HH24:MI:SS'));
  OPEN v_alert_data_cur FOR
  SELECT MGMT_GLOBAL.ADJUST_TZ(viol.collection_timestamp, l_tgt_timezone, 
                               v_timezone) start_date,
         DECODE(viol.violation_duration, NULL, l_null_date,
            MGMT_GLOBAL.ADJUST_TZ(viol.collection_timestamp + viol.violation_duration/24,
            l_tgt_timezone, v_timezone)) end_date,
         DECODE(viol.violation_duration, NULL, l_null_number, viol.violation_duration/24) 
             duration,
         viol.violation_level status, viol.violation_guid, map.category_name, tgt.target_type,
         DECODE(met.is_transposed, 1, viol.key_value, met.column_label),
         DECODE(met.is_transposed, 1, NULL, met.column_label_nlsid),
         DECODE(met.is_transposed, 1, NULL, met.short_name),
         DECODE(met.is_transposed, 1, NULL, met.short_name_nlsid),
         DECODE(met.is_transposed, 1, NULL,
            DECODE(met.num_keys, 0, NULL,
               DECODE(met.num_keys, 1, viol.key_value, get_key_part_values(viol.key_value))))
    FROM mgmt_violations viol, mgmt_category_map map,
         mgmt_targets tgt, mgmt_metrics met
   WHERE viol.target_guid=v_target_guid
     AND tgt.target_guid = viol.target_guid
     AND met.metric_guid = viol.policy_guid
     AND met.target_type = tgt.target_type
     AND met.type_meta_ver = tgt.type_meta_ver
     AND ( met.CATEGORY_PROP_1 = tgt.CATEGORY_PROP_1
             OR met.category_prop_1 = ' ' )
     AND ( met.CATEGORY_PROP_2 = tgt.CATEGORY_PROP_2
             OR met.category_prop_2 = ' ' )
     AND ( met.CATEGORY_PROP_3 = tgt.CATEGORY_PROP_3
             OR met.category_prop_3 = ' ' )
     AND ( met.CATEGORY_PROP_4 = tgt.CATEGORY_PROP_4
             OR met.category_prop_4 = ' ' )
     AND ( met.CATEGORY_PROP_5 = tgt.CATEGORY_PROP_5
             OR met.category_prop_5 = ' ' )
     AND violation_level = MGMT_GLOBAL.G_SEVERITY_CRITICAL
    AND (  l_start_date BETWEEN collection_timestamp AND
           DECODE(violation_duration, NULL, l_tgt_sysdate,
               collection_timestamp + violation_duration / 24)
           OR
           collection_timestamp  >= l_start_date
        )
    AND (  l_end_date BETWEEN collection_timestamp   AND
           DECODE(violation_duration, NULL, l_tgt_sysdate,
               collection_timestamp + violation_duration / 24)
           OR
           l_end_date >= DECODE(violation_duration, NULL, l_tgt_sysdate,
               collection_timestamp + violation_duration / 24)
        )
    --AND violation_duration != 0
    AND policy_guid = map.object_guid
    AND map.class_name = mgmt_global.G_CATEGORY_CLASS_SERVICE
    AND map.type_meta_ver  = tgt.type_meta_ver
  UNION 
 SELECT MGMT_GLOBAL.ADJUST_TZ(start_collection_timestamp,
              l_tgt_timezone, v_timezone) start_date,
        DECODE(end_collection_timestamp, NULL, l_null_date,
              MGMT_GLOBAL.ADJUST_TZ(end_collection_timestamp,
                 l_tgt_timezone, v_timezone)) end_date,
        DECODE(end_collection_timestamp, NULL, l_null_number,
              (end_collection_timestamp - start_collection_timestamp)) duration,
        current_status status, severity_guid, 'Availability',
        NULL, NULL, NULL, NULL, NULL, NULL
   FROM mgmt_availability
  WHERE current_status = MGMT_GLOBAL.G_STATUS_DOWN
    AND target_guid=v_target_guid
    AND (  l_start_date BETWEEN start_collection_timestamp AND
           NVL(end_collection_timestamp,
                MGMT_GLOBAL.SYSDATE_TZRGN(l_tgt_timezone))
           OR
           start_collection_timestamp  >= l_start_date
        )
    AND (  l_end_date BETWEEN start_collection_timestamp   AND
           NVL(end_collection_timestamp ,
                MGMT_GLOBAL.SYSDATE_TZRGN(l_tgt_timezone))
           OR
           l_end_date >= NVL(end_collection_timestamp , 
                        MGMT_GLOBAL.SYSDATE_TZRGN(l_tgt_timezone))
        );

END get_alert_data;

FUNCTION get_key_part_values(l_key_value mgmt_violations.key_value%TYPE)
RETURN VARCHAR2
IS
l_key_part_values VARCHAR2(512);
BEGIN
      SELECT mck.key_part1_value || G_SEPARATOR || mck.key_part2_value
                || DECODE(mck.key_part3_value, NULL, NULL,
                           G_SEPARATOR || mck.key_part3_value)
                || DECODE(mck.key_part4_value, NULL, NULL, 
                              G_SEPARATOR || mck.key_part4_value)
                || DECODE(mck.key_part5_value, NULL, NULL, 
                         G_SEPARATOR || mck.key_part5_value) key_part_values
        INTO l_key_part_values
        FROM mgmt_metrics_composite_keys mck
       WHERE l_key_value = mck.composite_key;

      RETURN l_key_part_values;
   EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
         RETURN NULL;
END get_key_part_values;
/*
FUNCTION get_label_for_metric(v_target_guid IN MGMT_TARGETS.target_guid%TYPE,
                         v_metric_guid IN MGMT_METRICS.metric_guid%TYPE,
                         v_key_value IN VARCHAR2)
RETURN VARCHAR2
IS
  l_transposed NUMBER;
  l_label mgmt_metrics.column_label%TYPE;
BEGIN
  l_transposed := get_is_transposed(v_target_guid, v_metric_guid);
  IF l_transposed = 1
  THEN
    RETURN v_key_value;
  ELSE
    SELECT column_label INTO l_label
    FROM mgmt_targets tgt, mgmt_metrics met
    WHERE tgt.target_guid = v_target_guid
      AND tgt.type_meta_ver = met.type_meta_ver
      AND tgt.target_type = met.target_type
      AND met.metric_guid = v_metric_guid
      AND ( met.CATEGORY_PROP_1 = tgt.CATEGORY_PROP_1
              OR met.category_prop_1 = ' ' )
      AND ( met.CATEGORY_PROP_2 = tgt.CATEGORY_PROP_2
              OR met.category_prop_2 = ' ' )
      AND ( met.CATEGORY_PROP_3 = tgt.CATEGORY_PROP_3
              OR met.category_prop_3 = ' ' )
      AND ( met.CATEGORY_PROP_4 = tgt.CATEGORY_PROP_4
              OR met.category_prop_4 = ' ' )
      AND ( met.CATEGORY_PROP_5 = tgt.CATEGORY_PROP_5
              OR met.category_prop_5 = ' ' );
  END IF;
  RETURN l_label;
END;
*/

PROCEDURE update_ip_target_add(
         p_target_name in MGMT_TARGETS.target_name%TYPE,
         p_target_type in MGMT_TARGETS.target_type%TYPE,
         p_target_guid in MGMT_TARGETS.target_guid%TYPE
)
IS
PROC_NAME VARCHAR2(20) := 'update_ip_target_add';
l_count NUMBER;
l_report_guid MGMT_IP_REPORT_DEF.report_guid%TYPE;
BEGIN
   IF (emdw_log.p_is_debug_set)THEN
      emdw_log.info('update_ip_target_add:Entry p_target_name='|| p_target_name ||
                    ' , p_target_type='|| p_target_type ||
                    ' , p_target_guid='|| p_target_guid, G_PKG_NAME || '.' || PROC_NAME);
    END IF;

   SELECT count(*) INTO l_count
    FROM
          mgmt_targets tgt,    mgmt_type_properties typ
    WHERE
          tgt.target_guid    = p_target_guid
      AND tgt.target_type    = typ.target_type
      AND typ.property_name  = MGMT_GLOBAL.G_IS_SERVICE_PROP
      AND typ.property_value = 1;

   IF l_count = 0
   THEN
      RETURN;
   END IF;

-- Bind this target_type onto  service dashboard reports type.
   BEGIN
      MGMT_IP.update_element_type(G_DASHBOARD_ELEMENT_TYPE,p_target_type,
                                 TRUE);

   EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN NULL;
      --WHEN OTHERS THEN NULL;
   END;
 
-- Bind this target onto service dashboard out of the box report

   BEGIN
     SELECT report_guid INTO l_report_guid 
       FROM MGMT_IP_REPORT_DEF 
        WHERE title_nlsid = G_DASHBOARD_TITLE
          AND owner       = G_DASHBOARD_REPORT_OWNER
          AND system_report = 1;

       MGMT_IP.update_late_binding_tgt_type (l_report_guid,
                      p_target_type,TRUE); 
      

   EXCEPTION
-- We will ignore the data_not found and DUP_VAL_ON_INDEX 
      WHEN DUP_VAL_ON_INDEX THEN NULL;
      WHEN NO_DATA_FOUND THEN NULL;
   END;

END update_ip_target_add;

PROCEDURE update_ip_target_delete(
         p_target_name in MGMT_TARGETS.target_name%TYPE,
         p_target_type in MGMT_TARGETS.target_type%TYPE,
         p_target_guid in MGMT_TARGETS.target_guid%TYPE
)
IS
PROC_NAME VARCHAR2(25) := 'update_ip_target_delete';
l_count NUMBER;
l_target_count NUMBER;
l_value VARCHAR2(4000);
l_new_value VARCHAR2(4000);
l_combo VARCHAR2(321);
l_update BOOLEAN;
l_name mgmt_targets.target_name%TYPE;
l_type mgmt_targets.target_type%TYPE;
l_report_guid MGMT_IP_REPORT_DEF.report_guid%TYPE;
CURSOR svc_val_cursor
IS
   SELECT params.report_guid, params.element_guid,
          params.param, params.value
     FROM MGMT_IP_REPORT_ELEM_PARAMS params,
          MGMT_IP_REPORT_DEF_ELEMENTS elems
    WHERE params.report_guid = elems.report_guid
      AND params.element_guid = elems.element_guid
      AND elems.ELEMENT_TYPE_NLSID = 'SVC_DASH_SERVICE_TYPE'
      AND elems.ELEMENT_NAME_NLSID IN
          ('dashboard_service_status', 'servicelevel_table',
           'service_dashboard', 'Violations_table')
      AND params.param = 'delimitedServiceCombo';
          
BEGIN
   IF (emdw_log.p_is_debug_set)THEN
      emdw_log.info('update_ip_target_delete:Entry p_target_name='|| p_target_name ||
                    ' , p_target_type='|| p_target_type ||
                    ' , p_target_guid='|| p_target_guid, G_PKG_NAME || '.' || PROC_NAME);
    END IF;

   SELECT count(*) INTO l_count
    FROM
          mgmt_targets tgt,    mgmt_type_properties typ
    WHERE
          tgt.target_guid    = p_target_guid
      AND tgt.target_type    = typ.target_type
      AND typ.property_name  = MGMT_GLOBAL.G_IS_SERVICE_PROP
      AND typ.property_value = 1;

   IF l_count = 0
   THEN
      RETURN;
   END IF;

   SELECT count(*) INTO l_target_count
     FROM mgmt_targets
    WHERE target_type = p_target_type;

   IF (l_target_count = 1) THEN
     BEGIN
      -- Means no other target for the same type is left
      -- remember this is a pre_delete_target_call_back
         MGMT_IP.update_element_type('SVC_DASH_SERVICE_TYPE',p_target_type,
                                     FALSE);

         EXCEPTION 
             WHEN DUP_VAL_ON_INDEX THEN NULL;
             WHEN NO_DATA_FOUND THEN NULL;
     END;
    --- Delete this target type for report level params as well
     BEGIN

       SELECT report_guid INTO l_report_guid
         FROM MGMT_IP_REPORT_DEF
        WHERE title_nlsid = G_DASHBOARD_TITLE
          AND owner       = G_DASHBOARD_REPORT_OWNER
          AND system_report = 1;


       MGMT_IP.update_late_binding_tgt_type (l_report_guid,
                      p_target_type,FALSE); 
      
       EXCEPTION 
             WHEN DUP_VAL_ON_INDEX THEN NULL;
             WHEN NO_DATA_FOUND THEN NULL;
     END;
   END IF;

   FOR record IN svc_val_cursor
   LOOP
      IF record.value IS NOT NULL
      THEN
         l_value := TO_CHAR(record.value);
         l_new_value := '';
         l_update := false;
         LOOP
            EXIT WHEN l_value IS NULL;
            IF INSTR(l_value, ';') = 0 THEN
               l_combo := l_value;
               l_value := NULL;
            ELSE
               l_combo := SUBSTR(l_value, 1, (INSTR(l_value, ';') - 1)) ;  
               l_value := SUBSTR(l_value, INSTR(l_value, ';') + 1);
            END IF;
            IF (INSTR(l_combo, ':') > 0) THEN
               l_name := SUBSTR(l_combo, 1 , (INSTR(l_combo, ':') - 1)) ;  
               l_type := SUBSTR(l_combo, (INSTR(l_combo, ':') + 1) ); 
               IF (trim(l_name) = trim(p_target_name) AND trim(l_type) = trim(p_target_type)) THEN
                  l_update := true;
               ELSE
                  l_new_value := l_new_value || l_combo || ';';
               END IF;
            END IF;
         END LOOP;
         IF (l_update) THEN
            UPDATE MGMT_IP_REPORT_ELEM_PARAMS
               SET value = TO_CLOB(l_new_value)
             WHERE report_guid = record.report_guid
               AND element_guid = record.element_guid
               AND param = record.param;
         END IF;
      END IF;
   END LOOP;
END update_ip_target_delete;

PROCEDURE GET_SYSTEM_DETAILS
(
    p_service_name  IN VARCHAR2,
    p_target_type   IN VARCHAR2,
    p_system_details OUT em_system_obj
)
IS
BEGIN
  em_system_dashboard.GET_SYSTEM_DETAILS(p_service_name,
                                         p_target_type,
                                         p_system_details);
END;

----------------------------------------------------------------------
-- FUNCTION    : get_total_severity_duration
----------------------------------------------------------------------
--
-- PURPOSE     : Returns the number hours when there were violations
--               (Performance or Business)
--
-- DESCRIPTION :
--    This procedure returns the number of hours within a
--    time-period under consideration.
--
-- PARAMETERS  :
--    INPUT    v_target_guid                - Target GUID
--             v_start_collection_timestamp - Start of Period
--             v_end_collection_timestamp   - End of Period
--             v_clock_in                   - Start of Business hour
--             v_clock_out                  - End of Business hour
--             v_ignore_days                - Days to ignore
--    OUTPUT   Number of hours when there were violations
----------------------------------------------------------------------
FUNCTION get_total_severity_duration(v_target_guid IN MGMT_TARGETS.target_guid%TYPE,
                        v_start_collection_timestamp IN DATE,
                        v_end_collection_timestamp IN DATE,
                        v_clock_in  IN NUMBER,
                        v_clock_out IN NUMBER,
                        v_ignore_days IN VARCHAR2)
RETURN NUMBER
AS
l_slow_hours NUMBER := 0;
l_total_hours NUMBER := 0;
l_tgt_timezone VARCHAR2(64);
l_tgt_sysdate DATE;
temp_sev_array sla_sev_rec_array;
greatest_rec sla_sev_rec;
start_time DATE;
end_time DATE;
i NUMBER;
BEGIN
  temp_sev_array := sla_sev_rec_array();
  SELECT timezone_region
    INTO l_tgt_timezone
    FROM MGMT_TARGETS
    WHERE target_guid=v_target_guid;
  l_tgt_sysdate := MGMT_GLOBAL.SYSDATE_TZRGN(l_tgt_timezone);
  SELECT 
   sla_sev_rec(
           greatest(collection_timestamp,v_start_collection_timestamp),
           least(DECODE(violation_duration, NULL, l_tgt_sysdate,
               collection_timestamp + violation_duration / 24), 
                  v_end_collection_timestamp))
  BULK COLLECT INTO temp_sev_array
    FROM mgmt_violations viol, mgmt_sl_metrics slm
   WHERE viol.target_guid  =  v_target_guid
     AND slm.target_guid   =  viol.target_guid
     AND violation_level   =  MGMT_GLOBAL.G_SEVERITY_CRITICAL
     AND viol.policy_guid  =  slm.metric_guid
     AND viol.key_value    =  slm.key_value
     AND (v_start_collection_timestamp
         BETWEEN collection_timestamp AND 
	 DECODE(violation_duration, NULL, l_tgt_sysdate,collection_timestamp + violation_duration / 24) 
	 OR  collection_timestamp >=
         v_start_collection_timestamp )
     AND (v_end_collection_timestamp
         BETWEEN collection_timestamp AND 
         DECODE(violation_duration, NULL, l_tgt_sysdate,collection_timestamp + violation_duration / 24)  OR
         v_end_collection_timestamp >= 
         DECODE(violation_duration, NULL, l_tgt_sysdate,collection_timestamp + violation_duration / 24))
     ORDER BY collection_timestamp;
 IF (temp_sev_array.FIRST IS NOT NULL )
 THEN
   
   -- This is where we removed overlapped intervals...
 FOR i in to_number(temp_sev_array.FIRST) .. to_number(temp_sev_array.LAST)
  LOOP
     l_slow_hours := 0;
     IF( i = temp_sev_array.FIRST)
     THEN
        l_slow_hours := hours_worked(temp_sev_array(i).sev_start_time,
                                   temp_sev_array(i).sev_end_time,
                                v_ignore_days,v_clock_in,v_clock_out);
        greatest_rec := sla_sev_rec(temp_sev_array(i).sev_start_time,
                                temp_sev_array(i).sev_end_time);

     ELSE 
           IF (temp_sev_array(i).sev_end_time >
              greatest_rec.sev_end_time )
           THEN
           start_time := greatest(temp_sev_array(i).sev_start_time,
                                  greatest_rec.sev_end_time);
                                  
           end_time := temp_sev_array(i).sev_end_time;
           
           l_slow_hours := hours_worked(start_time,end_time,v_ignore_days,
                        v_clock_in, v_clock_out);
           greatest_rec := sla_sev_rec(start_time,end_time);
          ELSE
           l_slow_hours := 0;
          END IF;
     END IF;
     l_total_hours := l_slow_hours + l_total_hours;
  END LOOP;
END IF;
    return l_total_hours;
END get_total_severity_duration;

PROCEDURE truncate_performance_hours(v_all_violations IN violations_record_array,
                               v_bus_violation IN violations_record,
                               v_truncated_record OUT violations_record,
                               v_splitted_record OUT violations_record)
AS
BEGIN
  v_truncated_record := v_bus_violation;

  IF v_all_violations.COUNT = 0 THEN
   RETURN ;
  END IF;

  FOR i IN 1 .. v_all_violations.LAST
  LOOP
    IF v_all_violations(i).outage_type = G_SLOW_STATUS THEN
       IF v_all_violations(i).start_time <= v_bus_violation.start_time
          AND v_all_violations(i).end_time >= v_bus_violation.end_time THEN
         v_truncated_record := NULL;
         v_splitted_record := NULL;
         RETURN;
       ELSE 
       IF v_all_violations(i).start_time > v_bus_violation.start_time
          AND v_all_violations(i).start_time < v_bus_violation.end_time
          AND v_all_violations(i).end_time >= v_bus_violation.end_time THEN
         v_truncated_record.end_time := v_all_violations(i).start_time;
       ELSE 
         IF v_all_violations(i).start_time <= v_bus_violation.start_time
            AND v_all_violations(i).end_time > v_bus_violation.start_time
            AND v_all_violations(i).end_time < v_bus_violation.end_time THEN
           v_truncated_record.start_time := v_all_violations(i).end_time;
         ELSE
           IF v_all_violations(i).start_time > v_bus_violation.start_time
              AND v_all_violations(i).end_time < v_bus_violation.end_time THEN
             v_splitted_record := v_bus_violation;
             v_splitted_record.start_time := v_all_violations(i).end_time;
             v_truncated_record.end_time := v_all_violations(i).start_time;
             RETURN ;
             END IF;
           END IF;
         END IF;
       END IF;
    END IF;
  END LOOP;

END truncate_performance_hours;

PROCEDURE get_severity_annotation(p_severity_guids_in IN MGMT_SHORT_STRING_ARRAY,
                                  p_annotations_out  OUT MGMT_MAX_STRING_ARRAY)

IS
l_severity_annotations mgmt_namevalue_array;
TYPE varchar2_array IS TABLE OF VARCHAR2(4000) INDEX BY VARCHAR2(64);
l_annotations varchar2_array;
l_annotations_index NUMBER;
BEGIN
   p_annotations_out := MGMT_MAX_STRING_ARRAY();
   IF (p_severity_guids_in IS NULL OR p_severity_guids_in.COUNT < 1)
   THEN
      RETURN;
   END IF;

   SELECT MGMT_NAMEVALUE_OBJ(RAWTOHEX(annotations1.severity_guid), annotations1.message)
     BULK COLLECT INTO l_severity_annotations
     FROM mgmt_severity_annotation annotations1,
          (SELECT severity_guid, MAX(collection_timestamp) max_timestamp
             FROM TABLE(CAST(p_severity_guids_in AS MGMT_SHORT_STRING_ARRAY)) severities,
                  mgmt_severity_annotation annotations
            WHERE HEXTORAW(severities.column_value) = annotations.severity_guid
              AND annotations.annotation_type IS NULL
         GROUP BY severity_guid) annotations2
           
    WHERE annotations2.severity_guid = annotations1.severity_guid
      AND annotations2.max_timestamp = annotations1.collection_timestamp
      AND annotations1.annotation_type IS NULL;

   IF l_severity_annotations IS NOT NULL AND l_severity_annotations.COUNT > 0
   THEN
      FOR l_index IN l_severity_annotations.FIRST .. l_severity_annotations.LAST
      LOOP
         l_annotations(l_severity_annotations(l_index).name) := l_severity_annotations(l_index).value;
      END LOOP;
   END IF;

   l_annotations_index := 0;
   FOR l_index IN p_severity_guids_in.FIRST .. p_severity_guids_in.LAST
   LOOP
      l_annotations_index := l_annotations_index + 1;
      p_annotations_out.extend();
      IF (l_annotations.EXISTS(p_severity_guids_in(l_index)))
      THEN
         p_annotations_out(l_annotations_index) := l_annotations(p_severity_guids_in(l_index));
      ELSE
         p_annotations_out(l_annotations_index) := NULL;
      END IF;
   END LOOP;

END get_severity_annotation;

END em_dashboard_service;
/
SHOW ERRORS;
