Rem drv: <create type="pkgdefs" pos="service_level/service_level_pkgdef.sql+"/>
Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/ip/dashboard_service/dashboard_service_pkgdef.sql /st_emcore_10.2.0.4.1db11/2 2008/07/21 08:51:45 nmathuri Exp $
Rem
Rem dashboard_service_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2008, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      dashboard_service_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    nmathuri    07/19/08 - Fix the Bug#7148257, Remove email reference from comments
Rem    jashukla    06/03/08 - Bug 7144619 remove internal identifiers
Rem    tsubrama    05/22/07 - Backport mswamyt_bug-5705867 from main
Rem    nanand      12/08/05 - Backport mkm_bug4507741 from main 
Rem    mswamyt     02/07/07 - fix for bug 5705867
Rem    skotha      07/03/06 - Service Dashboard enhancements 
Rem                            for BAM Integration
Rem    mkm         11/30/05 - Fix for bug 4507741 
Rem    mkm         07/21/05 - workaround for 3037197 
Rem    mkm         07/19/05 - perf fix for get_metric_list 
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    mkm         06/28/05 - adding get_guids_privs 
Rem    mkm         06/13/05 - nls translation of labels in alert table 
Rem    mkm         05/24/05 - get_sl_history with out timezone parameter 
Rem    nanand      05/17/05 - Added new constants 
Rem    nanand      05/17/05 - Add callback for dashboard ootb 
Rem    nanand      05/13/05 - uncommenting get_avail procedures 
Rem    mswamyt     05/09/05 - adding update_ip_tables 
Rem    mkm         04/25/05 - Fix code review comments 
Rem    mkm         03/17/05 - transposed metrics fix 
Rem    jmenon      01/31/05 - removing declaration for internal 
Rem                           procedures/functions 
Rem    jmenon      01/28/05 - clean up 
Rem    jmenon      01/27/05 - code cleanup 
Rem    mswamyt     01/10/05 - code cleanup 
Rem    mswamyt     01/07/05 - fix
Rem    mswamyt     12/31/04 - adding avail time functions 
Rem    mswamyt     12/22/04 - changing slow and non business hrs constants 
Rem    verangan    12/07/04 - timezone fix 
Rem    mswamyt     11/24/04 - changing get_diff_percent 
Rem    verangan    11/03/04 - adding get_servicenames_from_guids 
Rem    snathan     10/21/04 - snathan_svclvl_merge
Rem    snathan     10/20/04 - Fix errors 
Rem    snathan     10/19/04 - fix
Rem    snathan     07/20/04 - created
Rem
Rem  Open  questions 
Rem    We should not expose all of the individual  procedures
Rem     get and set service rules should be sufficient

CREATE OR REPLACE PACKAGE em_dashboard_service AS

-- Declaring the cursor for later use.
TYPE CURSORTYPE IS REF CURSOR;
TYPE metric_rec_array_table IS TABLE OF METRIC_REC_ARRAY INDEX BY VARCHAR2(64);

-- Constants for SL status categories.

G_UP_STATUS CONSTANT NUMBER := 1;
G_SLOW_STATUS CONSTANT NUMBER := 25;
G_BUS_ISSUE_STATUS CONSTANT NUMBER := 250;
G_NON_BUSINESS_STATUS CONSTANT NUMBER := 100;
G_NO_DATA_STATUS  CONSTANT NUMBER := -1;
G_PKG_NAME CONSTANT VARCHAR2(20) := 'em_dashboard_service';
G_SEPARATOR CHAR(1) := ',';

-- Constant for the service_dashboard out of the box report

G_DASHBOARD_TITLE CONSTANT VARCHAR2(20) := 'service_dashboard';
G_DASHBOARD_REPORT_OWNER CONSTANT VARCHAR2(20):= 'SYSMAN';
G_DASHBOARD_ELEMENT_TYPE CONSTANT VARCHAR2(30) := 'SVC_DASH_SERVICE_TYPE';

--workaround for 3037197
G_GUIDS MGMT_USER_GUID_ARRAY;

--workaround for 3037197
FUNCTION get_guids
RETURN MGMT_USER_GUID_ARRAY;

-- get_services_list
-- 
-- PURPOSE : Procedure that will be invoked from the UI customization screen 
--           to obtain list of all services defined in the system
-- 
-- This procedure will obtain the list of services by querying the 
-- mgmt_targets and looking for target_type for SERVICE TYPE
-- For now till we get clarity on this we will stub out this call 
-- and return the services as strings.

-- Parameters
--      Input params None
--      Output params
--      service_cut_out params - Cursor with list of services defined in system

PROCEDURE get_services_list(service_cur_out OUT CURSORTYPE );

FUNCTION is_aggregate_service(target_guid_in IN MGMT_TARGETS.target_guid%TYPE)
RETURN NUMBER;

FUNCTION is_aggregate_service(target_type_in IN MGMT_TARGETS.target_type%TYPE)
RETURN NUMBER;

--
-- Procedure get_metric_list will return the list of metrics for a service guid
-- Parameters
--   INPUT guid_in service/target_guid
--         metric_type_in - Response,availability,usage type
--         metric_cur_out - cursor with the list of metric guids and metric names
-- For now we will return stubbed out version of the list

--This procedure is used by ASLM reports team
--Inform ASLM Team if any change is done to this
PROCEDURE get_metric_list( target_guid_in IN MGMT_TARGETS.target_guid%TYPE,
                           metric_type_in IN MGMT_CATEGORY_MAP.category_name%TYPE,
                           metric_cursor_out  OUT CURSORTYPE);

PROCEDURE get_metric_list( guids_in IN  MGMT_USER_GUID_ARRAY,
                           metric_type_in IN MGMT_CATEGORY_MAP.category_name%TYPE,
                           metric_cursor_out  OUT CURSORTYPE);

PROCEDURE get_metric_list( target_name_in IN MGMT_TARGETS.target_name%TYPE,
                           target_type_in IN MGMT_TARGETS.target_type%TYPE,
                           metric_type_in IN MGMT_CATEGORY_MAP.category_name%TYPE,
                           metric_cursor_out  OUT CURSORTYPE);
PROCEDURE get_metric_list(
  service_namestypes_in      IN  SMP_EMD_NVPAIR_ARRAY,
  usage_metric_rec_array_out OUT METRIC_REC_ARRAY_ARRAY,
  resp_metric_rec_array_out OUT METRIC_REC_ARRAY_ARRAY);
-- added this to get business metrics for a service along with other metrics

PROCEDURE get_metric_list(
  service_namestypes_in      IN  SMP_EMD_NVPAIR_ARRAY,
  usage_metric_rec_array_out OUT METRIC_REC_ARRAY_ARRAY,
  resp_metric_rec_array_out OUT METRIC_REC_ARRAY_ARRAY,
  bus_metric_rec_array_out OUT METRIC_REC_ARRAY_ARRAY);

FUNCTION verify_metric_type(p_metric_guid mgmt_metrics.metric_guid%TYPE,
  p_metric_type VARCHAR2,
  p_target_guid mgmt_targets.target_guid%TYPE)
RETURN NUMBER;

PROCEDURE get_statuses(
  service_namestypes_in      IN  SMP_EMD_NVPAIR_ARRAY,
  status_out         OUT SMP_EMD_NVPAIR_ARRAY,
  total_member_count_out OUT SMP_EMD_NVPAIR_ARRAY,
  up_member_count_out OUT SMP_EMD_NVPAIR_ARRAY,
  down_member_count_out OUT SMP_EMD_NVPAIR_ARRAY,
  unknown_member_count_out OUT SMP_EMD_NVPAIR_ARRAY,
  timezones_out OUT SMP_EMD_NVPAIR_ARRAY);
--

-- Procedure Name : get_services_sla_value
-- Parameters
---       INPUT
---          guids_in          : Service guids separated by :
---          start_date_in     : start date for the SLA
---          end_date_in       : end date for SLA
--         OUTPUT
--       service_sla_out :  Name value pair of guid and SLA value
--       service_name_arr_out : Name of the serice
--       service_sla_time_arr_out Used for pie chart in SL details UI
--       service_exp_sl_arr_out expected sl based on the defn

PROCEDURE get_services_sla_value (guid_array_in IN target_guid_array,
                     start_date_in IN VARCHAR2,
                     end_date_in IN VARCHAR2,
                     timezone_in IN VARCHAR2,
                     service_sla_out OUT SMP_EMD_NVPAIR_ARRAY,
                     service_name_arr_out OUT SMP_EMD_NVPAIR_ARRAY,
                     service_sla_time_arr_out OUT pie_time_record_array,
                     service_exp_sl_arr_out OUT SMP_EMD_NVPAIR_ARRAY);

PROCEDURE get_sl_history(v_target_guid in MGMT_TARGETS.target_guid%TYPE,
                   v_start_date IN VARCHAR2,
                   v_end_date IN VARCHAR2,
                   v_timezone IN VARCHAR2,
                   v_out_timezone IN VARCHAR2,
                   sl_violations_arr_out OUT violations_record_array,
                   sl_violtable_arr_out OUT violations_record_array);

PROCEDURE get_sl_history(v_target_guid IN MGMT_TARGETS.target_guid%TYPE,
                  v_start_date IN VARCHAR2,
                  v_end_date IN VARCHAR2,
                  v_timezone IN VARCHAR2,
                  sl_violations_arr_out OUT violations_record_array,
                  sl_violtable_arr_out OUT violations_record_array);

--This procedure is used by ASLM reports team
PROCEDURE get_avail_for_pie_chart (v_target_guid IN MGMT_TARGETS.target_guid%TYPE,
                                   v_start_date IN VARCHAR2,
                                   v_end_date IN VARCHAR2,
                                   v_timezone in VARCHAR2,
                                   v_status_dur_cur OUT CURSORTYPE);
          
--This procedure is used by ASLM reports team
PROCEDURE get_avail_for_cigar_chart (v_target_guid IN MGMT_TARGETS.target_guid%TYPE,
                                     v_start_date IN VARCHAR2,
                                     v_end_date IN VARCHAR2, 
                                     v_timezone IN VARCHAR2,
                                     v_status_det_cur OUT CURSORTYPE);

PROCEDURE get_avail_details(v_target_name IN VARCHAR2,
                            v_target_type IN VARCHAR2,
                            v_start_date IN VARCHAR2,
                            v_end_date IN VARCHAR2,
                            v_timezone IN VARCHAR2,
                            v_tgt_timezone OUT VARCHAR2,
                            v_curr_status OUT NUMBER,
                            v_status_since OUT DATE,
                            v_avail_percent OUT NUMBER,
                            v_status_dur_cur  OUT CURSORTYPE);
                            --v_status_det_cur OUT CURSORTYPE);

--This procedure is used by ASLM reports team
PROCEDURE get_metric_data(p_target_guid IN VARCHAR2,
                          p_metric_guid IN VARCHAR2,
                          v_key_value IN VARCHAR2,
                          v_start_date IN VARCHAR2,
                          v_end_date IN VARCHAR2,
                          v_timezone IN VARCHAR2,
                          v_warning_operator OUT NUMBER,
                          v_critical_operator OUT NUMBER,
                          v_warning_threshold OUT VARCHAR2,
                          v_critical_threshold OUT VARCHAR2,
                          v_metric_data_cur OUT CURSORTYPE,
                          v_downtime_cur OUT CURSORTYPE);

PROCEDURE get_alert_data(p_target_guid IN VARCHAR2,
                         v_start_date IN VARCHAR2,
                         v_end_date IN VARCHAR2,
                         v_timezone IN VARCHAR2,
                         v_alert_data_cur OUT CURSORTYPE);

PROCEDURE GET_SYSTEM_DETAILS
(
    p_service_name  IN VARCHAR2,
    p_target_type   IN VARCHAR2,
    p_system_details OUT em_system_obj
);

PROCEDURE get_serviceguids_from_names (
   svcnamestypes_in IN  SMP_EMD_NVPAIR_ARRAY,
   svcguids_out OUT MGMT_USER_GUID_ARRAY);

FUNCTION hours_worked(v_start_collection_timestamp IN DATE,
                      v_end_collection_timestamp IN DATE,
                      v_ignore_days IN VARCHAR2,
                      v_clock_in IN NUMBER,
                      v_clock_out IN NUMBER)
RETURN NUMBER;

FUNCTION get_severity_duration (v_target_guid IN MGMT_TARGETS.target_guid%TYPE,
                            v_start_collection_timestamp IN DATE,
                            v_end_collection_timestamp IN DATE,
                            v_clock_in  IN NUMBER,
                            v_clock_out IN NUMBER,
                            v_ignore_days IN VARCHAR2)
return NUMBER;

----------------------------------------------------------------------
-- FUNCTION    : get_total_severity_duration
----------------------------------------------------------------------
--
-- PURPOSE     : Returns the number hours when there were violations
--               (Performance or Business)
--
-- DESCRIPTION :
--    This procedure returns the number of hours within a
--    time-period under consideration.
--
-- PARAMETERS  :
--    INPUT    v_target_guid                - Target GUID
--             v_start_collection_timestamp - Start of Period
--             v_end_collection_timestamp   - End of Period
--             v_clock_in                   - Start of Business hour
--             v_clock_out                  - End of Business hour
--             v_ignore_days                - Days to ignore
--    OUTPUT   Number of hours when there were violations
----------------------------------------------------------------------
FUNCTION get_total_severity_duration(v_target_guid IN MGMT_TARGETS.target_guid%TYPE,
                        v_start_collection_timestamp IN DATE,
                        v_end_collection_timestamp IN DATE,
                        v_clock_in  IN NUMBER,
                        v_clock_out IN NUMBER,
                        v_ignore_days IN VARCHAR2)
return NUMBER;

PROCEDURE truncate_performance_hours(v_all_violations IN violations_record_array,
                               v_bus_violation IN violations_record,
                               v_truncated_record OUT violations_record,
                               v_splitted_record OUT violations_record);

FUNCTION get_metric_diff(v_target_guid IN MGMT_TARGETS.target_guid%TYPE,
                         v_metric_guid IN MGMT_METRICS.metric_guid%TYPE,
                         v_key_value IN MGMT_CURRENT_METRICS.key_value%TYPE,
                         v_value IN MGMT_CURRENT_METRICS.value%TYPE,
                         v_viol_level IN MGMT_CURRENT_VIOLATION.violation_level%TYPE)
RETURN NUMBER;

/*
FUNCTION get_metric_name(v_target_guid IN MGMT_TARGETS.target_guid%TYPE, 
                         v_metric_guid IN MGMT_METRICS.metric_guid%TYPE, 
                         v_key_value IN VARCHAR2)
RETURN VARCHAR2;
*/

FUNCTION get_key_part_values(l_key_value mgmt_violations.key_value%TYPE)
RETURN VARCHAR2;

PROCEDURE update_ip_target_add(
         p_target_name in MGMT_TARGETS.target_name%TYPE,
         p_target_type in MGMT_TARGETS.target_type%TYPE,
         p_target_guid in MGMT_TARGETS.target_guid%TYPE
);

PROCEDURE update_ip_target_delete(
         p_target_name in MGMT_TARGETS.target_name%TYPE,
         p_target_type in MGMT_TARGETS.target_type%TYPE,
         p_target_guid in MGMT_TARGETS.target_guid%TYPE
);

PROCEDURE get_guids_privs (
  namestypes_in IN SMP_EMD_NVPAIR_ARRAY,
  username_in IN VARCHAR2,
  privname_in IN VARCHAR2,
  guids_privs_out OUT SMP_EMD_NVPAIR_ARRAY
);

PROCEDURE get_severity_annotation(p_severity_guids_in IN MGMT_SHORT_STRING_ARRAY,
                                  p_annotations_out  OUT MGMT_MAX_STRING_ARRAY);

END em_dashboard_service;

/

SHOW ERRORS;
