Rem
Rem $Header: ip_indexes_10_2_0_3_0.sql 25-sep-2006.12:49:59 lgloyd Exp $
Rem
Rem ip_indexes_10.2.0.3.0.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ip_indexes_10_2_0_3_0.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       lgloyd   09/25/06 - use = in define statement
Rem       lgloyd   09/14/06 - add user param
Rem       lgloyd   09/11/06 - add index on stored report table for performance
Rem


Rem  Drop the index if it exists already before attempting create
Rem 
Rem  This step is taken because this index as a temporary patch has been applied
Rem  to some systems to alleviate a performance issue with the Reports tab query
Rem 

DEFINE EM_REPOS_USER ="&1"

DECLARE 
  l_object_name VARCHAR2(30);
BEGIN
  SELECT object_name
  INTO l_object_name
  FROM all_objects
  WHERE object_name = 'MGMT_IP_STORED_REPORT_INDEX1'
    and owner = UPPER('&EM_REPOS_USER')
    and object_type = 'INDEX';
  
  EXECUTE IMMEDIATE 'drop index MGMT_IP_STORED_REPORT_INDEX1';

EXCEPTION 
  WHEN NO_DATA_FOUND THEN
    NULL;
END;
/

 
CREATE INDEX MGMT_IP_STORED_REPORT_INDEX1
  ON MGMT_IP_STORED_REPORT (REPORT_GUID, GENERATED_DATE_UTC DESC);  
