Rem
Rem $Header: ip_outofbox_reports_10_2_0_1_0.sql 19-jul-2005.14:42:32 lgloyd Exp $
Rem
Rem ip_outofbox_reports_10_2_0_1_0.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ip_outofbox_reports_10_2_0_1_0.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Out of the box reports that ship with EM 10.2.0.1.0
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       lgloyd   07/19/05 - beta->production upgrade 
Rem       tzimmerm 06/30/05 - Add Avail Timeline param controller 
Rem       tzimmerm 03/15/05 - Set group as tgt type 4 Avail Timeline 
Rem       vkgarg   03/10/05 - add licensing element 
Rem       lgloyd   02/18/05 - all targets option for alerts element 
Rem       lgloyd   02/16/05 - lgloyd_bug-4167015
Rem       lgloyd   02/15/05 - upgrade work 
Rem       ratadiko 02/09/05 - Correcting the render element of Availability 
Rem                           Element 
Rem       ratadiko 02/03/05 - Adding appropriate comments 
Rem       ratadiko 02/03/05 - Adding EUM & Summary related reports defn. 
Rem       lgloyd   01/26/05 - fix table_from_sql 
Rem       pmaddi   01/12/05 - 
Rem       lgloyd   01/07/05 - avail param controllers 
Rem       lgloyd   12/28/04 - fix alerts params 
Rem       vmotamar 12/16/04 - Change System Dashboard Target Type to support both group and system
Rem       vmotamar 11/25/04 - Add system dashboard reports element
Rem       lgloyd   12/02/04 - remove timestamp 
Rem       tzimmerm 11/15/04 - Cut over NLS strings to new strings in .DLF file
Rem       lgloyd   11/24/04 - misc improvements 
Rem       tyhorton 11/15/04 - adding separator element 
Rem       lgloyd   11/11/04 - named notation 
Rem       lgloyd   10/26/04 - timestamp
Rem       lgloyd   10/15/04 - more targets 
Rem       tyhorton 10/13/04 - adding Text element definition 
Rem       lgloyd   10/08/04 - targets
Rem       lgloyd   09/18/04 - any_target->any_type
Rem       lgloyd   09/15/04 - add user chart 
Rem       lgloyd   09/08/04 - add user table sql 
Rem       lgloyd   09/06/04 - lgloyd_ip_040820
Rem

SET DEFINE OFF

BEGIN
 
  DECLARE 
    l_target_types  MGMT_IP_TARGET_TYPES;
    l_param_classes MGMT_IP_PARAM_CLASSES;
    l_param_values  MGMT_IP_PARAM_VALUE_LIST;
    
  BEGIN

    -- -------------------------------------------------------------------------
    -- Element Types
    -- -------------------------------------------------------------------------    

    -- No targets for element (targetless)
    --
    l_target_types := MGMT_IP_TARGET_TYPES();
    l_target_types.extend(1);
    l_target_types(1) := 'no_types'; 
    mgmt_ip.add_element_type(
      p_element_type_nlsid  => 'IPMSG_NO_TARGET_TYPE',
      p_target_types        => l_target_types);
      
    -- any_target_type
    --
    l_target_types := MGMT_IP_TARGET_TYPES();
    l_target_types.extend(1);
    l_target_types(1) := 'any_type'; 
    mgmt_ip.add_element_type(
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',  
      p_target_types        => l_target_types);
--
--  DEPRECATED  - any_target_type 
--  use IPMSG_ANY_TARGET_TYPE
--
l_target_types := MGMT_IP_TARGET_TYPES();
l_target_types.extend(1);
l_target_types(1) := 'any_type'; 
mgmt_ip.add_element_type(
  p_element_type_nlsid  => 'any_target_type',  
  p_target_types        => l_target_types);

    -- node_target_types 
    --
    l_target_types := MGMT_IP_TARGET_TYPES();
    l_target_types.extend(1);
    l_target_types(1) := 'host'; 
    mgmt_ip.add_element_type(
      p_element_type_nlsid  => 'IPMSG_NODE_TARGET_TYPE',  
      p_target_types        => l_target_types);      
--
--  DEPRECATED - node_target_types
--  use IPMSG_NODE_TARGET_TYPE
--
l_target_types := MGMT_IP_TARGET_TYPES();
l_target_types.extend(1);
l_target_types(1) := 'host'; 
mgmt_ip.add_element_type(
  p_element_type_nlsid  => 'node_target_types',  
  p_target_types        => l_target_types);

    -- database_target_types (database group)
    l_target_types := MGMT_IP_TARGET_TYPES();
    l_target_types.extend(2);
    l_target_types(1) := 'oracle_database'; 
    l_target_types(2) := 'oracle_database_group'; 
    mgmt_ip.add_element_type(
      p_element_type_nlsid  => 'IPMSG_DATABASE_GROUP_TARGET_TYPE',  
      p_target_types        => l_target_types);
--
-- DEPRECATED - database_target_types (database group)
-- use IPMSG_DATABASE_GROUP_TARGET_TYPE
--
l_target_types := MGMT_IP_TARGET_TYPES();
l_target_types.extend(2);
l_target_types(1) := 'oracle_database'; 
l_target_types(2) := 'oracle_database_group'; 
mgmt_ip.add_element_type(
  p_element_type_nlsid  => 'database_target_types',  
  p_target_types        => l_target_types);
      
      
    -- database_target_type
    --
    l_target_types := MGMT_IP_TARGET_TYPES();
    l_target_types.extend(1);
    l_target_types(1) := 'oracle_database'; 
    mgmt_ip.add_element_type(
      p_element_type_nlsid  => 'IPMSG_DATABASE_TARGET_TYPE',  
      p_target_types        => l_target_types);
--
-- DEPRECATED - database_target_type
-- use IPMSG_DATABASE_TARGET_TYPE
--
l_target_types := MGMT_IP_TARGET_TYPES();
l_target_types.extend(1);
l_target_types(1) := 'oracle_database'; 
mgmt_ip.add_element_type(
  p_element_type_nlsid  => 'database_target_type',  
  p_target_types        => l_target_types);
      
    -- group_target_types
    --
    l_target_types := MGMT_IP_TARGET_TYPES();
    l_target_types.extend(3);
    l_target_types(1) := 'composite'; 
    l_target_types(2) := 'generic_system'; 
    l_target_types(3) := 'generic_redundancy_group'; 
    mgmt_ip.add_element_type(
      p_element_type_nlsid  => 'IPMSG_GROUP_TARGET_TYPES',  
      p_target_types        => l_target_types);
--
-- DEPRECATED - group_target_types
-- use IPMSG_GROUP_TARGET_TYPES
--
l_target_types := MGMT_IP_TARGET_TYPES();
l_target_types.extend(3);
l_target_types(1) := 'composite'; 
l_target_types(2) := 'host_group'; 
l_target_types(3) := 'oracle_database_group'; 
mgmt_ip.add_element_type(
  p_element_type_nlsid  => 'group_target_types',  
  p_target_types        => l_target_types);
    
   -- dashboard_target_types
   --
   l_target_types := MGMT_IP_TARGET_TYPES();
   l_target_types.extend(2);
   l_target_types(1) := 'generic_system';
   l_target_types(2) := 'composite';
   mgmt_ip.add_element_type(
     p_element_type_nlsid  => 'IPMSG_SYSTEM_DASHBOARD_TARGET_TYPE',
     p_target_types        => l_target_types);

    COMMIT;  

    -- -------------------------------------------------------------------------
    -- Element Definitions
    -- -------------------------------------------------------------------------    
    
    -- chart from sql (sql is not editable by em user, executes against base tables)
    --
    mgmt_ip.add_element_definition(
      p_element_name_nlsid  => 'IPMSG_CHART_FROM_SQL',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_description_nlsid   => 'IPMSG_CHART_FROM_SQL_DESC',
      p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.ChartRenderController',
      p_internal_use_only   => 1, 
      p_param_classes       => null, 
      p_default_parameters  => null, 
      p_pack_name           => null
      );
--
-- DEPRECATED - chart from sql (sql is not editable by em user, executes against base tables)
-- use IPMSG_CHART_FROM_SQL
--
mgmt_ip.add_element_definition(
  p_element_name_nlsid  => 'chart_from_sql',
  p_element_type_nlsid  => 'any_target_type',
  p_description_nlsid   => 'chart_desc',
  p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.ChartRenderController',
  p_internal_use_only   => 1, 
  p_param_classes       => null, 
  p_default_parameters  => null, 
  p_pack_name           => null
  );    
   
    -- user chart from sql (sql is editable by em user, executes against mgmt$ views)
    --
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(2);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.ChartParamController';
    mgmt_ip.add_element_definition(
      p_element_name_nlsid  => 'IPMSG_USER_CHART_FROM_SQL',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_description_nlsid   => 'IPMSG_USER_CHART_FROM_SQL_DESC',
      p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.UserChartRenderController',
      p_internal_use_only   => 0, 
      p_param_classes       => l_param_classes,
      p_default_parameters  => null,
      p_pack_name           => null
      );
--
-- DEPRECATED - user chart from sql (sql is editable by em user, executes against mgmt$ views)
-- use IPMSG_USER_CHART_FROM_SQL
--
mgmt_ip.add_element_definition(
  p_element_name_nlsid  => 'user_chart_from_sql',
  p_element_type_nlsid  => 'any_target_type',
  p_description_nlsid   => 'user_chart_desc',
  p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.UserChartRenderController',
  p_internal_use_only   => 1, 
  p_param_classes       => l_param_classes,
  p_default_parameters  => null,
  p_pack_name           => null
  );
      
    -- table from sql (sql is not editable by em user, executes against base tables)
    --
    mgmt_ip.add_element_definition(
      p_element_name_nlsid  => 'IPMSG_TABLE_FROM_SQL',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_description_nlsid   => 'IPMSG_USER_TABLE_FROM_SQL_DESC',
      p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.TableRenderController',
      p_internal_use_only   => 1, 
      p_param_classes       => null,
      p_default_parameters  => null,
      p_pack_name           => null
      );
--
-- DEPRECATED -  table from sql (sql is not editable by em user, executes against base tables)
-- use IPMSG_USER_TABLE_FROM_SQL
--
mgmt_ip.add_element_definition(
  p_element_name_nlsid  => 'table_from_sql',
  p_element_type_nlsid  => 'any_target_type',
  p_description_nlsid   => 'user_chart_desc',
  p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.TableRenderController',
  p_internal_use_only   => 1, 
  p_param_classes       => null,
  p_default_parameters  => null,
  p_pack_name           => null
  );  
      
    -- user table from sql (sql is editable by em users, executes against mgmt$ views)
    --
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(2);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.SQLStatementParamController';
    mgmt_ip.add_element_definition(
      p_element_name_nlsid  => 'IPMSG_USER_TABLE_FROM_SQL',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_description_nlsid   => 'IPMSG_USER_TABLE_FROM_SQL_DESC',
      p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.UserTableRenderController',
      p_internal_use_only   => 0, 
      p_param_classes       => l_param_classes,
      p_default_parameters  => null,
      p_pack_name           => null
      );
--
-- DEPRECATED - user table from sql (sql is editable by em users, executes against mgmt$ views)
-- use IPMSG_USER_TABLE_FROM_SQL
--
mgmt_ip.add_element_definition(
  p_element_name_nlsid  => 'user_table_from_sql',
  p_element_type_nlsid  => 'any_target_type',
  p_description_nlsid   => 'user_table_desc',
  p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.UserTableRenderController',
  p_internal_use_only   => 1, 
  p_param_classes       => l_param_classes,
  p_default_parameters  => null,
  p_pack_name           => null
  );

    -- metric details
    --
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(4);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.metaParam.minTargetsAllowed',
      '0');
    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.metaParam.maxTargetsAllowed',
      '10');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.metaParam.allowsMixedTargetTypes',
      'false');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TimePeriodParam',
      '0:0');

    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(4);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
    l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
    l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.MetDetParamController';
    mgmt_ip.add_element_definition(
      p_element_name_nlsid  => 'IPMSG_METRIC_DETAILS',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_description_nlsid   => 'IPMSG_METRIC_DETAILS_DESC',
      p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.MetDetRenderController',
      p_internal_use_only   => 0, 
      p_param_classes       => l_param_classes,
      p_default_parameters  => l_param_values,
      p_pack_name           => null
      );
--
-- DEPRECATED - metric details 
-- use IPMSG_METRIC_DETAILS
--
mgmt_ip.add_element_definition(
  p_element_name_nlsid  => 'metric_details',
  p_element_type_nlsid  => 'any_target_type',
  p_description_nlsid   => 'metric_details_desc',
  p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.MetDetRenderController',
  p_internal_use_only   => 1, 
  p_param_classes       => l_param_classes,
  p_default_parameters  => null,
  p_pack_name           => null
  );  
      
    -- availability history
    --
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(3);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
    l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
        
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(4);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.metaParam.minTargetsAllowed',
      '0');
    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.metaParam.maxTargetsAllowed',
      '1');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.metaParam.allowsMixedTargetTypes',
      'true');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.TimePeriodParam',
      '0:0');

    mgmt_ip.add_element_definition(
      p_element_name_nlsid  => 'IPMSG_AVAILABILITY_TIMELINE',
      p_element_type_nlsid  => 'IPMSG_GROUP_TARGET_TYPES',
      p_description_nlsid   => 'IPMSG_AVAILABILITY_TIMELINE_DESC',
      p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.AvailRenderController',
      p_internal_use_only   => 0, 
      p_param_classes       => l_param_classes,
      p_default_parameters  => l_param_values,
      p_pack_name           => null
      );


  
    -- Image element
    --
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(1);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.ImageParamController';
    mgmt_ip.add_element_definition(
      p_element_name_nlsid  => 'IPMSG_IMAGE_DISPLAY',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_description_nlsid   => 'IPMSG_IMAGE_DISPLAY_DESC',
      p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.ImageRenderController',
      p_internal_use_only   => 0, 
      p_param_classes       => l_param_classes,
      p_default_parameters  => null,
      p_pack_name           => null
      );
--
-- DEPRECATED - Image element
-- use IPMSG_IMAGE_DISPLAY
--
l_param_classes := MGMT_IP_PARAM_CLASSES();
l_param_classes.extend(1);
l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.ImageParamController';
mgmt_ip.add_element_definition(
  p_element_name_nlsid  => 'image_display',
  p_element_type_nlsid  => 'any_target_type',
  p_description_nlsid   => 'image_desc',
  p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.ImageRenderController',
  p_internal_use_only   => 1, 
  p_param_classes       => l_param_classes,
  p_default_parameters  => null,
  p_pack_name           => null
  );
      
    -- Styled text element
    --
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(1);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.TextParamController';
    mgmt_ip.add_element_definition(
      p_element_name_nlsid  => 'IPMSG_STYLED_TEXT',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_description_nlsid   => 'IPMSG_STYLED_TEXT_DESC',
      p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.TextRenderController',
      p_internal_use_only   => 0, 
      p_param_classes       => l_param_classes,
      p_default_parameters  => null,
      p_pack_name           => null
      );
--
-- DEPRECATED - Styled text element
-- use IPMSG_STYLED_TEXT
--
l_param_classes := MGMT_IP_PARAM_CLASSES();
l_param_classes.extend(1);
l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.TextParamController';
mgmt_ip.add_element_definition(
  p_element_name_nlsid  => 'text_display',
  p_element_type_nlsid  => 'any_target_type',
  p_description_nlsid   => 'text_desc',
  p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.TextRenderController',
  p_internal_use_only   => 1, 
  p_param_classes       => l_param_classes,
  p_default_parameters  => null,
  p_pack_name           => null
  );  
      
    -- Alerts element
    --
    l_param_values := MGMT_IP_PARAM_VALUE_LIST();
    l_param_values.extend(4);
    l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.metaParam.minTargetsAllowed',
      '0');
    l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.metaParam.maxTargetsAllowed',
      '1000000');
    l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.metaParam.allowsMixedTargetTypes',
      'true');
    l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
      'oracle.sysman.eml.ip.render.elem.metaParam.supportsAllTargets',
      'true');

    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(3);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
    l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.AlertsParamController';
    mgmt_ip.add_element_definition(
      p_element_name_nlsid  => 'IPMSG_ALERTS_ELEMENT',
      p_element_type_nlsid  => 'IPMSG_ANY_TARGET_TYPE',
      p_description_nlsid   => 'IPMSG_ALERTS_ELEMENT_DESC',
      p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.AlertsRenderController',
      p_internal_use_only   => 0, 
      p_param_classes       => l_param_classes,
      p_default_parameters  => l_param_values,
      p_pack_name           => null
      );
--
-- DEPRECATED - alerts element
-- use IPMSG_ALERTS_ELEMENT
--
l_param_classes := MGMT_IP_PARAM_CLASSES();
l_param_classes.extend(2);
l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.AlertsParamController';
mgmt_ip.add_element_definition(
  p_element_name_nlsid  => 'alerts',
  p_element_type_nlsid  => 'any_target_type',
  p_description_nlsid   => 'alerts_desc',
  p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.AlertsRenderController',
  p_internal_use_only   => 1, 
  p_param_classes       => l_param_classes,
  p_default_parameters  => l_param_values,
  p_pack_name           => null
  );

    --  Separator element
    --
    mgmt_ip.add_element_definition(
      p_element_name_nlsid  => 'IPMSG_SEPARATOR',
      p_element_type_nlsid  => 'IPMSG_NO_TARGET_TYPE',
      p_description_nlsid   => 'IPMSG_SEPARATOR_DESC',
      p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.SeparatorRenderController',
      p_internal_use_only   => 0, 
      p_param_classes       => null,
      p_default_parameters  => null,
      p_pack_name           => null
      );
--
-- DEPRECATED - Separator element
-- use IPMSG_SEPARATOR
--
mgmt_ip.add_element_definition(
  p_element_name_nlsid  => 'separator',
  p_element_type_nlsid  => 'any_target_type',
  p_description_nlsid   => 'separator_desc',
  p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.SeparatorRenderController',
  p_internal_use_only   => 1, 
  p_param_classes       => null,
  p_default_parameters  => null,
  p_pack_name           => null
  );      
      

    -- system dashboard
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(1);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.system.SysDashParamController';
    mgmt_ip.add_element_definition(
      p_element_name_nlsid  => 'IPMSG_SYSTEM_DASHBOARD',
      p_element_type_nlsid  => 'IPMSG_SYSTEM_DASHBOARD_TARGET_TYPE',
      p_description_nlsid   => 'IPMSG_SYSTEM_DASHBOARD_DESC',
      p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.system.SysDashRenderController',
      p_internal_use_only   => 0, 
      p_param_classes       => l_param_classes,
      p_default_parameters  => null,
      p_pack_name           => null
      );

    -- licensing
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(2);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.licensing.LicensingParamController';
    mgmt_ip.add_element_definition(
      p_element_name_nlsid  => 'IPMSG_LICENSING',
      p_element_type_nlsid  => 'IPMSG_LICENSING_TARGET_TYPE',
      p_description_nlsid   => 'IPMSG_LICENSING_DESC',
      p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.licensing.LicensingRenderController',
      p_internal_use_only   => 0, 
      p_param_classes       => l_param_classes,
      p_default_parameters  => null,
      p_pack_name           => null
      );
      
COMMIT;  
    
  END;

END;
/

SET DEFINE ON
