Rem
Rem $Header: ip_outofbox_reports_10_2_0_2_0.sql 10-mar-2006.03:46:19 pmaddi Exp $
Rem
Rem ip_outofbox_reports_10_2_0_2_0.sql
Rem
Rem Copyright (c) 2004, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ip_outofbox_reports_10_2_0_2_0.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Out of the box reports that ship with EM 10.2.0.2.0
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       pmaddi   03/10/06 - Backport pmaddi_bug-4606201 from main 
Rem       pmaddi   09/14/05 - Adding webapp to 'IPMSG_SERVICE_TARGET_TYPES' 
Rem       tzimmerm 08/19/05 - Comment out Availability Timeline (Services) for 
Rem                           10.2GC 
Rem       tzimmerm 08/02/05 - Add Services Availability element 
Rem       lgloyd   07/20/05 - lgloyd_bug-4502618
Rem       lgloyd   07/19/05 - beta->production upgrade 
Rem

SET DEFINE OFF

BEGIN
 
  DECLARE 
    l_target_types  MGMT_IP_TARGET_TYPES;    
    l_param_classes MGMT_IP_PARAM_CLASSES;
    l_param_values  MGMT_IP_PARAM_VALUE_LIST;    
    
  BEGIN
    -- -------------------------------------------------------------------------
    -- Add the Availability Timeline parameter controller to the param classes
    -- for this element
    -- -------------------------------------------------------------------------
    INSERT INTO MGMT_IP_ELEM_PARAM_CLASSES
        (ELEMENT_NAME_NLSID, ELEMENT_TYPE_NLSID, 
          ELEMENT_PARAM_CLASS, DISPLAY_ORDER)
    VALUES
        ('IPMSG_AVAILABILITY_TIMELINE', 'IPMSG_GROUP_TARGET_TYPES',
          'oracle.sysman.eml.ip.render.elem.AvailParamController', 4);

    -- -------------------------------------------------------------------------
    --  Add EM Service Target Types - this includes OCS Custom Service
    --  target types
    -- -------------------------------------------------------------------------
    l_target_types := MGMT_IP_TARGET_TYPES();
    l_target_types.extend(42);
    l_target_types(1) := 'calendar_asvc'; 
    l_target_types(2) := 'calendar_user_acc_asvc'; 
    l_target_types(3) := 'cw_asvc';
    l_target_types(4) := 'cw_user_acc_asvc';
    l_target_types(5) := 'email_asvc';
    l_target_types(6) := 'email_housekeeper_svc';
    l_target_types(7) := 'email_imap_svc';
    l_target_types(8) := 'email_infra_asvc';
    l_target_types(9) := 'email_list_svc';
    l_target_types(10) := 'email_nntp_svc';
    l_target_types(11) := 'email_pop_svc';
    l_target_types(12) := 'email_smtp_svc';
    l_target_types(13) := 'email_user_acc_asvc';
    l_target_types(14) := 'email_vscrub_svc';
    l_target_types(15) := 'files_asvc';
    l_target_types(16) := 'files_ftp_svc';
    l_target_types(17) := 'files_user_acc_asvc';
    l_target_types(18) := 'ic_asvc';
    l_target_types(19) := 'im_asvc';
    l_target_types(20) := 'im_ldap_svc';
    l_target_types(21) := 'im_user_acc_asvc';
    l_target_types(22) := 'mobile_acc_asvc';
    l_target_types(23) := 'mobile_asvc';
    l_target_types(24) := 'mobile_devicemgmt_asvc';
    l_target_types(25) := 'mobile_pushmail_asvc';
    l_target_types(26) := 'ocs_asvc';
    l_target_types(27) := 'ovf_asvc';
    l_target_types(28) := 'ovf_fax_asvc';
    l_target_types(29) := 'ovf_fax_svc';
    l_target_types(30) := 'ovf_record_asvc';
    l_target_types(31) := 'ovf_record_svc';
    l_target_types(32) := 'ovf_retrieve_asvc';
    l_target_types(33) := 'ovf_retrieve_svc';
    l_target_types(34) := 'rtc_asvc';
    l_target_types(35) := 'rtc_user_acc_asvc';
    l_target_types(36) := 'td_asvc';
    l_target_types(37) := 'td_user_acc_asvc';
    l_target_types(38) := 'ultrasearch_admin_asvc';
    l_target_types(39) := 'ultrasearch_asvc';
    l_target_types(40) := 'ultrasearch_search_asvc';    
    l_target_types(41) := 'generic_service'; 
    l_target_types(42) := 'aggregate_service';  
    
    l_target_types.extend(1);
    l_target_types(43) := 'website';

    mgmt_ip.add_element_type(
      p_element_type_nlsid  => 'IPMSG_SERVICE_TARGET_TYPES',  
      p_target_types        => l_target_types);
      
            
    -- Add Service Availability history element
    --
--  l_param_classes := MGMT_IP_PARAM_CLASSES();
--  l_param_classes.extend(4);
--  l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
--  l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
--  l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
--  l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.AvailParamController';
    
--  l_param_values := MGMT_IP_PARAM_VALUE_LIST();
--  l_param_values.extend(4);
--  l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
--    'oracle.sysman.eml.ip.render.elem.metaParam.minTargetsAllowed',
--    '0');
--  l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
--    'oracle.sysman.eml.ip.render.elem.metaParam.maxTargetsAllowed',
--    '1');
--  l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
--    'oracle.sysman.eml.ip.render.elem.metaParam.allowsMixedTargetTypes',
--    'true');
--  l_param_values(4) := MGMT_IP_PARAM_VALUE_RECORD(
--    'oracle.sysman.eml.ip.render.elem.TimePeriodParam',
--    '0:0');

--  mgmt_ip.add_element_definition(
--    p_element_name_nlsid  => 'IPMSG_SERVICE_AVAILABILITY',
--    p_element_type_nlsid  => 'IPMSG_SERVICE_TARGET_TYPES',
--    p_description_nlsid   => 'IPMSG_SERVICE_AVAILABILITY_DESC',
--    p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.AvailRenderController',
--    p_internal_use_only   => 0, 
--    p_param_classes       => l_param_classes,
--    p_default_parameters  => l_param_values,
--    p_pack_name           => null
--    );                                  

    -- -------------------------------------------------------------------------
    -- Update the group target type adding custom clusters and custom 
    -- redundancy groups.
    -- -------------------------------------------------------------------------
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'oracle_ias_cluster',
                                 TRUE);
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'oc4j_cluster',
                                 TRUE);
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'oracle_apache_cluster',
                                 TRUE);
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'calendar_app_rgroup',
                                 TRUE);        
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'calendar_server_rgroup',
                                 TRUE);     
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'cw_rgroup',
                                 TRUE);    
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'email_housekeeper_rgroup',
                                 TRUE);     
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'email_imap_rgroup',
                                 TRUE);     
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'email_list_rgroup',
                                 TRUE);     
                             
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'email_nntp_rgroup',
                                 TRUE);     
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'email_pop_rgroup',
                                 TRUE);     
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'email_smtp_rgroup',
                                 TRUE);            
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'email_vscrub_rgroup',
                                 TRUE); 
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'ic_ocsintg_rgroup',
                                 TRUE); 
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'im_ldap_rgroup',
                                 TRUE); 
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'im_sso_rgroup',
                                 TRUE); 
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'mobile_rgroup',
                                 TRUE); 
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'rtc_rgroup',
                                 TRUE); 
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'td_rgroup',
                                 TRUE); 
                         
    MGMT_IP.update_element_type ('IPMSG_GROUP_TARGET_TYPES',
                                 'ultrasearch_ocsclient_rgroup',
                                 TRUE);                          

  COMMIT;  
    
  END;

END;
/

SET DEFINE ON
