Rem
Rem  ip_pkgdef_10_2_0_1_0.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ip_pkgdef_10_2_0_1_0.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    lgloyd      07/28/05 - lgloyd_bug_4502618_plsql
Rem    lgloyd      09/08/04 - custom bean 
Rem    lgloyd      08/25/04 - alerts
Rem    tzimmerm    07/21/04 - Add IP purge functionality 
Rem    lgloyd      07/14/04 - pl/sql api for report defns 
Rem    tzimmerm    05/21/04 - Add delete rpt by version 
Rem    tzimmerm    03/29/04 - 
Rem    tzimmerm    03/26/04 - 
Rem    tzimmerm    03/15/04 - Add JIT target flag to API 
Rem    tzimmerm    02/27/04 - tzimmerm_reports_repos 
Rem    tzimmerm    02/17/04 - Created
Rem
create or replace package MGMT_IP
as

-- type definition
TYPE CURSOR_TYPE IS REF CURSOR;

--  ----------------------------------------------------------------------------
--  Create a report definition
--  Input:
--      p_title_nlsid         report title (nlsid if translated or
--                            display string if not translated)
--      p_description_nlsid   description (nlsid if translated or
--                            display string if not translated)
--      p_owner               owner name
--      p_category_nlsid      category name (nlsid if translated or
--                            display string if not translated)
--      p_sub_category_nlsid  subcategory name (nlsid if translated or
--                            display string if not translated)
--      p_late_binding_target_types  - target type for late binding, 
--                            or null if not late binding
--      p_late_binding_multi_targets  - 1 if multiple targets are
--                            supported for late binding, otherwise 0
--      p_show_table_of_contents    1=show 0=hide
--      p_system_report       1=system report, 0=end user report      
--      p_custom_bean_class   optional class for customizing report
--      p_internal_use_only   1=internal use only, 0=available to administrators
--      p_pack_name           License pack assoc with this report defintion
--  Output:
--      returns guid for report definition
--  ----------------------------------------------------------------------------
FUNCTION create_report_definition (
                p_title_nlsid                       IN VARCHAR2,
                p_description_nlsid                 IN VARCHAR2,
                p_owner                             IN VARCHAR2,
                p_category_nlsid                    IN VARCHAR2,
                p_sub_category_nlsid                IN VARCHAR2,                
                p_late_binding_target_types         IN MGMT_IP_TARGET_TYPES DEFAULT NULL,
                p_late_binding_multi_targets        IN NUMBER DEFAULT 0,
                p_show_table_of_contents            IN NUMBER DEFAULT 0,
                p_system_report                     IN NUMBER DEFAULT 1,
                p_custom_report_bean_class          IN VARCHAR2 DEFAULT NULL,
                p_internal_use_only                 IN NUMBER DEFAULT 0,
                p_pack_name                         IN VARCHAR2 DEFAULT NULL
                ) RETURN RAW;


--  ----------------------------------------------------------------------------
--  Add an element to a report definition
--  Input:
--        p_report_guid         guid to identify the report definition       
--        p_element_name_nlsid  element name (nlsid if translated or
--                              display string if not translated)
--        p_element_type_nlsid  element type name (nlsid if translated or
--                              display string if not translated) 
--        p_header_nlslid       element header (nlsid if translated or
--                              display string if not translated), or null
--        p_element_order       order of this element, 1 based
--        p_element_row         row for this element, 1 based
--        p_parameters          parameters for this element
--        p_targets             targets for this element
--  Output:
--      returns guid for this element instance
--  ----------------------------------------------------------------------------
FUNCTION add_element_to_report_def(
                p_report_guid                       IN RAW,
                p_element_name_nlsid                IN VARCHAR2,
                p_element_type_nlsid                IN VARCHAR2,
                p_header_nlslid                     IN VARCHAR2,
                p_element_order                     IN NUMBER,
                p_element_row                       IN NUMBER,
                p_parameters                        IN MGMT_IP_PARAM_VALUE_LIST,
                p_targets                           IN MGMT_IP_TARGET_LIST
                ) RETURN RAW;


--  ----------------------------------------------------------------------------
--  Add an element type.  An element type defines what target types are
--    compatiable with an element.
--   Input:
--    p_element_type_nlsid    element type name (nlsid if translated or
--                            display string if not translated)
--    p_target_types          list of target types assoc with this element type
--  ----------------------------------------------------------------------------
PROCEDURE add_element_type (
                p_element_type_nlsid              IN VARCHAR2,
                p_target_types                    IN MGMT_IP_TARGET_TYPES
                );


--  ----------------------------------------------------------------------------
--  Add an element definition
--   Input:
--        p_element_name_nlsid  element name (nlsid if translated or
--                              display string if not translated)
--        p_element_type_nlsid  element type name (nlsid if translated or
--                              display string if not translated) 
--        p_description_nlsid   description (nlsid if translated or
--                              display string if not translated), or null
--        p_element_class_name  name of the class which renders this element
--        p_internal_use_only   1=internal use only, 0=available to administrators
--        p_param_classes       list of parameter controller class names
--        p_default_parameters  list of default parameters
--  ----------------------------------------------------------------------------
PROCEDURE add_element_definition (                
                p_element_name_nlsid                IN VARCHAR2,
                p_element_type_nlsid                IN VARCHAR2,
                p_description_nlsid                 IN VARCHAR2,
                p_element_class_name                IN VARCHAR2,
                p_internal_use_only                 IN NUMBER DEFAULT 0, 
                p_param_classes                     IN MGMT_IP_PARAM_CLASSES  DEFAULT NULL,
                p_default_parameters                IN MGMT_IP_PARAM_VALUE_LIST DEFAULT NULL,
                p_pack_name                         IN VARCHAR2 DEFAULT NULL
                );


--  ----------------------------------------------------------------------------
--  IP INTERNAL USE ONLY:  Grant access to report to the specified user
--  ----------------------------------------------------------------------------
PROCEDURE grant_report_to_user(user_name_in IN VARCHAR2,
                               report_guid_in IN RAW);

--  ----------------------------------------------------------------------------
--  IP INTERNAL USE ONLY:  Retrieve the Reports page hGrid data
--  ----------------------------------------------------------------------------
PROCEDURE get_report_hgrid_data (
                title_in           IN  VARCHAR2,
                owner_in           IN  VARCHAR2,
                target_name_in     IN  VARCHAR2,
                target_type_in     IN  VARCHAR2,
                target_guid_in     IN  VARCHAR2,
                locale_in          IN  VARCHAR2,
                report_cursor_out  OUT CURSOR_TYPE
                );
                
--  ----------------------------------------------------------------------------
--   IP INTERNAL USE ONLY:  Delete a Report (all versions and copies of the report)
--  ----------------------------------------------------------------------------
PROCEDURE delete_report (
                report_id_in       IN  VARCHAR2, 
                check_security     IN  INTEGER);
                         
--  ----------------------------------------------------------------------------
--  IP INTERNAL USE ONLY:  Delete a report element given the element guid
--  ----------------------------------------------------------------------------
PROCEDURE delete_report_element (
                report_id_in  VARCHAR2,
                element_id_in IN RAW );
--  ----------------------------------------------------------------------------
--   IP INTERNAL USE ONLY:  Delete a single report version, specifically 
--   the report version's stored data.
--  ----------------------------------------------------------------------------
PROCEDURE delete_report_by_version (report_id_in    IN  VARCHAR2,
                                    version_id_in   IN  VARCHAR2,
                                    check_security  IN  INTEGER);

--  ----------------------------------------------------------------------------
--  EM Reports purge policy entrypoints
--  ----------------------------------------------------------------------------
PROCEDURE do_purge (pcb_params IN OUT MGMT_PURGE_CALLBACK_PARAMS);

PROCEDURE purge_by_version (report_id_in    IN RAW, 
                            num_versions_in IN NUMBER);





PROCEDURE get_alert_data (
                tgt_guid_in              IN  MGMT_IP_TGT_GUID_ARRAY,
                severities_in            IN  MGMT_IP_STRING_ARRAY,
                metric_alert_cursor_out  OUT CURSOR_TYPE,
                avail_alert_cursor_out   OUT CURSOR_TYPE,
                metric_error_cursor_out  OUT CURSOR_TYPE);
                
                
                
FUNCTION getAvailAlertsSQL (
                tgt_guid_in        IN  MGMT_IP_TGT_GUID_ARRAY,
                severities_in      IN  MGMT_IP_STRING_ARRAY)
  RETURN VARCHAR2;                

FUNCTION getMetricAlertsSQL (
                tgt_guid_in        IN  MGMT_IP_TGT_GUID_ARRAY,
                severities_in      IN  MGMT_IP_STRING_ARRAY)
  RETURN VARCHAR2;                
                
FUNCTION getMetricErrorAlertSQL (
                tgt_guid_in        IN  MGMT_IP_TGT_GUID_ARRAY,
                severities_in      IN  MGMT_IP_STRING_ARRAY)
  RETURN VARCHAR2;                
                
FUNCTION getTargetWhere (
                tgt_guid_in        IN  MGMT_IP_TGT_GUID_ARRAY)
  RETURN VARCHAR2;
                
end MGMT_IP;
/
show errors


