Rem
Rem  ip_pkgdef_10_2_0_2_0.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ip_pkgdef_10_2_0_2_0.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    tyhorton    09/12/05 - Adding new delete_report_by_title signature 
Rem    jabramso    08/11/05 - nightly purge - bug 4521067 
Rem    jabramso    08/10/05 - 
Rem    lgloyd      07/28/05 - lgloyd_bug_4502618_plsql
Rem    lgloyd      07/28/05 - beta->production upgrade 
Rem    jabramso    07/20/05 - 
Rem    jabramso    07/13/05 - 
Rem    lgloyd      06/15/05 - sql injection hardening 
Rem    lgloyd      05/16/05 - deregister sql statement 
Rem    lgloyd      05/06/05 - add api to update targets 
Rem    mkm         04/20/05 - adding add_element_to_report_def_internal for 
Rem                           regression tests 
Rem    lgloyd      03/31/05 - add api for regression tests 
Rem    jabramso    03/18/05 - add update_element_type 
Rem    lgloyd      02/28/05 - register sql 
Rem    lgloyd      02/16/05 - help topic 
Rem    jabramso    01/12/05 - Add parm to create for public user 
Rem    tzimmerm    12/21/04 - Purge publish jobs with stored copies 
Rem    lgloyd      12/06/04 - generate context 
Rem    jabramso    12/06/04 - remove revoke_view_report_all wrapper 
Rem    lgloyd      11/26/04 - report params, version 
Rem    lgloyd      11/24/04 - add version to rep def 
Rem    jabramso    10/27/04 - add USER_HAS_PUBLISH_TO_PUBLIC 
Rem    lgloyd      09/23/04 - style, header option 
Rem    jabramso    09/24/04 - more security routines 
Rem    kmanicka    09/20/04 - add user model callbacks
Rem    lgloyd      09/08/04 - custom bean 
Rem    lgloyd      08/25/04 - alerts
Rem    tzimmerm    07/21/04 - Add IP purge functionality 
Rem    lgloyd      07/14/04 - pl/sql api for report defns 
Rem    tzimmerm    05/21/04 - Add delete rpt by version 
Rem    tzimmerm    03/29/04 - 
Rem    tzimmerm    03/26/04 - 
Rem    tzimmerm    03/15/04 - Add JIT target flag to API 
Rem    tzimmerm    02/27/04 - tzimmerm_reports_repos 
Rem    tzimmerm    02/17/04 - Created
Rem
create or replace package MGMT_IP
as

-- type definition
TYPE CURSOR_TYPE IS REF CURSOR;
TYPE GRANT_CURSOR IS REF CURSOR;

--  ----------------------------------------------------------------------------
--  Create a report definition
--  Input:
--      p_title_nlsid         report title (nlsid if translated or
--                            display string if not translated)
--      p_description_nlsid   description (nlsid if translated or
--                            display string if not translated)
--      p_owner               owner name
--      p_category_nlsid      category name (nlsid if translated or
--                            display string if not translated)
--      p_sub_category_nlsid  subcategory name (nlsid if translated or
--                            display string if not translated)
--      p_late_binding_target_types  - target type for late binding, 
--                            or null if not late binding
--      p_late_binding_multi_targets  - 1 if multiple targets are
--                            supported for late binding, otherwise 0
--      p_show_table_of_contents    1=show 0=hide
--      p_system_report       1=system report, 0=end user report      
--      p_custom_bean_class   optional class for customizing report
--      p_internal_use_only   1=internal use only, 0=available to administrators
--      p_pack_name           License pack assoc with this report defintion
--      p_style               Style for rendering
--      p_show_navigation     Show navigation headers in report (tabs, etc)
--      p_product_name        Product name
--      p_component_name      Component name
--      p_version             Product version
--      p_parameters          Report wide parameters
--      p_generate_context    0=viewer's context (default), 1=owner's context
--      p_public              Whether report will show up for public user
--      p_help_topic_id       Help topic id
--  Output:
--      returns guid for report definition
--  ----------------------------------------------------------------------------
FUNCTION create_report_definition (
                p_title_nlsid                       IN VARCHAR2,
                p_description_nlsid                 IN VARCHAR2,
                p_owner                             IN VARCHAR2,
                p_category_nlsid                    IN VARCHAR2,
                p_sub_category_nlsid                IN VARCHAR2,                
                p_late_binding_target_types         IN MGMT_IP_TARGET_TYPES DEFAULT NULL,
                p_late_binding_multi_targets        IN NUMBER DEFAULT 0,
                p_show_table_of_contents            IN NUMBER DEFAULT 0,
                p_system_report                     IN NUMBER DEFAULT 1,
                p_custom_report_bean_class          IN VARCHAR2 DEFAULT NULL,
                p_internal_use_only                 IN NUMBER DEFAULT 0,
                p_pack_name                         IN VARCHAR2 DEFAULT NULL,
                p_style                             IN VARCHAR2 DEFAULT 'BLAF',
                p_show_navigation                   IN NUMBER DEFAULT 1,
                p_product_name                      IN VARCHAR2 DEFAULT 'EM',
                p_component_name                    IN VARCHAR2 DEFAULT '',
                p_version                           IN VARCHAR2 DEFAULT '10.2.0.1.0',
                p_parameters                        IN MGMT_IP_PARAM_VALUE_LIST DEFAULT NULL,
                p_generate_context                  IN NUMBER DEFAULT 0,
                p_public_report                     IN NUMBER DEFAULT 0,
                p_help_topic_id                     IN VARCHAR2 DEFAULT NULL
                ) RETURN RAW;

--  ----------------------------------------------------------------------------
-- ORACLE INTERNAL USE ONLY: This api is provided to create report definitions 
--                       for regression tests
--  ----------------------------------------------------------------------------
FUNCTION create_report_def_internal (
                p_report_guid                       IN RAW,
                p_title_nlsid                       IN VARCHAR2,
                p_description_nlsid                 IN VARCHAR2,
                p_owner                             IN VARCHAR2,
                p_category_nlsid                    IN VARCHAR2,
                p_sub_category_nlsid                IN VARCHAR2,                
                p_late_binding_target_types         IN MGMT_IP_TARGET_TYPES DEFAULT NULL,
                p_late_binding_multi_targets        IN NUMBER DEFAULT 0,
                p_show_table_of_contents            IN NUMBER DEFAULT 0,
                p_system_report                     IN NUMBER DEFAULT 1,
                p_custom_report_bean_class          IN VARCHAR2 DEFAULT NULL,
                p_internal_use_only                 IN NUMBER DEFAULT 0,
                p_pack_name                         IN VARCHAR2 DEFAULT NULL,
                p_style                             IN VARCHAR2 DEFAULT 'BLAF',
                p_show_navigation                   IN NUMBER DEFAULT 1,
                p_product_name                      IN VARCHAR2 DEFAULT 'EM',
                p_component_name                    IN VARCHAR2 DEFAULT '',
                p_version                           IN VARCHAR2 DEFAULT '10.2.0.1.0',
                p_parameters                        IN MGMT_IP_PARAM_VALUE_LIST DEFAULT NULL,
                p_generate_context                  IN NUMBER DEFAULT 0,
                p_public_report                     IN NUMBER DEFAULT 0,
                p_help_topic_id                     IN VARCHAR2 DEFAULT NULL
                ) RETURN RAW;

--  ----------------------------------------------------------------------------
--  Update late binding target types supported by a report definition
--   Input:
--    p_report_guid           report guid
--    p_target_type           Target type assoc with this element type
--    p_add_or_remove         True to add, false to remove
--  ----------------------------------------------------------------------------

PROCEDURE update_late_binding_tgt_type (
                p_report_guid                     IN RAW,
                p_target_type                     IN VARCHAR,
                p_add_or_remove                   IN BOOLEAN
                );

--  ----------------------------------------------------------------------------
--  Add an element to a report definition
--  Input:
--        p_report_guid         guid to identify the report definition       
--        p_element_name_nlsid  element name (nlsid if translated or
--                              display string if not translated)
--        p_element_type_nlsid  element type name (nlsid if translated or
--                              display string if not translated) 
--        p_header_nlslid        element header (nlsid if translated or
--                              display string if not translated), or null
--        p_element_order       order of this element, 1 based
--        p_element_row         row for this element, 1 based
--        p_parameters          parameters for this element
--        p_targets             targets for this element
--        p_header_nlsid        element header (nlsid if translated or
--                              display string if not translated), or null
--                              [fix typo in earlier param]
--  Output:
--      returns guid for this element instance
--  ----------------------------------------------------------------------------
FUNCTION add_element_to_report_def(
                p_report_guid                       IN RAW,
                p_element_name_nlsid                IN VARCHAR2,
                p_element_type_nlsid                IN VARCHAR2,
                p_header_nlslid                     IN VARCHAR2 DEFAULT NULL,
                p_element_order                     IN NUMBER,
                p_element_row                       IN NUMBER,
                p_parameters                        IN MGMT_IP_PARAM_VALUE_LIST,
                p_targets                           IN MGMT_IP_TARGET_LIST,
                p_header_nlsid                      IN VARCHAR2 DEFAULT NULL
                ) RETURN RAW;

--  ----------------------------------------------------------------------------
-- ORACLE INTERNAL USE ONLY: This api is provided to add elements to reports
--                       for regression tests
--  ----------------------------------------------------------------------------
FUNCTION add_element_to_report_internal(
                p_report_guid                       IN RAW,
                p_element_guid                      IN RAW,
                p_element_name_nlsid                IN VARCHAR2,
                p_element_type_nlsid                IN VARCHAR2,
                p_header_nlslid                     IN VARCHAR2 DEFAULT NULL,
                p_element_order                     IN NUMBER,
                p_element_row                       IN NUMBER,
                p_parameters                        IN MGMT_IP_PARAM_VALUE_LIST,
                p_targets                           IN MGMT_IP_TARGET_LIST,
                p_header_nlsid                      IN VARCHAR2 DEFAULT NULL
                ) RETURN RAW;

--  ----------------------------------------------------------------------------
--  Add an element type.  An element type defines what target types are
--    compatiable with an element.
--   Input:
--    p_element_type_nlsid    element type name (nlsid if translated or
--                            display string if not translated)
--    p_target_types          list of target types assoc with this element type
--  ----------------------------------------------------------------------------
PROCEDURE add_element_type (
                p_element_type_nlsid              IN VARCHAR2,
                p_target_types                    IN MGMT_IP_TARGET_TYPES
                );


--  ----------------------------------------------------------------------------
--  Update target types supported by an element type
--  An element type defines which target types are
--  compatiable with an element.
--   Input:
--    p_element_type_nlsid    element type name (nlsid if translated or
--                            display string if not translated)
--    p_target_type           Target type assoc with this element type
--    p_add_or_remove         True to add, false to remove
--  ----------------------------------------------------------------------------

PROCEDURE update_element_type (
                p_element_type_nlsid              IN VARCHAR2,
                p_target_type                     IN VARCHAR,
                p_add_or_remove                   IN BOOLEAN
                );

--  ----------------------------------------------------------------------------
--  Add an element definition
--   Input:
--        p_element_name_nlsid  element name (nlsid if translated or
--                              display string if not translated)
--        p_element_type_nlsid  element type name (nlsid if translated or
--                              display string if not translated) 
--        p_description_nlsid   description (nlsid if translated or
--                              display string if not translated), or null
--        p_element_class_name  name of the class which renders this element
--        p_internal_use_only   1=internal use only, 0=available to administrators
--        p_param_classes       list of parameter controller class names
--        p_default_parameters  list of default parameters
--        p_pack_name           License pack assoc with this element defintion
--        p_product_name        Product name
--        p_component_name      Component name
--        p_version             Product version
--  ----------------------------------------------------------------------------
PROCEDURE add_element_definition (                
                p_element_name_nlsid                IN VARCHAR2,
                p_element_type_nlsid                IN VARCHAR2,
                p_description_nlsid                 IN VARCHAR2,
                p_element_class_name                IN VARCHAR2,
                p_internal_use_only                 IN NUMBER DEFAULT 0, 
                p_param_classes                     IN MGMT_IP_PARAM_CLASSES  DEFAULT NULL,
                p_default_parameters                IN MGMT_IP_PARAM_VALUE_LIST DEFAULT NULL,
                p_pack_name                         IN VARCHAR2 DEFAULT NULL,
                p_product_name                      IN VARCHAR2 DEFAULT 'EM',
                p_component_name                    IN VARCHAR2 DEFAULT '',
                p_version                           IN VARCHAR2 DEFAULT '10.2.0.1.0'
                );

--  ----------------------------------------------------------------------------
--  Add a chart from SQL element definition (for querying against mgmt views)
--   Input:
--        p_element_name_nlsid  element name (nlsid if translated or
--                              display string if not translated)
--        p_element_type_nlsid  element type name (nlsid if translated or
--                              display string if not translated) 
--        p_description_nlsid   description (nlsid if translated or
--                              display string if not translated), or null
--        p_internal_use_only   1=internal use only, 0=available to administrators
--        p_param_classes       list of parameter controller class names
--        p_default_parameters  list of default parameters
--        p_pack_name           License pack assoc with this element defintion
--        p_product_name        Product name
--        p_component_name      Component name
--        p_version             Product version
--        p_query_views         SQL queries against mgmt views (true=1, false=0)
--  ----------------------------------------------------------------------------
PROCEDURE add_chart_from_sql_elem_def (                
                p_element_name_nlsid                IN VARCHAR2,
                p_element_type_nlsid                IN VARCHAR2,
                p_description_nlsid                 IN VARCHAR2,
                p_internal_use_only                 IN NUMBER DEFAULT 0, 
                p_param_classes                     IN MGMT_IP_PARAM_CLASSES  DEFAULT NULL,
                p_default_parameters                IN MGMT_IP_PARAM_VALUE_LIST DEFAULT NULL,
                p_pack_name                         IN VARCHAR2 DEFAULT NULL,
                p_product_name                      IN VARCHAR2 DEFAULT 'EM',
                p_component_name                    IN VARCHAR2 DEFAULT '',
                p_version                           IN VARCHAR2 DEFAULT '10.2.0.1.0',
                p_query_views                       IN NUMBER DEFAULT 1
                );

--  ----------------------------------------------------------------------------
--  Add a table from sql element definition (for querying against mgmt views)
--   Input:
--        p_element_name_nlsid  element name (nlsid if translated or
--                              display string if not translated)
--        p_element_type_nlsid  element type name (nlsid if translated or
--                              display string if not translated) 
--        p_description_nlsid   description (nlsid if translated or
--                              display string if not translated), or null
--        p_internal_use_only   1=internal use only, 0=available to administrators
--        p_param_classes       list of parameter controller class names
--        p_default_parameters  list of default parameters
--        p_pack_name           License pack assoc with this element defintion
--        p_product_name        Product name
--        p_component_name      Component name
--        p_version             Product version
--        p_query_views         SQL queries against mgmt views (true=1, false=0)
--  ----------------------------------------------------------------------------
PROCEDURE add_table_from_sql_elem_def (                
                p_element_name_nlsid                IN VARCHAR2,
                p_element_type_nlsid                IN VARCHAR2,
                p_description_nlsid                 IN VARCHAR2,
                p_internal_use_only                 IN NUMBER DEFAULT 0, 
                p_param_classes                     IN MGMT_IP_PARAM_CLASSES  DEFAULT NULL,
                p_default_parameters                IN MGMT_IP_PARAM_VALUE_LIST DEFAULT NULL,
                p_pack_name                         IN VARCHAR2 DEFAULT NULL,
                p_product_name                      IN VARCHAR2 DEFAULT 'EM',
                p_component_name                    IN VARCHAR2 DEFAULT '',
                p_version                           IN VARCHAR2 DEFAULT '10.2.0.1.0',
                p_query_views                       IN NUMBER DEFAULT 1
                );

--  ----------------------------------------------------------------------------
--  Add image element definition for an image file that ships with EM
--   Input:
--        p_element_name_nlsid  element name (nlsid if translated or
--                              display string if not translated)
--        p_element_type_nlsid  element type name (nlsid if translated or
--                              display string if not translated) 
--        p_description_nlsid   description (nlsid if translated or
--                              display string if not translated), or null
--        p_internal_use_only   1=internal use only, 0=available to administrators
--        p_default_parameters  list of default parameters
--        p_pack_name           License pack assoc with this element defintion
--        p_product_name        Product name
--        p_component_name      Component name
--        p_version             Product version
--  ----------------------------------------------------------------------------
PROCEDURE add_em_image_elem_def (                
                p_element_name_nlsid                IN VARCHAR2,
                p_element_type_nlsid                IN VARCHAR2,
                p_description_nlsid                 IN VARCHAR2,
                p_internal_use_only                 IN NUMBER DEFAULT 0, 
                p_default_parameters                IN MGMT_IP_PARAM_VALUE_LIST DEFAULT NULL,
                p_pack_name                         IN VARCHAR2 DEFAULT NULL,
                p_product_name                      IN VARCHAR2 DEFAULT 'EM',
                p_component_name                    IN VARCHAR2 DEFAULT '',
                p_version                           IN VARCHAR2 DEFAULT '10.2.0.1.0'
                );


--  ----------------------------------------------------------------------------
--  Register a named SQL statement
--  Input:
--      p_product_name        Product name
--      p_component_name      Component name
--      p_version             Product version
--      p_name                Statement name (must be unique)
--      p_sql_statement       SQL statement text
--  ----------------------------------------------------------------------------
PROCEDURE register_sql_statement (
                p_product_name                      IN VARCHAR2 DEFAULT NULL,
                p_component_name                    IN VARCHAR2 DEFAULT NULL,
                p_version                           IN VARCHAR2 DEFAULT NULL,
                p_name                              IN VARCHAR2 DEFAULT NULL,
                p_sql_statement                     IN VARCHAR2 DEFAULT NULL
                );

--  ----------------------------------------------------------------------------
--  Deregister a named SQL statement
--  Input:
--      p_name                Statement name (must be unique)
--  ----------------------------------------------------------------------------
PROCEDURE deregister_sql_statement (
                p_name                              IN VARCHAR2 DEFAULT NULL
                );


--  ----------------------------------------------------------------------------
--  IP INTERNAL USE ONLY:  Grant access to report to the specified user
--  ----------------------------------------------------------------------------
PROCEDURE grant_report_to_user(user_name_in IN VARCHAR2,
                               report_guid_in IN RAW);


--  ----------------------------------------------------------------------------
-- IP INTERNAL USE ONLY: determine if a user has the publish to public
--                       system privilege
--  ----------------------------------------------------------------------------

FUNCTION USER_HAS_PUBLISH_TO_PUBLIC (user_name_in IN VARCHAR2)
RETURN NUMBER;

--  ----------------------------------------------------------------------------
--  IP INTERNAL USE ONLY:  Get owner/grantee for specified report
--  ----------------------------------------------------------------------------
PROCEDURE get_report_grants (report_guid_in IN RAW,
                             owner_out OUT VARCHAR2,
                             grantees_out OUT GRANT_CURSOR);

                
--  ----------------------------------------------------------------------------
--   IP INTERNAL USE ONLY:  Delete a Report (all versions and copies of the
--                          report) given its owner and title
--  ----------------------------------------------------------------------------
PROCEDURE delete_report_by_title (report_owner_in    IN  VARCHAR2,
                                  report_title_in    IN  VARCHAR2,
                                  check_security     IN  INTEGER);

--  ----------------------------------------------------------------------------
--   IP INTERNAL USE ONLY:  Delete a Report (all versions and copies of the
--                          report) given its owner and title
--  ----------------------------------------------------------------------------
PROCEDURE delete_report_by_title (report_owner_in    IN  VARCHAR2,
                                  report_title_in    IN  VARCHAR2,
                                  is_system_report   IN  INTEGER,
                                  check_security     IN  INTEGER);

--  ----------------------------------------------------------------------------
--   IP INTERNAL USE ONLY:  Delete a Report (all versions and copies of the report)
--  ----------------------------------------------------------------------------
PROCEDURE delete_report (
                report_id_in       IN  VARCHAR2, 
                check_security     IN  INTEGER);
                         
--  ----------------------------------------------------------------------------
--  IP INTERNAL USE ONLY:  Delete a report element given the element guid
--  ----------------------------------------------------------------------------
PROCEDURE delete_report_element (
                report_id_in  VARCHAR2,
                element_id_in IN RAW );
--  ----------------------------------------------------------------------------
--   IP INTERNAL USE ONLY:  Delete a single report version, specifically 
--   the report version's stored data.
--  ----------------------------------------------------------------------------
PROCEDURE delete_report_by_version (report_id_in    IN  VARCHAR2,
                                    version_id_in   IN  VARCHAR2,
                                    check_security  IN  INTEGER);

--  ----------------------------------------------------------------------------
--  EM Reports purge policy entrypoints
--  ----------------------------------------------------------------------------
PROCEDURE do_purge (pcb_params IN OUT MGMT_PURGE_CALLBACK_PARAMS);

PROCEDURE purge_by_keep_versions (report_id_in    IN RAW, 
                                  num_versions_in IN NUMBER,
                                  rows_purged     OUT NUMBER);

PROCEDURE purge_by_keep_days (report_id_in    IN RAW, 
                              num_intervals   IN NUMBER,
                              interval_type   IN NUMBER,
                              rows_purged     OUT NUMBER);

-- Delete the  runs for the job with the specified job id
-- and scheduled time
-- This is used by the mgmt_ip package to be used during nightly purge
-- of saved copies of reports
PROCEDURE purge_old_jobs(p_job_id RAW, p_scheduled_time DATE);


PROCEDURE get_alert_data (
                tgt_guid_in              IN  MGMT_IP_TGT_GUID_ARRAY,
                severities_in            IN  MGMT_IP_STRING_ARRAY,
                metric_alert_cursor_out  OUT CURSOR_TYPE,
                avail_alert_cursor_out   OUT CURSOR_TYPE,
                metric_error_cursor_out  OUT CURSOR_TYPE);
                
                
                
FUNCTION getAvailAlertsSQL (
                tgt_guid_in        IN  MGMT_IP_TGT_GUID_ARRAY,
                severities_in      IN  MGMT_IP_STRING_ARRAY)
  RETURN CURSOR_TYPE;

FUNCTION getMetricAlertsSQL (
                tgt_guid_in        IN  MGMT_IP_TGT_GUID_ARRAY,
                severities_in      IN  MGMT_IP_STRING_ARRAY)
  RETURN CURSOR_TYPE;
                


PROCEDURE getParamsAndTargets(rpt_id_in IN RAW,
                              elem_id_in IN RAW,
                              elemName_in IN VARCHAR2,
                              elemType_in IN VARCHAR2,
                              report_context_in IN VARCHAR2,
                              def_params_cursor_out OUT CURSOR_TYPE,
                              all_params_cursor_out OUT CURSOR_TYPE,
                              classes_cursor_out OUT CURSOR_TYPE,
                              targets_cursor_out OUT CURSOR_TYPE);

PROCEDURE getTargetsFromRep(rpt_id_in           IN RAW,
                            elem_id_in          IN RAW,
                            report_context_in   IN VARCHAR2,
                            targets_cursor_out  OUT CURSOR_TYPE);


PROCEDURE getElementsFromRep(rpt_id_in           IN  RAW,
                             msg_class_in        IN VARCHAR2,
                             lang_code_in        IN VARCHAR2,
                             country_code_in     IN VARCHAR2,
                             elements_cursor_out OUT CURSOR_TYPE);


PROCEDURE getReportFromRep(
                rpt_id_in          IN  RAW,
                rpt_title_in       IN VARCHAR2,
                rpt_owner_in       IN VARCHAR2,
                msg_class_in       IN VARCHAR2,
                lang_code_in       IN VARCHAR2,
                country_code_in    IN VARCHAR2,
                create_like_in     IN VARCHAR2,
                current_user_in    IN VARCHAR2,
                reports_cursor_out OUT CURSOR_TYPE,
                elements_cursor_out OUT CURSOR_TYPE,
                jit_targets_cursor_out OUT CURSOR_TYPE,
                rw_targets_cursor_out OUT CURSOR_TYPE,
                rw_params_cursor_out OUT CURSOR_TYPE,
                if_stored_out OUT VARCHAR2,
                owner_out OUT VARCHAR2,
                grantees_out OUT GRANT_CURSOR,
                pub_to_public_out OUT NUMBER);

--

FUNCTION getMetricErrorAlertSQL (
                tgt_guid_in        IN  MGMT_IP_TGT_GUID_ARRAY,
                severities_in      IN  MGMT_IP_STRING_ARRAY)
  RETURN CURSOR_TYPE;
                
  
--
-- PROCEDURE : get_user_report_defs
--
-- PURPOSE
--
--   this is a callback which will be registered to the user_model pkg 
--   user_model pkg will call this procedure to get a list of report_defs which the 
--   user has
--  
-- PARAMETERS
--
--  user_name_in     - name of the user
--  user_objects_out - list of report_defs will be appended to user_objects_out
--  type_in          - type of user model callback
--
-- NOTES
--
  
  PROCEDURE get_user_report_defs(user_name_in      IN VARCHAR2,
                                 user_objects_out  OUT MGMT_USER_OBJECTS,
                                 type_in           IN NUMBER);

--
-- PROCEDURE : drop_user_report_defs
--
-- PURPOSE
--
--   this is a callback which will be registered to the user_model pkg 
--   user_model pkg will call this procedure to delete the report_defs
--   owned by a user.
--  
-- PARAMETERS
--
--  user_name_in     - name of the user
--  type_in          - type of user model callback
--
-- NOTES
--
        
  PROCEDURE drop_user_report_defs(user_name_in      IN VARCHAR2,
                                  type_in           IN NUMBER);


--
-- PROCEDURE : reassign_user_report_defs
--
-- PURPOSE
--
--   this is a callback which will be registered to the user_model pkg 
--   user_model pkg will call this procedure to reassign the report_defs
--   owned by a user to a new user.
--  
-- PARAMETERS
--
--  user_name_in     - name of the user
--  new_user_name_in - the new user name
--  type_in          - type of user model callback
--
-- NOTES
--
        
  PROCEDURE reassign_user_report_defs(user_name_in      IN VARCHAR2,
                                      new_user_name_in  IN VARCHAR2,
                                      type_in           IN NUMBER);

                
end MGMT_IP;
/
show errors

