Rem
Rem $Header: ip_post_creation_10_2_0_1_0.sql 04-jul-2005.00:00:21 gsbhatia Exp $
Rem
Rem ip_post_creation_10_2_0_1_0.sql
Rem
Rem Copyright (c) 2003, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ip_post_creation_10_2_0_1_0.sql - Repository operations to be completed
Rem                                        for the Reporting Framework immediately 
Rem                                        after successful repository creation.
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/04/05 - Removing repmgr header 
Rem    tzimmerm    06/07/05 - tzimmerm_bug-4393605
Rem    tzimmerm    06/06/05 - Modify for upgrade 
Rem    tzimmerm    01/26/05 - Register publish job command 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    kmanicka    09/21/04 - add user model callbacks
Rem    tzimmerm    08/09/04 - tzimmerm_ip_purge
Rem    tzimmerm    07/21/04 - Created

Rem

-- Register reporting job command
BEGIN
  MGMT_JOBS.REGISTER_COMMAND('PublishReport', 'oracle.sysman.emdrep.jobs.commands.PublishReport');
END;
/

-- register user model callbacks
BEGIN
    MGMT_USER.add_callback('MGMT_IP.get_user_report_defs', MGMT_USER.GET_USER_OBJECTS_CALLBACK);
    MGMT_USER.add_callback('MGMT_IP.drop_user_report_defs', MGMT_USER.USER_DROPPED_CALLBACK);
    MGMT_USER.add_callback('MGMT_IP.reassign_user_report_defs', MGMT_USER.USER_REASSIGN_CALLBACK);
END;
/


BEGIN
  EM_PURGE.add_purge_policy('MGMT_IP_STORED_REPORTS',             -- Policy name
                            EM_PURGE.G_POLICY_TYPE_SYSTEM,        -- Policy type
                            'MGMT_IP.DO_PURGE',                   -- Purge procedure name
                            24,                                   -- Retention hours (run do_purge() once a day)
                            NULL,                                 -- No rollup procedure
                            'Purge policy for EM Information Publisher',  -- Policy description
                            NULL);                                 -- Retention group name
  commit;
END;
/

