Rem
Rem $Header: ip_tables_10_2_0_1_0.sql 19-jul-2005.14:30:28 lgloyd Exp $
Rem
Rem ip_tables_10_2_0_1_0.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ip_tables_10_2_0_1_0.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       lgloyd   07/19/05 - beta->production upgrade 
Rem

rem === IMPORTANT =============================================
rem DO NOT MODIFY THIS FILE - ANY MODIFICATIONS FOR THE 10.2 PRODUCTION RELEASE
rem MUST BE MADE IN IP_TABLES_10_2_0_2_0.SQL.
rem
rem This is to preserve consistency between the upgrade schema script and the 
rem newly created schema scripts.
rem ===========================================================


rem
rem This script requires the following arguments
rem  1. Name of the ecm_depot tablespace where all LOBs are stored
rem
DEFINE EM_ECM_DEPOT_TABLESPACE = "&1"


rem
rem MGMT_IP_REPORT_DEF
rem
rem PURPOSE
rem   The MGMT_IP_REPORT_DEF table is the table that stores basic information 
rem   saved and pre-canned reports.  Using the report_id the report can be 
rem   published or viewed.
rem
rem COLUMNS
rem
rem   REPORT_GUID		  Report definition unique identifier 
rem
rem   SCHEDULE_GUID       Schedule identifier.  Join with MGMT_IP_REPORT_SCHEDULE table to obtain
rem                       schedule for a given report instance.
rem
rem   SCHEDULE_ENABLED    Indicates whether or not this report follows a schedule.
rem                       0 (default) = not scheduled; else scheduled.
rem
rem   STORE_ENABLED       Indicates whether or not this report should store copies 
rem                       according to the schedule. 0 (default) = don't store; else store.
rem
rem   PURGE_POLICY_GUID   Purge policy identifier.   Join with the MGMT_IP_PURGE_POLICY table 
rem                       to obtain policy for a given report.
rem
rem   TITLE_NLSID         Report name as assigned by the user
rem
rem   DESCRIPTION_NLSID   Detailed description of report content
rem
rem   OWNER               Administrator that created the report (defaults to ??? for pre-canned reports)
rem
rem   CATEGORY_NLSID      The report category (ie: General, Events/Jobs, Availability, etc.)
rem
rem   SUB_CATEGORY_NLSID  The report sub-category or further classification of category
rem
rem   LAST_PUBLISHED      Date report was last saved or published.  
rem                       Performance optimization (original date actually kept in MGMT_IP_STORED_REPORT) 
rem
rem   LAST_EDIT_TIME      Last report modification date.
rem
rem   LAST_EDIT_BY        Last modified by administrator
rem
rem   IS_JIT_TARGET       Prompt user for targets at report generation time, 
rem                       i.e. targets have late binding.
rem                       Targets are not saved with report element definitions
rem
rem   IS_JIT_MULTI_TARGET Set to true (1) if multiple targest can be supplied
rem                       at late binding time.  Normally only one target is supplied.
rem
rem   ADD_TOC             Flag to add a table of contents to the report 
rem
rem   PUBLISH_TO_PUBLIC   Flag indicating that the report is published to the PUBLIC REPORTS
rem                       user.
rem   SYSTEM_REPORT       Flag indicating that this report is a pre-canned report supplied
rem                       by the reporting framework. These reports are visible to all users.
rem                       Also, system reports cannot be edited or deleted.
rem   CUSTOM_REPORT_BEAN_CLASS   Deprecated:  Optional class name of a custom bean associated with 
rem                       this report definition.  This class must implement the
rem                       oracle.sysman.eml.ip.render.CustomReportBean interface.
rem   INTERNAL_ONLY       Flag indicating that the report  is internal to Oracle and not 
rem                       available for selection in the navigator.
rem   PACK_NAME           Name of Pack for this functionality, or null
rem
rem   STYLE               Name of style to use to display report 'BLAF' (default) 
rem                       or 'DASHBOARD' (alternate)
rem
rem   SHOW_NAVIGATION     Set to true(1) to show navigation (headers and 
rem                       footers, buttons) in report container.  
rem
rem   PRODUCT_NAME        Product Name, 'EM' (default)
rem 
rem   COMPONENT_NAME      Product Component Name,  '' (default)
rem
rem   VERSION             Product Version, '10.2.0.1.0' (default)
rem
rem   GENERATE_CONTEXT    0=viewer's context(default), 1=owner's context 
rem
rem   HELP_TOPIC_ID       help id for this report definition

CREATE TABLE MGMT_IP_REPORT_DEF
(
    REPORT_GUID	         RAW(16)        default SYS_GUID(),        
    SCHEDULE_GUID        RAW(16)        default null, 
    SCHEDULE_ENABLED     NUMBER(1)      default 0,
    STORE_ENABLED        NUMBER(1)      default 0,
    PURGE_POLICY_GUID    RAW(16)        default null,       
    TITLE_NLSID          VARCHAR2(100)	not null,
    DESCRIPTION_NLSID    VARCHAR2(500)	default null,
    OWNER                VARCHAR2(256)  not null,    
    CATEGORY_NLSID       VARCHAR2(100)	not null,
    SUB_CATEGORY_NLSID   VARCHAR2(100)	not null,
    LAST_PUBLISHED       DATE           default null,   
    LAST_EDIT_TIME       DATE           default null,	 
    LAST_EDIT_BY         VARCHAR2(256)   default null,  
    IS_JIT_TARGET        NUMBER(1)      default 1,       -- JIT=just in time, user will select targets for this 
                                                         -- report immediately prior to report generation.
    IS_JIT_MULTI_TARGET  NUMBER(1)      default 0,       -- true if multiple late binging targets can be supplied
    ADD_TOC              NUMBER(1)      default 0,       -- show table of contents if 1
    PUBLISH_TO_PUBLIC    NUMBER(1)      default 0,
    SYSTEM_REPORT        NUMBER(1)      default 0,
    CUSTOM_REPORT_BEAN_CLASS  VARCHAR(500)  default null, -- deprecated
    INTERNAL_ONLY        NUMBER         default 0,
    PACK_NAME            VARCHAR2(64)   default null,
    STYLE                VARCHAR2(64)   default 'BLAF',
    SHOW_NAVIGATION      NUMBER(1)      default 1,
    PRODUCT_NAME         VARCHAR2(100)  default 'EM',
    COMPONENT_NAME       VARCHAR2(100)  default '',
    VERSION              VARCHAR2(100)  default '10.2.0.1.0',
    GENERATE_CONTEXT     NUMBER(1)      default 0,
    HELP_TOPIC_ID        VARCHAR(256)   default null,
    CONSTRAINT MGMT_IP_REPORT_PK PRIMARY KEY (REPORT_GUID)
) MONITORING;


rem
rem MGMT_IP_REPORT_DEF_JIT_TYPES
rem
rem PURPOSE
rem   The MGMT_IP_REPORT_DEF_JIT_TYPES table stores late binding (just in time)
rem   target types for a report definition.  Any target of a type that is in the
rem   set of late binding target types can be chosen as a report is 
rem   generated.
rem
rem
rem COLUMNS
rem
rem   REPORT_GUID		  Report definition unique identifier 
rem
rem   TARGET_TYPE     Valid target type for late binding
rem

CREATE TABLE MGMT_IP_REPORT_DEF_JIT_TYPES 
(
    REPORT_GUID 		    RAW(16), 
    TARGET_TYPE 		    VARCHAR(64)
) MONITORING;



rem
rem MGMT_IP_REPORT_DEF_ELEMENTS
rem
rem PURPOSE
rem   The MGMT_IP_REPORT_DEF_ELEMENTS table is the table that stores the elements
rem   for a report.  The elements are instances of an element which have associated 
rem   parameters from the MGMT_IP_REPORT_ELEM_PARAMS table.
rem
rem   NOTE:  All columns with names ending in "_NLSID" are columns that need to
rem          join with MGMT_MESSAGES to obtain the actual translated
rem          text string.
rem
rem COLUMNS
rem
rem   REPORT_GUID		  Report definition unique identifier 
rem
rem   ELEMENT_GUID        Element unique identifier
rem 
rem   ELEMENT_NAME_NLSID  Element name NLSID  
rem   
rem   ELEMENT_TYPE_NLSID  Element type NLSID
rem
rem   HEADER_NLDID        User defined element header text.
rem
rem   ELEMENT_ORDER       The order in which report elements appear when the report
rem                       is generated.
rem
rem   ELEMENT_ROW         Two elements are allowed on a "row" in a report.   In other
rem                       words, 2 elements can be positioned side by side.  
rem
rem   SUPPRESS_RENDER     Flag = 1 if element rendering is to be suppressed for 
rem                       any reason.
rem

CREATE TABLE MGMT_IP_REPORT_DEF_ELEMENTS 
(
    REPORT_GUID 	      RAW(16), 
    ELEMENT_GUID      	RAW(16), 
    IMAGE_GUID          RAW(16),
    ELEMENT_NAME_NLSID  VARCHAR(256),    
    ELEMENT_TYPE_NLSID  VARCHAR(100),    
    HEADER_NLSID        VARCHAR(200),
    ELEMENT_ORDER 	    NUMBER,
    ELEMENT_ROW         NUMBER,
    SUPPRESS_RENDER     NUMBER,
    CONSTRAINT MGMT_IP_REPORT_ELEM_PK PRIMARY KEY (REPORT_GUID, ELEMENT_GUID)
) MONITORING;

rem
rem MGMT_IP_REPORT_ELEM_PARAMS
rem
rem PURPOSE
rem   The MGMT_IP_REPORT_ELEM_PARAMS table is the table that stores the parameters
rem   for the instance of a report element.   There will be one record for each
rem   parameter defined for a given element instance.
rem
rem   NOTE:  All columns with names ending in "_NLSID" are columns that need to
rem          join with MGMT_MESSAGES to obtain the actual translated
rem          text string.
rem
rem COLUMNS
rem
rem   REPORT_GUID		  Report definition unique identifier 
rem
rem   ELEMENT_GUID        Element unique identifier
rem 
rem   PARAM               The name/key for an element parameter.
rem
rem   VALUE               Parameter value
rem

CREATE TABLE MGMT_IP_REPORT_ELEM_IMAGE 
(
    REPORT_GUID     RAW(16),
    ELEMENT_GUID    RAW(16),
    IMAGE_GUID      RAW(16),
    IMAGE_DATA      BLOB,
    CONSTRAINT MGMT_IP_IMAGE_PK PRIMARY KEY (REPORT_GUID, ELEMENT_GUID, IMAGE_GUID)
) MONITORING
  LOB(IMAGE_DATA) STORE AS (TABLESPACE &EM_ECM_DEPOT_TABLESPACE);

rem
rem MGMT_IP_REPORT_ELEM_PARAMS
rem
rem PURPOSE
rem   The MGMT_IP_REPORT_ELEM_PARAMS table is the table that stores the parameters
rem   for the instance of a report element.   There will be one record for each
rem   parameter defined for a given element instance.
rem
rem   NOTE:  All columns with names ending in "_NLSID" are columns that need to
rem          join with MGMT_MESSAGES to obtain the actual translated
rem          text string.
rem
rem COLUMNS
rem
rem   REPORT_GUID		  Report definition unique identifier 
rem
rem   ELEMENT_GUID        Element unique identifier
rem 
rem   PARAM               The name/key for an element parameter.
rem
rem   VALUE               Parameter value
rem

CREATE TABLE MGMT_IP_REPORT_ELEM_PARAMS 
(
    REPORT_GUID     RAW(16),
    ELEMENT_GUID    RAW(16),
    PARAM 		      VARCHAR(100), 
    VALUE 		      CLOB,
    CONSTRAINT MGMT_IP_REPORT_ELEM_PARAMS_PK PRIMARY KEY (REPORT_GUID, ELEMENT_GUID, PARAM)
) MONITORING
  LOB(VALUE) STORE AS (TABLESPACE &EM_ECM_DEPOT_TABLESPACE);

rem
rem MGMT_IP_REPORT_ELEM_TARGETS
rem
rem PURPOSE
rem   The MGMT_IP_REPORT_ELEM_TARGETS table is the table that stores 
rem   the targets associated or selected for a report element instance.
rem
rem COLUMNS
rem
rem   REPORT_GUID		  Report definition unique identifier 
rem
rem   ELEMENT_GUID        Element unique identifier
rem 
rem   TARGET_GUID         Target guid
rem
rem   TARGET_NAME         Target name
rem
rem   TARGET_TYPE         Target type
rem
rem   TIMEZONE_REGION     The timezone region name the target operates in
rem

CREATE TABLE MGMT_IP_REPORT_ELEM_TARGETS
(
    REPORT_GUID		  RAW(16)         not null,
    ELEMENT_GUID	  RAW(16)         not null,
    TARGET_GUID     RAW(16)         default '0',        
    TARGET_NAME	    VARCHAR2(256)   not null,      
    TARGET_TYPE	    VARCHAR2(64)    not null,    
    TIMEZONE_REGION VARCHAR2(64)    DEFAULT NULL,
    CONSTRAINT MGMT_IP_ELEM_TARGETS_PK PRIMARY KEY (REPORT_GUID, ELEMENT_GUID, TARGET_GUID)    
) MONITORING;

rem
rem MGMT_IP_STORED_REPORT
rem
rem PURPOSE
rem   The MGMT_IP_STORED_REPORT table contains the data for a stored report.
rem   Stored reports are not stored html.  Each report element that is stored
rem   for a report will store serialized data that can be used to reconstruct 
rem   the report.   The report data is in the ELEMENT_OBJECT column.
rem   Report targets are found in MGMT_IP_REPORT_ELEM_TARGETS table.
rem
rem COLUMNS
rem
rem   REPORT_GUID		  Report definition unique identifier 
rem
rem   ELEMENT_GUID        Element unique identifier
rem 
rem   GENERATED_DATE      Date report was generated/stored (in UTC timzone)
rem
rem   VERSION_GUID        Unique identifier of a single version of a report
rem                       (ease of use on URL)
rem  
rem   STATUS              Optional report generation status or error
rem
rem   ELEMENT_OBJECT      BLOB containing data for a report element
rem


CREATE TABLE MGMT_IP_STORED_REPORT 
(
    REPORT_GUID 	      RAW(16)         not null,
    ELEMENT_GUID        RAW(16)         not null,
    GENERATED_DATE      DATE            not null, 
    VERSION_GUID        RAW(16)         default SYS_GUID(),
    STATUS              VARCHAR(4000)   default null,
    ELEMENT_OBJECT      BLOB,
    CONSTRAINT MGMT_IP_STORED_REPORT_PK PRIMARY KEY (REPORT_GUID, ELEMENT_GUID, VERSION_GUID)
) MONITORING
  LOB(ELEMENT_OBJECT) STORE AS (TABLESPACE &EM_ECM_DEPOT_TABLESPACE);


rem
rem MGMT_IP_REPORT_ELEM_DEF
rem
rem PURPOSE
rem   The MGMT_IP_REPORT_ELEM_DEF table stores metaadata for an element type 
rem   as well as the classes that renders an element of this type (pie chart)) 
rem   and render this element's parameter page.
rem
rem   NOTE:  All columns with names ending in "_NLSID" are columns that need to
rem          join with MGMT_MESSAGES to obtain the actual translated
rem          text string.
rem
rem COLUMNS
rem
rem   ELEMENT_NAME_NLSID    Element name NLSID
rem 
rem   ELEMENT_TYPE_NLSID    Element type NLSID
rem 
rem   DESCRIPTION_NLSID     Description NLSID
rem
rem   INTERNAL_ONLY         Flag indicating that the element is internal to Oracle and not 
rem                         available for selection in the UI.
rem 
rem   PACK_NAME             Name of Pack for this functionality, or null
rem
rem   ELEMENT_CLASS         Element class (ie: for a precanned pie chart controller the 
rem                         class could be "oracle.sysman.eml.ip.render.elem.PieChartRenderController"
rem
rem   PRODUCT_NAME          Product Name, 'EM' (default)
rem 
rem   COMPONENT_NAME        Product Component Name,  '' (default)
rem
rem   VERSION               Product Version, '10.2.0.1.0' (default)
rem

CREATE TABLE MGMT_IP_REPORT_ELEM_DEF 
(
    ELEMENT_NAME_NLSID    VARCHAR(256),
    ELEMENT_TYPE_NLSID    VARCHAR(100), 
    DESCRIPTION_NLSID     VARCHAR(256),
    ELEMENT_CLASS         VARCHAR(1000) default null,
    INTERNAL_ONLY         NUMBER        default 0,
    PACK_NAME             VARCHAR2(64)  default null,
    PRODUCT_NAME          VARCHAR2(100) default 'EM',
    COMPONENT_NAME        VARCHAR2(100) default '',
    VERSION               VARCHAR2(100) default '10.2.0.1.0',
  CONSTRAINT MGMT_IP_ELEM_TYPE_DEF_PK PRIMARY KEY (ELEMENT_NAME_NLSID, ELEMENT_TYPE_NLSID)        
) MONITORING;

rem
rem MGMT_IP_ELEM_TARGET_TYPES
rem
rem PURPOSE
rem   The MGMT_IP_ELEM_TARGET_TYPES table stores valid target types for 
rem   a report element of a specific type.  For example an element that reports
rem   on database instance parameters may allow oracle_database, rac or 
rem   oracle_database_group as valid target types.
rem 
rem   NOTE:  All columns with names ending in "_NLSID" are columns that need to
rem          join with MGMT_MESSAGES to obtain the actual translated
rem          text string.
rem
rem COLUMNS
rem
rem   ELEMENT_NAME_NLSID    Element name NLSID
rem 
rem   ELEMENT_TYPE_NLSID    Element type NLSID
rem 
rem   TARGET_TYPE           Internal target type name
rem

CREATE TABLE MGMT_IP_ELEM_TARGET_TYPES 
(
    ELEMENT_TYPE_NLSID    VARCHAR2(100)    not null, 
    TARGET_TYPE           VARCHAR2(64)     not null,
    CONSTRAINT PK_ELEMENT_TARGET_TYPES PRIMARY KEY(ELEMENT_TYPE_NLSID, TARGET_TYPE)  
)  MONITORING;

rem
rem MGMT_IP_ELEM_PARAM_CLASSES
rem
rem PURPOSE
rem   The MGMT_IP_ELEM_PARAM_CLASSES table stores parameter controller 
rem   class names for a report element of a specific type.  For example 
rem   an element that requires a timeperiod and a metric name may include
rem   a time period param controller and a metric name param controller.
rem 
rem   NOTE:  All columns with names ending in "_NLSID" are columns that need to
rem          join with MGMT_MESSAGES to obtain the actual translated
rem          text string.
rem
rem COLUMNS
rem
rem   ELEMENT_NAME_NLSID    Element name NLSID
rem 
rem   ELEMENT_TYPE_NLSID    Element type NLSID
rem 
rem   ELEMENT_PARAM_CLASS   Parameter class (ie: for a precanned pie chart param controller the 
rem                         class could be "oracle.sysman.eml.ip.render.elem.PieChartParamController"
rem
rem   DISPLAY_ORDER         Order in which parameter controllers should be rendered
rem

CREATE TABLE MGMT_IP_ELEM_PARAM_CLASSES 
(
    ELEMENT_NAME_NLSID    VARCHAR2(256)    not null,
	  ELEMENT_TYPE_NLSID    VARCHAR2(100)    not null, 
    ELEMENT_PARAM_CLASS   VARCHAR(1000),
    DISPLAY_ORDER         NUMBER, 
    CONSTRAINT PK_ELEMENT_PARAM_CLASSES PRIMARY KEY(ELEMENT_NAME_NLSID, ELEMENT_TYPE_NLSID, ELEMENT_PARAM_CLASS, DISPLAY_ORDER)  
)  MONITORING;

rem
rem MGMT_IP_ELEM_DEFAULT_PARAMS
rem
rem PURPOSE
rem   The MGMT_IP_ELEM_DEFAULT_PARAMS table is the table that stores
rem   default parameters for an element definition.
rem   There will be one record for each default parameter defined for a given 
rem   element definition.
rem
rem   NOTE:  All columns with names ending in "_NLSID" are columns that need to
rem          join with MGMT_MESSAGES to obtain the actual translated
rem          text string.
rem
rem COLUMNS
rem
rem   ELEMENT_NAME_NLSID	Element name 
rem
rem   ELEMENT_TYPE_NLSID  Element type
rem 
rem   PARAM               The name/key for an element parameter.
rem
rem   VALUE               Parameter value
rem

CREATE TABLE MGMT_IP_ELEM_DEFAULT_PARAMS 
(
    ELEMENT_NAME_NLSID    VARCHAR2(256)    not null,
	  ELEMENT_TYPE_NLSID    VARCHAR2(100)    not null, 
    PARAM 		            VARCHAR(100), 
    VALUE 		            CLOB,
    CONSTRAINT MGMT_IP_ELEM_DEFAULT_PARAMS_PK PRIMARY KEY (ELEMENT_NAME_NLSID, ELEMENT_TYPE_NLSID, PARAM)
) MONITORING
  LOB(VALUE) STORE AS (TABLESPACE &EM_ECM_DEPOT_TABLESPACE);

rem
rem MGMT_IP_SQL_STATEMENTS
rem
rem PURPOSE
rem   The MGMT_IP_SQL_STATEMENTS stores sql statements used by OOTB report elements.
rem
rem COLUMNS
rem
rem   PRODUCT_NAME        Product Name, 'EM' (default)
rem 
rem   COMPONENT_NAME      Product Component Name,  '' (default)
rem
rem   VERSION             Product Version, '10.2.0.1.0' (default)
rem
rem   NAME                Name for this SQL statement (must be unique)

CREATE TABLE MGMT_IP_SQL_STATEMENTS
(
    PRODUCT_NAME         VARCHAR2(100)  default 'EM',
    COMPONENT_NAME       VARCHAR2(100)  default '',
    VERSION              VARCHAR2(100)  default '10.2.0.1.0',
    NAME                 VARCHAR(256)   default null,
    SQL_STATEMENT        CLOB,
    CONSTRAINT MGMT_IP_SQL_PK PRIMARY KEY (NAME)
) MONITORING
  LOB(SQL_STATEMENT) STORE AS (TABLESPACE &EM_ECM_DEPOT_TABLESPACE);

rem
rem MGMT_IP_REPORT_NLS_MAP
rem
rem PURPOSE
rem   The MGMT_IP_REPORT_NLS_MAP table contains the translated strings for report
rem   titles, descriptions, categories and sub_categories as well as element
rem   names, types and descriptions.   For pre-canned reports the LOCALE will be
rem   NULL.
rem
rem  COLUMNS
rem 
rem   NLSID         NLS identifier used for mapping translated report titles, 
rem                 descriptions, catetories, elements, etc.
rem
rem   LOCALE        Java locale used to map NLS strings
rem   
rem   NLS_STRING    Translated string
rem

CREATE TABLE MGMT_IP_REPORT_NLS_MAP 
(
    NLSID           VARCHAR2(1000),
    LOCALE          VARCHAR2(5),
    NLS_STRING      VARCHAR2(1000),
  CONSTRAINT PK_MGMT_IP_NLS_MAP PRIMARY KEY (nlsid, locale)        
) MONITORING;

rem
rem MGMT_IP_PURGE_POLICY
rem
rem PURPOSE
rem   The MGMT_IP_PURGE_POLICY table is the table that stores report
rem   purge policy settings.  Users can choose *either* a number of 
rem   report versions to retain OR a number of days to retain copies.
rem
rem COLUMNS
rem 
rem   PURGE_POLICY_GUID - policy unique identifier
rem
rem   KEEP_NUM_VERSIONS - number of days to retain stored copies of reports
rem
rem   KEEP_NUM_DAYS - number of days to keep reports prior to purging.
rem

CREATE TABLE MGMT_IP_PURGE_POLICY
(
    PURGE_POLICY_GUID		    RAW(16)     NOT NULL,
    REPORT_GUID             RAW(16)     NOT NULL,
    KEEP_NUM_VERSIONS       NUMBER(4)   default 0,
    RETENTION_INTERVAL      NUMBER(4)   default 0,
    NUM_INTERVALS           NUMBER(4)   default 0   
) MONITORING ;

CREATE TABLE MGMT_IP_EMAIL_REPORT
(
    REPORT_GUID             RAW(16)        NOT NULL,
    EMAIL_ENABLED           NUMBER(1)      DEFAULT 0,
    EMAIL_SUBJECT           VARCHAR2(300),
    EMAIL_SENDER            VARCHAR2(100)  NOT NULL,   
    EMAIL_RECIPIENTS        VARCHAR2(4000) NOT NULL
) MONITORING ;


