Rem
Rem $Header: ip_tables_10_2_0_2_0.sql 20-jul-2005.14:12:33 lgloyd Exp $
Rem
Rem ip_tables_10_2_0_2_0.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ip_tables_10_2_0_2_0.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       lgloyd   07/20/05 - lgloyd_bug-4502618
Rem       lgloyd   07/19/05 - beta->production upgrade 
Rem

rem
rem This script requires the following arguments
rem  1. Name of the ecm_depot tablespace where all LOBs are stored
rem
DEFINE EM_ECM_DEPOT_TABLESPACE = "&1"

rem This script updates the 10.2.0.1.0 table definitions to the 10.2.0.2.0 
rem table definitions.

rem
rem MGMT_IP_REPORT_DEF
rem
rem PURPOSE
rem   The MGMT_IP_REPORT_DEF table is the table that stores basic information 
rem   saved and pre-canned reports.  Using the report_id the report can be 
rem   published or viewed.
rem
rem COLUMNS
rem
rem   LAST_PUBLISHED_UTC  Date report was last saved or published in UTC timezone.  
rem                       Performance optimization (original date actually kept in MGMT_IP_STORED_REPORT) 
rem
rem   LAST_EDIT_TIME_UTC  Last report modification date in UTC timezone.
rem

ALTER TABLE MGMT_IP_REPORT_DEF 
  RENAME COLUMN LAST_PUBLISHED TO LAST_PUBLISHED_UTC;

ALTER TABLE MGMT_IP_REPORT_DEF 
  RENAME COLUMN LAST_EDIT_TIME TO LAST_EDIT_TIME_UTC;


rem
rem MGMT_IP_STORED_REPORT
rem
rem PURPOSE
rem   The MGMT_IP_STORED_REPORT table contains the data for a stored report.
rem   Stored reports are not stored html.  Each report element that is stored
rem   for a report will store serialized data that can be used to reconstruct 
rem   the report.   The report data is in the ELEMENT_OBJECT column.
rem   Report targets are found in MGMT_IP_REPORT_ELEM_TARGETS table.
rem
rem COLUMNS
rem
rem   GENERATED_DATE_UTC  Date report was generated/stored (in UTC timzone)
rem
rem   GENERATED_OMS_TZ    Timezone of OMS that generated stored report
rem 

ALTER TABLE MGMT_IP_STORED_REPORT 
  RENAME COLUMN GENERATED_DATE TO GENERATED_DATE_UTC;
  
ALTER TABLE MGMT_IP_STORED_REPORT 
  ADD (GENERATED_OMS_TZ VARCHAR2(256) default null);

rem
rem MGMT_IP_REPORT_NLS_MAP
rem
rem PURPOSE
rem
rem Obsolete since messages are stored in MGMT_MESSAGES table

DROP TABLE MGMT_IP_REPORT_NLS_MAP;