Rem drv: <create type="triggers" pos="severity/severity_triggers.sql+"/>
Rem
Rem $Header: ip_triggers.sql 01-jul-2005.22:01:50 gsbhatia Exp $
Rem
Rem ip_triggers.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ip_triggers.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Triggers for information publishing tables
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       gsbhatia 07/01/05 - New repmgr header impl 
Rem       gsbhatia 06/26/05 - New repmgr header impl 
Rem       lgloyd   04/25/05 - add timezone to tgt table 
Rem       gsbhatia 02/13/05 - updating repmgr header 
Rem       gsbhatia 02/09/05 - updating repmgr header 
Rem       gsbhatia 02/07/05 - updating repmgr header 
Rem       ktlaw    01/11/05 - add repmgr header 
Rem       lgloyd   06/04/04 - lgloyd_ip040531
Rem

rem
rem Trigger MGMT_IP_DERIVED_TARGET_GUID
rem 
rem This trigger ensures that entries in MGMT_IP_REPORT_ELEM_TARGETS
rem have target name, target type and target guid.  If a name/type or guid
rem is not inserted, the value of one or the other will be derived.
rem
CREATE OR REPLACE TRIGGER MGMT_IP_DERIVED_TARGET_GUID
BEFORE INSERT OR UPDATE OF REPORT_GUID, ELEMENT_GUID, TARGET_NAME, 
  TARGET_TYPE, TARGET_GUID ON MGMT_IP_REPORT_ELEM_TARGETS
FOR EACH ROW
DECLARE
  tmpGuid RAW(16);
  tmpName VARCHAR(256);
  tmpType VARCHAR(64);
  tmpTimezoneRegion VARCHAR(64);
BEGIN

  if :new.TARGET_GUID is null 
  then
    SELECT TARGET_GUID into tmpGuid 
    FROM MGMT_TARGETS 
    WHERE TARGET_NAME = :new.TARGET_NAME 
      AND TARGET_TYPE = :new.TARGET_TYPE;
    :new.TARGET_GUID := tmpGuid;
  elsif :new.TARGET_NAME is null and :new.TARGET_TYPE is null
  then
    SELECT TARGET_NAME, TARGET_TYPE into tmpName, tmpType
    FROM MGMT_TARGETS 
    WHERE TARGET_GUID = :new.TARGET_GUID;
    :new.TARGET_NAME := tmpName;
    :new.TARGET_TYPE := tmpType;
  end if;
  
  SELECT TIMEZONE_REGION into tmpTimezoneRegion
    FROM MGMT_TARGETS 
    WHERE TARGET_GUID = :new.TARGET_GUID;  
  :new.TIMEZONE_REGION := tmpTimezoneRegion;
  
END;
/
   

