REM############################################################################
REM
REM Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
REM
REM
REM PRODUCT
REM	Oracle Enterprise Manager
REM
REM THIS FILE IS MACHINE GENERATED. DO NOT EDIT!
REM
REM JOB TYPE SQL FOR JOB TYPE: ApplySQLInOracleHome
REM
REM#############################################################################

SET DEFINE OFF

SET SQLPREFIX OFF


BEGIN 
BEGIN
DECLARE
    l_job_type_name MGMT_JOB_TYPE_INFO.job_type%TYPE;
    l_job_type_id MGMT_JOB_TYPE_INFO.job_type_id%TYPE;
    l_major_version MGMT_JOB_TYPE_INFO.major_version%TYPE;
    l_minor_version1 MGMT_JOB_TYPE_INFO.minor_version1%TYPE;
    l_minor_version2 MGMT_JOB_TYPE_INFO.minor_version2%TYPE;
BEGIN

l_job_type_name:= 'ApplySQLInOracleHome';

BEGIN 
MGMT_JOB_ENGINE.fix_flatten_steps(TRUE); 
MGMT_JOB_ENGINE.get_max_versions(l_job_type_name, l_major_version,
                   l_minor_version1, l_minor_version2, 
                   l_job_type_id); 
                         
l_minor_version2 := l_minor_version2+1; 
     
EXCEPTION 
    WHEN OTHERS THEN 
        IF SQLCODE=MGMT_GLOBAL.INVALID_JOB_TYPE_ERR THEN             l_major_version := 1; 
            l_minor_version1 := 0; 
            l_minor_version2 := 1; 
        ELSE 
            RAISE;
        END IF; 
END; 

-- CHECK TO VALIDATE REFERENCED COMMANDS/NESTED JOB TYPES
BEGIN
DECLARE
    l_commands SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
    l_nested_jobtypes SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN

    l_commands.trim(l_commands.count);

    l_commands.extend(1);
    l_commands(1) := 'remoteOp';

    l_nested_jobtypes.trim(l_nested_jobtypes.count);

    l_nested_jobtypes.extend(3);
    l_nested_jobtypes(1) := 'PatchPrePostScript';
    l_nested_jobtypes(2) := 'ShutdownDBInHome';
    l_nested_jobtypes(3) := 'StartupDBInHome';
    MGMT_JOB_ENGINE.validate_job_type(l_job_type_name, l_commands, l_nested_jobtypes );


END;
END;


-- JOBTYPE ENTRY
INSERT INTO MGMT_JOB_TYPE_INFO(job_type, version, major_version, minor_version1, minor_version2, job_type_category, all_target_types, agent_bound, single_target, suspend_on_nocreds, default_target_type, restartable, editable, suspendable, trusted,job_type_nlsid,job_type_default,create_text_nlsid,create_text_default,delete_text_nlsid,delete_text_default)  VALUES
	( l_job_type_name, '1.0', l_major_version, l_minor_version1, l_minor_version2, 0, 0, 0, 0, 0, null, 1, 1, 1, -1, null, null, null, null, null, null)
RETURNING job_type_id INTO l_job_type_id;

-- ENTRIES FOR STEPSET applySQLInOracleHome
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'applySQLInOracleHome', 2, null, null, -1, null, -1, null, null, null, null, null, 1, null, null, null, 1, 0, 0, 0, null, null, -1 );

-- PARAMINFO ENTRIES FOR STEP chkSqlPreScript
-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'username';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'chkSqlPreScript', 3, 'user', 1, null, 0, 1, 1, l_param_names );


END;
END;


-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'password';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'chkSqlPreScript', 3, 'user', 2, null, 0, 1, 1, l_param_names );


END;
END;


-- PARAM SOURCE: source type substValues
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(5);
    l_param_names(1) := 'final_sql_prescript_cmd';
    l_param_names(2) := 'final_sql_prescript';
    l_param_names(3) := 'final_sql_postscript_cmd';
    l_param_names(4) := 'final_sql_postscript';
    l_param_names(5) := 'final_sql_script';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'chkSqlPreScript', 3, 'substValues', 3, '
      ', 1, 0, 0, l_param_names );


END;
END;


-- SUBSTVALUES PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_source_params MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_source_params.trim(l_source_params.count);

    l_source_params.extend(5);
    l_source_params(1) := 'sql_prescript_cmd';
    l_source_params(2) := 'sql_prescript';
    l_source_params(3) := 'sql_postscript_cmd';
    l_source_params(4) := 'sql_postscript';
    l_source_params(5) := 'sql_script';
    INSERT INTO MGMT_JOB_SUBST_PARAMS(source_id, 
                      source_params) 
 SELECT source_id, l_source_params     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=3;
END;
END;


-- PARAM SOURCE: source type inline
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'perlscript';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'chkSqlPreScript', 3, 'inline', 4, '
    ', 0, 0, 0, l_param_names );


END;
END;


-- INLINE PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_params MGMT_JOB_PARAM_LIST := MGMT_JOB_PARAM_LIST();
    l_vector_vals MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_params.trim(l_params.count);

    l_params.extend(1);
    l_params(1) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(1).param_name := 'perlscript';
    l_params(1).param_type := 1;
    l_params(1).scalar_value := 'osm/empexecuteSQL.pl';
    l_params(1).vector_value := null;
    INSERT INTO MGMT_JOB_VALUE_PARAMS(source_id, param_values, action) 
  SELECT source_id, l_params, 'none'     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=4;
END;
END;


-- ENTRIES FOR STEPSET chkSqlPreScript
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'chkSqlPreScript', 3, null, null, 1, 'applySQLInOracleHome', 2, 'apply_sql_prescript', null, null, null, null, 1, 'applySQLInOracleHome', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB runSqlPrescript
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'runSqlPrescript';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'PatchPrePostScript', FALSE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runSqlPrescript', 12, 'PatchPrePostScript', null, 3, 'chkSqlPreScript', 3, null, null, 'yes', l_gen_iterate_param, null, 0, 'chkSqlPreScript', null, null, 1, null, 0, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runSqlPrescript', 6, null, null, 7, 'runSqlPrescript', 12, null, null, 'yes', l_gen_iterate_param, null, 1, 'chkSqlPreScript', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runSqlPrescript', 2, null, null, 6, 'runSqlPrescript', 6, null, null, 'yes', null, null, 1, 'runSqlPrescript', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runSqlPrescript', 7, 'PatchPrePostScript', null, 1, 'runSqlPrescript', 2, null, null, 'yes', l_gen_iterate_param, null, 0, 'runSqlPrescript', null, null, 1, 0, 0, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'runSqlPrescript', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runSqlPrescript', 7, 'PatchPrePostScript', null, 3, 'chkSqlPreScript', 3, null, null, 'yes', null, null, 0, 'chkSqlPreScript', null, null, 1, 0, 0, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP runSqlPrescript
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlPrescript', 'command', 1, 0, '%final_sql_prescript_cmd%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlPrescript', 'args', 1, 0, '%final_sql_prescript%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlPrescript', 'sudoMode', 1, 0, '%sql_prescript_sumode%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlPrescript', 'targetName', 1, 0, '%hosts%[%index_of_node%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlPrescript', 'targetType', 1, 0, 'host', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlPrescript', 'username', 1, 0, '%username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlPrescript', 'password', 1, 0, '%password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlPrescript', 'dest_home', 1, 0, '%oraclehome%', null, null );


END;
END;


-- ENTRIES FOR STEPSET chkSqlDbStarted
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'chkSqlDbStarted', 3, null, null, 7, 'chkSqlPreScript', 3, 'sql_dbtobe_started', null, null, null, null, 1, 'applySQLInOracleHome', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB runSqlDbStarted
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'runSqlDbStarted';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'StartupDBInHome', FALSE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runSqlDbStarted', 12, 'StartupDBInHome', null, 3, 'chkSqlDbStarted', 3, null, null, 'yes', l_gen_iterate_param, null, 0, 'chkSqlDbStarted', null, null, 1, null, 0, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runSqlDbStarted', 6, null, null, 7, 'runSqlDbStarted', 12, null, null, 'yes', l_gen_iterate_param, null, 1, 'chkSqlDbStarted', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runSqlDbStarted', 2, null, null, 6, 'runSqlDbStarted', 6, null, null, 'yes', null, null, 1, 'runSqlDbStarted', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runSqlDbStarted', 7, 'StartupDBInHome', null, 1, 'runSqlDbStarted', 2, null, null, 'yes', l_gen_iterate_param, null, 0, 'runSqlDbStarted', null, null, 1, 0, 0, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'runSqlDbStarted', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runSqlDbStarted', 7, 'StartupDBInHome', null, 3, 'chkSqlDbStarted', 3, null, null, 'yes', null, null, 0, 'chkSqlDbStarted', null, null, 1, 0, 0, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP runSqlDbStarted
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlDbStarted', 'dest_home', 1, 0, '%oraclehome%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlDbStarted', 'instance_names', 1, 0, '%targets%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlDbStarted', 'startupdbsids', 1, 0, '-startupdbsids', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlDbStarted', 'db_sid_list', 1, 0, '%dbsids%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlDbStarted', 'listener_list', 1, 0, '%listeners%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlDbStarted', 'upgrade_mode', 1, 0, '-upgrade', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlDbStarted', 'username', 1, 0, '%username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlDbStarted', 'password', 1, 0, '%password%', null, null );


END;
END;


MGMT_JOB_ENGINE.extract_nested_job_targets(l_job_type_id, 'runSqlDbStarted', MGMT_JOB_VECTOR_PARAMS('%hosts%[%index_of_node%]'),MGMT_JOB_VECTOR_PARAMS('host'));
-- ENTRIES FOR STEPSET chkSqlScript
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'chkSqlScript', 3, null, null, 7, 'chkSqlDbStarted', 3, 'apply_sql_script', null, null, null, null, 1, 'applySQLInOracleHome', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP Command
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'Command', 1, null, null, 3, 'chkSqlScript', 3, null, null, 'yes', null, null, 0, 'chkSqlScript', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP Command
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Command', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Command', 'args', 1, 0, '-w,%scriptsdir%/%perlscript%,-oh,%oraclehome%,-os,%dbsids%,-sql,%final_sql_script%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Command', 'targetName', 1, 0, '%hosts%[%index_of_node%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Command', 'targetType', 1, 0, 'host', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Command', 'username', 1, 0, '%username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'Command', 'password', 1, 0, '%password%', null, null );


END;
END;


-- ENTRIES FOR STEPSET chkSqlDbShutdown
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'chkSqlDbShutdown', 3, null, null, 7, 'chkSqlScript', 3, 'sql_dbtobe_shutdown', null, null, null, null, 1, 'applySQLInOracleHome', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB runSqlDbShutdown
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'runSqlDbShutdown';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'ShutdownDBInHome', FALSE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runSqlDbShutdown', 12, 'ShutdownDBInHome', null, 3, 'chkSqlDbShutdown', 3, null, null, 'yes', l_gen_iterate_param, null, 0, 'chkSqlDbShutdown', null, null, 1, null, 0, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runSqlDbShutdown', 6, null, null, 7, 'runSqlDbShutdown', 12, null, null, 'yes', l_gen_iterate_param, null, 1, 'chkSqlDbShutdown', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runSqlDbShutdown', 2, null, null, 6, 'runSqlDbShutdown', 6, null, null, 'yes', null, null, 1, 'runSqlDbShutdown', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runSqlDbShutdown', 7, 'ShutdownDBInHome', null, 1, 'runSqlDbShutdown', 2, null, null, 'yes', l_gen_iterate_param, null, 0, 'runSqlDbShutdown', null, null, 1, 0, 0, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'runSqlDbShutdown', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runSqlDbShutdown', 7, 'ShutdownDBInHome', null, 3, 'chkSqlDbShutdown', 3, null, null, 'yes', null, null, 0, 'chkSqlDbShutdown', null, null, 1, 0, 0, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP runSqlDbShutdown
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlDbShutdown', 'dest_home', 1, 0, '%oraclehome%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlDbShutdown', 'instance_names', 1, 0, '%targets%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlDbShutdown', 'shutdowndbsids', 1, 0, '-shutdowndbsids', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlDbShutdown', 'db_sid_list', 1, 0, '%dbsids%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlDbShutdown', 'listener_list', 1, 0, '%listeners%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlDbShutdown', 'username', 1, 0, '%username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlDbShutdown', 'password', 1, 0, '%password%', null, null );


END;
END;


MGMT_JOB_ENGINE.extract_nested_job_targets(l_job_type_id, 'runSqlDbShutdown', MGMT_JOB_VECTOR_PARAMS('%hosts%[%index_of_node%]'),MGMT_JOB_VECTOR_PARAMS('host'));
-- ENTRIES FOR STEPSET chkSqlPostScript
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'chkSqlPostScript', 3, null, null, 2, 'chkSqlDbShutdown', 3, 'apply_sql_postscript', null, null, null, null, 1, 'applySQLInOracleHome', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB runSqlPostscript
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'runSqlPostscript';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'PatchPrePostScript', FALSE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runSqlPostscript', 12, 'PatchPrePostScript', null, 3, 'chkSqlPostScript', 3, null, null, 'yes', l_gen_iterate_param, null, 0, 'chkSqlPostScript', null, null, 1, null, 0, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runSqlPostscript', 6, null, null, 7, 'runSqlPostscript', 12, null, null, 'yes', l_gen_iterate_param, null, 1, 'chkSqlPostScript', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runSqlPostscript', 2, null, null, 6, 'runSqlPostscript', 6, null, null, 'yes', null, null, 1, 'runSqlPostscript', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runSqlPostscript', 7, 'PatchPrePostScript', null, 1, 'runSqlPostscript', 2, null, null, 'yes', l_gen_iterate_param, null, 0, 'runSqlPostscript', null, null, 1, 0, 0, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'runSqlPostscript', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runSqlPostscript', 7, 'PatchPrePostScript', null, 3, 'chkSqlPostScript', 3, null, null, 'yes', null, null, 0, 'chkSqlPostScript', null, null, 1, 0, 0, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP runSqlPostscript
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlPostscript', 'command', 1, 0, '%final_sql_postscript_cmd%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlPostscript', 'args', 1, 0, '%final_sql_postscript%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlPostscript', 'sudoMode', 1, 0, '%sql_postscript_sumode%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlPostscript', 'targetName', 1, 0, '%hosts%[%index_of_node%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlPostscript', 'targetType', 1, 0, 'host', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlPostscript', 'username', 1, 0, '%username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlPostscript', 'password', 1, 0, '%password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runSqlPostscript', 'dest_home', 1, 0, '%oraclehome%', null, null );


END;
END;


-- Ensure that all existing scheduled executions use the new jobtype version
MGMT_JOB_ENGINE.reschedule_on_new_jobtype_ver(l_job_type_id);
-- Patch NLS information for backward-compatibility
MGMT_JOB_ENGINE.update_job_type_nls_info(l_job_type_id, l_job_type_name);

END;
END;


MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
EXCEPTION 
    WHEN OTHERS THEN 
        MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
        RAISE; 
END; 
/
COMMIT;
SET DEFINE ON

SET SQLPREFIX ON

