REM############################################################################
REM
REM Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
REM
REM
REM PRODUCT
REM	Oracle Enterprise Manager
REM
REM THIS FILE IS MACHINE GENERATED. DO NOT EDIT!
REM
REM JOB TYPE SQL FOR JOB TYPE: CopyHome
REM
REM#############################################################################

SET DEFINE OFF

SET SQLPREFIX OFF


BEGIN 
BEGIN
DECLARE
    l_job_type_name MGMT_JOB_TYPE_INFO.job_type%TYPE;
    l_job_type_id MGMT_JOB_TYPE_INFO.job_type_id%TYPE;
    l_major_version MGMT_JOB_TYPE_INFO.major_version%TYPE;
    l_minor_version1 MGMT_JOB_TYPE_INFO.minor_version1%TYPE;
    l_minor_version2 MGMT_JOB_TYPE_INFO.minor_version2%TYPE;
BEGIN

l_job_type_name:= 'CopyHome';

BEGIN 
MGMT_JOB_ENGINE.fix_flatten_steps(TRUE); 
MGMT_JOB_ENGINE.get_max_versions(l_job_type_name, l_major_version,
                   l_minor_version1, l_minor_version2, 
                   l_job_type_id); 
                         
l_minor_version2 := l_minor_version2+1; 
     
EXCEPTION 
    WHEN OTHERS THEN 
        IF SQLCODE=MGMT_GLOBAL.INVALID_JOB_TYPE_ERR THEN             l_major_version := 1; 
            l_minor_version1 := 0; 
            l_minor_version2 := 1; 
        ELSE 
            RAISE;
        END IF; 
END; 

-- CHECK TO VALIDATE REFERENCED COMMANDS/NESTED JOB TYPES
BEGIN
DECLARE
    l_commands SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
    l_nested_jobtypes SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN

    l_commands.trim(l_commands.count);

    l_commands.extend(2);
    l_commands(1) := 'fileTransfer';
    l_commands(2) := 'remoteOp';
    MGMT_JOB_ENGINE.validate_job_type(l_job_type_name, l_commands, l_nested_jobtypes );


END;
END;


-- JOBTYPE ENTRY
INSERT INTO MGMT_JOB_TYPE_INFO(job_type, version, major_version, minor_version1, minor_version2, job_type_category, all_target_types, agent_bound, single_target, suspend_on_nocreds, default_target_type, restartable, editable, suspendable, trusted,job_type_nlsid,job_type_default,create_text_nlsid,create_text_default,delete_text_nlsid,delete_text_default)  VALUES
	( l_job_type_name, '1.0', l_major_version, l_minor_version1, l_minor_version2, 0, 0, 0, 0, 0, null, 1, 0, 1, -1, null, null, null, null, null, null)
RETURNING job_type_id INTO l_job_type_id;

-- ENTRIES FOR STEPSET copyHomeJob
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'copyHomeJob', 2, null, null, -1, null, -1, null, null, null, null, null, 1, null, null, null, 1, 0, 0, 0, null, null, -1 );

-- PARAMINFO ENTRIES FOR STEP createDestDirs
-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(12);
    l_param_names(1) := 'sourceTargetName';
    l_param_names(2) := 'sourceTargetType';
    l_param_names(3) := 'sourceHomeLocation';
    l_param_names(4) := 'sourceArchivePath';
    l_param_names(5) := 'excludeListFile';
    l_param_names(6) := 'destTargetName';
    l_param_names(7) := 'destTargetType';
    l_param_names(8) := 'destHomeLocation';
    l_param_names(9) := 'destTempDirPath';
    l_param_names(10) := 'destArchivePath';
    l_param_names(11) := 'destIsRemote';
    l_param_names(12) := 'tryFtpCopy';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'createDestDirs', 1, 'user', 1, '
	', 0, 1, 0, l_param_names );


END;
END;


-- USER PARAMETER SOURCE DETAILS
BEGIN
DECLARE
    l_target_name_params MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_type_params MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_target_name_params.trim(l_target_name_params.count);

    l_target_name_params.extend(2);
    l_target_name_params(1) := 'sourceTargetName';
    l_target_name_params(2) := 'destTargetName';

    l_target_type_params.trim(l_target_type_params.count);

    l_target_type_params.extend(2);
    l_target_type_params(1) := 'sourceTargetType';
    l_target_type_params(2) := 'destTargetType';
    INSERT INTO MGMT_JOB_USER_PARAMS(source_id, 
                       target_name_params,  
                       target_type_params)  
 SELECT source_id, l_target_name_params, 
              l_target_type_params FROM 
   MGMT_JOB_PARAM_SOURCE WHERE job_type_id= l_job_type_id AND source_index=1;
END;
END;


-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(4);
    l_param_names(1) := 'sourceUsername';
    l_param_names(2) := 'sourcePassword';
    l_param_names(3) := 'destUsername';
    l_param_names(4) := 'destPassword';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'createDestDirs', 1, 'user', 2, '
    ', 0, 1, 1, l_param_names );


END;
END;


-- ENTRIES FOR STEP createDestDirs
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'createDestDirs', 1, null, null, 1, 'copyHomeJob', 2, null, null, null, null, null, 0, 'copyHomeJob', null, 'remoteOp', 1, 0, 0, 0, 'JOB_CREATE_DEST_DIRS', 'Create Dest Directories', 1 );

--  STEP PARAMETERS FOR STEP createDestDirs
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createDestDirs', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createDestDirs', 'targetName', 1, 0, '%destTargetName%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createDestDirs', 'targetType', 1, 0, '%destTargetType%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createDestDirs', 'args', 1, 0, '-, -w', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createDestDirs', 'username', 1, 0, '%destUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createDestDirs', 'password', 1, 0, '%destPassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createDestDirs', 'input', 1, 0, '
use strict;
require "$ENV{EMDROOT}/sysman/admin/scripts/osm/ecmCloneHome.pl";
setOutputAutoflush();
# create temp working dir, assuming we''ll need it.  Highly unlikely,
# but if a dir named this already exists, fail job. -->
makeNewDir(''%destTempDirPath%'');
# create destination home''s directory or make sure it''s empty
my $dirName = ''%destHomeLocation%'';
$!=0;
if (! -e $dirName)
{
  makeNewDir(''%destHomeLocation%'');
}
else
{
  if (!opendir(DEST_DIR, $dirName))
  { 
    abort("open of ''$dirName''", $!, "$!");
  }
  while (my $dirEntry = readdir(DEST_DIR))
  {
    if (!($dirEntry =~ m/^\.\.?$/)) 
    {
      abort("empty-test for ''$dirName''", $!, "$!");
    }
  }
}
exit 0;
        ', null, null );


END;
END;


-- ENTRIES FOR STEPSET switchCopyHome
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'switchCopyHome', 3, null, null, 7, 'createDestDirs', 1, 'destIsRemote', null, null, null, null, 1, 'copyHomeJob', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET copyAndExpand
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'copyAndExpand', 2, null, null, 3, 'switchCopyHome', 3, null, null, 'true', null, null, 1, 'switchCopyHome', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET switchFtpGetArchive
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'switchFtpGetArchive', 3, null, null, 1, 'copyAndExpand', 2, 'tryFtpCopy', null, null, null, null, 1, 'copyAndExpand', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET getSwArchiveToDest
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'getSwArchiveToDest', 2, null, null, 3, 'switchFtpGetArchive', 3, null, null, 'true', null, null, 1, 'switchFtpGetArchive', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP ftpSwArchiveToDest
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'ftpSwArchiveToDest', 1, null, null, 1, 'getSwArchiveToDest', 2, null, null, null, null, null, 0, 'getSwArchiveToDest', null, 'remoteOp', 1, 0, 0, 0, null, null, 1 );

--  STEP PARAMETERS FOR STEP ftpSwArchiveToDest
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'ftpSwArchiveToDest', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'ftpSwArchiveToDest', 'targetName', 1, 0, '%destTargetName%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'ftpSwArchiveToDest', 'targetType', 1, 0, '%destTargetType%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'ftpSwArchiveToDest', 'args', 1, 0, '-, -w', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'ftpSwArchiveToDest', 'username', 1, 0, '%destUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'ftpSwArchiveToDest', 'password', 1, 0, '%destPassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'ftpSwArchiveToDest', 'input', 1, 0, '
use strict;
require "$ENV{EMDROOT}/sysman/admin/scripts/osm/ecmCloneHome.pl";
setOutputAutoflush();
ftpGet(''%sourceTargetName%'',
       ''%sourceArchivePath%'',
       ''%destArchivePath%'',
       ''%sourceUsername%'',
       ''%sourcePassword%'');
exit 0;
                ', null, null );


END;
END;


-- ENTRIES FOR STEP copySwArchiveToDest
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'copySwArchiveToDest', 1, null, null, 8, 'ftpSwArchiveToDest', 1, null, null, null, null, null, 0, 'getSwArchiveToDest', null, 'fileTransfer', 1, 0, 0, 0, 'JOB_COPY_SW_ARCHIVE_ TO_DEST', 'Copy Archive To Dest', -1 );

--  STEP PARAMETERS FOR STEP copySwArchiveToDest
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copySwArchiveToDest', 'sourceTargetName', 1, 0, '%sourceTargetName%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copySwArchiveToDest', 'sourceTargetType', 1, 0, '%sourceTargetType%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copySwArchiveToDest', 'destTargetName', 1, 0, '%destTargetName%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copySwArchiveToDest', 'destTargetType', 1, 0, '%destTargetType%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copySwArchiveToDest', 'sourceFile', 1, 0, '%sourceArchivePath%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copySwArchiveToDest', 'sourceUsername', 1, 0, '%sourceUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copySwArchiveToDest', 'sourcePassword', 1, 0, '%sourcePassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copySwArchiveToDest', 'destFile', 1, 0, '%destArchivePath%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copySwArchiveToDest', 'destUsername', 1, 0, '%destUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copySwArchiveToDest', 'destPassword', 1, 0, '%destPassword%', null, null );


END;
END;


-- ENTRIES FOR STEP transferSwArchiveToDest
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'transferSwArchiveToDest', 1, null, null, 3, 'switchFtpGetArchive', 3, null, null, 'false', null, null, 0, 'switchFtpGetArchive', null, 'fileTransfer', 1, 0, 0, 0, 'JOB_TRANSFER_SWARCH_TO_DEST', 'Transfer Archive To Dest', -1 );

--  STEP PARAMETERS FOR STEP transferSwArchiveToDest
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferSwArchiveToDest', 'sourceTargetName', 1, 0, '%sourceTargetName%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferSwArchiveToDest', 'sourceTargetType', 1, 0, '%sourceTargetType%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferSwArchiveToDest', 'destTargetName', 1, 0, '%destTargetName%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferSwArchiveToDest', 'destTargetType', 1, 0, '%destTargetType%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferSwArchiveToDest', 'sourceFile', 1, 0, '%sourceArchivePath%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferSwArchiveToDest', 'sourceUsername', 1, 0, '%sourceUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferSwArchiveToDest', 'sourcePassword', 1, 0, '%sourcePassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferSwArchiveToDest', 'destFile', 1, 0, '%destArchivePath%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferSwArchiveToDest', 'destUsername', 1, 0, '%destUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferSwArchiveToDest', 'destPassword', 1, 0, '%destPassword%', null, null );


END;
END;


-- ENTRIES FOR STEP importFromSwArchive
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'importFromSwArchive', 1, null, null, 2, 'switchFtpGetArchive', 3, null, null, null, null, null, 0, 'copyAndExpand', null, 'remoteOp', 1, 0, 0, 0, 'JOB_IMPORT_FROM_SW_ARCHIVE', 'Import From Archive', 1 );

--  STEP PARAMETERS FOR STEP importFromSwArchive
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'importFromSwArchive', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'importFromSwArchive', 'targetName', 1, 0, '%destTargetName%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'importFromSwArchive', 'targetType', 1, 0, '%destTargetType%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'importFromSwArchive', 'args', 1, 0, '-, -w', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'importFromSwArchive', 'username', 1, 0, '%destUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'importFromSwArchive', 'password', 1, 0, '%destPassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'importFromSwArchive', 'input', 1, 0, '
use strict;
require "$ENV{EMDROOT}/sysman/admin/scripts/osm/ecmCloneHome.pl";
setOutputAutoflush();
# import/populate home clone
importHome(''%destHomeLocation%'', ''%destArchivePath%'');
exit 0;
				', null, null );


END;
END;


-- ENTRIES FOR STEP copySourceHome
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'copySourceHome', 1, null, null, 3, 'switchCopyHome', 3, null, null, 'false', null, null, 0, 'switchCopyHome', null, 'remoteOp', 1, 0, 0, 0, 'JOB_COPY_SOURCE_HOME', 'Copy Source Home', 1 );

--  STEP PARAMETERS FOR STEP copySourceHome
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copySourceHome', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copySourceHome', 'targetName', 1, 0, '%destTargetName%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copySourceHome', 'targetType', 1, 0, '%destTargetType%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copySourceHome', 'args', 1, 0, '-, -w', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copySourceHome', 'username', 1, 0, '%destUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copySourceHome', 'password', 1, 0, '%destPassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copySourceHome', 'input', 1, 0, '
use strict;
require "$ENV{EMDROOT}/sysman/admin/scripts/osm/ecmCloneHome.pl";
setOutputAutoflush();
copySourceHome(''%sourceHomeLocation%'',''%destHomeLocation%'',
               ''%excludeListFile%'');
exit 0;
          ', null, null );


END;
END;


-- DISPLAYINFO ENTRIES
INSERT INTO MGMT_JOB_TYPE_DISPLAY_INFO(job_type_id, nls_bundle,use_default_create_ui)  VALUES
	( l_job_type_id, 'oracle.sysman.eml.ecm.cloneHome.util.CloneHomeResourceBundle', 0 );

-- Ensure that all existing scheduled executions use the new jobtype version
MGMT_JOB_ENGINE.reschedule_on_new_jobtype_ver(l_job_type_id);
-- Patch NLS information for backward-compatibility
MGMT_JOB_ENGINE.update_job_type_nls_info(l_job_type_id, l_job_type_name);

END;
END;


MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
EXCEPTION 
    WHEN OTHERS THEN 
        MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
        RAISE; 
END; 
/
COMMIT;
SET DEFINE ON

SET SQLPREFIX ON

