REM############################################################################
REM
REM Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
REM
REM
REM PRODUCT
REM	Oracle Enterprise Manager
REM
REM THIS FILE IS MACHINE GENERATED. DO NOT EDIT!
REM
REM JOB TYPE SQL FOR JOB TYPE: ImageProvision
REM
REM#############################################################################

SET DEFINE OFF

SET SQLPREFIX OFF


BEGIN 
BEGIN
DECLARE
    l_job_type_name MGMT_JOB_TYPE_INFO.job_type%TYPE;
    l_job_type_id MGMT_JOB_TYPE_INFO.job_type_id%TYPE;
    l_major_version MGMT_JOB_TYPE_INFO.major_version%TYPE;
    l_minor_version1 MGMT_JOB_TYPE_INFO.minor_version1%TYPE;
    l_minor_version2 MGMT_JOB_TYPE_INFO.minor_version2%TYPE;
BEGIN

l_job_type_name:= 'ImageProvision';

BEGIN 
MGMT_JOB_ENGINE.fix_flatten_steps(TRUE); 
MGMT_JOB_ENGINE.get_max_versions(l_job_type_name, l_major_version,
                   l_minor_version1, l_minor_version2, 
                   l_job_type_id); 
                         
l_minor_version2 := l_minor_version2+1; 
     
EXCEPTION 
    WHEN OTHERS THEN 
        IF SQLCODE=MGMT_GLOBAL.INVALID_JOB_TYPE_ERR THEN             l_major_version := 1; 
            l_minor_version1 := 0; 
            l_minor_version2 := 1; 
        ELSE 
            RAISE;
        END IF; 
END; 

-- CHECK TO VALIDATE REFERENCED COMMANDS/NESTED JOB TYPES
BEGIN
DECLARE
    l_commands SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
    l_nested_jobtypes SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN

    l_commands.trim(l_commands.count);

    l_commands.extend(5);
    l_commands(1) := 'StageResetJobCommand';
    l_commands(2) := 'PostStageCommand';
    l_commands(3) := 'FreeIPAddressCommand';
    l_commands(4) := 'CheckDiagnosticCommand';
    l_commands(5) := 'ResetInitialCommand';

    l_nested_jobtypes.trim(l_nested_jobtypes.count);

    l_nested_jobtypes.extend(5);
    l_nested_jobtypes(1) := 'DiagnosticJob';
    l_nested_jobtypes(2) := 'CredentialValidatorJob';
    l_nested_jobtypes(3) := 'ResetProvisionTarget';
    l_nested_jobtypes(4) := 'StagingJob';
    l_nested_jobtypes(5) := 'AllTargetPrereqJob';
    MGMT_JOB_ENGINE.validate_job_type(l_job_type_name, l_commands, l_nested_jobtypes );


END;
END;


-- JOBTYPE ENTRY
INSERT INTO MGMT_JOB_TYPE_INFO(job_type, version, major_version, minor_version1, minor_version2, job_type_category, all_target_types, agent_bound, single_target, suspend_on_nocreds, default_target_type, restartable, editable, suspendable, trusted,job_type_nlsid,job_type_default,create_text_nlsid,create_text_default,delete_text_nlsid,delete_text_default)  VALUES
	( l_job_type_name, '1.0', l_major_version, l_minor_version1, l_minor_version2, 0, 0, 1, 1, 1, null, 1, 1, 1, -1, null, null, null, null, null, null)
RETURNING job_type_id INTO l_job_type_id;

INSERT INTO MGMT_JOB_SINGLE_TARGET_TYPES(job_type_id, single_target_type)  VALUES
	( l_job_type_id, 'host' );

MGMT_JOB_ENGINE.insert_cluster_target_types(l_job_type_id);

-- ENTRIES FOR STEPSET imageProvisionMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'imageProvisionMain', 2, null, null, -1, null, -1, null, null, null, null, null, 1, null, null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET imageProvisionMainInner
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'imageProvisionMainInner', 2, null, null, 1, 'imageProvisionMain', 2, null, null, null, null, null, 1, 'imageProvisionMain', 'StagingCheck', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET StagingCheck
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'StagingCheck', 2, null, null, 1, 'imageProvisionMainInner', 2, null, null, null, null, null, 1, 'imageProvisionMainInner', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET imageProvisionInner
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'imageProvisionInner', 2, null, null, 1, 'StagingCheck', 2, null, null, null, null, null, 1, 'StagingCheck', 'InitialCheck', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET InitialCheck
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'InitialCheck', 2, null, null, 1, 'imageProvisionInner', 2, null, null, null, null, null, 1, 'imageProvisionInner', null, null, 1, 0, 0, 0, null, null, -1 );

-- PARAMINFO ENTRIES FOR STEP initialJobCommand
-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'assignment_urn';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 0, 'initialJobCommand', 1, 'user', 1, null, 0, 1, 0, l_param_names );


END;
END;


-- PARAM SOURCE: source type credentials
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(2);
    l_param_names(1) := 'username';
    l_param_names(2) := 'password';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'initialJobCommand', 1, 'credentials', 2, '
	', 1, 0, 1, l_param_names );


END;
END;


-- CREDENTIAL PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_cred_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_types MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_container_paths MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_cred_type_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_cred_columns.trim(l_cred_columns.count);

    l_cred_columns.extend(2);
    l_cred_columns(1) := 'username';
    l_cred_columns(2) := 'password';
    INSERT INTO MGMT_JOB_CRED_PARAMS(source_id, 
                         credential_set_name, 
                         credential_set_target_type, 
                         base_cred_type_name, 
                         base_cred_type_target_type, 
                         base_cred_type_columns, 
                         credential_columns, 
                         credential_columns_param, 
                         target_names, 
                         target_types, 
                         container_paths, 
                         target_names_param, 
                         target_types_param, 
                         container_paths_param, 
                         set_override) 
       SELECT source_id, 'HostCredsPriv', 'host', null, null, null, l_cred_columns, null, null, null, null, 'job_target_names', 'job_target_types', null, 0         FROM   MGMT_JOB_PARAM_SOURCE WHERE job_type_id= l_job_type_id            AND source_index=2;
END;
END;


-- ENTRIES FOR STEP initialJobCommand
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'initialJobCommand', 1, null, null, 1, 'InitialCheck', 2, null, null, null, null, null, 0, 'InitialCheck', null, 'CheckDiagnosticCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP initialJobCommand
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'initialJobCommand', 'assignment_urn', 1, 0, '%assignment_urn%', null, null );


END;
END;


-- ENTRIES FOR STEPSET checkCredentials
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'checkCredentials', 4, null, null, 7, 'initialJobCommand', 1, null, null, null, null, null, 1, 'InitialCheck', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET checkCredsForTargets
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'checkCredsForTargets', 2, null, null, 4, 'checkCredentials', 4, null, null, null, null, null, 1, 'checkCredentials', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB targetCredentialsValidatorJob
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'targetCredentialsValidatorJob';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'CredentialValidatorJob', TRUE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'targetCredentialsValidatorJob', 12, 'CredentialValidatorJob', null, 1, 'checkCredsForTargets', 2, null, null, null, l_gen_iterate_param, null, 0, 'checkCredsForTargets', null, null, 1, null, 1, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'targetCredentialsValidatorJob', 6, null, null, 7, 'targetCredentialsValidatorJob', 12, null, null, null, l_gen_iterate_param, null, 1, 'checkCredsForTargets', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'targetCredentialsValidatorJob', 2, null, null, 6, 'targetCredentialsValidatorJob', 6, null, null, null, null, null, 1, 'targetCredentialsValidatorJob', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'targetCredentialsValidatorJob', 7, 'CredentialValidatorJob', null, 1, 'targetCredentialsValidatorJob', 2, null, null, null, l_gen_iterate_param, null, 0, 'targetCredentialsValidatorJob', null, null, 1, 0, 1, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'targetCredentialsValidatorJob', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'targetCredentialsValidatorJob', 7, 'CredentialValidatorJob', null, 1, 'checkCredsForTargets', 2, null, null, null, null, null, 0, 'checkCredsForTargets', null, null, 1, 0, 1, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP targetCredentialsValidatorJob
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'targetCredentialsValidatorJob', 'hw_servers', -1, 0, null, null, 'hw_servers' );


END;
END;


-- ENTRIES FOR STEPSET checkCredsForStageServer
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'checkCredsForStageServer', 2, null, null, 4, 'checkCredentials', 4, null, null, null, null, null, 1, 'checkCredentials', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB stageCredentialsValidatorJob
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'stageCredentialsValidatorJob';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'CredentialValidatorJob', TRUE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'stageCredentialsValidatorJob', 12, 'CredentialValidatorJob', null, 1, 'checkCredsForStageServer', 2, null, null, null, l_gen_iterate_param, null, 0, 'checkCredsForStageServer', null, null, 1, null, 1, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'stageCredentialsValidatorJob', 6, null, null, 7, 'stageCredentialsValidatorJob', 12, null, null, null, l_gen_iterate_param, null, 1, 'checkCredsForStageServer', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'stageCredentialsValidatorJob', 2, null, null, 6, 'stageCredentialsValidatorJob', 6, null, null, null, null, null, 1, 'stageCredentialsValidatorJob', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'stageCredentialsValidatorJob', 7, 'CredentialValidatorJob', null, 1, 'stageCredentialsValidatorJob', 2, null, null, null, l_gen_iterate_param, null, 0, 'stageCredentialsValidatorJob', null, null, 1, 0, 1, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'stageCredentialsValidatorJob', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'stageCredentialsValidatorJob', 7, 'CredentialValidatorJob', null, 1, 'checkCredsForStageServer', 2, null, null, null, null, null, 0, 'checkCredsForStageServer', null, null, 1, 0, 1, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP stageCredentialsValidatorJob
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'stageCredentialsValidatorJob', 'hw_servers', -1, 0, null, null, 'stage_target' );


END;
END;


-- ENTRIES FOR STEPSET runPrereqsForTargets
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runPrereqsForTargets', 2, null, null, 7, 'checkCredentials', 4, null, null, null, null, null, 1, 'InitialCheck', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB runPrereqsForAllTargets
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'runPrereqsForAllTargets';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'AllTargetPrereqJob', TRUE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runPrereqsForAllTargets', 12, 'AllTargetPrereqJob', null, 1, 'runPrereqsForTargets', 2, null, null, null, l_gen_iterate_param, null, 0, 'runPrereqsForTargets', null, null, 1, null, 1, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runPrereqsForAllTargets', 6, null, null, 7, 'runPrereqsForAllTargets', 12, null, null, null, l_gen_iterate_param, null, 1, 'runPrereqsForTargets', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runPrereqsForAllTargets', 2, null, null, 6, 'runPrereqsForAllTargets', 6, null, null, null, null, null, 1, 'runPrereqsForAllTargets', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runPrereqsForAllTargets', 7, 'AllTargetPrereqJob', null, 1, 'runPrereqsForAllTargets', 2, null, null, null, l_gen_iterate_param, null, 0, 'runPrereqsForAllTargets', null, null, 1, 0, 1, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'runPrereqsForAllTargets', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runPrereqsForAllTargets', 7, 'AllTargetPrereqJob', null, 1, 'runPrereqsForTargets', 2, null, null, null, null, null, 0, 'runPrereqsForTargets', null, null, 1, 0, 1, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP runPrereqsForAllTargets
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runPrereqsForAllTargets', 'hw_servers', -1, 0, null, null, 'hw_servers' );


END;
END;


-- ENTRIES FOR STEPSET FreeIPAndPostStage
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'FreeIPAndPostStage', 2, null, null, 8, 'InitialCheck', 2, null, null, null, null, null, 1, 'imageProvisionInner', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP errorStatusCommand
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'errorStatusCommand', 1, null, null, 1, 'FreeIPAndPostStage', 2, null, null, null, null, null, 0, 'FreeIPAndPostStage', null, 'PostStageCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP errorStatusCommand
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'errorStatusCommand', 'assignment_urn', 1, 0, '%assignment_urn%', null, null );


END;
END;


-- ENTRIES FOR STEP FreeNewIPAddress
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'FreeNewIPAddress', 1, null, null, 2, 'errorStatusCommand', 1, null, null, null, null, null, 0, 'FreeIPAndPostStage', null, 'FreeIPAddressCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP FreeNewIPAddress
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FreeNewIPAddress', 'assignment_urn', 1, 0, '%assignment_urn%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FreeNewIPAddress', 'clear_allIP', 1, 0, 'yes', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FreeNewIPAddress', 'clear_newIP', 1, 0, 'yes', null, null );


END;
END;


-- ENTRIES FOR STEPSET stagingDiagnoParallelSteps
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'stagingDiagnoParallelSteps', 2, null, null, 7, 'imageProvisionInner', 2, null, null, null, null, null, 1, 'StagingCheck', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET runDiagnosticIfRequired
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runDiagnosticIfRequired', 2, null, null, 1, 'stagingDiagnoParallelSteps', 2, null, null, null, null, null, 1, 'stagingDiagnoParallelSteps', 'runIfRequired', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET runIfRequired
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runIfRequired', 3, null, null, 1, 'runDiagnosticIfRequired', 2, 'need_to_run_diagnostic', null, null, null, null, 1, 'runDiagnosticIfRequired', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET runDiagnostic
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runDiagnostic', 2, null, null, 3, 'runIfRequired', 3, null, null, 'YES', null, null, 1, 'runIfRequired', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET executeForEachHW
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'executeForEachHW', 5, null, null, 1, 'runDiagnostic', 2, null, null, null, 'hw_servers', null, 1, 'runDiagnostic', null, null, 1, 0, 0, 0, null, null, -1 );

INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'executeForEachHW', 2, null, null, 5, 'executeForEachHW', 5, null, null, null, 'hw_servers', null, 1, 'executeForEachHW', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB diagnosticJob
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'diagnosticJob';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'DiagnosticJob', FALSE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'diagnosticJob', 12, 'DiagnosticJob', null, 1, 'executeForEachHW', 2, null, null, null, l_gen_iterate_param, null, 0, 'executeForEachHW', null, null, 1, null, 0, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'diagnosticJob', 6, null, null, 7, 'diagnosticJob', 12, null, null, null, l_gen_iterate_param, null, 1, 'executeForEachHW', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'diagnosticJob', 2, null, null, 6, 'diagnosticJob', 6, null, null, null, null, null, 1, 'diagnosticJob', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'diagnosticJob', 7, 'DiagnosticJob', null, 1, 'diagnosticJob', 2, null, null, null, l_gen_iterate_param, null, 0, 'diagnosticJob', null, null, 1, 0, 0, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'diagnosticJob', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'diagnosticJob', 7, 'DiagnosticJob', null, 1, 'executeForEachHW', 2, null, null, null, null, null, 0, 'executeForEachHW', null, null, 1, 0, 0, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP diagnosticJob
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'diagnosticJob', 'assignment_urn', 1, 0, '%assignment_urn%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'diagnosticJob', 'hw_urn', 1, 0, '%hw_server_urns%[%job_iterate_index%]', null, null );


END;
END;


MGMT_JOB_ENGINE.extract_nested_job_targets(l_job_type_id, 'diagnosticJob', MGMT_JOB_VECTOR_PARAMS('%hw_servers%[%job_iterate_index%]'),MGMT_JOB_VECTOR_PARAMS('%job_target_types%[1]'));
-- ENTRIES FOR STEP errorInDiagnosticStep
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'errorInDiagnosticStep', 1, null, null, 9, 'runIfRequired', 3, null, null, null, null, null, 0, 'runDiagnosticIfRequired', null, 'PostStageCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP errorInDiagnosticStep
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'errorInDiagnosticStep', 'assignment_urn', 1, 0, '%assignment_urn%', null, null );


END;
END;


-- ENTRIES FOR STEP exceptionInDiagnosticStep
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'exceptionInDiagnosticStep', 1, null, null, 8, 'runIfRequired', 3, null, null, null, null, null, 0, 'runDiagnosticIfRequired', null, 'PostStageCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP exceptionInDiagnosticStep
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'exceptionInDiagnosticStep', 'assignment_urn', 1, 0, '%assignment_urn%', null, null );


END;
END;


-- ENTRIES FOR STEPSET initiateStaging
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'initiateStaging', 2, null, null, 7, 'runDiagnosticIfRequired', 2, null, null, null, null, null, 1, 'stagingDiagnoParallelSteps', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB stagingJob
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'stagingJob';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'StagingJob', TRUE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'stagingJob', 12, 'StagingJob', null, 1, 'initiateStaging', 2, null, null, null, l_gen_iterate_param, null, 0, 'initiateStaging', null, null, 1, null, 1, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'stagingJob', 6, null, null, 7, 'stagingJob', 12, null, null, null, l_gen_iterate_param, null, 1, 'initiateStaging', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'stagingJob', 2, null, null, 6, 'stagingJob', 6, null, null, null, null, null, 1, 'stagingJob', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'stagingJob', 7, 'StagingJob', null, 1, 'stagingJob', 2, null, null, null, l_gen_iterate_param, null, 0, 'stagingJob', null, null, 1, 1, 1, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'stagingJob', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'stagingJob', 7, 'StagingJob', null, 1, 'initiateStaging', 2, null, null, null, null, null, 0, 'initiateStaging', null, null, 1, 1, 1, 0, null, null, -1 );

    END IF;

END;
END;


-- ENTRIES FOR STEP FreeNewIPAfterStagingAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'FreeNewIPAfterStagingAbort', 1, null, null, 9, 'StagingCheck', 2, null, null, null, null, null, 0, 'imageProvisionMainInner', null, 'FreeIPAddressCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP FreeNewIPAfterStagingAbort
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FreeNewIPAfterStagingAbort', 'assignment_urn', 1, 0, '%assignment_urn%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FreeNewIPAfterStagingAbort', 'clear_allIP', 1, 0, 'yes', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FreeNewIPAfterStagingAbort', 'clear_newIP', 1, 0, 'yes', null, null );


END;
END;


-- ENTRIES FOR STEP FreeNewIPAfterStagingFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'FreeNewIPAfterStagingFailure', 1, null, null, 8, 'StagingCheck', 2, null, null, null, null, null, 0, 'imageProvisionMainInner', null, 'FreeIPAddressCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP FreeNewIPAfterStagingFailure
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FreeNewIPAfterStagingFailure', 'assignment_urn', 1, 0, '%assignment_urn%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FreeNewIPAfterStagingFailure', 'clear_allIP', 1, 0, 'yes', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'FreeNewIPAfterStagingFailure', 'clear_newIP', 1, 0, 'yes', null, null );


END;
END;


-- ENTRIES FOR STEPSET callReset
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'callReset', 2, null, null, 7, 'imageProvisionMainInner', 2, null, null, null, null, null, 1, 'imageProvisionMain', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP initialCommand
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'initialCommand', 1, null, null, 1, 'callReset', 2, null, null, null, null, null, 0, 'callReset', null, 'ResetInitialCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP initialCommand
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'initialCommand', 'assignment_urn', 1, 0, '%assignment_urn%', null, null );


END;
END;


-- ENTRIES FOR STEPSET doForEachTarget
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'doForEachTarget', 5, null, null, 7, 'initialCommand', 1, null, null, null, 'hw_server_host_name', null, 1, 'callReset', null, null, 1, 0, 0, 0, null, null, -1 );

INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'doForEachTarget', 2, null, null, 5, 'doForEachTarget', 5, null, null, null, 'hw_server_host_name', null, 2, 'doForEachTarget', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP shceduleResetFailureJob
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'shceduleResetFailureJob', 1, null, null, 1, 'doForEachTarget', 2, null, null, null, null, null, 0, 'doForEachTarget', null, 'StageResetJobCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP shceduleResetFailureJob
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'shceduleResetFailureJob', 'hw_urn', 1, 0, '%hw_server_urns%[%job_iterate_index%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'shceduleResetFailureJob', 'assignment_urn', 1, 0, '%assignment_urn%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'shceduleResetFailureJob', 'iterate_index', 1, 0, '%job_iterate_index%', null, null );


END;
END;


-- ENTRY FOR NESTED JOB clearBootRecordAndResetTarget
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'clearBootRecordAndResetTarget';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'ResetProvisionTarget', FALSE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'clearBootRecordAndResetTarget', 12, 'ResetProvisionTarget', null, 7, 'shceduleResetFailureJob', 1, null, null, null, l_gen_iterate_param, null, 0, 'doForEachTarget', null, null, 1, null, 0, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'clearBootRecordAndResetTarget', 6, null, null, 7, 'clearBootRecordAndResetTarget', 12, null, null, null, l_gen_iterate_param, null, 1, 'doForEachTarget', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'clearBootRecordAndResetTarget', 2, null, null, 6, 'clearBootRecordAndResetTarget', 6, null, null, null, null, null, 1, 'clearBootRecordAndResetTarget', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'clearBootRecordAndResetTarget', 7, 'ResetProvisionTarget', null, 1, 'clearBootRecordAndResetTarget', 2, null, null, null, l_gen_iterate_param, null, 0, 'clearBootRecordAndResetTarget', null, null, 1, 0, 0, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'clearBootRecordAndResetTarget', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'clearBootRecordAndResetTarget', 7, 'ResetProvisionTarget', null, 7, 'shceduleResetFailureJob', 1, null, null, null, null, null, 0, 'doForEachTarget', null, null, 1, 0, 0, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP clearBootRecordAndResetTarget
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'clearBootRecordAndResetTarget', 'targetMachine', 1, 0, '%hw_server_host_name%[%job_iterate_index%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'clearBootRecordAndResetTarget', 'assignment_urn', 1, 0, '%assignment_urn%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'clearBootRecordAndResetTarget', 'hw_urn', 1, 0, '%hw_server_urns%[%job_iterate_index%]', null, null );


END;
END;


MGMT_JOB_ENGINE.extract_nested_job_targets(l_job_type_id, 'clearBootRecordAndResetTarget', MGMT_JOB_VECTOR_PARAMS('%hw_server_host_name%[%job_iterate_index%]'),MGMT_JOB_VECTOR_PARAMS('%job_target_types%[1]'));
-- Ensure that all existing scheduled executions use the new jobtype version
MGMT_JOB_ENGINE.reschedule_on_new_jobtype_ver(l_job_type_id);
-- Patch NLS information for backward-compatibility
MGMT_JOB_ENGINE.update_job_type_nls_info(l_job_type_id, l_job_type_name);

END;
END;


MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
EXCEPTION 
    WHEN OTHERS THEN 
        MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
        RAISE; 
END; 
/
COMMIT;
SET DEFINE ON

SET SQLPREFIX ON

