REM############################################################################
REM
REM Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
REM
REM
REM PRODUCT
REM	Oracle Enterprise Manager
REM
REM THIS FILE IS MACHINE GENERATED. DO NOT EDIT!
REM
REM JOB TYPE SQL FOR JOB TYPE: InstallJob
REM
REM#############################################################################

SET DEFINE OFF

SET SQLPREFIX OFF


BEGIN 
BEGIN
DECLARE
    l_job_type_name MGMT_JOB_TYPE_INFO.job_type%TYPE;
    l_job_type_id MGMT_JOB_TYPE_INFO.job_type_id%TYPE;
    l_major_version MGMT_JOB_TYPE_INFO.major_version%TYPE;
    l_minor_version1 MGMT_JOB_TYPE_INFO.minor_version1%TYPE;
    l_minor_version2 MGMT_JOB_TYPE_INFO.minor_version2%TYPE;
BEGIN

l_job_type_name:= 'InstallJob';

BEGIN 
MGMT_JOB_ENGINE.fix_flatten_steps(TRUE); 
MGMT_JOB_ENGINE.get_max_versions(l_job_type_name, l_major_version,
                   l_minor_version1, l_minor_version2, 
                   l_job_type_id); 
                         
l_minor_version2 := l_minor_version2+1; 
     
EXCEPTION 
    WHEN OTHERS THEN 
        IF SQLCODE=MGMT_GLOBAL.INVALID_JOB_TYPE_ERR THEN             l_major_version := 1; 
            l_minor_version1 := 0; 
            l_minor_version2 := 1; 
        ELSE 
            RAISE;
        END IF; 
END; 

-- CHECK TO VALIDATE REFERENCED COMMANDS/NESTED JOB TYPES
BEGIN
DECLARE
    l_commands SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
    l_nested_jobtypes SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN

    l_commands.trim(l_commands.count);

    l_commands.extend(13);
    l_commands(1) := 'CheckRunCloneCommand';
    l_commands(2) := 'remoteOp';
    l_commands(3) := 'ApplyMonitoringTemplateCommand';
    l_commands(4) := 'CreateCloneUsersCommand';
    l_commands(5) := 'PostInstallCommand';
    l_commands(6) := 'UpdateSuiteStatusCommand';
    l_commands(7) := 'CheckClusterCommand';
    l_commands(8) := 'AddHardwareToPatchGroupCommand';
    l_commands(9) := 'UpdateHardwareStatusCommand';
    l_commands(10) := 'UpdateInstallProgressCommand';
    l_commands(11) := 'InstallCommand';
    l_commands(12) := 'PostAddRemoveNodeCommand';
    l_commands(13) := 'CheckSuiteCommand';

    l_nested_jobtypes.trim(l_nested_jobtypes.count);

    l_nested_jobtypes.extend(5);
    l_nested_jobtypes(1) := 'CleanUpInstallJob';
    l_nested_jobtypes(2) := 'CloneProvComponents';
    l_nested_jobtypes(3) := 'ProvisionAddRemoveNode';
    l_nested_jobtypes(4) := 'ExecuteDirectivesJob';
    l_nested_jobtypes(5) := 'SuitePostInstall';
    MGMT_JOB_ENGINE.validate_job_type(l_job_type_name, l_commands, l_nested_jobtypes );


END;
END;


-- JOBTYPE ENTRY
INSERT INTO MGMT_JOB_TYPE_INFO(job_type, version, major_version, minor_version1, minor_version2, job_type_category, all_target_types, agent_bound, single_target, suspend_on_nocreds, default_target_type, restartable, editable, suspendable, trusted,job_type_nlsid,job_type_default,create_text_nlsid,create_text_default,delete_text_nlsid,delete_text_default)  VALUES
	( l_job_type_name, '1.0', l_major_version, l_minor_version1, l_minor_version2, 0, 0, 0, 0, 0, null, 1, 1, 1, -1, null, null, null, null, null, null)
RETURNING job_type_id INTO l_job_type_id;

-- ENTRIES FOR STEPSET main
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'main', 2, null, null, -1, null, -1, null, null, null, null, null, 1, null, 'install', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET install
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'install', 2, null, null, 1, 'main', 2, null, null, null, null, null, 1, 'main', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET installMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'installMain', 2, null, null, 1, 'install', 2, null, null, null, null, null, 1, 'install', 'cloneAndinstallMain', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET cloneAndinstallMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cloneAndinstallMain', 2, null, null, 1, 'installMain', 2, null, null, null, null, null, 1, 'installMain', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET installSubMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'installSubMain', 2, null, null, 1, 'cloneAndinstallMain', 2, null, null, null, null, null, 1, 'cloneAndinstallMain', 'installSubMainWrapper', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET installSubMainWrapper
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'installSubMainWrapper', 2, null, null, 1, 'installSubMain', 2, null, null, null, null, null, 1, 'installSubMain', null, null, 1, 0, 0, 0, null, null, -1 );

-- PARAMINFO ENTRIES FOR STEP getAllInstallDirectives
-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'HARDWARE_URN';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 0, 'getAllInstallDirectives', 1, 'user', 1, null, 0, 1, 0, l_param_names );


END;
END;


-- ENTRIES FOR STEP getAllInstallDirectives
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'getAllInstallDirectives', 1, null, null, 1, 'installSubMainWrapper', 2, null, null, null, null, null, 0, 'installSubMainWrapper', null, 'InstallCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP getAllInstallDirectives
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'getAllInstallDirectives', 'HARDWARE_URN', 1, 0, '%HARDWARE_URN%', null, null );


END;
END;


-- ENTRIES FOR STEPSET callInstall
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'callInstall', 3, null, null, 7, 'getAllInstallDirectives', 1, 'NEED_TO_INSTALL_FLAG', null, null, null, null, 1, 'installSubMainWrapper', 'toInstall', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET toInstall
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'toInstall', 2, null, null, 3, 'callInstall', 3, null, null, 'yes', null, null, 1, 'callInstall', 'startInstall', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET startInstall
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'startInstall', 2, null, null, 1, 'toInstall', 2, null, null, null, null, null, 1, 'toInstall', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET sudoToMkdir
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'sudoToMkdir', 2, null, null, 1, 'startInstall', 2, null, null, null, null, null, 1, 'startInstall', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP removeTimestampBeforeInstall
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'removeTimestampBeforeInstall', 1, null, null, 1, 'sudoToMkdir', 2, null, null, null, null, null, 0, 'sudoToMkdir', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP removeTimestampBeforeInstall
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeInstall', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeInstall', 'args', 1, 0, '-K', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeInstall', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeInstall', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeInstall', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeInstall', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeInstall', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEP mkdirTopLevelImageDir
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'mkdirTopLevelImageDir', 1, null, null, 7, 'removeTimestampBeforeInstall', 1, null, null, null, null, null, 0, 'sudoToMkdir', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP mkdirTopLevelImageDir
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'mkdirTopLevelImageDir', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'mkdirTopLevelImageDir', 'args', 1, 0, '-S, mkdir, -p, -m, 777, %TOP_DIR%, %IMAGES_DIR%, %TEMP_DIR%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'mkdirTopLevelImageDir', 'input', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'mkdirTopLevelImageDir', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'mkdirTopLevelImageDir', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'mkdirTopLevelImageDir', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'mkdirTopLevelImageDir', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'mkdirTopLevelImageDir', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEP removeTimestampAftermkdirTopLevelImageDir
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'removeTimestampAftermkdirTopLevelImageDir', 1, null, null, 7, 'mkdirTopLevelImageDir', 1, null, null, null, null, null, 0, 'sudoToMkdir', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP removeTimestampAftermkdirTopLevelImageDir
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAftermkdirTopLevelImageDir', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAftermkdirTopLevelImageDir', 'args', 1, 0, '-K', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAftermkdirTopLevelImageDir', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAftermkdirTopLevelImageDir', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAftermkdirTopLevelImageDir', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAftermkdirTopLevelImageDir', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAftermkdirTopLevelImageDir', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEPSET getImgHw
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'getImgHw', 3, null, null, 7, 'sudoToMkdir', 2, 'IS_NFS', null, null, null, null, 1, 'startInstall', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET sudoToMountAndUntar
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'sudoToMountAndUntar', 2, null, null, 3, 'getImgHw', 3, null, null, 'yes', null, null, 1, 'getImgHw', 'sudoToMountAndUntarInner', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET sudoToMountAndUntarInner
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'sudoToMountAndUntarInner', 2, null, null, 1, 'sudoToMountAndUntar', 2, null, null, null, null, null, 1, 'sudoToMountAndUntar', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP removeTimestampBeforeMount
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'removeTimestampBeforeMount', 1, null, null, 1, 'sudoToMountAndUntarInner', 2, null, null, null, null, null, 0, 'sudoToMountAndUntarInner', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP removeTimestampBeforeMount
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeMount', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeMount', 'args', 1, 0, '-K', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeMount', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeMount', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeMount', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeMount', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeMount', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEP mountStageTopLevelImageDir
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'mountStageTopLevelImageDir', 1, null, null, 7, 'removeTimestampBeforeMount', 1, null, null, null, null, null, 0, 'sudoToMountAndUntarInner', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP mountStageTopLevelImageDir
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'mountStageTopLevelImageDir', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'mountStageTopLevelImageDir', 'args', 1, 0, ' -S, mount, %MOUNT_FROM_HOST%:%SRC_MOUNT_DIR%, %TEMP_DIR% ', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'mountStageTopLevelImageDir', 'input', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'mountStageTopLevelImageDir', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'mountStageTopLevelImageDir', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'mountStageTopLevelImageDir', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'mountStageTopLevelImageDir', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'mountStageTopLevelImageDir', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEP removeTimestampAfterMount
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'removeTimestampAfterMount', 1, null, null, 7, 'mountStageTopLevelImageDir', 1, null, null, null, null, null, 0, 'sudoToMountAndUntarInner', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP removeTimestampAfterMount
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterMount', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterMount', 'args', 1, 0, '-K', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterMount', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterMount', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterMount', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterMount', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterMount', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEP untarTopLevelImageDir
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'untarTopLevelImageDir', 1, null, null, 7, 'removeTimestampAfterMount', 1, null, null, null, null, null, 0, 'sudoToMountAndUntarInner', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP untarTopLevelImageDir
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'untarTopLevelImageDir', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'untarTopLevelImageDir', 'args', 1, 0, '-S, /bin/sh, -c, tar -xvf  %IMAGE_HW_TAR% -C %IMAGES_DIR%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'untarTopLevelImageDir', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'untarTopLevelImageDir', 'input', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'untarTopLevelImageDir', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'untarTopLevelImageDir', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'untarTopLevelImageDir', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );


END;
END;


-- ENTRIES FOR STEP removeTimestampAfterUntar
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'removeTimestampAfterUntar', 1, null, null, 7, 'untarTopLevelImageDir', 1, null, null, null, null, null, 0, 'sudoToMountAndUntarInner', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP removeTimestampAfterUntar
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUntar', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUntar', 'args', 1, 0, '-K', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUntar', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUntar', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUntar', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUntar', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUntar', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEP changeUntaredDirectoryPermission
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'changeUntaredDirectoryPermission', 1, null, null, 7, 'removeTimestampAfterUntar', 1, null, null, null, null, null, 0, 'sudoToMountAndUntarInner', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP changeUntaredDirectoryPermission
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'changeUntaredDirectoryPermission', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'changeUntaredDirectoryPermission', 'args', 1, 0, '-S, chmod, -R, 755, %IMAGES_DIR%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'changeUntaredDirectoryPermission', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'changeUntaredDirectoryPermission', 'input', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'changeUntaredDirectoryPermission', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'changeUntaredDirectoryPermission', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'changeUntaredDirectoryPermission', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );


END;
END;


-- ENTRIES FOR STEPSET umountSuccess
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'umountSuccess', 2, null, null, 7, 'changeUntaredDirectoryPermission', 1, null, null, null, null, null, 1, 'sudoToMountAndUntarInner', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP removeTimestampBeforeUmountSuccess
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountSuccess', 1, null, null, 1, 'umountSuccess', 2, null, null, null, null, null, 0, 'umountSuccess', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP removeTimestampBeforeUmountSuccess
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountSuccess', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountSuccess', 'args', 1, 0, '-K', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountSuccess', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountSuccess', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountSuccess', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountSuccess', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountSuccess', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEP umountStageTopLevelImageDirSuccess
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirSuccess', 1, null, null, 7, 'removeTimestampBeforeUmountSuccess', 1, null, null, null, null, null, 0, 'umountSuccess', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP umountStageTopLevelImageDirSuccess
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirSuccess', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirSuccess', 'args', 1, 0, '-S, umount, %TEMP_DIR%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirSuccess', 'input', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirSuccess', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirSuccess', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirSuccess', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirSuccess', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirSuccess', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEP removeTimestampAfterUmountSuccess
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'removeTimestampAfterUmountSuccess', 1, null, null, 7, 'umountStageTopLevelImageDirSuccess', 1, null, null, null, null, null, 0, 'umountSuccess', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP removeTimestampAfterUmountSuccess
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountSuccess', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountSuccess', 'args', 1, 0, '-K', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountSuccess', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountSuccess', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountSuccess', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountSuccess', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountSuccess', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEPSET umountFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'umountFailure', 2, null, null, 8, 'sudoToMountAndUntarInner', 2, null, null, null, null, null, 1, 'sudoToMountAndUntar', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP removeTimestampBeforeUmountFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountFailure', 1, null, null, 1, 'umountFailure', 2, null, null, null, null, null, 0, 'umountFailure', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP removeTimestampBeforeUmountFailure
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountFailure', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountFailure', 'args', 1, 0, '-K', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountFailure', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountFailure', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountFailure', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountFailure', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountFailure', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEP umountStageTopLevelImageDirFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirFailure', 1, null, null, 7, 'removeTimestampBeforeUmountFailure', 1, null, null, null, null, null, 0, 'umountFailure', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP umountStageTopLevelImageDirFailure
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirFailure', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirFailure', 'args', 1, 0, '-S, umount, %TEMP_DIR%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirFailure', 'input', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirFailure', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirFailure', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirFailure', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirFailure', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirFailure', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEP removeTimestampAfterUmountFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'removeTimestampAfterUmountFailure', 1, null, null, 7, 'umountStageTopLevelImageDirFailure', 1, null, null, null, null, null, 0, 'umountFailure', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP removeTimestampAfterUmountFailure
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountFailure', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountFailure', 'args', 1, 0, '-K', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountFailure', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountFailure', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountFailure', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountFailure', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountFailure', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEPSET umountAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'umountAbort', 2, null, null, 9, 'sudoToMountAndUntarInner', 2, null, null, null, null, null, 1, 'sudoToMountAndUntar', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP removeTimestampBeforeUmountAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountAbort', 1, null, null, 1, 'umountAbort', 2, null, null, null, null, null, 0, 'umountAbort', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP removeTimestampBeforeUmountAbort
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountAbort', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountAbort', 'args', 1, 0, '-K', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountAbort', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountAbort', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountAbort', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountAbort', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampBeforeUmountAbort', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEP umountStageTopLevelImageDirAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirAbort', 1, null, null, 7, 'removeTimestampBeforeUmountAbort', 1, null, null, null, null, null, 0, 'umountAbort', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP umountStageTopLevelImageDirAbort
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirAbort', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirAbort', 'args', 1, 0, '-S, umount, %TEMP_DIR%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirAbort', 'input', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirAbort', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirAbort', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirAbort', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirAbort', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'umountStageTopLevelImageDirAbort', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEP removeTimestampAfterUmountAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'removeTimestampAfterUmountAbort', 1, null, null, 7, 'umountStageTopLevelImageDirAbort', 1, null, null, null, null, null, 0, 'umountAbort', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP removeTimestampAfterUmountAbort
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountAbort', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountAbort', 'args', 1, 0, '-K', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountAbort', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountAbort', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountAbort', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountAbort', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUmountAbort', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEPSET copyImgHwDir
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'copyImgHwDir', 2, null, null, 3, 'getImgHw', 3, null, null, 'no', null, null, 1, 'getImgHw', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP copyImageDirTar
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'copyImageDirTar', 1, null, null, 1, 'copyImgHwDir', 2, null, null, null, null, null, 0, 'copyImgHwDir', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP copyImageDirTar
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copyImageDirTar', 'remoteCommand', 1, 0, 'wget', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copyImageDirTar', 'args', 1, 0, ' %IMAGE_HW_URL%, -O, %IMAGE_HW_TAR%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copyImageDirTar', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copyImageDirTar', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copyImageDirTar', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'copyImageDirTar', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );


END;
END;


-- ENTRIES FOR STEP untarTopLevelImageDirNonNFS
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'untarTopLevelImageDirNonNFS', 1, null, null, 7, 'copyImageDirTar', 1, null, null, null, null, null, 0, 'copyImgHwDir', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP untarTopLevelImageDirNonNFS
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'untarTopLevelImageDirNonNFS', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'untarTopLevelImageDirNonNFS', 'args', 1, 0, '-S, /bin/sh, -c, tar -xvf  %IMAGE_HW_TAR% -C %IMAGES_DIR%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'untarTopLevelImageDirNonNFS', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'untarTopLevelImageDirNonNFS', 'input', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'untarTopLevelImageDirNonNFS', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'untarTopLevelImageDirNonNFS', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'untarTopLevelImageDirNonNFS', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );


END;
END;


-- ENTRIES FOR STEP removeTimestampAfterUntarNonNFS
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'removeTimestampAfterUntarNonNFS', 1, null, null, 7, 'untarTopLevelImageDirNonNFS', 1, null, null, null, null, null, 0, 'copyImgHwDir', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP removeTimestampAfterUntarNonNFS
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUntarNonNFS', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUntarNonNFS', 'args', 1, 0, '-K', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUntarNonNFS', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUntarNonNFS', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUntarNonNFS', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUntarNonNFS', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterUntarNonNFS', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEP changeUntaredDirectoryPermissionNonNFS
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'changeUntaredDirectoryPermissionNonNFS', 1, null, null, 7, 'removeTimestampAfterUntarNonNFS', 1, null, null, null, null, null, 0, 'copyImgHwDir', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP changeUntaredDirectoryPermissionNonNFS
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'changeUntaredDirectoryPermissionNonNFS', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'changeUntaredDirectoryPermissionNonNFS', 'args', 1, 0, '-S, chmod, -R, 755, %IMAGES_DIR%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'changeUntaredDirectoryPermissionNonNFS', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'changeUntaredDirectoryPermissionNonNFS', 'input', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'changeUntaredDirectoryPermissionNonNFS', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'changeUntaredDirectoryPermissionNonNFS', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'changeUntaredDirectoryPermissionNonNFS', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );


END;
END;


-- ENTRIES FOR STEP removeTimestampAfterChmodNonNFS
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'removeTimestampAfterChmodNonNFS', 1, null, null, 7, 'changeUntaredDirectoryPermissionNonNFS', 1, null, null, null, null, null, 0, 'copyImgHwDir', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP removeTimestampAfterChmodNonNFS
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterChmodNonNFS', 'remoteCommand', 1, 0, 'sudo', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterChmodNonNFS', 'args', 1, 0, '-K', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterChmodNonNFS', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterChmodNonNFS', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterChmodNonNFS', 'username', 1, 0, '%INSTALL_USERNAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterChmodNonNFS', 'password', 1, 0, '%INSTALL_PASSWORD%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'removeTimestampAfterChmodNonNFS', 'executeSynchronous', 1, 0, 'true', null, null );


END;
END;


-- ENTRIES FOR STEPSET executeInstall
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'executeInstall', 5, null, null, 7, 'getImgHw', 3, null, null, null, 'DIRECTIVE_URNS', null, 1, 'startInstall', null, null, 1, 0, 0, 1, null, null, -1 );

INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'executeInstall', 2, null, null, 5, 'executeInstall', 5, null, null, null, 'DIRECTIVE_URNS', null, 2, 'executeInstall', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB executeInstallDirective
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'executeInstallDirective';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'ExecuteDirectivesJob', FALSE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'executeInstallDirective', 12, 'ExecuteDirectivesJob', null, 1, 'executeInstall', 2, null, null, null, l_gen_iterate_param, null, 0, 'executeInstall', null, null, 1, null, 0, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'executeInstallDirective', 6, null, null, 7, 'executeInstallDirective', 12, null, null, null, l_gen_iterate_param, null, 1, 'executeInstall', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'executeInstallDirective', 2, null, null, 6, 'executeInstallDirective', 6, null, null, null, null, null, 1, 'executeInstallDirective', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'executeInstallDirective', 7, 'ExecuteDirectivesJob', null, 1, 'executeInstallDirective', 2, null, null, null, l_gen_iterate_param, null, 0, 'executeInstallDirective', null, null, 1, 0, 0, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'executeInstallDirective', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'executeInstallDirective', 7, 'ExecuteDirectivesJob', null, 1, 'executeInstall', 2, null, null, null, null, null, 0, 'executeInstall', null, null, 1, 0, 0, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP executeInstallDirective
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'executeInstallDirective', 'ASSIGNMENT_URN', 1, 0, '%ASSIGNMENT_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'executeInstallDirective', 'COMPONENT_URN', 1, 0, '%COMPONENT_URNS%[%job_iterate_index%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'executeInstallDirective', 'DIRECTIVE_URN', 1, 0, '%DIRECTIVE_URNS%[%job_iterate_index%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'executeInstallDirective', 'TARGET_FILENAME', 1, 0, '%TARGET_FILENAMES%[%job_iterate_index%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'executeInstallDirective', 'TOP_LEVEL_PROPERTY_PATH', 1, 0, '%TOP_LEVEL_PROPERTY_PATH%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'executeInstallDirective', 'PROPERTY_FILE_PATH', 1, 0, '%PROPERTY_FILENAME%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'executeInstallDirective', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'executeInstallDirective', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'executeInstallDirective', 'username', 1, 0, '%INSTALL_USERNAME%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'executeInstallDirective', 'password', 1, 0, '%INSTALL_PASSWORD%[1]', null, null );


END;
END;


MGMT_JOB_ENGINE.extract_nested_job_targets(l_job_type_id, 'executeInstallDirective', MGMT_JOB_VECTOR_PARAMS('%job_target_names%[1]'),MGMT_JOB_VECTOR_PARAMS('%job_target_types%[1]'));
-- ENTRIES FOR STEP updateInstallProgress
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateInstallProgress', 1, null, null, 7, 'executeInstallDirective', 7, null, null, null, null, null, 0, 'executeInstall', null, 'UpdateInstallProgressCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP updateInstallProgress
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateInstallProgress', 'HARDWARE_URN', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateInstallProgress', 'CURRENT_STEP', 1, 0, '%CURRENT_STEP%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateInstallProgress', 'TOTAL_STEP', 1, 0, '%TOTAL_STEP%', null, null );


END;
END;


-- ENTRIES FOR STEP updateFinalInstallProgress
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateFinalInstallProgress', 1, null, null, 7, 'callInstall', 3, null, null, null, null, null, 0, 'installSubMainWrapper', null, 'UpdateInstallProgressCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP updateFinalInstallProgress
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateFinalInstallProgress', 'HARDWARE_URN', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateFinalInstallProgress', 'CURRENT_STEP', 1, 0, '1', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateFinalInstallProgress', 'TOTAL_STEP', 1, 0, '1', null, null );


END;
END;


-- ENTRIES FOR STEPSET cloneMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cloneMain', 2, null, null, 7, 'installSubMain', 2, null, null, null, null, null, 1, 'cloneAndinstallMain', 'cloneSubMain', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET cloneSubMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cloneSubMain', 2, null, null, 1, 'cloneMain', 2, null, null, null, null, null, 1, 'cloneMain', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP readUserParams
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'readUserParams', 1, null, null, 1, 'cloneSubMain', 2, null, null, null, null, null, 0, 'cloneSubMain', null, 'CreateCloneUsersCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP readUserParams
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'readUserParams', 'hw_urn', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'readUserParams', 'emuser_id', 1, 0, '%job_owner%', null, null );


END;
END;


-- ENTRIES FOR STEP checkInvokeCloning
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'checkInvokeCloning', 1, null, null, 2, 'readUserParams', 1, null, null, null, null, null, 0, 'cloneSubMain', null, 'CheckRunCloneCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP checkInvokeCloning
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkInvokeCloning', 'hw_urn', 1, 0, '%HARDWARE_URN%', null, null );


END;
END;


-- ENTRIES FOR STEPSET chkRunCloning
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'chkRunCloning', 3, null, null, 2, 'checkInvokeCloning', 1, 'run_clone_job', null, null, null, null, 1, 'cloneSubMain', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET runCloneJobSwitch
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runCloneJobSwitch', 2, null, null, 3, 'chkRunCloning', 3, null, null, 'YES', null, null, 1, 'chkRunCloning', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB runCloneJob
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'runCloneJob';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'CloneProvComponents', FALSE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runCloneJob', 12, 'CloneProvComponents', null, 1, 'runCloneJobSwitch', 2, null, null, null, l_gen_iterate_param, null, 0, 'runCloneJobSwitch', null, null, 1, null, 0, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runCloneJob', 6, null, null, 7, 'runCloneJob', 12, null, null, null, l_gen_iterate_param, null, 1, 'runCloneJobSwitch', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runCloneJob', 2, null, null, 6, 'runCloneJob', 6, null, null, null, null, null, 1, 'runCloneJob', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runCloneJob', 7, 'CloneProvComponents', null, 1, 'runCloneJob', 2, null, null, null, l_gen_iterate_param, null, 0, 'runCloneJob', null, null, 1, 0, 0, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'runCloneJob', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runCloneJob', 7, 'CloneProvComponents', null, 1, 'runCloneJobSwitch', 2, null, null, null, null, null, 0, 'runCloneJobSwitch', null, null, 1, 0, 0, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP runCloneJob
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runCloneJob', 'ASSIGNMENT_URN', 1, 0, '%assignment_urn%', null, null );


END;
END;


MGMT_JOB_ENGINE.extract_nested_job_targets(l_job_type_id, 'runCloneJob', MGMT_JOB_VECTOR_PARAMS('%job_target_names%[1]'),MGMT_JOB_VECTOR_PARAMS('%job_target_types%[1]'));
-- ENTRIES FOR STEPSET postInstall
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postInstall', 2, null, null, 8, 'cloneSubMain', 2, null, null, null, null, null, 1, 'cloneMain', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP postInstallCommand
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postInstallCommand', 1, null, null, 1, 'postInstall', 2, null, null, null, null, null, 0, 'postInstall', null, 'PostInstallCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP postInstallCommand
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postInstallCommand', 'hw_urn', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postInstallCommand', 'failed_step', 1, 0, 'INSTALL_MAIN', null, null );


END;
END;


-- ENTRIES FOR STEP checkClusterAfterCloneErr
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'checkClusterAfterCloneErr', 1, null, null, 2, 'postInstallCommand', 1, null, null, null, null, null, 0, 'postInstall', null, 'CheckClusterCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP checkClusterAfterCloneErr
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkClusterAfterCloneErr', 'HARDWARE_URN', 1, 0, '%HARDWARE_URN%', null, null );


END;
END;


-- ENTRIES FOR STEP checkSuiteAfterCloneErr
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'checkSuiteAfterCloneErr', 1, null, null, 2, 'checkClusterAfterCloneErr', 1, null, null, null, null, null, 0, 'postInstall', null, 'CheckSuiteCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP checkSuiteAfterCloneErr
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkSuiteAfterCloneErr', 'hw_urn', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkSuiteAfterCloneErr', 'last_node', 1, 0, '%last_node%', null, null );


END;
END;


-- ENTRIES FOR STEPSET installAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'installAbort', 2, null, null, 9, 'cloneAndinstallMain', 2, null, null, null, null, null, 1, 'installMain', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP installAbortCommand
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'installAbortCommand', 1, null, null, 1, 'installAbort', 2, null, null, null, null, null, 0, 'installAbort', null, 'PostInstallCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP installAbortCommand
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'installAbortCommand', 'hw_urn', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'installAbortCommand', 'failed_step', 1, 0, 'INSTALL_MAIN', null, null );


END;
END;


-- ENTRIES FOR STEP checkClusterAfterInstallAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'checkClusterAfterInstallAbort', 1, null, null, 2, 'installAbortCommand', 1, null, null, null, null, null, 0, 'installAbort', null, 'CheckClusterCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP checkClusterAfterInstallAbort
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkClusterAfterInstallAbort', 'HARDWARE_URN', 1, 0, '%HARDWARE_URN%', null, null );


END;
END;


-- ENTRIES FOR STEP checkSuiteAfterInstallAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'checkSuiteAfterInstallAbort', 1, null, null, 2, 'checkClusterAfterInstallAbort', 1, null, null, null, null, null, 0, 'installAbort', null, 'CheckSuiteCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP checkSuiteAfterInstallAbort
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkSuiteAfterInstallAbort', 'hw_urn', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkSuiteAfterInstallAbort', 'last_node', 1, 0, '%last_node%', null, null );


END;
END;


-- ENTRIES FOR STEPSET installFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'installFailure', 2, null, null, 8, 'cloneAndinstallMain', 2, null, null, null, null, null, 1, 'installMain', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP installFailureCommand
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'installFailureCommand', 1, null, null, 1, 'installFailure', 2, null, null, null, null, null, 0, 'installFailure', null, 'PostInstallCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP installFailureCommand
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'installFailureCommand', 'hw_urn', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'installFailureCommand', 'failed_step', 1, 0, 'INSTALL_MAIN', null, null );


END;
END;


-- ENTRIES FOR STEP checkClusterAfterInstallFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'checkClusterAfterInstallFailure', 1, null, null, 2, 'installFailureCommand', 1, null, null, null, null, null, 0, 'installFailure', null, 'CheckClusterCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP checkClusterAfterInstallFailure
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkClusterAfterInstallFailure', 'HARDWARE_URN', 1, 0, '%HARDWARE_URN%', null, null );


END;
END;


-- ENTRIES FOR STEP checkSuiteAfterInstallFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'checkSuiteAfterInstallFailure', 1, null, null, 2, 'checkClusterAfterInstallFailure', 1, null, null, null, null, null, 0, 'installFailure', null, 'CheckSuiteCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP checkSuiteAfterInstallFailure
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkSuiteAfterInstallFailure', 'hw_urn', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkSuiteAfterInstallFailure', 'last_node', 1, 0, '%last_node%', null, null );


END;
END;


-- ENTRIES FOR STEPSET clusterAndSuite
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'clusterAndSuite', 2, null, null, 7, 'installMain', 2, null, null, null, null, null, 1, 'install', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET clusterAndSuiteMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'clusterAndSuiteMain', 2, null, null, 1, 'clusterAndSuite', 2, null, null, null, null, null, 1, 'clusterAndSuite', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET clusterActionsMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'clusterActionsMain', 2, null, null, 1, 'clusterAndSuiteMain', 2, null, null, null, null, null, 1, 'clusterAndSuiteMain', 'clusterActionsSubMain', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET clusterActionsSubMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'clusterActionsSubMain', 2, null, null, 1, 'clusterActionsMain', 2, null, null, null, null, null, 1, 'clusterActionsMain', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP checkCluster
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'checkCluster', 1, null, null, 1, 'clusterActionsSubMain', 2, null, null, null, null, null, 0, 'clusterActionsSubMain', null, 'CheckClusterCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP checkCluster
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkCluster', 'HARDWARE_URN', 1, 0, '%HARDWARE_URN%', null, null );


END;
END;


-- ENTRIES FOR STEP postClusterActions1
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postClusterActions1', 1, null, null, 8, 'checkCluster', 1, null, null, null, null, null, 0, 'clusterActionsSubMain', null, 'PostInstallCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP postClusterActions1
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postClusterActions1', 'hw_urn', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postClusterActions1', 'failed_step', 1, 0, 'CLUSTER_MAIN', null, null );


END;
END;


-- ENTRIES FOR STEPSET chkRunAddNode
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'chkRunAddNode', 3, null, null, 7, 'checkCluster', 1, 'run_add_node', null, null, null, null, 1, 'clusterActionsSubMain', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET addNode
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'addNode', 2, null, null, 3, 'chkRunAddNode', 3, null, null, 'YES', null, null, 1, 'chkRunAddNode', 'doForEachNode', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET doForEachNode
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'doForEachNode', 2, null, null, 1, 'addNode', 2, null, null, null, null, null, 1, 'addNode', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET doForEachNewNode
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'doForEachNewNode', 5, null, null, 1, 'doForEachNode', 2, null, null, null, 'new_node_target_names', null, 1, 'doForEachNode', null, null, 1, 0, 0, 0, null, null, -1 );

INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'doForEachNewNode', 2, null, null, 5, 'doForEachNewNode', 5, null, null, null, 'new_node_target_names', null, 1, 'doForEachNewNode', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB runAddNodeDirectiveOnNewNode
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'runAddNodeDirectiveOnNewNode';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'ProvisionAddRemoveNode', FALSE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnNewNode', 12, 'ProvisionAddRemoveNode', null, 1, 'doForEachNewNode', 2, null, null, null, l_gen_iterate_param, null, 0, 'doForEachNewNode', null, null, 1, null, 0, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnNewNode', 6, null, null, 7, 'runAddNodeDirectiveOnNewNode', 12, null, null, null, l_gen_iterate_param, null, 1, 'doForEachNewNode', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnNewNode', 2, null, null, 6, 'runAddNodeDirectiveOnNewNode', 6, null, null, null, null, null, 1, 'runAddNodeDirectiveOnNewNode', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnNewNode', 7, 'ProvisionAddRemoveNode', null, 1, 'runAddNodeDirectiveOnNewNode', 2, null, null, null, l_gen_iterate_param, null, 0, 'runAddNodeDirectiveOnNewNode', null, null, 1, 0, 0, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnNewNode', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnNewNode', 7, 'ProvisionAddRemoveNode', null, 1, 'doForEachNewNode', 2, null, null, null, null, null, 0, 'doForEachNewNode', null, null, 1, 0, 0, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP runAddNodeDirectiveOnNewNode
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnNewNode', 'clus_asn_urn', 1, 0, '%ASSIGNMENT_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnNewNode', 'cluster_dir_action', 1, 0, 'ADD_NODE', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnNewNode', 'IS_EXISTING_NODE', 1, 0, 'NO', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnNewNode', 'username', 1, 0, '%node_username_names%[%job_iterate_index%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnNewNode', 'password', 1, 0, '%node_passwd_names%[%job_iterate_index%]', null, null );


END;
END;


MGMT_JOB_ENGINE.extract_nested_job_targets(l_job_type_id, 'runAddNodeDirectiveOnNewNode', MGMT_JOB_VECTOR_PARAMS('%new_node_target_names%[%job_iterate_index%]'),MGMT_JOB_VECTOR_PARAMS('%job_target_types%[1]'));
-- ENTRIES FOR STEPSET doForEachExistingNode
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'doForEachExistingNode', 5, null, null, 7, 'doForEachNewNode', 5, null, null, null, 'existing_node_target_names', null, 1, 'doForEachNode', null, null, 1, 0, 0, 0, null, null, -1 );

INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'doForEachExistingNode', 2, null, null, 5, 'doForEachExistingNode', 5, null, null, null, 'existing_node_target_names', null, 1, 'doForEachExistingNode', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB runAddNodeDirectiveOnExistingNode
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'runAddNodeDirectiveOnExistingNode';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'ProvisionAddRemoveNode', FALSE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnExistingNode', 12, 'ProvisionAddRemoveNode', null, 1, 'doForEachExistingNode', 2, null, null, null, l_gen_iterate_param, null, 0, 'doForEachExistingNode', null, null, 1, null, 0, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnExistingNode', 6, null, null, 7, 'runAddNodeDirectiveOnExistingNode', 12, null, null, null, l_gen_iterate_param, null, 1, 'doForEachExistingNode', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnExistingNode', 2, null, null, 6, 'runAddNodeDirectiveOnExistingNode', 6, null, null, null, null, null, 1, 'runAddNodeDirectiveOnExistingNode', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnExistingNode', 7, 'ProvisionAddRemoveNode', null, 1, 'runAddNodeDirectiveOnExistingNode', 2, null, null, null, l_gen_iterate_param, null, 0, 'runAddNodeDirectiveOnExistingNode', null, null, 1, 0, 0, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnExistingNode', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnExistingNode', 7, 'ProvisionAddRemoveNode', null, 1, 'doForEachExistingNode', 2, null, null, null, null, null, 0, 'doForEachExistingNode', null, null, 1, 0, 0, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP runAddNodeDirectiveOnExistingNode
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnExistingNode', 'clus_asn_urn', 1, 0, '%ASSIGNMENT_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnExistingNode', 'cluster_dir_action', 1, 0, 'ADD_NODE', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runAddNodeDirectiveOnExistingNode', 'IS_EXISTING_NODE', 1, 0, 'YES', null, null );


END;
END;


MGMT_JOB_ENGINE.extract_nested_job_targets(l_job_type_id, 'runAddNodeDirectiveOnExistingNode', MGMT_JOB_VECTOR_PARAMS('%existing_node_target_names%[%job_iterate_index%]'),MGMT_JOB_VECTOR_PARAMS('%job_target_types%[1]'));
-- ENTRIES FOR STEP postAddNodeSuc
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postAddNodeSuc', 1, null, null, 7, 'doForEachNode', 2, null, null, null, null, null, 0, 'addNode', null, 'PostAddRemoveNodeCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP postAddNodeSuc
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postAddNodeSuc', 'ASSIGNMENT_URN', 1, 0, '%ASSIGNMENT_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postAddNodeSuc', 'HARDWARE_URN', 1, 0, '%HARDWARE_URN%', null, null );


END;
END;


-- ENTRIES FOR STEPSET postAddNodeFailedClusterSuite
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postAddNodeFailedClusterSuite', 2, null, null, 8, 'doForEachNode', 2, null, null, null, null, null, 1, 'addNode', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP postAddNodeFail
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postAddNodeFail', 1, null, null, 1, 'postAddNodeFailedClusterSuite', 2, null, null, null, null, null, 0, 'postAddNodeFailedClusterSuite', null, 'PostAddRemoveNodeCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP postAddNodeFail
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postAddNodeFail', 'ASSIGNMENT_URN', 1, 0, '%ASSIGNMENT_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postAddNodeFail', 'HARDWARE_URN', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postAddNodeFail', 'ADD_NODE_STATUS', 1, 0, 'FAILED', null, null );


END;
END;


-- ENTRIES FOR STEPSET suiteActionsFailMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'suiteActionsFailMain', 2, null, null, 2, 'postAddNodeFail', 1, null, null, null, null, null, 1, 'postAddNodeFailedClusterSuite', 'checkSuiteFailMain', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP checkSuiteFailMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'checkSuiteFailMain', 1, null, null, 1, 'suiteActionsFailMain', 2, null, null, null, null, null, 0, 'suiteActionsFailMain', null, 'CheckSuiteCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP checkSuiteFailMain
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkSuiteFailMain', 'hw_urn', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkSuiteFailMain', 'last_node', 1, 0, '%last_node%', null, null );


END;
END;


-- ENTRIES FOR STEP postSuiteActionsFailMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postSuiteActionsFailMain', 1, null, null, 8, 'checkSuiteFailMain', 1, null, null, null, null, null, 0, 'suiteActionsFailMain', null, 'PostInstallCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP postSuiteActionsFailMain
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postSuiteActionsFailMain', 'hw_urn', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postSuiteActionsFailMain', 'failed_step', 1, 0, 'SUITE_MAIN', null, null );


END;
END;


-- ENTRIES FOR STEPSET postAddNodeAbortClusterSuite
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postAddNodeAbortClusterSuite', 2, null, null, 9, 'doForEachNode', 2, null, null, null, null, null, 1, 'addNode', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP postAddNodeAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postAddNodeAbort', 1, null, null, 1, 'postAddNodeAbortClusterSuite', 2, null, null, null, null, null, 0, 'postAddNodeAbortClusterSuite', null, 'PostAddRemoveNodeCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP postAddNodeAbort
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postAddNodeAbort', 'ASSIGNMENT_URN', 1, 0, '%ASSIGNMENT_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postAddNodeAbort', 'HARDWARE_URN', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postAddNodeAbort', 'ADD_NODE_STATUS', 1, 0, 'FAILED', null, null );


END;
END;


-- ENTRIES FOR STEPSET suiteActionsAbortMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'suiteActionsAbortMain', 2, null, null, 2, 'postAddNodeAbort', 1, null, null, null, null, null, 1, 'postAddNodeAbortClusterSuite', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP checkSuiteAbortMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'checkSuiteAbortMain', 1, null, null, 1, 'suiteActionsAbortMain', 2, null, null, null, null, null, 0, 'suiteActionsAbortMain', null, 'CheckSuiteCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP checkSuiteAbortMain
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkSuiteAbortMain', 'hw_urn', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkSuiteAbortMain', 'last_node', 1, 0, '%last_node%', null, null );


END;
END;


-- ENTRIES FOR STEP postSuiteActionsAbortMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postSuiteActionsAbortMain', 1, null, null, 8, 'checkSuiteAbortMain', 1, null, null, null, null, null, 0, 'suiteActionsAbortMain', null, 'PostInstallCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP postSuiteActionsAbortMain
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postSuiteActionsAbortMain', 'hw_urn', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postSuiteActionsAbortMain', 'failed_step', 1, 0, 'SUITE_MAIN', null, null );


END;
END;


-- ENTRIES FOR STEPSET suiteActionsMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'suiteActionsMain', 2, null, null, 7, 'clusterActionsMain', 2, null, null, null, null, null, 1, 'clusterAndSuiteMain', 'checkSuiteMainOuter', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET checkSuiteMainOuter
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'checkSuiteMainOuter', 2, null, null, 1, 'suiteActionsMain', 2, null, null, null, null, null, 1, 'suiteActionsMain', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP checkSuiteMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'checkSuiteMain', 1, null, null, 1, 'checkSuiteMainOuter', 2, null, null, null, null, null, 0, 'checkSuiteMainOuter', null, 'CheckSuiteCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP checkSuiteMain
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkSuiteMain', 'hw_urn', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkSuiteMain', 'last_node', 1, 0, '%last_node%', null, null );


END;
END;


-- ENTRIES FOR STEPSET updateTargets
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateTargets', 2, null, null, 7, 'checkSuiteMain', 1, null, null, null, null, null, 1, 'checkSuiteMainOuter', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET updateTargetsSwitch
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateTargetsSwitch', 3, null, null, 1, 'updateTargets', 2, 'image_or_cluster', null, null, null, null, 1, 'updateTargets', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET updateTargetsImage
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateTargetsImage', 2, null, null, 3, 'updateTargetsSwitch', 3, null, null, 'image', null, null, 1, 'updateTargetsSwitch', 'updateNodeStatus', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP addHardwareToPatchGroup
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'addHardwareToPatchGroup', 1, null, null, 1, 'updateTargetsImage', 2, null, null, null, null, null, 0, 'updateTargetsImage', null, 'AddHardwareToPatchGroupCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP addHardwareToPatchGroup
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'addHardwareToPatchGroup', 'HARDWARE_URN', 1, 0, '%HARDWARE_URN%', null, null );


END;
END;


-- ENTRIES FOR STEP ApplyMonitoringTemplate
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'ApplyMonitoringTemplate', 1, null, null, 2, 'addHardwareToPatchGroup', 1, null, null, null, null, null, 0, 'updateTargetsImage', null, 'ApplyMonitoringTemplateCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP ApplyMonitoringTemplate
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'ApplyMonitoringTemplate', 'HARDWARE_URN', 1, 0, '%HARDWARE_URN%', null, null );


END;
END;


-- ENTRIES FOR STEP updateNodeStatus
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateNodeStatus', 1, null, null, 2, 'ApplyMonitoringTemplate', 1, null, null, null, null, null, 0, 'updateTargetsImage', null, 'UpdateHardwareStatusCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP updateNodeStatus
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateNodeStatus', 'hw_urn', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateNodeStatus', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateNodeStatus', 'targetType', 1, 0, '%job_target_types%[1]', null, null );


END;
END;


-- ENTRIES FOR STEPSET updateTargetsCluster
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateTargetsCluster', 2, null, null, 3, 'updateTargetsSwitch', 3, null, null, 'cluster', null, null, 1, 'updateTargetsSwitch', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET updateTargetsClusterInner
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateTargetsClusterInner', 3, null, null, 1, 'updateTargetsCluster', 2, 'last_node', null, null, null, null, 1, 'updateTargetsCluster', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET updateTargetsClusterAfterLastNode
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateTargetsClusterAfterLastNode', 2, null, null, 3, 'updateTargetsClusterInner', 3, null, null, 'YES', null, null, 1, 'updateTargetsClusterInner', 'updateNodesStatusMain', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET updateNodesStatusMain
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateNodesStatusMain', 5, null, null, 1, 'updateTargetsClusterAfterLastNode', 2, null, null, null, 'new_node_target_urns', null, 1, 'updateTargetsClusterAfterLastNode', null, null, 1, 0, 0, 0, null, null, -1 );

INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateNodesStatusMain', 2, null, null, 5, 'updateNodesStatusMain', 5, null, null, null, 'new_node_target_urns', null, 1, 'updateNodesStatusMain', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP updateNodesStatus
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateNodesStatus', 1, null, null, 1, 'updateNodesStatusMain', 2, null, null, null, null, null, 0, 'updateNodesStatusMain', null, 'UpdateHardwareStatusCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP updateNodesStatus
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateNodesStatus', 'hw_urn', 1, 0, '%new_node_target_urns%[%job_iterate_index%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateNodesStatus', 'targetName', 1, 0, '%new_node_target_names%[%job_iterate_index%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateNodesStatus', 'targetType', 1, 0, '%job_target_types%[1]', null, null );


END;
END;


-- ENTRIES FOR STEPSET postSuiteActionsMainFailureOuter
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postSuiteActionsMainFailureOuter', 2, null, null, 8, 'checkSuiteMainOuter', 2, null, null, null, null, null, 1, 'suiteActionsMain', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP updateSuiteStatusFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateSuiteStatusFailure', 1, null, null, 1, 'postSuiteActionsMainFailureOuter', 2, null, null, null, null, null, 0, 'postSuiteActionsMainFailureOuter', null, 'UpdateSuiteStatusCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP updateSuiteStatusFailure
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateSuiteStatusFailure', 'assignment_urn', 1, 0, '%suite_asgmnt_urn%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateSuiteStatusFailure', 'ACTION', 1, 0, 'FAILED', null, null );


END;
END;


-- ENTRIES FOR STEP postSuiteActionsMainFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postSuiteActionsMainFailure', 1, null, null, 2, 'updateSuiteStatusFailure', 1, null, null, null, null, null, 0, 'postSuiteActionsMainFailureOuter', null, 'PostInstallCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP postSuiteActionsMainFailure
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postSuiteActionsMainFailure', 'hw_urn', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postSuiteActionsMainFailure', 'failed_step', 1, 0, 'SUITE_MAIN', null, null );


END;
END;


-- ENTRIES FOR STEPSET postSuiteActionsMainAbortOuter
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postSuiteActionsMainAbortOuter', 2, null, null, 9, 'checkSuiteMainOuter', 2, null, null, null, null, null, 1, 'suiteActionsMain', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP updateSuiteStatusAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateSuiteStatusAbort', 1, null, null, 1, 'postSuiteActionsMainAbortOuter', 2, null, null, null, null, null, 0, 'postSuiteActionsMainAbortOuter', null, 'UpdateSuiteStatusCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP updateSuiteStatusAbort
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateSuiteStatusAbort', 'assignment_urn', 1, 0, '%suite_asgmnt_urn%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateSuiteStatusAbort', 'ACTION', 1, 0, 'FAILED', null, null );


END;
END;


-- ENTRIES FOR STEP postSuiteActionsMainAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postSuiteActionsMainAbort', 1, null, null, 2, 'updateSuiteStatusAbort', 1, null, null, null, null, null, 0, 'postSuiteActionsMainAbortOuter', null, 'PostInstallCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP postSuiteActionsMainAbort
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postSuiteActionsMainAbort', 'hw_urn', 1, 0, '%HARDWARE_URN%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postSuiteActionsMainAbort', 'failed_step', 1, 0, 'SUITE_MAIN', null, null );


END;
END;


-- ENTRIES FOR STEPSET runPostInstallDir
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runPostInstallDir', 3, null, null, 7, 'checkSuiteMainOuter', 2, 'suite_need_to_execute', null, null, null, null, 1, 'suiteActionsMain', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET runPostInstallDirYes
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runPostInstallDirYes', 2, null, null, 3, 'runPostInstallDir', 3, null, null, 'YES', null, null, 1, 'runPostInstallDir', 'runPostInstallDirYesInner', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET runPostInstallDirYesInner
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runPostInstallDirYesInner', 2, null, null, 1, 'runPostInstallDirYes', 2, null, null, null, null, null, 1, 'runPostInstallDirYes', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET iterateOverAllAssignments
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'iterateOverAllAssignments', 5, null, null, 1, 'runPostInstallDirYesInner', 2, null, null, null, 'assignment_urns', null, 1, 'runPostInstallDirYesInner', null, null, 1, 0, 0, 0, null, null, -1 );

INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'iterateOverAllAssignments', 2, null, null, 5, 'iterateOverAllAssignments', 5, null, null, null, 'assignment_urns', null, 1, 'iterateOverAllAssignments', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB postInstallSuiteDir
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'postInstallSuiteDir';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'SuitePostInstall', TRUE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'postInstallSuiteDir', 12, 'SuitePostInstall', null, 1, 'iterateOverAllAssignments', 2, null, null, null, l_gen_iterate_param, null, 0, 'iterateOverAllAssignments', null, null, 1, null, 1, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postInstallSuiteDir', 6, null, null, 7, 'postInstallSuiteDir', 12, null, null, null, l_gen_iterate_param, null, 1, 'iterateOverAllAssignments', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postInstallSuiteDir', 2, null, null, 6, 'postInstallSuiteDir', 6, null, null, null, null, null, 1, 'postInstallSuiteDir', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'postInstallSuiteDir', 7, 'SuitePostInstall', null, 1, 'postInstallSuiteDir', 2, null, null, null, l_gen_iterate_param, null, 0, 'postInstallSuiteDir', null, null, 1, 0, 1, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'postInstallSuiteDir', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'postInstallSuiteDir', 7, 'SuitePostInstall', null, 1, 'iterateOverAllAssignments', 2, null, null, null, null, null, 0, 'iterateOverAllAssignments', null, null, 1, 0, 1, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP postInstallSuiteDir
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postInstallSuiteDir', 'assignment_urn', 1, 0, '%assignment_urns%[%job_iterate_index%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postInstallSuiteDir', 'suite_urn', -1, 0, null, null, 'suite_urn' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'postInstallSuiteDir', 'suite_asgmnt_urn', -1, 0, null, null, 'suite_asgmnt_urn' );


END;
END;


-- ENTRIES FOR STEP updateSuiteStatusSuccess
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateSuiteStatusSuccess', 1, null, null, 7, 'iterateOverAllAssignments', 5, null, null, null, null, null, 0, 'runPostInstallDirYesInner', null, 'UpdateSuiteStatusCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP updateSuiteStatusSuccess
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateSuiteStatusSuccess', 'assignment_urn', 1, 0, '%suite_asgmnt_urn%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateSuiteStatusSuccess', 'ACTION', 1, 0, 'SUCCESS', null, null );


END;
END;


-- ENTRIES FOR STEP updateSuiteStatusFailed
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateSuiteStatusFailed', 1, null, null, 8, 'iterateOverAllAssignments', 5, null, null, null, null, null, 0, 'runPostInstallDirYesInner', null, 'UpdateSuiteStatusCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP updateSuiteStatusFailed
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateSuiteStatusFailed', 'assignment_urn', 1, 0, '%suite_asgmnt_urn%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateSuiteStatusFailed', 'ACTION', 1, 0, 'FALIED', null, null );


END;
END;


-- ENTRIES FOR STEP updateSuiteStatusAborted
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateSuiteStatusAborted', 1, null, null, 9, 'iterateOverAllAssignments', 5, null, null, null, null, null, 0, 'runPostInstallDirYesInner', null, 'UpdateSuiteStatusCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP updateSuiteStatusAborted
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateSuiteStatusAborted', 'assignment_urn', 1, 0, '%suite_asgmnt_urn%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateSuiteStatusAborted', 'ACTION', 1, 0, 'FAILED', null, null );


END;
END;


-- ENTRIES FOR STEPSET cleanUpInstallAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpInstallAbort', 2, null, null, 9, 'install', 2, null, null, null, null, null, 1, 'main', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET cleanUpAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpAbort', 3, null, null, 1, 'cleanUpInstallAbort', 2, 'image_or_cluster', null, null, null, null, 1, 'cleanUpInstallAbort', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET cleanUpImageAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpImageAbort', 2, null, null, 3, 'cleanUpAbort', 3, null, null, 'image', null, null, 1, 'cleanUpAbort', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET deleteInstalluserAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'deleteInstalluserAbort', 3, null, null, 1, 'cleanUpImageAbort', 2, 'delete_install_user', null, null, null, null, 1, 'cleanUpImageAbort', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET deleteInstallUserAbortYes
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'deleteInstallUserAbortYes', 2, null, null, 3, 'deleteInstalluserAbort', 3, null, null, 'YES', null, null, 1, 'deleteInstalluserAbort', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB cleanUpImageInstallAbort
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'cleanUpImageInstallAbort';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'CleanUpInstallJob', TRUE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'cleanUpImageInstallAbort', 12, 'CleanUpInstallJob', null, 1, 'deleteInstallUserAbortYes', 2, null, null, null, l_gen_iterate_param, null, 0, 'deleteInstallUserAbortYes', null, null, 1, null, 1, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpImageInstallAbort', 6, null, null, 7, 'cleanUpImageInstallAbort', 12, null, null, null, l_gen_iterate_param, null, 1, 'deleteInstallUserAbortYes', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpImageInstallAbort', 2, null, null, 6, 'cleanUpImageInstallAbort', 6, null, null, null, null, null, 1, 'cleanUpImageInstallAbort', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'cleanUpImageInstallAbort', 7, 'CleanUpInstallJob', null, 1, 'cleanUpImageInstallAbort', 2, null, null, null, l_gen_iterate_param, null, 0, 'cleanUpImageInstallAbort', null, null, 1, 0, 1, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'cleanUpImageInstallAbort', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpImageInstallAbort', 7, 'CleanUpInstallJob', null, 1, 'deleteInstallUserAbortYes', 2, null, null, null, null, null, 0, 'deleteInstallUserAbortYes', null, null, 1, 0, 1, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP cleanUpImageInstallAbort
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpImageInstallAbort', 'target_list', -1, 0, null, null, 'target_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpImageInstallAbort', 'username_list', -1, 0, null, null, 'username_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpImageInstallAbort', 'password_list', -1, 0, null, null, 'password_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpImageInstallAbort', 'TOP_DIR', 1, 0, '%TOP_DIR%', null, null );


END;
END;


-- ENTRIES FOR STEPSET cleanUpClusterAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpClusterAbort', 2, null, null, 3, 'cleanUpAbort', 3, null, null, 'cluster', null, null, 1, 'cleanUpAbort', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET cleanUpClusterInnerAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpClusterInnerAbort', 3, null, null, 1, 'cleanUpClusterAbort', 2, 'last_node', null, null, null, null, 1, 'cleanUpClusterAbort', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET cleanUpClusterAfterLastNodeAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpClusterAfterLastNodeAbort', 2, null, null, 3, 'cleanUpClusterInnerAbort', 3, null, null, 'YES', null, null, 1, 'cleanUpClusterInnerAbort', 'updateNodesStatusMainAbort', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET updateNodesStatusMainAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateNodesStatusMainAbort', 5, null, null, 1, 'cleanUpClusterAfterLastNodeAbort', 2, null, null, null, 'new_node_target_urns', null, 1, 'cleanUpClusterAfterLastNodeAbort', null, null, 1, 0, 0, 0, null, null, -1 );

INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateNodesStatusMainAbort', 2, null, null, 5, 'updateNodesStatusMainAbort', 5, null, null, null, 'new_node_target_urns', null, 1, 'updateNodesStatusMainAbort', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP updateNodesStatusAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateNodesStatusAbort', 1, null, null, 1, 'updateNodesStatusMainAbort', 2, null, null, null, null, null, 0, 'updateNodesStatusMainAbort', null, 'UpdateHardwareStatusCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP updateNodesStatusAbort
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateNodesStatusAbort', 'hw_urn', 1, 0, '%new_node_target_urns%[%job_iterate_index%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateNodesStatusAbort', 'targetName', 1, 0, '%new_node_target_names%[%job_iterate_index%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'updateNodesStatusAbort', 'targetType', 1, 0, '%job_target_types%[1]', null, null );


END;
END;


-- ENTRIES FOR STEPSET delInstallUsersAbort
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'delInstallUsersAbort', 3, null, null, 2, 'updateNodesStatusMainAbort', 5, 'delete_install_user', null, null, null, null, 1, 'cleanUpClusterAfterLastNodeAbort', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET delInstallUsersAbortYES
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'delInstallUsersAbortYES', 2, null, null, 3, 'delInstallUsersAbort', 3, null, null, 'YES', null, null, 1, 'delInstallUsersAbort', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB cleanUpClusterInstallAbort
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'cleanUpClusterInstallAbort';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'CleanUpInstallJob', TRUE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'cleanUpClusterInstallAbort', 12, 'CleanUpInstallJob', null, 1, 'delInstallUsersAbortYES', 2, null, null, null, l_gen_iterate_param, null, 0, 'delInstallUsersAbortYES', null, null, 1, null, 1, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpClusterInstallAbort', 6, null, null, 7, 'cleanUpClusterInstallAbort', 12, null, null, null, l_gen_iterate_param, null, 1, 'delInstallUsersAbortYES', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpClusterInstallAbort', 2, null, null, 6, 'cleanUpClusterInstallAbort', 6, null, null, null, null, null, 1, 'cleanUpClusterInstallAbort', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'cleanUpClusterInstallAbort', 7, 'CleanUpInstallJob', null, 1, 'cleanUpClusterInstallAbort', 2, null, null, null, l_gen_iterate_param, null, 0, 'cleanUpClusterInstallAbort', null, null, 1, 0, 1, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'cleanUpClusterInstallAbort', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpClusterInstallAbort', 7, 'CleanUpInstallJob', null, 1, 'delInstallUsersAbortYES', 2, null, null, null, null, null, 0, 'delInstallUsersAbortYES', null, null, 1, 0, 1, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP cleanUpClusterInstallAbort
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpClusterInstallAbort', 'target_list', -1, 0, null, null, 'target_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpClusterInstallAbort', 'username_list', -1, 0, null, null, 'username_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpClusterInstallAbort', 'password_list', -1, 0, null, null, 'password_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpClusterInstallAbort', 'TOP_DIR', 1, 0, '%TOP_DIR%', null, null );


END;
END;


-- ENTRIES FOR STEPSET cleanUpInstallFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpInstallFailure', 2, null, null, 8, 'install', 2, null, null, null, null, null, 1, 'main', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET cleanUpFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpFailure', 3, null, null, 1, 'cleanUpInstallFailure', 2, 'image_or_cluster', null, null, null, null, 1, 'cleanUpInstallFailure', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET cleanUpImageFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpImageFailure', 2, null, null, 3, 'cleanUpFailure', 3, null, null, 'image', null, null, 1, 'cleanUpFailure', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET deleteInstalluserFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'deleteInstalluserFailure', 3, null, null, 1, 'cleanUpImageFailure', 2, 'delete_install_user', null, null, null, null, 1, 'cleanUpImageFailure', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET deleteInstallUserFailureYes
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'deleteInstallUserFailureYes', 2, null, null, 3, 'deleteInstalluserFailure', 3, null, null, 'YES', null, null, 1, 'deleteInstalluserFailure', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB cleanUpImageInstallFailure
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'cleanUpImageInstallFailure';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'CleanUpInstallJob', TRUE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'cleanUpImageInstallFailure', 12, 'CleanUpInstallJob', null, 1, 'deleteInstallUserFailureYes', 2, null, null, null, l_gen_iterate_param, null, 0, 'deleteInstallUserFailureYes', null, null, 1, null, 1, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpImageInstallFailure', 6, null, null, 7, 'cleanUpImageInstallFailure', 12, null, null, null, l_gen_iterate_param, null, 1, 'deleteInstallUserFailureYes', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpImageInstallFailure', 2, null, null, 6, 'cleanUpImageInstallFailure', 6, null, null, null, null, null, 1, 'cleanUpImageInstallFailure', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'cleanUpImageInstallFailure', 7, 'CleanUpInstallJob', null, 1, 'cleanUpImageInstallFailure', 2, null, null, null, l_gen_iterate_param, null, 0, 'cleanUpImageInstallFailure', null, null, 1, 0, 1, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'cleanUpImageInstallFailure', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpImageInstallFailure', 7, 'CleanUpInstallJob', null, 1, 'deleteInstallUserFailureYes', 2, null, null, null, null, null, 0, 'deleteInstallUserFailureYes', null, null, 1, 0, 1, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP cleanUpImageInstallFailure
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpImageInstallFailure', 'target_list', -1, 0, null, null, 'target_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpImageInstallFailure', 'username_list', -1, 0, null, null, 'username_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpImageInstallFailure', 'password_list', -1, 0, null, null, 'password_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpImageInstallFailure', 'TOP_DIR', 1, 0, '%TOP_DIR%', null, null );


END;
END;


-- ENTRIES FOR STEPSET cleanUpClusterFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpClusterFailure', 2, null, null, 3, 'cleanUpFailure', 3, null, null, 'cluster', null, null, 1, 'cleanUpFailure', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET cleanUpClusterInnerFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpClusterInnerFailure', 3, null, null, 1, 'cleanUpClusterFailure', 2, 'last_node', null, null, null, null, 1, 'cleanUpClusterFailure', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET cleanUpClusterAfterLastNodeFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpClusterAfterLastNodeFailure', 2, null, null, 3, 'cleanUpClusterInnerFailure', 3, null, null, 'YES', null, null, 1, 'cleanUpClusterInnerFailure', 'updateNodesStatusMainFailure', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET updateNodesStatusMainFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateNodesStatusMainFailure', 5, null, null, 1, 'cleanUpClusterAfterLastNodeFailure', 2, null, null, null, 'new_node_target_urns', null, 1, 'cleanUpClusterAfterLastNodeFailure', null, null, 1, 0, 0, 0, null, null, -1 );

INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'updateNodesStatusMainFailure', 2, null, null, 5, 'updateNodesStatusMainFailure', 5, null, null, null, 'new_node_target_urns', null, 1, 'updateNodesStatusMainFailure', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP udpateNodesStatusFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'udpateNodesStatusFailure', 1, null, null, 1, 'updateNodesStatusMainFailure', 2, null, null, null, null, null, 0, 'updateNodesStatusMainFailure', null, 'UpdateHardwareStatusCommand', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP udpateNodesStatusFailure
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'udpateNodesStatusFailure', 'hw_urn', 1, 0, '%new_node_target_urns%[%job_iterate_index%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'udpateNodesStatusFailure', 'targetName', 1, 0, '%new_node_target_names%[%job_iterate_index%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'udpateNodesStatusFailure', 'targetType', 1, 0, '%job_target_types%[1]', null, null );


END;
END;


-- ENTRIES FOR STEPSET delInstallUsersFailure
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'delInstallUsersFailure', 3, null, null, 2, 'updateNodesStatusMainFailure', 5, 'delete_install_user', null, null, null, null, 1, 'cleanUpClusterAfterLastNodeFailure', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET delInstallUsersFailureYES
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'delInstallUsersFailureYES', 2, null, null, 3, 'delInstallUsersFailure', 3, null, null, 'YES', null, null, 1, 'delInstallUsersFailure', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB cleanUpClusterInstallFailure
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'cleanUpClusterInstallFailure';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'CleanUpInstallJob', TRUE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'cleanUpClusterInstallFailure', 12, 'CleanUpInstallJob', null, 1, 'delInstallUsersFailureYES', 2, null, null, null, l_gen_iterate_param, null, 0, 'delInstallUsersFailureYES', null, null, 1, null, 1, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpClusterInstallFailure', 6, null, null, 7, 'cleanUpClusterInstallFailure', 12, null, null, null, l_gen_iterate_param, null, 1, 'delInstallUsersFailureYES', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpClusterInstallFailure', 2, null, null, 6, 'cleanUpClusterInstallFailure', 6, null, null, null, null, null, 1, 'cleanUpClusterInstallFailure', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'cleanUpClusterInstallFailure', 7, 'CleanUpInstallJob', null, 1, 'cleanUpClusterInstallFailure', 2, null, null, null, l_gen_iterate_param, null, 0, 'cleanUpClusterInstallFailure', null, null, 1, 0, 1, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'cleanUpClusterInstallFailure', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpClusterInstallFailure', 7, 'CleanUpInstallJob', null, 1, 'delInstallUsersFailureYES', 2, null, null, null, null, null, 0, 'delInstallUsersFailureYES', null, null, 1, 0, 1, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP cleanUpClusterInstallFailure
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpClusterInstallFailure', 'target_list', -1, 0, null, null, 'target_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpClusterInstallFailure', 'username_list', -1, 0, null, null, 'username_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpClusterInstallFailure', 'password_list', -1, 0, null, null, 'password_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpClusterInstallFailure', 'TOP_DIR', 1, 0, '%TOP_DIR%', null, null );


END;
END;


-- ENTRIES FOR STEPSET cleanUpInstallSuccess
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpInstallSuccess', 2, null, null, 7, 'install', 2, null, null, null, null, null, 1, 'main', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET cleanUp
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUp', 3, null, null, 1, 'cleanUpInstallSuccess', 2, 'image_or_cluster', null, null, null, null, 1, 'cleanUpInstallSuccess', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET cleanUpImage
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpImage', 2, null, null, 3, 'cleanUp', 3, null, null, 'image', null, null, 1, 'cleanUp', 'deleteInstalluser', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET deleteInstalluser
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'deleteInstalluser', 3, null, null, 1, 'cleanUpImage', 2, 'delete_install_user', null, null, null, null, 1, 'cleanUpImage', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET deleteInstallUserYes
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'deleteInstallUserYes', 2, null, null, 3, 'deleteInstalluser', 3, null, null, 'YES', null, null, 1, 'deleteInstalluser', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB cleanUpImageInstallSuccess
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'cleanUpImageInstallSuccess';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'CleanUpInstallJob', TRUE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'cleanUpImageInstallSuccess', 12, 'CleanUpInstallJob', null, 1, 'deleteInstallUserYes', 2, null, null, null, l_gen_iterate_param, null, 0, 'deleteInstallUserYes', null, null, 1, null, 1, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpImageInstallSuccess', 6, null, null, 7, 'cleanUpImageInstallSuccess', 12, null, null, null, l_gen_iterate_param, null, 1, 'deleteInstallUserYes', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpImageInstallSuccess', 2, null, null, 6, 'cleanUpImageInstallSuccess', 6, null, null, null, null, null, 1, 'cleanUpImageInstallSuccess', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'cleanUpImageInstallSuccess', 7, 'CleanUpInstallJob', null, 1, 'cleanUpImageInstallSuccess', 2, null, null, null, l_gen_iterate_param, null, 0, 'cleanUpImageInstallSuccess', null, null, 1, 0, 1, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'cleanUpImageInstallSuccess', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpImageInstallSuccess', 7, 'CleanUpInstallJob', null, 1, 'deleteInstallUserYes', 2, null, null, null, null, null, 0, 'deleteInstallUserYes', null, null, 1, 0, 1, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP cleanUpImageInstallSuccess
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpImageInstallSuccess', 'target_list', -1, 0, null, null, 'target_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpImageInstallSuccess', 'username_list', -1, 0, null, null, 'username_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpImageInstallSuccess', 'password_list', -1, 0, null, null, 'password_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpImageInstallSuccess', 'TOP_DIR', 1, 0, '%TOP_DIR%', null, null );


END;
END;


-- ENTRIES FOR STEPSET cleanUpCluster
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpCluster', 2, null, null, 3, 'cleanUp', 3, null, null, 'cluster', null, null, 1, 'cleanUp', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET cleanUpClusterInner
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpClusterInner', 3, null, null, 1, 'cleanUpCluster', 2, 'last_node', null, null, null, null, 1, 'cleanUpCluster', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET cleanUpClusterAfterLastNode
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpClusterAfterLastNode', 2, null, null, 3, 'cleanUpClusterInner', 3, null, null, 'YES', null, null, 1, 'cleanUpClusterInner', 'delInstallUsers', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET delInstallUsers
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'delInstallUsers', 3, null, null, 1, 'cleanUpClusterAfterLastNode', 2, 'delete_install_user', null, null, null, null, 1, 'cleanUpClusterAfterLastNode', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET delInstallUsersYES
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'delInstallUsersYES', 2, null, null, 3, 'delInstallUsers', 3, null, null, 'YES', null, null, 1, 'delInstallUsers', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB cleanUpClusterInstallSuccess
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'cleanUpClusterInstallSuccess';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'CleanUpInstallJob', TRUE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'cleanUpClusterInstallSuccess', 12, 'CleanUpInstallJob', null, 1, 'delInstallUsersYES', 2, null, null, null, l_gen_iterate_param, null, 0, 'delInstallUsersYES', null, null, 1, null, 1, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpClusterInstallSuccess', 6, null, null, 7, 'cleanUpClusterInstallSuccess', 12, null, null, null, l_gen_iterate_param, null, 1, 'delInstallUsersYES', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpClusterInstallSuccess', 2, null, null, 6, 'cleanUpClusterInstallSuccess', 6, null, null, null, null, null, 1, 'cleanUpClusterInstallSuccess', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'cleanUpClusterInstallSuccess', 7, 'CleanUpInstallJob', null, 1, 'cleanUpClusterInstallSuccess', 2, null, null, null, l_gen_iterate_param, null, 0, 'cleanUpClusterInstallSuccess', null, null, 1, 0, 1, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'cleanUpClusterInstallSuccess', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanUpClusterInstallSuccess', 7, 'CleanUpInstallJob', null, 1, 'delInstallUsersYES', 2, null, null, null, null, null, 0, 'delInstallUsersYES', null, null, 1, 0, 1, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP cleanUpClusterInstallSuccess
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpClusterInstallSuccess', 'target_list', -1, 0, null, null, 'target_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpClusterInstallSuccess', 'username_list', -1, 0, null, null, 'username_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpClusterInstallSuccess', 'password_list', -1, 0, null, null, 'password_list' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanUpClusterInstallSuccess', 'TOP_DIR', 1, 0, '%TOP_DIR%', null, null );


END;
END;


-- Ensure that all existing scheduled executions use the new jobtype version
MGMT_JOB_ENGINE.reschedule_on_new_jobtype_ver(l_job_type_id);
-- Patch NLS information for backward-compatibility
MGMT_JOB_ENGINE.update_job_type_nls_info(l_job_type_id, l_job_type_name);

END;
END;


MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
EXCEPTION 
    WHEN OTHERS THEN 
        MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
        RAISE; 
END; 
/
COMMIT;
SET DEFINE ON

SET SQLPREFIX ON

