REM############################################################################
REM
REM Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
REM
REM
REM PRODUCT
REM	Oracle Enterprise Manager
REM
REM THIS FILE IS MACHINE GENERATED. DO NOT EDIT!
REM
REM JOB TYPE SQL FOR JOB TYPE: PatchAgent
REM
REM#############################################################################

SET DEFINE OFF

SET SQLPREFIX OFF


BEGIN 
BEGIN
DECLARE
    l_job_type_name MGMT_JOB_TYPE_INFO.job_type%TYPE;
    l_job_type_id MGMT_JOB_TYPE_INFO.job_type_id%TYPE;
    l_major_version MGMT_JOB_TYPE_INFO.major_version%TYPE;
    l_minor_version1 MGMT_JOB_TYPE_INFO.minor_version1%TYPE;
    l_minor_version2 MGMT_JOB_TYPE_INFO.minor_version2%TYPE;
BEGIN

l_job_type_name:= 'PatchAgent';

BEGIN 
MGMT_JOB_ENGINE.fix_flatten_steps(TRUE); 
MGMT_JOB_ENGINE.get_max_versions(l_job_type_name, l_major_version,
                   l_minor_version1, l_minor_version2, 
                   l_job_type_id); 
                         
l_minor_version2 := l_minor_version2+1; 
     
EXCEPTION 
    WHEN OTHERS THEN 
        IF SQLCODE=MGMT_GLOBAL.INVALID_JOB_TYPE_ERR THEN             l_major_version := 1; 
            l_minor_version1 := 0; 
            l_minor_version2 := 1; 
        ELSE 
            RAISE;
        END IF; 
END; 

-- CHECK TO VALIDATE REFERENCED COMMANDS/NESTED JOB TYPES
BEGIN
DECLARE
    l_commands SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
    l_nested_jobtypes SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN

    l_commands.trim(l_commands.count);

    l_commands.extend(3);
    l_commands(1) := 'remoteOp';
    l_commands(2) := 'execAndSuspend';
    l_commands(3) := 'sleepWait';

    l_nested_jobtypes.trim(l_nested_jobtypes.count);

    l_nested_jobtypes.extend(1);
    l_nested_jobtypes(1) := 'PatchPrePostScript';
    MGMT_JOB_ENGINE.validate_job_type(l_job_type_name, l_commands, l_nested_jobtypes );


END;
END;


-- JOBTYPE ENTRY
INSERT INTO MGMT_JOB_TYPE_INFO(job_type, version, major_version, minor_version1, minor_version2, job_type_category, all_target_types, agent_bound, single_target, suspend_on_nocreds, default_target_type, restartable, editable, suspendable, trusted,job_type_nlsid,job_type_default,create_text_nlsid,create_text_default,delete_text_nlsid,delete_text_default)  VALUES
	( l_job_type_name, '1.0', l_major_version, l_minor_version1, l_minor_version2, 0, 0, 0, 0, 0, null, 1, 0, 1, -1, null, null, null, null, null, null)
RETURNING job_type_id INTO l_job_type_id;

-- ENTRIES FOR STEPSET patchAgentJob
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'patchAgentJob', 2, null, null, -1, null, -1, null, null, null, null, null, 1, null, null, null, 1, 0, 0, 0, null, null, -1 );

-- PARAMINFO ENTRIES FOR STEP runCustomPreScript
-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(16);
    l_param_names(1) := 'patch_type';
    l_param_names(2) := 'patch_id';
    l_param_names(3) := 'patch_target_type';
    l_param_names(4) := 'dest_home';
    l_param_names(5) := 'shared_home';
    l_param_names(6) := 'apply_prescript';
    l_param_names(7) := 'apply_postscript';
    l_param_names(8) := 'prescript_cmd';
    l_param_names(9) := 'postscript_cmd';
    l_param_names(10) := 'oraclehome';
    l_param_names(11) := 'platform';
    l_param_names(12) := 'prescript_sumode';
    l_param_names(13) := 'postscript_sumode';
    l_param_names(14) := 'use_staged_patch';
    l_param_names(15) := 'patch_script';
    l_param_names(16) := 'apply_patch_script';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'runCustomPreScript', 3, 'user', 1, null, 0, 1, 0, l_param_names );


END;
END;


-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(2);
    l_param_names(1) := 'dest_username';
    l_param_names(2) := 'dest_password';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'runCustomPreScript', 3, 'user', 2, null, 0, 1, 1, l_param_names );


END;
END;


-- PARAM SOURCE: source type inline
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(3);
    l_param_names(1) := 'perlscript';
    l_param_names(2) := 'dest_SID';
    l_param_names(3) := 'defaultDepotPath';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'runCustomPreScript', 3, 'inline', 3, '
    ', 0, 0, 0, l_param_names );


END;
END;


-- INLINE PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_params MGMT_JOB_PARAM_LIST := MGMT_JOB_PARAM_LIST();
    l_vector_vals MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_params.trim(l_params.count);

    l_params.extend(3);
    l_params(1) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(1).param_name := 'perlscript';
    l_params(1).param_type := 1;
    l_params(1).scalar_value := 'osm/ecmPatchDatabase.pl';
    l_params(1).vector_value := null;
    l_params(2) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(2).param_name := 'dest_SID';
    l_params(2).param_type := 1;
    l_params(2).scalar_value := 'none';
    l_params(2).vector_value := null;
    l_params(3) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(3).param_name := 'defaultDepotPath';
    l_params(3).param_type := 1;
    l_params(3).scalar_value := 'EMStagedPatches';
    l_params(3).vector_value := null;
    INSERT INTO MGMT_JOB_VALUE_PARAMS(source_id, param_values, action) 
  SELECT source_id, l_params, 'none'     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=3;
END;
END;


-- PARAM SOURCE: source type substValues
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(5);
    l_param_names(1) := 'final_prescript_cmd';
    l_param_names(2) := 'final_prescript';
    l_param_names(3) := 'final_postscript_cmd';
    l_param_names(4) := 'final_postscript';
    l_param_names(5) := 'depot_path';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'runCustomPreScript', 3, 'substValues', 4, '
    ', 1, 0, 0, l_param_names );


END;
END;


-- SUBSTVALUES PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_source_params MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_source_params.trim(l_source_params.count);

    l_source_params.extend(5);
    l_source_params(1) := 'prescript_cmd';
    l_source_params(2) := 'prescript';
    l_source_params(3) := 'postscript_cmd';
    l_source_params(4) := 'postscript';
    l_source_params(5) := 'depot_path';
    INSERT INTO MGMT_JOB_SUBST_PARAMS(source_id, 
                      source_params) 
 SELECT source_id, l_source_params     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=4;
END;
END;


-- ENTRIES FOR STEPSET runCustomPreScript
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runCustomPreScript', 3, null, null, 1, 'patchAgentJob', 2, 'apply_prescript', null, null, null, null, 1, 'patchAgentJob', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB runPrescript
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'runPrescript';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'PatchPrePostScript', FALSE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runPrescript', 12, 'PatchPrePostScript', null, 3, 'runCustomPreScript', 3, null, null, 'yes', l_gen_iterate_param, null, 0, 'runCustomPreScript', null, null, 1, null, 0, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runPrescript', 6, null, null, 7, 'runPrescript', 12, null, null, 'yes', l_gen_iterate_param, null, 1, 'runCustomPreScript', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runPrescript', 2, null, null, 6, 'runPrescript', 6, null, null, 'yes', null, null, 1, 'runPrescript', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runPrescript', 7, 'PatchPrePostScript', null, 1, 'runPrescript', 2, null, null, 'yes', l_gen_iterate_param, null, 0, 'runPrescript', null, null, 1, 0, 0, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'runPrescript', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runPrescript', 7, 'PatchPrePostScript', null, 3, 'runCustomPreScript', 3, null, null, 'yes', null, null, 0, 'runCustomPreScript', null, null, 1, 0, 0, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP runPrescript
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runPrescript', 'command', 1, 0, '%final_prescript_cmd%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runPrescript', 'args', 1, 0, '%final_prescript%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runPrescript', 'sudoMode', 1, 0, '%prescript_sumode%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runPrescript', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runPrescript', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runPrescript', 'username', 1, 0, '%dest_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runPrescript', 'password', 1, 0, '%dest_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runPrescript', 'dest_home', 1, 0, '%dest_home%', null, null );


END;
END;


-- ENTRIES FOR STEPSET patchAgent
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'patchAgent', 2, null, null, 7, 'runCustomPreScript', 3, null, null, null, null, null, 1, 'patchAgentJob', 'showResults', null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET patchAgentSharedOrStandalone
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'patchAgentSharedOrStandalone', 3, null, null, 1, 'patchAgent', 2, 'shared_home', null, null, null, null, 1, 'patchAgent', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET applyPatchSharedHome
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'applyPatchSharedHome', 2, null, null, 3, 'patchAgentSharedOrStandalone', 3, null, null, 'yes', null, null, 1, 'patchAgentSharedOrStandalone', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET chkUseStagedPatch
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'chkUseStagedPatch', 3, null, null, 1, 'applyPatchSharedHome', 2, 'use_staged_patch', null, null, null, null, 1, 'applyPatchSharedHome', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP applyFromStagedPatch
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'applyFromStagedPatch', 1, null, null, 3, 'chkUseStagedPatch', 3, null, null, 'true', null, null, 0, 'chkUseStagedPatch', null, 'execAndSuspend', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP applyFromStagedPatch
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyFromStagedPatch', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyFromStagedPatch', 'args', 1, 0, '-w,%scriptsdir%/%perlscript%,applyPatch,-oh,%dest_home%,-os,%dest_SID%,-d,%defaultDepotPath%,-p,%patch_type%,-i,%patch_id%,-t,%patch_target_type%,-f,p%patch_id%.zip,-sharedMove,-stage_location,%depot_path%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyFromStagedPatch', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyFromStagedPatch', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyFromStagedPatch', 'username', 1, 0, '%dest_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyFromStagedPatch', 'password', 1, 0, '%dest_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyFromStagedPatch', 'suspendTimeout', 1, 0, '60', null, null );


END;
END;


-- ENTRIES FOR STEP applyAfterStaging
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'applyAfterStaging', 1, null, null, 3, 'chkUseStagedPatch', 3, null, null, 'false', null, null, 0, 'chkUseStagedPatch', null, 'execAndSuspend', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP applyAfterStaging
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyAfterStaging', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyAfterStaging', 'args', 1, 0, '-w,%scriptsdir%/%perlscript%,applyPatch,-oh,%dest_home%,-os,%dest_SID%,-d,%depot_path%,-p,%patch_type%,-i,%patch_id%,-t,%patch_target_type%,-f,p%patch_id%.zip,-sharedMove', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyAfterStaging', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyAfterStaging', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyAfterStaging', 'username', 1, 0, '%dest_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyAfterStaging', 'password', 1, 0, '%dest_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyAfterStaging', 'suspendTimeout', 1, 0, '60', null, null );


END;
END;


-- ENTRIES FOR STEPSET applyPatchStandalone
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'applyPatchStandalone', 2, null, null, 3, 'patchAgentSharedOrStandalone', 3, null, null, 'no', null, null, 1, 'patchAgentSharedOrStandalone', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET chkDefaultAgentApplyScript
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'chkDefaultAgentApplyScript', 3, null, null, 1, 'applyPatchStandalone', 2, 'apply_patch_script', null, null, null, null, 1, 'applyPatchStandalone', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET defaultAgentApplyScript
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'defaultAgentApplyScript', 2, null, null, 3, 'chkDefaultAgentApplyScript', 3, null, null, 'yes', null, null, 1, 'chkDefaultAgentApplyScript', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET chkStandaloneUseStagedPatch
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'chkStandaloneUseStagedPatch', 3, null, null, 1, 'defaultAgentApplyScript', 2, 'use_staged_patch', null, null, null, null, 1, 'defaultAgentApplyScript', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP applyDefaultStandaloneFromStagedPatch
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'applyDefaultStandaloneFromStagedPatch', 1, null, null, 3, 'chkStandaloneUseStagedPatch', 3, null, null, 'true', null, null, 0, 'chkStandaloneUseStagedPatch', null, 'execAndSuspend', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP applyDefaultStandaloneFromStagedPatch
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyDefaultStandaloneFromStagedPatch', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyDefaultStandaloneFromStagedPatch', 'args', 1, 0, '-w,%scriptsdir%/%perlscript%,applyPatch,-oh,%dest_home%,-os,%dest_SID%,-d,%defaultDepotPath%,-p,%patch_type%,-i,%patch_id%,-t,%patch_target_type%,-f,p%patch_id%.zip,-stage_location,%depot_path%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyDefaultStandaloneFromStagedPatch', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyDefaultStandaloneFromStagedPatch', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyDefaultStandaloneFromStagedPatch', 'username', 1, 0, '%dest_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyDefaultStandaloneFromStagedPatch', 'password', 1, 0, '%dest_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyDefaultStandaloneFromStagedPatch', 'suspendTimeout', 1, 0, '60', null, null );


END;
END;


-- ENTRIES FOR STEP applyDefaultStandaloneAfterStaging
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'applyDefaultStandaloneAfterStaging', 1, null, null, 3, 'chkStandaloneUseStagedPatch', 3, null, null, 'false', null, null, 0, 'chkStandaloneUseStagedPatch', null, 'execAndSuspend', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP applyDefaultStandaloneAfterStaging
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyDefaultStandaloneAfterStaging', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyDefaultStandaloneAfterStaging', 'args', 1, 0, '-w,%scriptsdir%/%perlscript%,applyPatch,-oh,%dest_home%,-os,%dest_SID%,-d,%depot_path%,-p,%patch_type%,-i,%patch_id%,-t,%patch_target_type%,-f,p%patch_id%.zip', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyDefaultStandaloneAfterStaging', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyDefaultStandaloneAfterStaging', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyDefaultStandaloneAfterStaging', 'username', 1, 0, '%dest_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyDefaultStandaloneAfterStaging', 'password', 1, 0, '%dest_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyDefaultStandaloneAfterStaging', 'suspendTimeout', 1, 0, '60', null, null );


END;
END;


-- ENTRIES FOR STEPSET customAgentApplyScript
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'customAgentApplyScript', 2, null, null, 3, 'chkDefaultAgentApplyScript', 3, null, null, 'no', null, null, 1, 'chkDefaultAgentApplyScript', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET chkStandalonePlatform
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'chkStandalonePlatform', 3, null, null, 1, 'customAgentApplyScript', 2, 'platform', null, null, null, null, 1, 'customAgentApplyScript', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP applyStandalonePatchUNIX
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'applyStandalonePatchUNIX', 1, null, null, 3, 'chkStandalonePlatform', 3, null, null, 'unix', null, null, 0, 'chkStandalonePlatform', null, 'execAndSuspend', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP applyStandalonePatchUNIX
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchUNIX', 'remoteCommand', 1, 0, '/bin/sh', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchUNIX', 'args', 1, 0, '-s', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchUNIX', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchUNIX', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchUNIX', 'username', 1, 0, '%dest_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchUNIX', 'password', 1, 0, '%dest_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchUNIX', 'executeSynchronous', 1, 0, 'false', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchUNIX', 'input', 1, 0, '
                      
                                         LOGNAME=%dest_username%;export LOGNAME
                                         ORACLE_HOME=%dest_home%;export ORACLE_HOME
                                         PATCH_ID=%patch_id%;export PATCH_ID
                                         PATCH_PATH=%depot_path%;export PATCH_PATH
                                         PATCH_TYPE=%patch_type%;export PATCH_TYPE
                                         STAGED_PATCH=%use_staged_patch%;export STAGED_PATCH
                                         EM_AGENT_CUSTOM_APPLY=true;export EM_AGENT_CUSTOM_APPLY
                                         set -x
                                         %patch_script%
					 exit $?
                                        
                    ', null, null );


END;
END;


-- ENTRIES FOR STEP applyStandalonePatchAIX
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'applyStandalonePatchAIX', 1, null, null, 3, 'chkStandalonePlatform', 3, null, null, 'aix', null, null, 0, 'chkStandalonePlatform', null, 'execAndSuspend', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP applyStandalonePatchAIX
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchAIX', 'remoteCommand', 1, 0, '/bin/sh', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchAIX', 'args', 1, 0, '-s', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchAIX', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchAIX', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchAIX', 'username', 1, 0, '%dest_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchAIX', 'password', 1, 0, '%dest_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchAIX', 'executeSynchronous', 1, 0, 'false', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchAIX', 'input', 1, 0, '
                       
                                          ORACLE_HOME=%dest_home%;export ORACLE_HOME
                                          PATCH_ID=%patch_id%;export PATCH_ID
                                          PATCH_PATH=%depot_path%;export PATCH_PATH
                                          PATCH_TYPE=%patch_type%;export PATCH_TYPE
                                          STAGED_PATCH=%use_staged_patch%;export STAGED_PATCH
                                          EM_AGENT_CUSTOM_APPLY=true;export EM_AGENT_CUSTOM_APPLY
                                          set -x
                                          %patch_script%
					  exit $?
                                         
                     ', null, null );


END;
END;


-- ENTRIES FOR STEP applyStandalonePatchWIN
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'applyStandalonePatchWIN', 1, null, null, 3, 'chkStandalonePlatform', 3, null, null, 'windows', null, null, 0, 'chkStandalonePlatform', null, 'execAndSuspend', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP applyStandalonePatchWIN
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchWIN', 'remoteCommand', 1, 0, 'cmd.exe', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchWIN', 'args', 1, 0, '/Q', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchWIN', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchWIN', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchWIN', 'username', 1, 0, '%dest_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchWIN', 'password', 1, 0, '%dest_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchWIN', 'executeSynchronous', 1, 0, 'false', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'applyStandalonePatchWIN', 'input', 1, 0, '
                      
                                         ' || CHR(ASCII('@')) || 'echo off
                                         ' || CHR(ASCII('@')) || 'set LOGNAME=%dest_username%
                                         ' || CHR(ASCII('@')) || 'set ORACLE_HOME=%dest_home%
                                         ' || CHR(ASCII('@')) || 'set PATCH_ID=%patch_id%
                                         ' || CHR(ASCII('@')) || 'set PATCH_PATH=%depot_path%
                                         ' || CHR(ASCII('@')) || 'set PATCH_TYPE=%patch_type%
                                         ' || CHR(ASCII('@')) || 'set STAGED_PATCH=%use_staged_patch%
                                         ' || CHR(ASCII('@')) || 'set EM_AGENT_CUSTOM_APPLY=true
                                         ' || CHR(ASCII('@')) || 'echo on
                                         %patch_script%
					 exit %%ERRORLEVEL%%
                                        
                    ', null, null );


END;
END;


-- ENTRIES FOR STEP waitForAgent
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'waitForAgent', 1, null, null, 2, 'patchAgentSharedOrStandalone', 3, null, null, null, null, null, 0, 'patchAgent', null, 'sleepWait', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP waitForAgent
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'waitForAgent', 'numSeconds', 1, 0, '120', null, null );


END;
END;


-- ENTRIES FOR STEP showResults
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'showResults', 1, null, null, 2, 'waitForAgent', 1, null, null, null, null, null, 0, 'patchAgent', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP showResults
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'showResults', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'showResults', 'args', 1, 0, '-w,%scriptsdir%/%perlscript%,showResults,-oh,%dest_home%,-os,%dest_SID%,-d,%defaultDepotPath%,-p,%patch_type%,-i,%patch_id%,-t,%patch_target_type%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'showResults', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'showResults', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'showResults', 'username', 1, 0, '%dest_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'showResults', 'password', 1, 0, '%dest_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'showResults', 'executeSynchronous', 1, 0, 'false', null, null );


END;
END;


-- ENTRIES FOR STEPSET runCustomPostScript
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runCustomPostScript', 3, null, null, 7, 'patchAgent', 2, 'apply_postscript', null, null, null, null, 1, 'patchAgentJob', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB runPostscript
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'runPostscript';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'PatchPrePostScript', FALSE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runPostscript', 12, 'PatchPrePostScript', null, 3, 'runCustomPostScript', 3, null, null, 'yes', l_gen_iterate_param, null, 0, 'runCustomPostScript', null, null, 1, null, 0, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runPostscript', 6, null, null, 7, 'runPostscript', 12, null, null, 'yes', l_gen_iterate_param, null, 1, 'runCustomPostScript', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runPostscript', 2, null, null, 6, 'runPostscript', 6, null, null, 'yes', null, null, 1, 'runPostscript', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'runPostscript', 7, 'PatchPrePostScript', null, 1, 'runPostscript', 2, null, null, 'yes', l_gen_iterate_param, null, 0, 'runPostscript', null, null, 1, 0, 0, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'runPostscript', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'runPostscript', 7, 'PatchPrePostScript', null, 3, 'runCustomPostScript', 3, null, null, 'yes', null, null, 0, 'runCustomPostScript', null, null, 1, 0, 0, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP runPostscript
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runPostscript', 'command', 1, 0, '%final_postscript_cmd%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runPostscript', 'args', 1, 0, '%final_postscript%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runPostscript', 'sudoMode', 1, 0, '%postscript_sumode%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runPostscript', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runPostscript', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runPostscript', 'username', 1, 0, '%dest_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runPostscript', 'password', 1, 0, '%dest_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'runPostscript', 'dest_home', 1, 0, '%dest_home%', null, null );


END;
END;


-- Ensure that all existing scheduled executions use the new jobtype version
MGMT_JOB_ENGINE.reschedule_on_new_jobtype_ver(l_job_type_id);
-- Patch NLS information for backward-compatibility
MGMT_JOB_ENGINE.update_job_type_nls_info(l_job_type_id, l_job_type_name);

END;
END;


MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
EXCEPTION 
    WHEN OTHERS THEN 
        MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
        RAISE; 
END; 
/
COMMIT;
SET DEFINE ON

SET SQLPREFIX ON

