REM############################################################################
REM
REM Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
REM
REM
REM PRODUCT
REM	Oracle Enterprise Manager
REM
REM THIS FILE IS MACHINE GENERATED. DO NOT EDIT!
REM
REM JOB TYPE SQL FOR JOB TYPE: PatchDatabaseTargets
REM
REM#############################################################################

SET DEFINE OFF

SET SQLPREFIX OFF


BEGIN 
BEGIN
DECLARE
    l_job_type_name MGMT_JOB_TYPE_INFO.job_type%TYPE;
    l_job_type_id MGMT_JOB_TYPE_INFO.job_type_id%TYPE;
    l_major_version MGMT_JOB_TYPE_INFO.major_version%TYPE;
    l_minor_version1 MGMT_JOB_TYPE_INFO.minor_version1%TYPE;
    l_minor_version2 MGMT_JOB_TYPE_INFO.minor_version2%TYPE;
BEGIN

l_job_type_name:= 'PatchDatabaseTargets';

BEGIN 
MGMT_JOB_ENGINE.fix_flatten_steps(TRUE); 
MGMT_JOB_ENGINE.get_max_versions(l_job_type_name, l_major_version,
                   l_minor_version1, l_minor_version2, 
                   l_job_type_id); 
                         
l_minor_version2 := l_minor_version2+1; 
     
EXCEPTION 
    WHEN OTHERS THEN 
        IF SQLCODE=MGMT_GLOBAL.INVALID_JOB_TYPE_ERR THEN             l_major_version := 1; 
            l_minor_version1 := 0; 
            l_minor_version2 := 1; 
        ELSE 
            RAISE;
        END IF; 
END; 

-- CHECK TO VALIDATE REFERENCED COMMANDS/NESTED JOB TYPES
BEGIN
DECLARE
    l_commands SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
    l_nested_jobtypes SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN

    l_nested_jobtypes.trim(l_nested_jobtypes.count);

    l_nested_jobtypes.extend(2);
    l_nested_jobtypes(1) := 'StageDatabasePatchTargets';
    l_nested_jobtypes(2) := 'PatchDatabase';
    MGMT_JOB_ENGINE.validate_job_type(l_job_type_name, l_commands, l_nested_jobtypes );


END;
END;


-- JOBTYPE ENTRY
INSERT INTO MGMT_JOB_TYPE_INFO(job_type, version, major_version, minor_version1, minor_version2, job_type_category, all_target_types, agent_bound, single_target, suspend_on_nocreds, default_target_type, restartable, editable, suspendable, trusted,job_type_nlsid,job_type_default,create_text_nlsid,create_text_default,delete_text_nlsid,delete_text_default)  VALUES
	( l_job_type_name, '1.0', l_major_version, l_minor_version1, l_minor_version2, 0, 0, 0, 0, 0, null, 1, 1, 1, -1, null, null, null, null, null, null)
RETURNING job_type_id INTO l_job_type_id;

-- ENTRIES FOR STEPSET patchDatabaseTargetsJob
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'patchDatabaseTargetsJob', 2, null, null, -1, null, -1, null, null, null, null, null, 1, null, null, null, 1, 0, 0, 0, null, null, -1 );

-- PARAMINFO ENTRIES FOR STEP toStagePatchOrNot
-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(17);
    l_param_names(1) := 'platform';
    l_param_names(2) := 'patch_type';
    l_param_names(3) := 'patch_id';
    l_param_names(4) := 'patch_size';
    l_param_names(5) := 'patch_target_type';
    l_param_names(6) := 'patch_script';
    l_param_names(7) := 'ARU_ID';
    l_param_names(8) := 'depot_path';
    l_param_names(9) := 'dest_home';
    l_param_names(10) := 'shared_home';
    l_param_names(11) := 'apply_prescript';
    l_param_names(12) := 'apply_postscript';
    l_param_names(13) := 'prescript_cmd';
    l_param_names(14) := 'postscript_cmd';
    l_param_names(15) := 'prescript_sumode';
    l_param_names(16) := 'postscript_sumode';
    l_param_names(17) := 'use_staged_patch';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'toStagePatchOrNot', 3, 'user', 1, null, 0, 1, 0, l_param_names );


END;
END;


-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(2);
    l_param_names(1) := 'prescript';
    l_param_names(2) := 'postscript';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'toStagePatchOrNot', 3, 'user', 2, null, 0, 0, 0, l_param_names );


END;
END;


-- PARAM SOURCE: source type credentials
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(2);
    l_param_names(1) := 'OHUsername';
    l_param_names(2) := 'OHPassword';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 0, 'toStagePatchOrNot', 3, 'credentials', 3, '
      ', 0, 0, 1, l_param_names );


END;
END;


-- CREDENTIAL PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_cred_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_types MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_container_paths MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_cred_type_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_cred_columns.trim(l_cred_columns.count);

    l_cred_columns.extend(2);
    l_cred_columns(1) := 'OHUsername';
    l_cred_columns(2) := 'OHPassword';
    INSERT INTO MGMT_JOB_CRED_PARAMS(source_id, 
                         credential_set_name, 
                         credential_set_target_type, 
                         base_cred_type_name, 
                         base_cred_type_target_type, 
                         base_cred_type_columns, 
                         credential_columns, 
                         credential_columns_param, 
                         target_names, 
                         target_types, 
                         container_paths, 
                         target_names_param, 
                         target_types_param, 
                         container_paths_param, 
                         set_override) 
       SELECT source_id, 'OHCreds', 'host', null, null, null, l_cred_columns, null, null, null, null, 'job_target_names', 'job_target_types', 'dest_home', 0         FROM   MGMT_JOB_PARAM_SOURCE WHERE job_type_id= l_job_type_id            AND source_index=3;
END;
END;


-- ENTRIES FOR STEPSET toStagePatchOrNot
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'toStagePatchOrNot', 3, null, null, 1, 'patchDatabaseTargetsJob', 2, 'use_staged_patch', null, null, null, null, 1, 'patchDatabaseTargetsJob', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET stageDatabasePatchTargetsJob
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'stageDatabasePatchTargetsJob', 2, null, null, 3, 'toStagePatchOrNot', 3, null, null, 'false', null, null, 1, 'toStagePatchOrNot', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB StageDatabasePatchTargetsJob
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'StageDatabasePatchTargetsJob';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'StageDatabasePatchTargets', TRUE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'StageDatabasePatchTargetsJob', 12, 'StageDatabasePatchTargets', null, 1, 'stageDatabasePatchTargetsJob', 2, null, null, null, l_gen_iterate_param, null, 0, 'stageDatabasePatchTargetsJob', null, null, 1, null, 1, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'StageDatabasePatchTargetsJob', 6, null, null, 7, 'StageDatabasePatchTargetsJob', 12, null, null, null, l_gen_iterate_param, null, 1, 'stageDatabasePatchTargetsJob', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'StageDatabasePatchTargetsJob', 2, null, null, 6, 'StageDatabasePatchTargetsJob', 6, null, null, null, null, null, 1, 'StageDatabasePatchTargetsJob', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'StageDatabasePatchTargetsJob', 7, 'StageDatabasePatchTargets', null, 1, 'StageDatabasePatchTargetsJob', 2, null, null, null, l_gen_iterate_param, null, 0, 'StageDatabasePatchTargetsJob', null, null, 1, 0, 1, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'StageDatabasePatchTargetsJob', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'StageDatabasePatchTargetsJob', 7, 'StageDatabasePatchTargets', null, 1, 'stageDatabasePatchTargetsJob', 2, null, null, null, null, null, 0, 'stageDatabasePatchTargetsJob', null, null, 1, 0, 1, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP StageDatabasePatchTargetsJob
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'StageDatabasePatchTargetsJob', 'patch_type', -1, 0, null, null, 'patch_type' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'StageDatabasePatchTargetsJob', 'patch_id', -1, 0, null, null, 'patch_id' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'StageDatabasePatchTargetsJob', 'patch_size', -1, 0, null, null, 'patch_size' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'StageDatabasePatchTargetsJob', 'ARU_ID', -1, 0, null, null, 'ARU_ID' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'StageDatabasePatchTargetsJob', 'ARU_PASSWORD', -1, 0, null, null, 'ARU_PASSWORD' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'StageDatabasePatchTargetsJob', 'patch_target_type', 1, 0, '%patch_target_type%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'StageDatabasePatchTargetsJob', 'shared_home', 1, 0, '%shared_home%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'StageDatabasePatchTargetsJob', 'depot_path', 1, 0, '%depot_path%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'StageDatabasePatchTargetsJob', 'dest_home', -1, 0, null, null, 'dest_home' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'StageDatabasePatchTargetsJob', 'OHUsername', -1, 0, null, null, 'OHUsername' );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'StageDatabasePatchTargetsJob', 'OHPassword', -1, 0, null, null, 'OHPassword' );


END;
END;


-- ENTRIES FOR STEPSET PatchDatabase
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'PatchDatabase', 6, null, null, 2, 'toStagePatchOrNot', 3, null, null, null, 'job_target_names', null, 1, 'patchDatabaseTargetsJob', null, null, 1, 0, 0, 0, null, null, -1 );

INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'PatchDatabase', 2, null, null, 6, 'PatchDatabase', 6, null, null, null, 'job_target_names', null, 1, 'PatchDatabase', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRY FOR NESTED JOB PatchDatabaseJob
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'PatchDatabaseJob';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'PatchDatabase', FALSE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'PatchDatabaseJob', 12, 'PatchDatabase', null, 1, 'PatchDatabase', 2, null, null, null, l_gen_iterate_param, null, 0, 'PatchDatabase', null, null, 1, null, 0, 1, null, null, 1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'PatchDatabaseJob', 6, null, null, 7, 'PatchDatabaseJob', 12, null, null, null, l_gen_iterate_param, null, 1, 'PatchDatabase', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'PatchDatabaseJob', 2, null, null, 6, 'PatchDatabaseJob', 6, null, null, null, null, null, 1, 'PatchDatabaseJob', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'PatchDatabaseJob', 7, 'PatchDatabase', null, 1, 'PatchDatabaseJob', 2, null, null, null, l_gen_iterate_param, null, 0, 'PatchDatabaseJob', null, null, 1, 0, 0, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'PatchDatabaseJob', 7, 'PatchDatabase', null, 1, 'PatchDatabase', 2, null, null, null, null, null, 0, 'PatchDatabase', null, null, 1, 0, 0, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP PatchDatabaseJob
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'platform', 1, 0, '%platform%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'patch_type', 1, 0, '%patch_type%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'patch_id', 1, 0, '%patch_id%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'patch_script', 1, 0, '%patch_script%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'patch_target_type', 1, 0, '%patch_target_type%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'depot_path', 1, 0, '%depot_path%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'dest_home', 1, 0, '%dest_home%[%job_iterate_index%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'dest_username', 1, 0, '%OHUsername%[%job_iterate_index%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'dest_password', 1, 0, '%OHPassword%[%job_iterate_index%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'oraclehome', 1, 0, '%dest_home%[%job_iterate_index%]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'apply_prescript', 1, 0, '%apply_prescript%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'apply_postscript', 1, 0, '%apply_postscript%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'prescript_cmd', 1, 0, '%prescript_cmd%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'prescript', 1, 0, '%prescript%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'postscript_cmd', 1, 0, '%postscript_cmd%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'postscript', 1, 0, '%postscript%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'prescript_sumode', 1, 0, '%prescript_sumode%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'postscript_sumode', 1, 0, '%postscript_sumode%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'PatchDatabaseJob', 'use_staged_patch', 1, 0, '%use_staged_patch%', null, null );


END;
END;


MGMT_JOB_ENGINE.extract_nested_job_targets(l_job_type_id, 'PatchDatabaseJob', MGMT_JOB_VECTOR_PARAMS('%job_target_names%[%job_iterate_index%]'),MGMT_JOB_VECTOR_PARAMS('%job_target_types%[%job_iterate_index%]'));
-- DISPLAYINFO ENTRIES
INSERT INTO MGMT_JOB_TYPE_DISPLAY_INFO(job_type_id, nls_bundle,use_default_create_ui)  VALUES
	( l_job_type_id, null, 0 );

INSERT INTO MGMT_JOB_TYPE_URI_INFO(job_type_id, uri_use, uri, is_jsp, class)  VALUES
	( l_job_type_id, 2, '/ecm/patch/summary/patchSummary.jsp', 1, 'oracle.sysman.eml.ecm.patch.summary.PatchSummaryBean' );

INSERT INTO MGMT_JOB_TYPE_URI_INFO(job_type_id, uri_use, uri, is_jsp, class)  VALUES
	( l_job_type_id, 7, null, 0, null );

INSERT INTO MGMT_JOB_TYPE_URI_INFO(job_type_id, uri_use, uri, is_jsp, class)  VALUES
	( l_job_type_id, 8, null, 0, null );

INSERT INTO MGMT_JOB_TYPE_URI_INFO(job_type_id, uri_use, uri, is_jsp, class)  VALUES
	( l_job_type_id, 9, null, 0, null );

INSERT INTO MGMT_JOB_TYPE_URI_INFO(job_type_id, uri_use, uri, is_jsp, class)  VALUES
	( l_job_type_id, 10, null, 0, null );

-- Ensure that all existing scheduled executions use the new jobtype version
MGMT_JOB_ENGINE.reschedule_on_new_jobtype_ver(l_job_type_id);
-- Patch NLS information for backward-compatibility
MGMT_JOB_ENGINE.update_job_type_nls_info(l_job_type_id, l_job_type_name);

END;
END;


MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
EXCEPTION 
    WHEN OTHERS THEN 
        MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
        RAISE; 
END; 
/
COMMIT;
SET DEFINE ON

SET SQLPREFIX ON

