REM############################################################################
REM
REM Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
REM
REM
REM PRODUCT
REM	Oracle Enterprise Manager
REM
REM THIS FILE IS MACHINE GENERATED. DO NOT EDIT!
REM
REM JOB TYPE SQL FOR JOB TYPE: StageDatabasePatch
REM
REM#############################################################################

SET DEFINE OFF

SET SQLPREFIX OFF


BEGIN 
BEGIN
DECLARE
    l_job_type_name MGMT_JOB_TYPE_INFO.job_type%TYPE;
    l_job_type_id MGMT_JOB_TYPE_INFO.job_type_id%TYPE;
    l_major_version MGMT_JOB_TYPE_INFO.major_version%TYPE;
    l_minor_version1 MGMT_JOB_TYPE_INFO.minor_version1%TYPE;
    l_minor_version2 MGMT_JOB_TYPE_INFO.minor_version2%TYPE;
BEGIN

l_job_type_name:= 'StageDatabasePatch';

BEGIN 
MGMT_JOB_ENGINE.fix_flatten_steps(TRUE); 
MGMT_JOB_ENGINE.get_max_versions(l_job_type_name, l_major_version,
                   l_minor_version1, l_minor_version2, 
                   l_job_type_id); 
                         
l_minor_version2 := l_minor_version2+1; 
     
EXCEPTION 
    WHEN OTHERS THEN 
        IF SQLCODE=MGMT_GLOBAL.INVALID_JOB_TYPE_ERR THEN             l_major_version := 1; 
            l_minor_version1 := 0; 
            l_minor_version2 := 1; 
        ELSE 
            RAISE;
        END IF; 
END; 

-- CHECK TO VALIDATE REFERENCED COMMANDS/NESTED JOB TYPES
BEGIN
DECLARE
    l_commands SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
    l_nested_jobtypes SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN

    l_commands.trim(l_commands.count);

    l_commands.extend(2);
    l_commands(1) := 'remoteOp';
    l_commands(2) := 'putFile';
    MGMT_JOB_ENGINE.validate_job_type(l_job_type_name, l_commands, l_nested_jobtypes );


END;
END;


-- JOBTYPE ENTRY
INSERT INTO MGMT_JOB_TYPE_INFO(job_type, version, major_version, minor_version1, minor_version2, job_type_category, all_target_types, agent_bound, single_target, suspend_on_nocreds, default_target_type, restartable, editable, suspendable, trusted,job_type_nlsid,job_type_default,create_text_nlsid,create_text_default,delete_text_nlsid,delete_text_default)  VALUES
	( l_job_type_name, '1.0', l_major_version, l_minor_version1, l_minor_version2, 0, 0, 0, 0, 0, null, 1, 0, 1, -1, null, null, null, null, null, null)
RETURNING job_type_id INTO l_job_type_id;

-- ENTRIES FOR STEPSET stageDatabasePatchJob
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'stageDatabasePatchJob', 2, null, null, -1, null, -1, null, null, null, null, null, 1, null, null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET stageDatabasePatch
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'stageDatabasePatch', 2, null, null, 1, 'stageDatabasePatchJob', 2, null, null, null, null, null, 1, 'stageDatabasePatchJob', null, null, 1, 0, 0, 0, null, null, -1 );

-- PARAMINFO ENTRIES FOR STEP checkTarget
-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(7);
    l_param_names(1) := 'patch_type';
    l_param_names(2) := 'patch_id';
    l_param_names(3) := 'patch_size';
    l_param_names(4) := 'patch_target_type';
    l_param_names(5) := 'ARU_ID';
    l_param_names(6) := 'depot_path';
    l_param_names(7) := 'dest_home';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'checkTarget', 1, 'user', 1, null, 0, 1, 0, l_param_names );


END;
END;


-- PARAM SOURCE: source type user
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(2);
    l_param_names(1) := 'dest_username';
    l_param_names(2) := 'dest_password';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'checkTarget', 1, 'user', 2, null, 0, 1, 1, l_param_names );


END;
END;


-- PARAM SOURCE: source type inline
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(2);
    l_param_names(1) := 'perlscript';
    l_param_names(2) := 'dest_SID';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'checkTarget', 1, 'inline', 3, '
      ', 0, 0, 0, l_param_names );


END;
END;


-- INLINE PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_params MGMT_JOB_PARAM_LIST := MGMT_JOB_PARAM_LIST();
    l_vector_vals MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_params.trim(l_params.count);

    l_params.extend(2);
    l_params(1) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(1).param_name := 'perlscript';
    l_params(1).param_type := 1;
    l_params(1).scalar_value := 'osm/ecmPatchDatabase.pl';
    l_params(1).vector_value := null;
    l_params(2) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(2).param_name := 'dest_SID';
    l_params(2).param_type := 1;
    l_params(2).scalar_value := 'none';
    l_params(2).vector_value := null;
    INSERT INTO MGMT_JOB_VALUE_PARAMS(source_id, param_values, action) 
  SELECT source_id, l_params, 'none'     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=3;
END;
END;


-- PARAM SOURCE: source type sql
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'destFileInit';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'checkTarget', 1, 'sql', 4, '
               select ''destFileInit'',  DECODE (
                                               INSTR(''%depot_path%'' ,''EMStagedPatches'',1,1)
                                               ,''1''
                                               ,''%dest_home%/%depot_path%/%patch_id%/p%patch_id%.zip''
                                               ,''%depot_path%/%patch_id%/p%patch_id%.zip''
                                              )
               from dual
         ', 1, 0, 0, l_param_names );


END;
END;


-- SQL PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_vector_params MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_SQL_PARAMS(source_id, 
                      vector_params, 
                      out_proc, 
                      out_param_type) 
  SELECT source_id, l_vector_params, 0, null     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=4;
END;
END;


-- ENTRIES FOR STEP checkTarget
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'checkTarget', 1, null, null, 1, 'stageDatabasePatch', 2, null, null, null, null, null, 0, 'stageDatabasePatch', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP checkTarget
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkTarget', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkTarget', 'args', 1, 0, '-w,%scriptsdir%/%perlscript%,checkTarget,-oh,%dest_home%,-os,%dest_SID%,-d,%depot_path%,-p,%patch_type%,-i,%patch_id%,-s,%patch_size%,-t,%patch_target_type%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkTarget', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkTarget', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkTarget', 'username', 1, 0, '%dest_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkTarget', 'password', 1, 0, '%dest_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'checkTarget', 'executeSynchronous', 1, 0, 'false', null, null );


END;
END;


-- ENTRIES FOR STEP stagePatch
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'stagePatch', 1, null, null, 7, 'checkTarget', 1, null, null, null, null, null, 0, 'stageDatabasePatch', null, 'putFile', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP stagePatch
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'stagePatch', 'sourceType', 1, 0, 'sql', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'stagePatch', 'sqlType', 1, 0, 'blob', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'stagePatch', 'accessSql', 1, 0, 'SELECT FILE_CONTENTS FROM MGMT_ECM_PATCH_CACHE WHERE ARU_ID=%ARU_ID%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'stagePatch', 'destFile', 1, 0, '%destFileInit%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'stagePatch', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'stagePatch', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'stagePatch', 'username', 1, 0, '%dest_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'stagePatch', 'password', 1, 0, '%dest_password%', null, null );


END;
END;


-- ENTRIES FOR STEP expandPatch
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'expandPatch', 1, null, null, 7, 'stagePatch', 1, null, null, null, null, null, 0, 'stageDatabasePatch', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP expandPatch
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'expandPatch', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'expandPatch', 'args', 1, 0, '-w,%scriptsdir%/%perlscript%,expandPatch,-oh,%dest_home%,-os,%dest_SID%,-d,%depot_path%,-p,%patch_type%,-i,%patch_id%,-f,p%patch_id%.zip,-t,%patch_target_type%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'expandPatch', 'targetName', 1, 0, '%job_target_names%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'expandPatch', 'targetType', 1, 0, '%job_target_types%[1]', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'expandPatch', 'username', 1, 0, '%dest_username%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'expandPatch', 'password', 1, 0, '%dest_password%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'expandPatch', 'executeSynchronous', 1, 0, 'false', null, null );


END;
END;


-- Ensure that all existing scheduled executions use the new jobtype version
MGMT_JOB_ENGINE.reschedule_on_new_jobtype_ver(l_job_type_id);
-- Patch NLS information for backward-compatibility
MGMT_JOB_ENGINE.update_job_type_nls_info(l_job_type_id, l_job_type_name);

END;
END;


MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
EXCEPTION 
    WHEN OTHERS THEN 
        MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
        RAISE; 
END; 
/
COMMIT;
SET DEFINE ON

SET SQLPREFIX ON

