Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/jobs/jobs_engine_pkgdef.sql /st_emcore_10.2.0.4.2db11.2/1 2008/10/11 11:26:12 lsatyapr Exp $
Rem
Rem jobs_engine_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2008, Oracle and/or its affiliates. All rights reserved.
Rem
Rem    NAME
Rem      jobs_engine_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
rem     This is an internal package that provides low-level job system
rem     services such as scheduling and dispatching a step, and updating
rem     the status of a step that has finished executing
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED  (MM/DD/YY)
Rem    lsatyapr   10/09/08 - Add helper proc for large_param ref cnt
Rem    kmanicka   05/24/07 - Implement 10.2.0.4 Trusted RemoteOp
Rem    rdabbott   05/22/07 - bug 5714960b: desupport user suspend with timeout
Rem    lsatyapr   05/20/07 - Backport lsatyapr_bug-6020632 from main
Rem    lsatyapr   05/14/07 - Bug6020632 - change sign of reset_dispatcher_id
Rem    lsatyapr   05/08/07 - Bug6031714 Remove encrypt_job_level_params
Rem    lsatyapr   05/09/07 - Backport lsatyapr_bug-6031714 from main
Rem    kmanicka   03/28/07 - add USER_JOB
Rem    kmanicka   04/25/07 - Backport kmanicka_bug-5955919 from main
Rem    skini      08/04/06 - 5395103: Write to step error when error
Rem                          notifications arrive
Rem    skini      08/09/06 - Backport skini_bug-5395103 from main
Rem    skini      12/12/05 - Backport skini_bug-4741721 from main 
Rem    skini      12/06/05 - Introduce PURGE_ROWSET_SIZE_NAME 
Rem    nqureshi   09/15/05 - added overloaded get_large_param function 
Rem    dsahrawa   09/15/05 - bug 4601560, deadock between receiver and console 
Rem                          threads 
Rem    skini      09/09/05 - Revert module name to EM.jobs 
Rem    skini      09/02/05 - Introduce PARAMSRC_RETRY_EXEC 
Rem    rpinnama   09/08/05 - Modify create_temp_cp_ca_from_temp_cp to accept 
Rem                          src and dest CA names 
Rem    jaysmith   09/07/05 - add are_cas_equivalent() 
Rem    jaysmith   08/25/05 - cluster types eligible for same jobtypes as 
Rem                          members 
Rem    dsahrawa   08/23/05 - add extract_nested_job_targets 
Rem    dsahrawa   08/17/05 - change module name 
Rem    skini      08/07/05 - Change signature of nested_job_creds added 
Rem    jsadras    08/07/05 - lock_cas_for_object add target_type 
Rem    dsahrawa   08/01/05 - bug 4482130, add clone_job_type 
Rem    dsahrawa   07/22/05 - bug 4496616, add support for large params for 
Rem                          tasks 
Rem    pkantawa   07/11/05 - Fix 4348291: Add target post delete callback 
Rem    pkantawa   07/07/05 - Fix 4348291: add delete_executions_complete 
Rem    skini      07/17/05 - Keep track of error messages from async 
Rem                          notifications 
Rem    jsadras    07/08/05 - add cfg columns to trigger_ca_for_violation
Rem    skini      07/11/05 - Add group membership change callback 
Rem    scgrover   07/07/05 - add extended sql trace 
Rem    dsahrawa   06/14/05 - bug 4148622, command block rewrite 
Rem    rzazueta   07/06/05 - Fix 4435559 
Rem    rpinnama   06/25/05 - Fix 4448414 : Copy target CAs properly to 
Rem                          template copy scope 
Rem    skini      06/13/05 - Removal of edit_ca 
Rem    skini      06/06/05 - grabtrans 'skini_bug-4377344' 
Rem    skini      05/23/05 - Change signature of update_job_parameters_auto 
Rem    skini      05/22/05 - Add step_id to suspend on event procedure 
Rem    skini      05/20/05 - Bug 4377344: autonomous txns for suspend, 
Rem                          set_set_targets 
Rem    rdabbott   04/19/05 - Fix 4316792: stop job run 
Rem    jaysmith   05/19/05 - create_target_ca_from_default
Rem    pkantawa   04/13/05 - 
Rem    dsahrawa   04/14/05 - 
Rem    skini      04/14/05 - Continue broken ca changes 
Rem    skini      04/13/05 - Broken CAs 
Rem    skuchero   04/08/05 - add force_stop_all_executions for StopJobVerb
Rem    dsahrawa   04/06/05 - add process_flatten_targets_step for use from dispatcher
Rem    skini      04/01/05 - Copy large parameters 
Rem    pkantawa   03/28/05 - Add execution status for job reassignment
Rem    pkantawa   03/24/05 - Fix 4148622: add_job_callback 
Rem    dsahrawa   03/17/05 - add new variant of is_single_target_job_type 
Rem    kmanicka   03/07/05 - Impl IMMEDIATE Schedule
Rem    dsahrawa   03/07/05 - nested job group target fixes
Rem    kmanicka   03/09/05 - Impl JOB_STATUS_EXPIRED
Rem    pkantawa   03/07/05 - add delete pending status 
Rem    dsahrawa   02/08/05 - impl association parameter sources 
Rem    pkantawa   03/04/05 - Add constants for commands (e.g. remoteOp, etc)
Rem    skini      02/14/05 - Expose get_current_schedule for migration 
Rem    kmanicka   01/25/05 - always compute timezone in sechdule_execution
Rem    skini      01/07/05 - Add cleanup_queue API 
Rem    skini      12/16/04 - Add delete_template_cas 
Rem    skini      11/23/04 - Code Review comments 
Rem    skini      11/21/04 - Moce CA scope constants to job engine 
Rem    kmanicka   11/22/04 - 3941700 make update_job_parameters public 
Rem    dsahrawa   11/17/04 - 
Rem    skini      11/17/04 - Cutover credentials_disabled column to broken 
Rem                          column 
Rem    pkantawa   11/16/04 - Add Skipped status 
Rem    dsahrawa   11/15/04 - add run_after_start_grace to 
Rem                          resume_job/execution 
Rem    jaysmith   11/11/04 - pass violation from severity trigger to CA code 
Rem    dsahrawa   11/01/04 - add last_end_time to schedule_execution 
Rem    dsahrawa   10/28/04 - add sysdate_utc to pkg def 
Rem    skini      10/27/04 - Versioning support, part 2 
Rem    skini      10/08/04 - Versioning changes 
Rem    jaysmith   10/28/04 - set triggering_severity at insert-time 
Rem    pkantawa   10/13/04 - Add job type category constants 
Rem    dsahrawa   10/06/04 - add get_nested_job_targets
Rem    rpinnama   10/01/04 - Add lock_cas_for_object API 
Rem    rpinnama   10/01/04 - Add reset_ca_ctrs and delete_noref_cas 
Rem    pshishir   09/23/04 - Added template Copy APIs
Rem    kmanicka   09/20/04 - add user model callbacks for jobs and ca 
Rem    skini      09/14/04 - Implement error code propogation 
Rem    skini      09/14/04 - new type of system job assoc with session 
Rem    dsahrawa   09/14/04 - add get_multi_task_job_info 
Rem    pshishir   08/09/04 - 
Rem    skini      08/23/04 - Add insert_command_block_error 
Rem    ashugupt   08/19/04 - removing fetching credentials values from 
Rem                          get_job_credential_metadata procedure 
Rem    shianand   08/25/04 - Added get_job_step_params 
Rem    pkantawa   08/09/04 - grabtrans 'nqureshi_naim_parameter_2' 
Rem    kmanicka   08/06/04 - fixing retry with prameters
Rem 	 pshishir   07/12/04 - Modified delete_job, added delete_ca and process_delete_job
Rem    skini      07/27/04 - Fix bug with stopping skipped executions 
Rem    ashugupt   07/26/04 - job credential ui related changes 
Rem 	 pshishir   07/12/04 - Shifted restart_job_execution from MGMT_JOB
Rem 	 pshishir   07/12/04 - Add check_modify_ca and set_job_params
Rem    pshishir   07/07/04 - Add Corrective action APIs
Rem    nqureshi      07/19/04 - added procedure to be used in parameters page  
Rem    skini      07/19/04 - Implement notification support 
Rem    skini      07/16/04 - Job Notifications support 
Rem    dsahrawa   06/08/04 - skipped executions implementation 
Rem    skini      05/19/04 - Encrypt job-level parameters 
Rem    jsadras    03/17/04 - added force_stop to stop_all_executions 
Rem    jsadras    03/16/04 - 
Rem    ramalhot   03/04/04 - Add stop_all_executions_with_id(p_job_id RAW) 
Rem    rdabbott   02/03/04 - suspend, stop pending is actually a 'running' status 
Rem    rdabbott   01/30/04 - Fix 3256113: create 'active' bucket 
Rem    aholser    02/05/04 - remove JOB_STEP_COUNT 
Rem    dsahrawa   02/02/04 - fix job deletion for multi target jobs 
Rem    skini      11/13/03 - Remove job status expired 
Rem    rdabbott   10/28/03 - bug 3209093: fix buckets 
Rem    dsahrawa   10/16/03 - change for test dispatcher 
Rem    skini      10/02/03 - Implement delete_run 
Rem    skini      10/01/03 - 
Rem    skini      09/30/03 - Queues 
Rem    skini      09/30/03 - Add status bucket column 
Rem    skini      09/14/03 - Add resolve_cluster 
Rem    skini      09/10/03 - Implement suspend job 
Rem    skini      09/09/03 - timezone changes 
Rem    skini      09/08/03 - Add user deletion callback 
Rem    skini      09/04/03 - Add is_single_target_job 
Rem    skini      09/02/03 - 
Rem    skini      08/30/03 - Add is_editable, etc 
Rem    skini      08/26/03 - 
Rem    skini      08/25/03 - Continue with group support 
Rem    skini      08/23/03 - Changes to make job name/owner unique 
Rem    skini      08/22/03 - Add substValues source 
Rem    dsahrawa   07/16/03 - Add get_next_execution_time to the package def as it is needed for testing
Rem    skini      07/16/03 - Job library support
Rem    skini      06/27/03 - Logging for jobs
Rem    skini      06/23/03 - Callbacks
Rem    skini      06/18/03 - Add getLargeParameterForUpdate
Rem    skini      06/11/03 - Large parameter support
Rem    skini      05/12/03 - Add edit API, security checks for new usermodel
Rem    skini      04/14/03 - Add new constant for parameter source
Rem    skini      03/20/03 - Add validate_job_type
Rem    skini      12/07/02 - Complete fix for scheduling bug
Rem    skini      11/24/02 - Jobs and blackouts
Rem    skini      11/22/02 - Blackout windows
Rem    skini      10/11/02 - Change signature of update_job_parameters
Rem    skini      10/09/02 - Continue work on 2549136
Rem    skini      10/14/02 - Add bulk update method
Rem    skini      09/04/02 - 
Rem    skini      09/03/02 - Finish up implementing locking
Rem    skini      08/28/02 - Implement suspend timeout
Rem    skini      08/27/02 - Implement event-based suspends
Rem    skini      08/08/02 - Support locking output in NOWAIT mode
Rem    skini      07/02/02 - Changes for deleteTarget and system jobs
Rem    skini      06/07/02 - Changes to support TIMEZONE_SPECIFIED
Rem    rpinnama   05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama   05/15/02 - Restructured.
rem    skini      04/19/02 - Remove autonomous transaction
rem    skini      04/18/02 - SMP_MGMT_JOB=>MGMT_JOB
rem    skini      04/16/02 - Commit autonomous transaction
rem    aholser    04/10/02 - performance logging.
rem    skini      04/15/02 - Make get_output_writer autonomous
rem    rdabbott   04/08/02 - expose subst param
rem    skini      04/03/02 - Fix end time issues
rem    skini      03/27/02 - Change boolean to integer in calls to delete_job_execution
rem    skini      03/25/02 - Fix for restart
rem    skini      03/21/02 - Change dispatcher to get one set off steps at a time
rem    skini      03/15/02 - Fix 2266912: restart does not work correctly
rem    skini      03/14/02 - Bug 2266922: Abort execution when param source fails
rem    rpatti     02/25/02 - use function to get current user
rem    skini      02/27/02 - Implement option to nuke system jobs
rem    skini      02/20/02 - Fix param sources for nested jobs
rem    aholser    02/05/02 - fix merge error
rem    skini      02/05/02 - Fix bug 2206570: account for jobs within iterative stepsets
rem    skini      01/31/02 - history table
rem    skini      01/30/02 - More timestamp issues
rem    skini      01/28/02 - timezone support
rem    skini      01/24/02 - Schedules, contd
rem    skini      01/23/02 - Schedules, contd
rem    skini      01/21/02 - Implement target deletion, schedules
rem    skini      01/18/02 - Implement security info, purging
rem    skini      01/16/02 - Encryption, system jobs
rem    skini      01/09/02 - Fix switch stepset abort, support system jobs
rem    rpinnama   12/28/01 - Change constants.
rem    skini      12/27/01 - Implement support for container paths
rem    rpinnama   12/26/01 - Update update_step_status.
rem    edemembe   12/27/01 - Removing target name/type and metric name/column references
rem    skini      11/20/01 - Implement agentbound jobs
rem    skini      11/19/01 - 
rem    skini      11/16/01 - Job system stability, continued
rem    skini      11/14/01 - Break up steps into long and short steps
rem    skini      11/12/01 - Support overrrideUser in parameter sources
rem    skini      11/01/01 - Implement restart
rem    skini      11/01/01 - Call reset_params
rem    skini      10/30/01 - Tune dispatcher query
rem    skini      10/26/01 - Fix job name length problem
rem    tjaiswal   10/25/01 - Fix exception errors
rem    aholser    10/16/01 - remove drops
rem    skini      10/18/01 - Drop credential_type column
rem    skini      10/16/01 - Fully support nested jobs
rem    skini      10/16/01 - Fix param source bug
rem    skini      10/05/01 - Support for parameter sources
rem    skini      09/20/01 - Async
rem    skini      09/17/01 - Change iterative stepset definition
rem    skini      09/14/01 - Serialize updates
Rem

CREATE OR REPLACE PACKAGE MGMT_JOB_ENGINE AS

TYPE MGMT_JOB_REFCURSOR IS REF CURSOR;
TYPE DATE_ARRAY IS VARRAY(10000) OF DATE;

-- Module name used for logging
MODULE_NAME CONSTANT VARCHAR2(11) := 'EM.jobs';

-- Constant for a job type that can operate on "all" taregt types
ALL_TARGET_TYPES VARCHAR2(4) := 'all';

-- Constants for frequency codes
IMMEDIATE_FREQUENCY_CODE constant NUMBER(1) := 0;
ONE_TIME_FREQUENCY_CODE constant NUMBER(1) := 1;
INTERVAL_FREQUENCY_CODE constant NUMBER(1) := 2;
DAILY_FREQUENCY_CODE constant NUMBER(1) := 3;
WEEK_FREQUENCY_CODE constant NUMBER(1) := 4;
MONTH_FREQUENCY_CODE constant NUMBER(1) := 5;
YEAR_FREQUENCY_CODE constant NUMBER(1) := 6;

-- Constants for timezone values
TIMEZONE_REPOSITORY constant NUMBER(1) := 1;
TIMEZONE_TARGET constant NUMBER(1) := 2;
TIMEZONE_SPECIFIED constant NUMBER(1) := 3;
TIMEZONE_RGN_SPECIFIED constant NUMBER(1) := 4;

-- No start grace period defined
NO_START_GRACE constant NUMBER := -1;

-- Constants for execution status
SCHEDULED_STATUS            constant NUMBER(2) := 1;
EXECUTING_STATUS            constant NUMBER(2) := 2;
ABORTED_STATUS              constant NUMBER(2) := 3;
FAILED_STATUS               constant NUMBER(2) := 4;
COMPLETED_STATUS            constant NUMBER(2) := 5;
SUSPENDED_STATUS            constant NUMBER(2) := 6;
AGENTDOWN_STATUS            constant NUMBER(2) := 7;
STOPPED_STATUS              constant NUMBER(2) := 8;
SUSPENDED_LOCK_STATUS       constant NUMBER(2) := 9;
SUSPENDED_EVENT_STATUS      constant NUMBER(2) := 10;
SUSPENDED_BLACKOUT_STATUS   constant NUMBER(2) := 11;
STOP_PENDING_STATUS         constant NUMBER(2) := 12;
SUSPEND_PENDING_STATUS      constant NUMBER(2) := 13;
INACTIVE_STATUS             constant NUMBER(2) := 14;
QUEUED_STATUS               constant NUMBER(2) := 15;
FAILED_RETRIED_STATUS       constant NUMBER(2) := 16;
WAITING_STATUS              constant NUMBER(2) := 17;
SKIPPED_STATUS              constant NUMBER(2) := 18;
DELETE_PENDING_STATUS       constant NUMBER(2) := 19;
REASSIGNED_STATUS           constant NUMBER(2) := 20;
SUSPENDED_CREDS_STATUS      constant NUMBER(2) := 21;

STATUS_BUCKET_SCHEDULED     CONSTANT NUMBER(3) := -SCHEDULED_STATUS;
STATUS_BUCKET_RUNNING       CONSTANT NUMBER(3) := -EXECUTING_STATUS;
STATUS_BUCKET_SUSPENDED     CONSTANT NUMBER(3) := -SUSPENDED_STATUS;
STATUS_BUCKET_OK            CONSTANT NUMBER(3) := -COMPLETED_STATUS;
STATUS_BUCKET_PROBLEM       CONSTANT NUMBER(3) := -FAILED_STATUS;

STATUS_BUCKET_ACTIVE        CONSTANT NUMBER(4) := -990;
STATUS_BUCKET_ALL           CONSTANT NUMBER(4) := -999;

-- Constants for status categories
STATUS_CATEGORY_APP CONSTANT NUMBER(1) := 1;
STATUS_CATEGORY_INTERNAL CONSTANT NUMBER(1) := 2;

-- Constant for purge rowset size
PURGE_ROWSET_SIZE_NAME CONSTANT VARCHAR2(32) := 'jobPurgeRowsetSize';

-- 'new' constants for status values
--  for now, just use them in the 'status_bucket' column
ALL_BUCKET_START            constant NUMBER(3) := 100;
ACTIVE_BUCKET_START         constant NUMBER(3) := 100;

SCHEDULED_BUCKET_START      constant NUMBER(3) := 100;
SCHEDULED_STATUS_2          constant NUMBER(3) := 120;
-- todo: should this come before scheduled?
QUEUED_STATUS_2             constant NUMBER(3) := 150;
SCHEDULED_BUCKET_END        constant NUMBER(3) := 199;

RUNNING_BUCKET_START        constant NUMBER(3) := 200;
EXECUTING_STATUS_2          constant NUMBER(3) := 210;
SUSPEND_PENDING_STATUS_2    constant NUMBER(3) := 220;
STOP_PENDING_STATUS_2       constant NUMBER(3) := 230;
RUNNING_BUCKET_END          constant NUMBER(3) := 299;

SUSPENDED_BUCKET_START      constant NUMBER(3) := 300;
SUSPENDED_STATUS_2          constant NUMBER(3) := 320;
AGENTDOWN_STATUS_2          constant NUMBER(3) := 330;
SUSPENDED_LOCK_STATUS_2     constant NUMBER(3) := 340;
SUSPENDED_EVENT_STATUS_2    constant NUMBER(3) := 350;
SUSPENDED_BLACKOUT_STATUS_2 constant NUMBER(3) := 360;
SUSPENDED_CREDS_STATUS_2    constant NUMBER(3) := 380;
SUSPENDED_BUCKET_END        constant NUMBER(3) := 399;

ACTIVE_BUCKET_END           constant NUMBER(3) := 399;

COMPLETED_BUCKET_START      constant NUMBER(3) := 400;
COMPLETED_STATUS_2          constant NUMBER(3) := 410;
COMPLETED_BUCKET_END        constant NUMBER(3) := 499;

PROBLEM_BUCKET_START        constant NUMBER(3) := 500;
STOPPED_STATUS_2            constant NUMBER(3) := 520;
ABORTED_STATUS_2            constant NUMBER(3) := 530;
INACTIVE_STATUS_2           constant NUMBER(3) := 540;
FAILED_STATUS_2             constant NUMBER(3) := 550;
FAILED_RETRIED_STATUS_2     constant NUMBER(3) := 560;
SKIPPED_STATUS_2            constant NUMBER(3) := 570;
REASSIGNED_STATUS_2         constant NUMBER(3) := 580;
PROBLEM_BUCKET_END          constant NUMBER(3) := 599;

ALL_BUCKET_END              constant NUMBER(3) := 999;

-- Constants for CORRECTIVE ACTION SCOPE 
CA_SCOPE_TARGET constant NUMBER(1) := 1; 
CA_SCOPE_TEMPLATE constant NUMBER(1) := 2; 
CA_SCOPE_TARGET_TYPE constant NUMBER(1) := 3; 
CA_SCOPE_USER constant NUMBER(1) := 4;
CA_SCOPE_TEMPLATE_COPY constant NUMBER(1) :=5;

-- Constants for job status
JOB_STATUS_ACTIVE              constant NUMBER(2) := 0;
JOB_STATUS_SUSPENDED           constant NUMBER(2) := 1;
JOB_STATUS_STOPPED             constant NUMBER(2) := 2;
JOB_STATUS_REASSIGNED          constant NUMBER(2) := 3;
JOB_STATUS_EXPIRED             constant NUMBER(2) := 4;
JOB_STATUS_DELETE_PENDING      constant NUMBER(2) := 5; 

-- Possible values for status_detail. This only
-- applies right now when the status is SKIPPED
-- or WAITING
SKIPPED_USER_SUSPEND        constant NUMBER(2) := 1;
SKIPPED_SYSTEM_SUSPEND      constant NUMBER(2) := 2;
SKIPPED_RUNNING             constant NUMBER(2) := 3;
SKIPPED_EXPIRY              constant NUMBER(2) := 4;
SKIPPED_USER                constant NUMBER(2) := 5;
SKIPPED_SYSTEM              constant NUMBER(2) := 6;
SKIPPED_REASSIGNED          constant NUMBER(2) := 9;

START_WAITING_STATUS        constant NUMBER(2) := 7;
GRACE_WAITING_STATUS        constant NUMBER(2) := 8;

TRUSTED                     constant NUMBER(1) := 1;
NOT_TRUSTED                 constant NUMBER(1) := 0;
TRUST_UNDEFINED             constant NUMBER(1) := -1;

-- Constants for Trustable Command
NON_TRUSTABLE_COMMAND constant INTEGER := 0;
TRUSTABLE_COMMAND     constant INTEGER := 1;



-- Constant for default switch value
DEFAULT_SWITCH_VALUE constant VARCHAR2(20) := 'SWITCH_DEFAULT';

-- Constants for step types
-- A note about the paramsrc steps
-- STEPTYPE_PARAMSRC is used to run execution-time paramsrcs
-- STEPTYPE_PARAMSRC_RETRY is used to rerun param sources
--     when a step is rerun. It is only ever called from
--     reschedule_step()
-- STEPTYPE_PARAMSRC_RETRY_EXEC is used to run param sources
--     in retried execs that are marked evaluateAtRetry=true
--
STEPTYPE_STEP                  constant NUMBER(2) := 1;
STEPTYPE_SERIAL_STEPSET        constant NUMBER(2) := 2;
STEPTYPE_SWITCH_STEPSET        constant NUMBER(2) := 3;
STEPTYPE_PARALLEL_STEPSET      constant NUMBER(2) := 4;
STEPTYPE_ITSERIAL_STEPSET      constant NUMBER(2) := 5;
STEPTYPE_ITPLL_STEPSET         constant NUMBER(2) := 6;
STEPTYPE_JOB                   constant NUMBER(2) := 7;
STEPTYPE_PARAMSRC              constant NUMBER(2) := 8;
STEPTYPE_PARAMSRC_RETRY        constant NUMBER(2) := 9;
STEPTYPE_START_WAIT_STEP       constant NUMBER(2) := 10;
STEPTYPE_GRACE_WAIT_STEP       constant NUMBER(2) := 11;
STEPTYPE_FLATTEN_TARGETS_STEP  constant NUMBER(2) := 12;
STEPTYPE_PARAMSRC_RETRY_EXEC   constant NUMBER(2) := 13;

-- Constants for purge criteria
TARGET_CRITERION constant NUMBER(1) := 1;
JOBTYPE_CRITERION constant NUMBER(1) := 2;
USER_CRITERION constant NUMBER(1) := 3;
JOBNAME_CRITERION constant NUMBER(1) := 4;

-- Constants for callback types
EXECUTION_SUSPENDED_CALLBACK constant NUMBER(1) := 1;
EXECUTION_RESUMED_CALLBACK constant NUMBER(1) := 2;
EXECUTION_STOPPED_CALLBACK constant NUMBER(1) := 3;
EXECUTION_DELETED_CALLBACK constant NUMBER(1) := 4;
JOB_DELETED_CALLBACK constant NUMBER(1) := 5;
JOB_RETRY_CALLBACK constant NUMBER(1) := 6;

-- Constants for broken reasons
BROKEN_USER_REASSIGN CONSTANT NUMBER(1) := 1;
BROKEN_NO_CREDS CONSTANT NUMBER(1) := 2;
BROKEN_NO_PRIVS CONSTANT NUMBER(1) := 3;
BROKEN_TARGET_DELETED CONSTANT NUMBER(1) := 4;

-- Constants for privilege types
TARGET_PRIVILEGE          constant NUMBER(1) := 1;
SYSTEM_PRIVILEGE          constant NUMBER(1) := 2;

-- Normal User Job
USER_JOB constant NUMBER(1) := 0;
-- System job constants
SYSTEM_JOB constant NUMBER(1) := 1;
-- System job that must be retried on failure
SYSTEM_JOB_RETRY constant NUMBER(1) := 2;
-- System jobs associated with a http session
SYSTEM_JOB_SESSION constant NUMBER(1) := 3;

-- Constants for parameter types
PARAM_TYPE_VECTOR constant NUMBER(1) := 0;
PARAM_TYPE_SCALAR constant NUMBER(1) := 1;
PARAM_TYPE_LARGE constant NUMBER(1) := 2;

NO_EXECUTION constant RAW(16) := '0000000000000000';
NO_GUID constant RAW(16) := '0000000000000000';

-- Constants for incoming edge types
-- Note: some of the scheduling code depends on the edge type
-- codes being ordered as they are below, so don't change
-- these values without considering the impact on the code!
ETYPE_SERIAL_BEGIN     constant NUMBER(1) := 1;
ETYPE_SERIAL_END       constant NUMBER(1) := 2;
ETYPE_SWITCH_BEGIN     constant NUMBER(1) := 3;
ETYPE_PARALLEL_BEGIN   constant NUMBER(1) := 4;
ETYPE_ITERATIVES_BEGIN constant NUMBER(1) := 5;
ETYPE_ITERATIVEP_BEGIN constant NUMBER(1) := 6;
ETYPE_SUCCESSOF_END    constant NUMBER(1) := 7;
ETYPE_FAILUREOF_END    constant NUMBER(1) := 8;
ETYPE_ABORTOF_END      constant NUMBER(1) := 9;

-- Constants for job system "system" parameters
PARAM_TARGET_NAMES constant varchar2(32) := 'job_target_names';
PARAM_TARGET_TYPES constant varchar2(32) := 'job_target_types';

-- The job name for the job dispatcher
JOB_DISPATCHER_NAME constant varchar2(32) := 'JOB_DISPATCHER';

-- Constants for parameter source types
SOURCE_TYPE_SQL constant varchar2(20) := 'sql';
SOURCE_TYPE_CRED constant varchar2(20) := 'credentials';
SOURCE_TYPE_PROP constant varchar2(20) := 'properties';
SOURCE_TYPE_USER constant varchar2(20) := 'user';
SOURCE_TYPE_INLINE constant varchar2(20) := 'inline';
SOURCE_TYPE_ASSOC constant varchar2(20) := 'association';
SOURCE_TYPE_CHECKVALUES constant varchar2(20) := 'checkValues';
SOURCE_TYPE_SUBSTVALUES constant varchar2(20) := 'substValues';

-- Constants for serialized job types
GLOBALLY_SERIALIZED constant INTEGER := 1;
TARGET_SERIALIZED constant INTEGER := 2;

-- Constants for restart modes
RESTART_MODE_FAILURE constant INTEGER := 1;
RESTART_MODE_ALWAYS constant INTEGER := 2;

-- Constants for command types
SHORT_RUNNING_COMMAND constant INTEGER := 0;
LONG_RUNNING_COMMAND constant INTEGER := 1;
SYSTEM_COMMAND constant INTEGER := 2;
WAIT_COMMAND constant INTEGER := 3;

-- Constants for emd status events
EVENT_EMD_DOWN constant INTEGER := 1;
EVENT_EMD_UP constant INTEGER := 2;
EVENT_EMD_BOUNCED constant INTEGER := 3;

-- The error code when a step was aborted because an agent went down
AGENT_DOWN_ERROR constant INTEGER := 9;

-- Constants indicating events
AGENTBOUNCED_EVENT constant VARCHAR2(20) := 'bounceAgent';
AGENTBOUNCED_EMDURL constant VARCHAR2(20) := 'emdUrl';

-- Constants indicating locking actions
LOCK_SUSPEND_ACTION constant INTEGER := 1;
LOCK_ABORT_ACTION constant INTEGER := 2;

-- Constants indicating locking types
LOCKTYPE_GLOBAL constant INTEGER := 1;
LOCKTYPE_TARGET_EXCLUSIVE constant INTEGER := 2;
LOCKTYPE_TARGET_NAMED constant INTEGER := 3;

-- Constants indicating the mode in which lock is obtained
LOCKMODE_EXCLUSIVE constant INTEGER := 1;
LOCKMODE_SHARED_EXCLUSIVE constant INTEGER := 2;

-- Constants indicating lock status
LOCKSTATUS_ACQUIRED constant INTEGER := 2;
LOCKSTATUS_WAITING constant INTEGER := 1;

-- Constants for commands
COMMAND_REMOTE_OP constant varchar2(20) := 'remoteOp';
COMMAND_FILE_TRANSFER constant varchar2(20) := 'fileTransfer';
COMMAND_PUT_FILE constant varchar2(20) := 'putFile';
COMMAND_GET_FILE constant varchar2(20) := 'getFile';

-- Constants for job credentials
USE_PREFERRED_CREDENTIALS constant INTEGER := 1;
OVERRIDE_PREFERRED_CREDENTIALS constant INTEGER := 2;

-- Constants for job type category that is defined in MGMT_JOB table
--
-- Job Type Category constants
--
JOBTYPE_CATEGORY_INTERNAL CONSTANT NUMBER(1) := 0;
JOBTYPE_CATEGORY_DRAFT    CONSTANT NUMBER(1) := 1;
JOBTYPE_CATEGORY_SHARED   CONSTANT NUMBER(1) := 2;
JOBTYPE_CATEGORY_HIDDEN   CONSTANT NUMBER(1) := 3;

--
-- Multi task job type constant
--
MULTITASK_JOB_TYPE CONSTANT VARCHAR(32) := 'multitask';

-- Lock type for locking jobId + targetListIndex
JOB_TARGET_INDEX_LOCK CONSTANT VARCHAR(32) := 'JOB_TARGET_INDEX';

EST_JOB_NAME CONSTANT VARCHAR(32) := 'EST_JOB';

TYPE LOCKCURSOR IS REF CURSOR;

--associative array used to store mapping of:
-- job_type_id <---> requires credentials (0 or 1)
--job type id must be converted to char before storing.
TYPE MGMT_CREDENTIAL_JOB_TYPE_MAP IS TABLE OF NUMBER INDEX BY VARCHAR(64);
    
-- Date related routines
FUNCTION SYSDATE_UTC RETURN DATE;
FUNCTION SYSDATE_TZRGN(tzrgn_in VARCHAR2) RETURN DATE; 

-- Return true if the specified jobtype id is single-target
FUNCTION is_single_target_job_type_id(p_job_type_id RAW) RETURN BOOLEAN;

-- Return true if the specified jobtype is single-target
FUNCTION is_single_target_job_type(p_job_type_name VARCHAR2) RETURN BOOLEAN;

-- Return 1 if the specified jobtype is single-target
PROCEDURE is_single_target_job_type(p_job_type_name VARCHAR2, p_single_target_out OUT NUMBER);

-- Return true if the specified job is a single-target job
FUNCTION is_single_target_job(p_job_id RAW) RETURN BOOLEAN;

-- Is this nested job a candidate for flattening of the target list?
FUNCTION is_nested_flatten_candidate(p_parent_job_id RAW, 
                                     p_nested_job_type VARCHAR2, 
                                     p_all_targets BOOLEAN) return BOOLEAN;

-- Extract nested job targets
PROCEDURE extract_nested_job_targets(p_parent_job_type_id RAW,
                                     p_step_name VARCHAR2,
                                     p_target_names MGMT_JOB_VECTOR_PARAMS,
                                     p_target_types MGMT_JOB_VECTOR_PARAMS);

-- Return the job id for the specified job
FUNCTION get_job_id(p_job_name VARCHAR2, 
                    p_owner VARCHAR2,
                    p_is_library NUMBER DEFAULT 0) RETURN RAW;

-- static constructor for MGMT_JOB_SCHEDULE_RECORD
FUNCTION get_job_schedule_record(p_frequency_code NUMBER,
                                p_start_time DATE,
                                p_end_time DATE,
                                p_execution_hours NUMBER,
                                p_execution_minutes NUMBER,
                                p_interval NUMBER,
                                p_months MGMT_JOB_INT_ARRAY,
                                p_days MGMT_JOB_INT_ARRAY,
                                p_timezone_info NUMBER,
                                p_timezone_target_index NUMBER,
                                p_timezone_offset NUMBER,
                                p_timezone_region VARCHAR2,
                                p_start_grace_period NUMBER DEFAULT NO_START_GRACE) RETURN MGMT_JOB_SCHEDULE_RECORD;

FUNCTION get_immediate_schedule_record RETURN MGMT_JOB_SCHEDULE_RECORD;

-- Should we allow the mgmt_job_execplan insert trigger to
-- munge the entries in there? Typically, the answer is
-- yes for job type registration and no for multitask 
-- (or regular, when it is implemented) jobtype cloning
-- This is the setter. Note that this is per session.
-- The default is to not munge entries.
PROCEDURE fix_flatten_steps(val BOOLEAN);
-- This is the getter. This is per session once again.
FUNCTION fixing_flatten_steps RETURN BOOLEAN;

-- Return job step parameters
FUNCTION get_job_step_params(p_job_id RAW, p_execution_id RAW,
                             p_step_name VARCHAR2, p_step_id NUMBER,
                             p_all_params NUMBER,
                             p_iterate_param VARCHAR2,
                             p_iterate_param_index NUMBER,
                             p_fill_encrypt_info BOOLEAN,
                             p_encrypt_info IN OUT NOCOPY MGMT_JOB_INT_ARRAY) RETURN MGMT_JOB_PARAM_LIST;

FUNCTION get_job_step_params(p_job_id RAW, p_execution_id RAW,
                             p_step_name VARCHAR2, p_step_id NUMBER,
                             p_job_type_id RAW,
                             p_all_params NUMBER,
                             p_iterate_param VARCHAR2,
                             p_iterate_param_index NUMBER,
                             p_fill_encrypt_info BOOLEAN,
                             p_encrypt_info IN OUT NOCOPY MGMT_JOB_INT_ARRAY) RETURN MGMT_JOB_PARAM_LIST;

-- Insert one execution. p_source_exec_id is non-null if this is a
-- restart execution. Parameter sources are not invoked for
-- restart executions. Returns the execution id of the job
FUNCTION insert_execution(p_job_id RAW,
                          p_target_list_index INTEGER,
                          p_target_guid RAW,
                          p_source_exec_id RAW,
                          p_expected_start_time DATE DEFAULT NULL,
                          p_start_time DATE DEFAULT NULL,
                          p_end_time DATE DEFAULT NULL,
                          p_status NUMBER DEFAULT SCHEDULED_STATUS,
                          p_status_detail NUMBER DEFAULT 0,
                          p_triggering_severity RAW DEFAULT NULL,
                          p_schedule MGMT_JOB_SCHEDULE_RECORD DEFAULT NULL) RETURN RAW;

-- Validate the specified schedule, throw an exception if invalid
PROCEDURE validate_schedule(p_schedule IN OUT NOCOPY MGMT_JOB_SCHEDULE_RECORD);

-- Schedule an execution at the specified target list index. 
-- If p_execution_id is non-null, the execution is already
-- inserted. If p_execution_id is null, this method attempts
-- to insert an execution. In all cases, it returns the
-- new (or old) execution id. 
-- If p_next_start_time is not null, then it is used as the
-- start time of the execution.
-- If p_target_guid is not null, it is used as the target
-- for the execution (single-target jobs).
-- Otherwise, the targets inserted at job level for the target
-- list specified by p_target_list_index will be copied over
FUNCTION schedule_execution(p_job_id RAW,
                            p_queue_name VARCHAR2,
                            p_execution_id RAW,
                            p_source_exec_id RAW,
                            p_schedule MGMT_JOB_SCHEDULE_RECORD,
                            p_target_list_index NUMBER,
                            p_target_guid RAW,
                            p_last_start_time DATE DEFAULT NULL,
                            p_last_end_time DATE DEFAULT NULL,
                            p_next_start_time DATE DEFAULT NULL,
                            p_current_time DATE DEFAULT NULL,
                            p_status INTEGER DEFAULT SCHEDULED_STATUS,
                            p_status_detail INTEGER DEFAULT 0,
                            p_triggering_severity RAW DEFAULT NULL,
                            p_restart_params MGMT_JOB_PARAM_LIST DEFAULT NULL) RETURN RAW;

-- upsert the target lists of the job, schedule executions as
-- necessary. Returns the guids of all newly scheduled executions
FUNCTION upsert_job_target_lists(p_job_id RAW,
                                 p_is_library NUMBER,
                                 p_job_targets MGMT_JOB_TARGET_LIST_ARRAY,
                                 p_schedule MGMT_JOB_SCHEDULE_RECORD,
                                 p_job_target_type VARCHAR2,
                                 p_edit BOOLEAN,
                                 p_queue_names SMP_EMD_STRING_ARRAY DEFAULT NULL)
    RETURN MGMT_JOB_GUID_ARRAY;

-- This call is used by the dispatcher to set steps that it was
-- unable to dispatch back to SCHEDULING status
PROCEDURE update_unscheduled_steps(steps_to_reschedule SMP_EMD_INTEGER_ARRAY);

-- Update the status of all steps specified. Like update_step_status,
-- but acts on arrays
PROCEDURE update_bulk_step_status(p_step_ids SMP_EMD_INTEGER_ARRAY,
                                  p_statuses SMP_EMD_INTEGER_ARRAY,
                                  p_error_codes SMP_EMD_INTEGER_ARRAY,
                                  p_async SMP_EMD_INTEGER_ARRAY,
                                  p_emd_urls SMP_EMD_STRING_ARRAY);

-- Reset the dispacther id for an async step. p_emd_url is the
-- identity of the emd that the async step was dispatched to.
PROCEDURE reset_dispatcher_id(p_step_id NUMBER, p_emd_url VARCHAR2, p_update_time NUMBER DEFAULT 1);

-- Update the status of a step, schedule all dependent steps
PROCEDURE update_step_status(p_step_id INTEGER,
                             p_step_status INTEGER,
                             p_status_code INTEGER,
                             p_status_code_category NUMBER 
                                DEFAULT STATUS_CATEGORY_APP,
                             p_force_schedule BOOLEAN DEFAULT false,
                             p_step_being_scheduled BOOLEAN DEFAULT false);

-- Update the status of a remote command from the command
-- exit code, schedule all dependent steps.
PROCEDURE update_async_op_status(p_step_id INTEGER,
                                 p_exit_code INTEGER,
                                 p_sequence_number INTEGER);

-- Return the next set of steps which are ready for dispatching
PROCEDURE get_scheduled_steps(p_max_steps INTEGER,
                              p_command_type NUMBER,
                              p_steps OUT MGMT_JOB_STEP_LIST,
                              p_dispatcher_id INTEGER);

-- Process a flatten targets step
PROCEDURE process_flatten_targets_step(p_step_id NUMBER);

-- Process a start wait or grace wait step
PROCEDURE process_wait_step(p_step_id NUMBER);

-- Return true if the job type is "restartable"
FUNCTION is_restartable(p_job_id RAW) RETURN BOOLEAN;

-- Return true if the job type is "suspendable"
FUNCTION is_suspendable(p_job_id RAW) RETURN BOOLEAN;

-- Return true if the job type is "editable"
FUNCTION is_editable(p_job_id RAW) RETURN BOOLEAN;

-- Return the next execution time in the repository timezone. Return null
-- if the job does not have any further executions
FUNCTION get_next_execution_time(p_schedule MGMT_JOB_SCHEDULE_RECORD,
                                 p_last_start_time DATE DEFAULT NULL,
                                 p_tzregion VARCHAR2,
                                 p_current_time DATE DEFAULT NULL)
    RETURN DATE;

-- Write out the output for a step
-- p_error_notification is relevant only when the step dispatched
-- an async remote op. For async remote ops, if p_error_notification
-- is true (1), then this is later used to determine the actual
-- status (Failed/Aborted) of the step.
PROCEDURE write_step_output(p_step_id INTEGER,
                            p_output VARCHAR2,
                            p_async_error_received NUMBER DEFAULT 0);

-- Write out the output for a step: autonomous txn version
PROCEDURE write_step_output_auto(p_step_id INTEGER,
                            p_output VARCHAR2);



-- Insert an error message for the specified step
PROCEDURE write_step_error_message(p_step_id NUMBER,
                                   p_error_message VARCHAR2);

-- Return the output for a step. If for_update is true, then
-- lock the row in preparation to updating it. If p_sequence_number
-- is -1, it is ignored. If p_sequence_number is > 0, then this
-- method returns null if the current step sequence number is
-- greater than or equal to the specified sequence number.
-- If p_lock_nowait is true (1), then the lock is obtained in 
-- NOWAIT mode, and an ORA-54 is thrown when the lock cannot
-- be obtained. The default is to block on the lock
FUNCTION get_output(p_step_id INTEGER, 
                    p_for_update INTEGER,
                    p_sequence_number INTEGER,
                    p_lock_nowait INTEGER DEFAULT 0) return CLOB;

-- Return the error message for a step. If for_update is true, then
-- lock the row in preparation to updating it.
-- If p_sequence_number is > 0, then this
-- method returns null if the current step sequence number is
-- greater than or equal to the specified sequence number.
-- If p_lock_nowait is true (1), then the lock is obtained in 
-- NOWAIT mode, and an ORA-54 is thrown when the lock cannot
-- be obtained. The default is to block on the lock
FUNCTION get_error_message(p_step_id INTEGER, 
                           p_for_update INTEGER,
                           p_sequence_number INTEGER,
                           p_lock_nowait INTEGER DEFAULT 0,
                           p_async_error_received INTEGER DEFAULT 0) return CLOB;

-- Update the values of job parameters. All incoming parameter
-- values are assumed to be unencrypted.
-- If p_encrypt_info is non-null, then store each parameter 
-- encrypted/unencrypted, as directed by p_encrypt_info(i).
-- If p_store_encrypted is true, then it overrides p_encrypt_info, and
-- all are encrypted before storing. If false, then all parameters
-- are stored unencrypted.
-- If p_insert_only is set to true, then do nothing if the parameter
-- is already present. If p_insert_only is true and the parameter
-- is directed to be encrypted (either because p_encrypt_info(i) is
-- true or p_store_encrypted is true) and the parameter already exists, 
-- then the parameter is encrypted if it is not already encrypted.
-- If p_recompute_ext_tgt_list is true, the extended target list of the job
-- is recomputed
-- If p_at_submit is true (1), then consider the parameters to have
-- been specified by the user
PROCEDURE update_job_parameters(p_job_id RAW,
                                p_execution_id RAW,
                                p_param_list MGMT_JOB_PARAM_LIST,
                                p_encrypt_info MGMT_JOB_INT_ARRAY,
                                p_store_encrypted BOOLEAN DEFAULT false,
                                p_insert_only BOOLEAN DEFAULT false,
                                p_recompute_ext_tgt_list BOOLEAN DEFAULT false,
                                p_at_submit NUMBER DEFAULT 0); 

-- Add/Update parameters of a job. If a parameter is already
-- present, it is updated; otherwise, it is inserted.
-- If p_store_encrypted is true, then the parameters are stored
-- encrypted, if not already encrypted.
-- If p_insert_only is true, then existing parameter values, if
-- any, are not updated. 
PROCEDURE update_job_parameters(p_job_id RAW,
                                p_execution_id RAW,
                                p_param_list MGMT_JOB_PARAM_LIST,
                                p_store_encrypted BOOLEAN DEFAULT false,
                                p_insert_only BOOLEAN DEFAULT false,
                                p_recompute_ext_list BOOLEAN DEFAULT false,
                                p_at_submit NUMBER DEFAULT 0);

-- The autonomous txn version
PROCEDURE update_job_parameters_auto(p_job_id RAW,
                                p_execution_id RAW,
                                p_param_list MGMT_JOB_PARAM_LIST,
                                p_encrypt_info MGMT_JOB_INT_ARRAY);

-- Edit the current job; assumes one target list
PROCEDURE edit_job(p_job_id RAW,
                   p_description VARCHAR2, 
                   p_params MGMT_JOB_PARAM_LIST,
                   p_targets MGMT_JOB_TARGET_LIST,
                   p_schedule MGMT_JOB_SCHEDULE_RECORD,
                   p_overridden_creds MGMT_JOB_CRED_ARRAY DEFAULT NULL,
                   p_job_notify_states SMP_EMD_INTEGER_ARRAY DEFAULT NULL);

-- Edit the current job; multiple target lists
PROCEDURE edit_job(p_job_id RAW,
                   p_description VARCHAR2, 
                   p_params MGMT_JOB_PARAM_LIST,
                   p_targets MGMT_JOB_TARGET_LIST_ARRAY,
                   p_schedule MGMT_JOB_SCHEDULE_RECORD,
                   p_overridden_creds MGMT_JOB_CRED_ARRAY DEFAULT NULL,
                   p_job_notify_states SMP_EMD_INTEGER_ARRAY DEFAULT NULL); 

-- Throw an exception if the current user does not possess the
-- specified (system) privilege. If p_job_guid is null, then the privilege
-- is assumed to be a system privilege. Otherwise, the privilege
-- is assumed to be a job privilege on the specified job.
PROCEDURE check_priv(p_priv_name VARCHAR2,
                     p_current_user VARCHAR2 DEFAULT NULL,
                     p_job_id RAW DEFAULT NULL,
                     p_allow_superuser BOOLEAN DEFAULT TRUE);

-- Perform checks to ensure that the user submitting the job has the
-- required privileges.
PROCEDURE check_security_info(p_job_id RAW,
                              p_execution_id RAW,
                              p_submission NUMBER DEFAULT 1);

-- Suspend an execution
PROCEDURE suspend_job_execution(p_execution_id IN RAW);

-- Suspend an execution. If p_suspend_step is true, then suspend the
-- currently running step
PROCEDURE suspend_job_execution(p_step_id      IN NUMBER,
                                p_suspend_step IN NUMBER);

-- Suspend an execution: autonomous transaction version
PROCEDURE suspend_job_execution_auto(p_step_id      IN NUMBER,
                                     p_suspend_step IN NUMBER);

-- Resume a suspended job
PROCEDURE resume_job_execution(p_execution_id IN RAW);

-- Suspend a job
PROCEDURE suspend_job(p_job_id RAW);

-- Resume a suspended job
PROCEDURE resume_job(p_job_id RAW);

-- Delete the job specified by p_job_name. If p_commit is true (1), then 
-- a commit is performed after each execution is deleted. This will
-- be useful when deleting a bunch of executions, so that they do
-- not cause rollback segments to blow. 
-- Deletion of a job causes all executions in the job to be deleted.
-- An exception is thrown if there are active executions.
PROCEDURE delete_job(p_job_name IN VARCHAR2,
                     p_job_owner IN VARCHAR2,
                     p_commit NUMBER DEFAULT 0,
                     p_is_library NUMBER DEFAULT 0);

-- Gets called by DeleteJob job type.
-- Deletes the jobs and CAs that are in status DELETE_PENDING_STATUS
PROCEDURE delete_job_complete;

-- Delete Corrective action
PROCEDURE delete_ca(p_job_id IN RAW,
                     p_commit INTEGER DEFAULT 0); 

-- Delete all CAs corresponding to a template or template copy
PROCEDURE delete_template_cas(p_template_guid IN RAW, 
                              p_template_copy BOOLEAN DEFAULT false);

-- Delete the execution with the specified execution id
PROCEDURE delete_job_execution(p_execution_id IN RAW);

-- Delete the run for the job with the specified job id
-- and scheduled time
PROCEDURE delete_job_run(p_job_id RAW, p_scheduled_time DATE);

-- Delete the specified executions. If p_commit is true (1), then 
-- a commit is performed after each execution is deleted. This will
-- be useful when deleting a bunch of executions, so that they do
-- not cause rollback segments to blow. 
PROCEDURE delete_job_executions(p_execution_ids IN MGMT_JOB_GUID_ARRAY,
                                p_commit NUMBER DEFAULT 0);

-- Delete all non-active executions in a job. p_commit has the usual
-- semantics 
PROCEDURE delete_all_executions(p_job_name VARCHAR2,
                                p_job_owner VARCHAR2 DEFAULT NULL,
                                p_commit NUMBER DEFAULT 0,
                                p_is_library NUMBER DEFAULT 0);

-- Stop the execution, if currently active. Nothing is done if
-- the execution is not currently active (ie is stopped, aborted,
-- completed, or failed).
PROCEDURE stop_execution(p_execution_id RAW);

-- Stop the specified set of executions.
PROCEDURE stop_executions(p_execution_ids MGMT_JOB_GUID_ARRAY);

-- stop the run for the job with the specified job id and scheduled time
PROCEDURE stop_job_run(p_job_id RAW, p_scheduled_time DATE);

-- Stop all active executions in the specified job
PROCEDURE stop_all_executions_with_id(p_job_id RAW,
                                      p_force_stop BOOLEAN DEFAULT FALSE);

-- force stop will skip STOP_PENDING and set the status
-- to STOPPED_STATUS, the actual job execution will not be stopped
PROCEDURE stop_all_executions(p_job_name   VARCHAR2,
                              p_job_owner  VARCHAR2 DEFAULT NULL,
                              p_force_stop BOOLEAN DEFAULT FALSE);

-- force stop will skip STOP_PENDING and set the status
-- to STOPPED_STATUS, the actual job execution will not be stopped
PROCEDURE force_stop_all_executions(p_job_name   VARCHAR2,
                                    p_job_owner  VARCHAR2);

-- Check that the current user can modify the specified job
-- If p_allow_superuser is TRUE, then superusers will be able to 
-- perform the operation. If set to FALSE, then the user will 
-- be able to perform the operation only if the user is the
-- owner of the job.
-- 
PROCEDURE check_modify_job(p_job_id RAW, 
                           p_allow_superuser BOOLEAN DEFAULT TRUE);

-- Check that the current user can modify the specified execution
-- Throw an exception if that is not the case
-- If p_allow_superuser is TRUE, then superusers will be able to 
-- perform the operation. If set to FALSE, then the user will 
-- be able to perform the operation only if the user is the
-- owner of the job.
PROCEDURE check_modify_execution(p_execution_id RAW,
                                 p_allow_superuser BOOLEAN DEFAULT TRUE);

-- Check that the current user can modify the specified step
-- Throw an exception if that is not the case
-- If p_allow_superuser is TRUE, then superusers will be able to 
-- perform the operation. If set to FALSE, then the user will 
-- be able to perform the operation only if the user is the
-- owner of the job.
PROCEDURE check_modify_step(p_step_id NUMBER,
                            p_allow_superuser BOOLEAN DEFAULT TRUE);

-- Set the targets of a step
PROCEDURE set_step_targets(p_step_id NUMBER,
                           p_targets MGMT_JOB_TARGET_LIST);

-- Set the targets of a step: autonomous txn version
PROCEDURE set_step_targets_auto(p_step_id NUMBER,
                                p_targets MGMT_JOB_TARGET_LIST);
                            
-- Methods dealing with purge policies
-- Register a new purge policy with the specified name, timeframe (in days)
-- and purge criteria
PROCEDURE register_purge_policy(p_policy_name VARCHAR2, 
                            p_timeframe NUMBER,
                            p_purge_criteria MGMT_JOB_PURGE_CRITERION_LIST);

-- Drop a purge policy that has the specified name
PROCEDURE drop_purge_policy(p_policy_name VARCHAR2);

PROCEDURE DBMSJOB_EXTENDED_SQL_TRACE_ON(p_value IN BOOLEAN);

-- Apply all registered purge policies
PROCEDURE apply_purge_policies;

-- The job system target pre deletion callback
PROCEDURE handle_target_pre_delete(p_target_name VARCHAR2,
                                   p_target_type VARCHAR2,
                                   p_target_guid RAW);


--The job system post target deletion callback
PROCEDURE handle_target_post_delete(p_target_name VARCHAR2,
                                    p_target_type VARCHAR2,
                                    p_target_guid RAW);

-- END Methods dealing with purge policies

-- Compute the "extended" target list for the specified execution.
-- The extended target list is the target list of the execution and
-- all additional targets in all designated target parameters
-- of the execution
-- This is still here only so it can be used during migration.
-- No new code should be using this method!
PROCEDURE compute_extended_target_list(p_execution_id RAW);

                                  
-- Failover callback
PROCEDURE handle_dispatcher_death(p_dispatcher_id INTEGER, 
                                  last_timestamp DATE);

-- Callback when an emd bounces; this is called when the emd
-- "startup" notification is received by the job receiver
PROCEDURE handle_startup_notification(p_emd_url VARCHAR2);

-- Callback when an emd is detected to be "DOWN"
PROCEDURE handle_emd_state_change(p_emd_url VARCHAR2, p_state INTEGER);

-- A procedure that processes entries in the job system emd event
-- queue (MGMT_JOB_EMD_STATUS_QUEUE). This is usually called from
-- a periodically running dbms_job
PROCEDURE process_emd_queue_entries;

-- 
-- The following procedures deal with registering events
--

-- Register a new event
-- The event callback function must have the following 
-- signature:
-- PROCEDURE callback(p_event_name VARCHAR2, 
--                    p_event_params SMP_EMD_NVPAIR_ARRAY);
-- The event callback is called when the event is "raised". The
-- callback can do additional processing outside the scope of the
-- job system, if required.
-- The event callback is optional, but is useful for validating
-- the parameters to the raise_event() call, for example.
PROCEDURE add_event(p_event_name VARCHAR2, p_event_callback VARCHAR2);

-- Raise an already registered event with the specified params
PROCEDURE raise_event(p_event_name VARCHAR2, 
                      p_event_params SMP_EMD_NVPAIR_ARRAY);

-- Suspend the job execution (excluding the current step) on
-- the specified event, having the specified parameters
PROCEDURE suspend_job_execution_on_event(p_execution_id RAW,
                                         p_event_name VARCHAR2,
                                         p_event_params SMP_EMD_NVPAIR_ARRAY,
                                         p_suspend_timeout NUMBER DEFAULT 0);

-- Suspend the job execution (excluding the current step) on
-- the specified event, having the specified parameters
-- Autonomous transaction version
PROCEDURE suspend_job_exec_on_event_auto(p_execution_id RAW,
                                         p_event_name VARCHAR2,
                                         p_event_params SMP_EMD_NVPAIR_ARRAY,
                                         p_suspend_timeout NUMBER DEFAULT 0);

-- "Associate" an event with the specified execution, without
-- actually suspending it. This generally indicates an intention
-- to eventually suspend the execution based on that event.
PROCEDURE associate_event_with_execution(p_execution_id RAW,
                                         p_event_name VARCHAR2,
                                         p_event_params SMP_EMD_NVPAIR_ARRAY);

-- Callback for the "bounceAgent" event
PROCEDURE bounce_agent_callback(p_event_name VARCHAR2,
                                p_event_params SMP_EMD_NVPAIR_ARRAY);

-- Functions to encrypt/decrypt values
FUNCTION decrypt_scalar(p_is_encrypted INTEGER,
                        p_scalar_value VARCHAR2)
        RETURN VARCHAR2;

FUNCTION decrypt_vector(p_is_encrypted INTEGER,
                        p_vector_value MGMT_JOB_VECTOR_PARAMS)
        RETURN MGMT_JOB_VECTOR_PARAMS;

FUNCTION encrypt_scalar(p_encrypt INTEGER,
                        p_scalar_value VARCHAR2)
        RETURN VARCHAR2;

FUNCTION encrypt_vector(p_encrypt INTEGER,
                        p_vector_value MGMT_JOB_VECTOR_PARAMS)
        RETURN MGMT_JOB_VECTOR_PARAMS;


-- Execute parameter sources for the specified step,
-- as well as scheduling the next entries in the execution
-- If p_first_step is true (1), this is the first step of
-- the execution   
-- Return the status of the execution (COMPLETED/ABORTED)
FUNCTION execute_param_sources(p_step_id NUMBER, 
                               p_first_step NUMBER,
                               p_retry NUMBER) RETURN NUMBER;

-- Forward declarations. These procedures should never
-- be called directly from outside the package
PROCEDURE schedule(p_job_id RAW,
                   p_execution_id RAW,
                   p_parent_step_id INTEGER,
                   p_source_parent_step_id INTEGER,
                   p_orig_parent_step_id INTEGER,
                   p_restart_mode INTEGER,
                   p_job_type_id RAW,
                   p_step_name VARCHAR2,
                   p_step_type VARCHAR2,
                   p_iterate_param VARCHAR2,
                   p_iterate_param_index NUMBER,
                   p_start_time DATE,
                   p_tzregion VARCHAR2,
                   p_update_status NUMBER);


PROCEDURE update_step_status_nolock(p_step_id INTEGER,
                                    p_step_status INTEGER,
                                    p_status_code INTEGER,
                                    p_status_code_category NUMBER 
                                            DEFAULT STATUS_CATEGORY_APP,
                                    p_force_schedule BOOLEAN DEFAULT false,
                                    p_step_being_scheduled BOOLEAN DEFAULT false);

-- This is needed here for command block procedures
FUNCTION update_sequence_number(p_step_id INTEGER,
                                p_sequence_number INTEGER) RETURN BOOLEAN;

PROCEDURE delete_job(p_job_id IN RAW,
                     p_commit INTEGER DEFAULT 0,
                     p_lock_job BOOLEAN DEFAULT TRUE);

-- Update the status of a command block. If p_status is
-- COMPLETED, the error message is null.
-- If p_status is FAILED then  we insert error messages
-- for these some cases from the java layer. for example,
-- 1. the command block size is too large for us to handle (>32K)
-- 2. there is a mismatch between the procedure signature
--    which was registerd and the arguments that were passed in.
PROCEDURE update_command_block_status(p_step_id NUMBER,
                                      p_sequence_number INTEGER,
                                      p_status NUMBER,
                                      p_text_id RAW DEFAULT NULL,
                                      p_error_message VARCHAR2 DEFAULT NULL);

-- Apply a command block to the specified step. p_sequence_number
-- is the sequence number of the command block. The job system checks
-- to ensure that two calls to apply_command_block with the same 
-- sequence number are not applied more than once
-- Note. This is only to be used in backward compatibility mode.
--       All regular command blocks must use the new XML format.
PROCEDURE apply_command_block(p_step_id NUMBER,
                              p_command_block VARCHAR2,
                              p_sequence_number INTEGER);

-- Update the reference count in the job output table
FUNCTION update_refcount(p_output_id RAW) RETURN RAW;

-- Remove a reference to a target from the extended list
-- If more than one reference is made to the target, the
-- reference count is reduced
PROCEDURE delete_ext_target(p_job_id RAW,
                            p_execution_id RAW,
                            p_target_list_index NUMBER,
                            p_target_guid RAW);

-- Insert a target into the "extended" list, upping the
-- ref count as necessary.
PROCEDURE insert_ext_target(p_job_id RAW,
                            p_execution_id RAW,
                            p_target_list_index NUMBER,
                            p_target_guid RAW);

-- Insert a target into the "extended" list. p_target_name_param
-- and p_target_type_param are the names of the parameters that
-- hold the target name and type, respectively. 
-- If p_raise_invalid_target is true, an exception is raised if the
-- target specified by p_target_name and p_target_type was found
-- to not exist.
PROCEDURE insert_ext_target(p_job_id RAW, p_execution_id RAW,
                            p_target_list_index NUMBER,
                            p_target_name VARCHAR2, 
                            p_target_type VARCHAR2,
                            p_raise_invalid_target BOOLEAN,
                            p_target_name_param VARCHAR2,
                            p_target_type_param VARCHAR2);


-- Substitute values of the form %param%
FUNCTION substitute_params(p_job_id VARCHAR2,
                           p_execution_id VARCHAR2,
                           p_step_id NUMBER,
                           p_iterate_param VARCHAR2,
                           p_iterate_param_index NUMBER,
                           p_job_name VARCHAR2,
                           p_job_owner VARCHAR2,
                           p_param_value VARCHAR2,
                           p_flattened BOOLEAN DEFAULT FALSE,
                           p_task_name VARCHAR2 DEFAULT NULL) RETURN VARCHAR2;

-- Call reset_params after each set of calls to substitute_params()
PROCEDURE reset_params;

-- Generate a lock guid that is unique for the specified 
-- lock name and type.
FUNCTION generate_lock_guid(p_lock_name VARCHAR2,
                            p_lock_type NUMBER) RETURN RAW;

-- Release all the locks associated with an execution
PROCEDURE release_execution_locks(p_execution_id RAW,
                                  p_job_type_id RAW);

-- A new blackout window was registered, or was modified
-- Note that start time and end time are always in repository time
PROCEDURE blackout_window_started(p_blackout_guid RAW,
                                  p_job_flag NUMBER,
                                  p_start_time DATE,
                                  p_end_time DATE);

-- A blackout ended, and had the job flag on
PROCEDURE blackout_window_ended(p_blackout_guid RAW);

-- Validate a job type. This is called by the job type parser
-- to validate that the job type is not referencing invalid commands
-- or nested job types.
-- p_commands is the set of commands referenced by this job type
-- p_nested_job_types is the set of job types referenced by this
-- job type
PROCEDURE validate_job_type(p_job_type VARCHAR2,
                            p_commands SMP_EMD_STRING_ARRAY,
                            p_nested_job_types SMP_EMD_STRING_ARRAY);

--
-- Return the large paremeter having the specified name
-- corresponding to the specified job and execution.
-- This will create and return an empty clob if the parameter
-- has not yet been initialized, so the caller must commit after
-- this call. p_for_update must be set to 1 if the caller intends
-- to update the parameter
--
FUNCTION get_large_param(p_job_id RAW,
                         p_execution_id RAW,
                         p_parameter_name VARCHAR2,
                         p_for_update NUMBER DEFAULT 0) RETURN CLOB;

-- Return the large parameter within the specified job that
-- associated with the the nested job p_nested_job_name
FUNCTION get_large_param(p_job_name VARCHAR2,
                         p_job_owner VARCHAR2,
                         p_is_library NUMBER,
                         p_nested_job_name VARCHAR2,
                         p_parameter_name VARCHAR2,
                         p_for_update NUMBER DEFAULT 0) RETURN CLOB;

FUNCTION get_large_param(p_job_id RAW,
                         p_execution_id RAW,
                         p_nested_job_name VARCHAR2,
                         p_parameter_name VARCHAR2,
                         p_for_update NUMBER DEFAULT 0) RETURN CLOB;

-- Get the most recent major version for the specified job type
PROCEDURE get_max_versions(p_job_type VARCHAR2,
                           p_major_version_out OUT NUMBER,
                           p_job_type_id_out OUT RAW);
-- Get the most recent version numbers for the specified job type
PROCEDURE get_max_versions(p_job_type VARCHAR2,
                           p_major_version_out OUT NUMBER,
                           p_minor_version1_out OUT NUMBER,
                           p_minor_version2_out OUT NUMBER,
                           p_job_type_id_out OUT RAW);

-- Return the job type id associated with the execution IF the 
-- specified job id is the parent job associated with the
-- execution. If not, return the job type id of the nested job
FUNCTION get_job_type_id(p_job_id RAW, p_execution_id RAW) RETURN RAW;
FUNCTION get_job_type_id(p_job_id RAW) RETURN RAW;


-- Handle changes in the membership of a group, propogate to all
-- jobs submitted against the group
PROCEDURE handle_membership_change(p_group_guid RAW);

-- this is a callback will be registered to the user model
-- it will be called by the user model when a user is deleted 
-- to delete the assiciated jobs
PROCEDURE drop_user_jobs(p_user_name       IN VARCHAR2,
                         type_in           IN NUMBER);

-- this is a callback will be registered to the user model
-- it will be called by the user model when a user is deleted 
-- to delete the assiciated jobs
PROCEDURE drop_user_ca(p_user_name       IN VARCHAR2,
                       type_in           IN NUMBER);

--this callback will be registered to user model
-- it will be called by the user model when a user is deleted
-- and the deleted user's jobs are being reassigned to a new user
--
-- INPUT PARAMETERS
-- p_username username of the user being deleted
-- p_new_username username of the user to whom jobs are being assigned
-- p_type type
--
-- OUTPUT PARAMETERS
-- p_user_objects_out list of jobs that do not meet the reassignment criteria

PROCEDURE check_reassign_user_jobs(p_username          IN VARCHAR2,
                                   p_new_username      IN VARCHAR2,
                                   p_user_objects_out  OUT MGMT_USER_OBJECTS,
                                   p_type              IN NUMBER);

-- this is a callback will be registered to the user model
-- it will be called by the user model when a user is deleted 
-- to reassign the assiciated jobs to a new user
PROCEDURE reassign_user_jobs(p_user_name       IN VARCHAR2, 
                             p_new_user_name   IN VARCHAR2,
                             type_in           IN NUMBER);

-- check if there are any ca owned by the user which can be reassigned to the
-- new user
PROCEDURE check_reassign_user_ca(user_name_in      IN VARCHAR2,
                                 new_user_name_in  IN VARCHAR2,
                                 user_objects_out  OUT MGMT_USER_OBJECTS,
                                 type_in           IN NUMBER);
 

-- this is a callback will be registered to the user model
-- it will be called by the user model when a user is deleted 
-- to reassign the assiciated jobs to a new user
PROCEDURE reassign_user_ca(p_user_name       IN VARCHAR2, 
                           p_new_user_name   IN VARCHAR2,
                           type_in           IN NUMBER);

-- get_user_jobs_and_ca is user model callback
-- user_name_in     : the name of user which is being deleted
-- user_objects_out : the list of jobs and ca owned by the user is returned
-- type_in          : type of user model callback
PROCEDURE get_user_jobs(user_name_in      IN VARCHAR2,
                        user_objects_out  OUT MGMT_USER_OBJECTS,
                        type_in           IN NUMBER);

-- get_user_jobs_and_ca is user model callback
-- user_name_in     : the name of user which is being deleted
-- user_objects_out : the list of ca owned by the user is returned
-- type_in          : type of user model callback
PROCEDURE get_user_ca(user_name_in      IN VARCHAR2,
                      user_objects_out  OUT MGMT_USER_OBJECTS,
                      type_in           IN NUMBER);


-- Return the emd url corresponding to the specified target. If the
-- target is a cluster, an appropriate instance is picked. The target
-- name and type of the resolved target is returned in the out
-- parameters p_target_name_out and p_target_type_out
FUNCTION get_emd_url(p_target_name VARCHAR2,
                     p_target_type VARCHAR2,
                     p_target_name_out OUT VARCHAR2,
                     p_target_type_out OUT VARCHAR2) RETURN VARCHAR2;

-- Create a new queue with the specified name that is
-- currently active and enabled, with a concurrency
-- factor of 1
PROCEDURE create_job_queue(p_queue_name VARCHAR2);

-- Enable/Disable the specified queue
PROCEDURE enable_job_queue(p_queue_name VARCHAR2, p_enabled NUMBER);

-- Delete the specified queue and all the executions
PROCEDURE delete_job_queue(p_queue_name VARCHAR2);

-- Cleanup all current executions in the job queue. If there are executions
-- in the queue that are currently running and p_force_delete_execs 
-- is true, the executions are silently stopped and deleted. 
-- If there are running executions and p_force_delete is false, 
-- an exception is thrown.
PROCEDURE cleanup_job_queue(p_queue_name VARCHAR2, 
                            p_force_delete_execs BOOLEAN DEFAULT false);

-- Convert to new status values from old ones
FUNCTION get_status_2_from_status(p_status IN NUMBER) RETURN NUMBER
DETERMINISTIC;

-- get status_2 value range for a given status or bucket
-- p_status_in can be 
--      an old status value
--      a new status value
--      a status bucket
PROCEDURE get_status_2_range(p_status_in        IN  NUMBER,
                             p_status_2_min_out OUT NUMBER,
                             p_status_2_max_out OUT NUMBER);
-- Increase the number of count by one if the number of metric thresholds
--  or policy rules on the scoped object with which the corrective action is associated
                             
PROCEDURE increment_ca_ref_count(p_job_id RAW); 

-- Decrease the number of count by one if the number of metric thresholds
-- or policy rules on the scoped object with which the corrective action is associated is removed.

PROCEDURE decrement_ca_ref_count(p_job_id RAW); 

-- Lock all CAs associated with an target/template/template copy
PROCEDURE lock_cas_for_object(p_object_guid IN RAW, 
                              p_ca_scope    IN NUMBER,
                              p_target_type IN VARCHAR2 DEFAULT NULL);

-- Reset the reference count for all CAs associated with the object
PROCEDURE reset_ca_refctr(p_object_guid IN RAW, p_ca_scope IN NUMBER);

-- Delete noref CA jobs for a given object
PROCEDURE delete_noref_cas(p_object_guid IN RAW, p_ca_scope IN NUMBER);

-- This procudure is responsible to associate a corrective action configured 
-- target with policy 

PROCEDURE set_target_policy_assoc_ca(p_target_type     IN VARCHAR2,
                                     p_target_name     IN VARCHAR2,
                                     p_policy_name     IN VARCHAR2,
                                     p_coll_name       IN VARCHAR2,
                                     p_key_value       IN VARCHAR2,
                                     p_key_operator    IN NUMBER DEFAULT 0,
                                     p_violation_level IN NUMBER,
                                     p_ca_name         IN VARCHAR2 );
-- This procudure is responsible to associate a corrective action configured 
-- target with Metric 

PROCEDURE set_target_metric_assoc_ca(p_target_type     IN VARCHAR2,
                                     p_target_name     IN VARCHAR2,
                                     p_metric_name     IN VARCHAR2,
                                     p_metric_column   IN VARCHAR2,
                                     p_coll_name       IN VARCHAR2,
                                     p_key_value       IN VARCHAR2,
                                     p_key_operator    IN NUMBER DEFAULT 0,
                                     p_violation_level IN NUMBER,
                                     p_ca_name         IN VARCHAR2 );

-- This procudure is responsible to set a target configured Corrective action 
-- for a particular severity level, on a particular agent fixit association.

PROCEDURE set_target_metric_agent_fixit(p_target_type   IN VARCHAR2, 
					p_target_name   IN VARCHAR2, 
					p_metric_name   IN VARCHAR2, 
					p_metric_column IN VARCHAR2,
                                        p_coll_name     IN VARCHAR2, 
					p_key_value     IN VARCHAR2, 
					p_key_operator IN NUMBER DEFAULT 0, 
					p_agent_fixit IN VARCHAR2); 

-- This procudure is responsible to associate a corrective action configured 
-- template with policy 

PROCEDURE set_template_policy_assoc_ca(p_target_type     IN VARCHAR2,
                                       p_template_name   IN VARCHAR2,
                                       p_policy_name     IN VARCHAR2,
                                       p_coll_name       IN VARCHAR2,
                                       p_key_value       IN VARCHAR2,
                                       p_key_operator    IN NUMBER DEFAULT 0,
                                       p_violation_level IN NUMBER,
                                       p_ca_name         IN VARCHAR2 );

-- This procudure is responsible to associate a corrective action configured 
-- template with Metric 

PROCEDURE set_template_metric_assoc_ca(p_target_type     IN VARCHAR2,
                                       p_template_name   IN VARCHAR2,
                                       p_metric_name     IN VARCHAR2,
                                       p_metric_column   IN VARCHAR2,
                                       p_coll_name       IN VARCHAR2,
                                       p_key_value       IN VARCHAR2,
                                       p_key_operator    IN NUMBER DEFAULT 0,
                                       p_violation_level IN NUMBER,
                                       p_ca_name         IN VARCHAR2 );

-- This procudure is responsible to set a template configured Corrective action 
-- for a particular severity level, on a particular agent fixit association.

PROCEDURE set_template_metric_fixit(p_target_type   IN VARCHAR2,
                                          p_template_name   IN VARCHAR2,
                                          p_metric_name   IN VARCHAR2,
                                          p_metric_column IN VARCHAR2,
                                          p_coll_name     IN VARCHAR2,
                                          p_key_value     IN VARCHAR2,
                                          p_key_operator IN NUMBER DEFAULT 0,
                                          p_agent_fixit IN VARCHAR2);

-- Insert the common schema entries for a job/corrective action
PROCEDURE insert_job(p_job_name IN VARCHAR2,
                     p_job_owner IN VARCHAR2,
                     p_is_library NUMBER,
                     p_job_target_type VARCHAR2,
                     p_description IN VARCHAR2,
                     p_job_type IN VARCHAR2,
                     p_job_params IN MGMT_JOB_PARAM_LIST,
                     p_schedule MGMT_JOB_SCHEDULE_RECORD,
                     p_job_creds MGMT_JOB_CRED_ARRAY,
                     p_notify_states SMP_EMD_INTEGER_ARRAY,
                     p_execution_timeout NUMBER,
                     p_max_target_list_index NUMBER,
                     p_system_job NUMBER,
                     p_is_corrective_action NUMBER,
                     p_ca_scope NUMBER,
                     p_ca_target_guid RAW,
                     p_ca_template_guid RAW,                     
                     p_job_id_out OUT RAW);


-- Restart Job/CA execution

FUNCTION restart_job_execution(p_exec_id IN RAW) RETURN RAW ;

PROCEDURE insert_target_list(p_job_id RAW,
                             p_targets MGMT_JOB_TARGET_LIST,
                             p_target_list_index NUMBER);

-- Call all job retry callbacks
PROCEDURE process_retry_callbacks(p_job_id IN RAW, p_exec_id IN RAW);

-- This function return execution id for the corrective action using job_id 
-- Which is the job id for target scoped corrective action,execution parameters
-- which allow the execution to receive parameters from violation, severity GUID
-- , simultaneous_actions and other_job_id as input attributes.
 
FUNCTION insert_ca_execution(p_job_id IN RAW, 
                             p_exec_params IN MGMT_JOB_PARAM_LIST,
                             p_severity_guid IN RAW,
                             p_simultaneous_actions NUMBER,
                             p_other_job_id IN RAW) RETURN RAW;

-- Get the job credentials meta data for the specified job type
PROCEDURE get_job_credential_metadata( p_job_type IN varchar2,
                                       p_target_type IN varchar2,
                                       p_job_credential OUT MGMT_JOB_CREDENTIAL_RECORD );


--get TARGETTYPE data for the Parameters page 
--   target type name as Input 
--   array of target values 
PROCEDURE get_target_type_data(target_type_name IN VARCHAR2, 
				prop_arr out MGMT_TARGET_TYPE_PROP_ARRAY  );

--- get all the parametesr meta Data 
-- job_type_name jobType 
--- returns Struct of metaData 
PROCEDURE get_job_type_metadata(job_type_name IN VARCHAR2 , 
				l_parameter_metaData out mgmt_job_parameter_metaData) ;

-- The following Procedure takes the input argruments from mgmt_severity
-- row while inserting a new severity and trigger a corrective action
-- associated with the target.
-- Callback to the http session manager
PROCEDURE handle_http_session_expiry(p_object_type VARCHAR2, 
                                     p_http_session VARCHAR2);
PROCEDURE trigger_ca_for_violation(p_object_guid      IN RAW,
                                   p_policy_guid      IN RAW,
                                   p_key_value        IN VARCHAR2,
                                   p_severity_code    IN NUMBER,
                                   p_severity_guid    IN RAW,
                                   p_violation       IN MGMT_VIOLATIONS%ROWTYPE,
                                   p_cfg_coll_name    IN VARCHAR2,
                                   p_cfg_key_value    IN VARCHAR2,
                                   p_cfg_key_operator IN NUMBER);

-- Get all information about a MultiTaskJob. This does not
-- include any metadata. This procedure will be used only 
-- for viewing and editing of existing MultiTaskJobs.
PROCEDURE get_multi_task_job_info(p_job_name VARCHAR2,
                       p_job_owner VARCHAR2,
                       p_description_out OUT VARCHAR2,
                       p_job_type_out OUT VARCHAR2,
                       p_is_single_target OUT NUMBER,
                       p_is_library_out OUT NUMBER,
                       p_is_ca_out OUT NUMBER,
                       p_targets_out OUT SYS_REFCURSOR,
                       p_schedule_out OUT MGMT_JOB_SCHEDULE_RECORD,
                       p_notify_states_out OUT SYS_REFCURSOR,
                       p_access_list_out OUT SYS_REFCURSOR);

-- Get all information about a MultiTaskJob. This does not
-- include any metadata or data about the underlying jobtype. 
-- This procedure will be used only for viewing and editing 
-- of existing MultiTaskJobs.
PROCEDURE get_multi_task_job_info(p_job_id RAW,
                       p_job_name_out OUT VARCHAR2,
                       p_job_owner_out OUT VARCHAR2,
                       p_description_out OUT VARCHAR2,
                       p_job_type_out OUT VARCHAR2,
                       p_is_single_target OUT NUMBER,
                       p_is_library_out OUT NUMBER,
                       p_is_ca_out OUT NUMBER,
                       p_targets_out OUT SYS_REFCURSOR,
                       p_schedule_out OUT MGMT_JOB_SCHEDULE_RECORD,
                       p_notify_states_out OUT SYS_REFCURSOR,
                       p_access_list_out OUT SYS_REFCURSOR);

-- Get information about the jobtype underlying a MultiTaskJob.
PROCEDURE get_multi_task_job_type_info(p_job_id RAW,
                                       p_job_name VARCHAR2,
                                       p_job_owner VARCHAR2,
                                       p_job_type IN OUT VARCHAR2,
                                       p_job_type_info_out OUT SYS_REFCURSOR,
                                       p_job_type_execplan_out OUT SYS_REFCURSOR);

-- Get the target names and types for a nested job (task)
-- within a MultiTaskJob. This is used for single execution
-- MultiTaskJobs and the target names and types are found
-- in certain job level parameters.
PROCEDURE get_nested_job_targets(p_job_id RAW,
                                 p_job_name VARCHAR2,
                                 p_job_owner VARCHAR2,
                                 p_job_type VARCHAR2,
                                 p_nested_job_name VARCHAR2,
                                 p_target_names_out OUT MGMT_JOB_VECTOR_PARAMS,
                                 p_target_types_out OUT MGMT_JOB_VECTOR_PARAMS);

--
-- Clone a multitask job type and return the cloned job type
--
-- This is used when submitting a multitask job from the
-- library, as well as when copying a template-scoped
-- corrective action to a copy, and from the copy to a
-- target.
-- Note that this routine does not perform a complete clone
-- of a job type: for example, the securityInfo and lockInfo
-- sections are not currently copied. It only clones the
-- job type elements that we currently use for multitask jobs.
--
FUNCTION clone_multitask_job_type(p_job_id RAW) RETURN VARCHAR2;

-- This procedure creates the template copy scoped
-- CA using the template scoped CA
Procedure create_template_copy_ca
    (
    p_template_copy_guid IN RAW,
    p_template_guid      IN VARCHAR2,
    p_ca_name            IN VARCHAR2,
    p_ca_creds           IN MGMT_JOB_CRED_ARRAY DEFAULT NULL,
    p_job_id             OUT RAW
    );

-- This procedure creates the template copy scoped
-- CA using the template copy scoped CA
 
PROCEDURE create_temp_cp_ca_from_temp_cp
    (
    p_dest_template_copy_guid IN RAW,
    p_src_template_copy_guid  IN VARCHAR2,
    p_src_ca_name             IN VARCHAR2,
    p_dest_ca_name            IN VARCHAR2,
    p_ca_creds                IN MGMT_JOB_CRED_ARRAY DEFAULT NULL,
    p_job_id                  OUT RAW
    );

-- This procedure creates the template copy scoped
-- CA using the target scoped CA

PROCEDURE create_temp_cp_ca_from_target
    (
    p_template_copy_guid IN RAW,
    p_target_guid        IN VARCHAR2,
    p_ca_name            IN VARCHAR2,
    p_ca_creds           IN MGMT_JOB_CRED_ARRAY DEFAULT NULL,
    p_job_id             OUT RAW
    );

-- Creates a target scoped CA using the specified template-copy scoped CA
PROCEDURE create_target_ca_from_template
    (
    p_target_guid        IN RAW,
    p_ca_id              IN RAW,
    p_job_id_out         OUT RAW
    );

-- Creates a template-scoped CA given the specified target CA
PROCEDURE create_templ_ca_from_target_ca(p_template_name VARCHAR2,
                                         p_target_type VARCHAR2,
                                         p_source_ca_id IN RAW,
                                         p_ca_job_id_out OUT RAW);

PROCEDURE create_target_ca_from_default
    (
    p_target_type_guid   IN RAW,
    p_target_guid        IN RAW,
    p_source_ca_id       IN RAW,
    p_ca_job_id_out          OUT RAW
    );

-- This function returns the corrective action id
-- for corrective action name, and scope.
-- p_object_guid is the id of the target/template/copy
-- that this CA is associated with
FUNCTION get_ca_id(p_object_guid RAW, 
                   p_ca_name  IN VARCHAR2,
		   p_ca_scope IN NUMBER)
        RETURN RAW;

-- compares two corrective actions, specified by job_id, and returns true
-- if they are equivalent.
-- Single-task CAs are equivalent if their names, job-types, target-types,
-- descriptions and parameters are identical.
-- (We'd like to be able to test multitask CAs for equivalence, but that
-- requires comparing the job-type definitions as well, since each multitask
-- CA always has its own job-type, even if one is a clone of the other.  So
-- for 10Gr2, no two multitask CAs are equivalent.)
FUNCTION are_cas_equivalent(p_job_id_1 IN RAW, p_job_id_2 IN RAW) 
        RETURN BOOLEAN;


-- The two procedures below are used when deleting
-- rows from MGMT_JOB_TYPE_INFO to workaround the
-- mutating trigger error 
-- "Register" the job type row being deleted
PROCEDURE add_deleted_job_type(p_job_type VARCHAR2,
                               p_major_version NUMBER,
                               p_job_type_id RAW);

-- Update the max versions table as a result of 
-- various deletes
PROCEDURE update_max_versions;

-- Reschedule all scheduled executions when a new version of
-- the job type is created
PROCEDURE reschedule_on_new_jobtype_ver(p_new_job_type_id RAW);

-- For the given job type id, populate entries into the
-- MGMT_JOB_SINGLE_TARGET_TYPES table to indicate
-- all target types that support host credentials
PROCEDURE insert_host_cred_target_types(p_job_type_id RAW);

-- Update the job type definition with the appropriate default NLS
-- information. This provides backward compatibility for the old
-- NLS mechanism that used generated NLS IDs.
PROCEDURE update_job_type_nls_info(p_job_type_id RAW, p_job_type_name VARCHAR2);
-- Return the job schedule
FUNCTION get_current_schedule(p_job_id RAW)
         RETURN MGMT_JOB_SCHEDULE_RECORD;

-- Return the single-target guid for the specified job/target-list-index,
-- if the job is a single-target job
FUNCTION get_single_target_guid(p_job_id RAW,
                                p_target_list_index NUMBER,
                                p_active_out OUT NUMBER)
    RETURN RAW;

-- Register callback defined in job type
--
-- INPUT PARAMETERS
--
-- p_job_type_id Job Type ID
-- p_callback_type Callback type
-- p_callback_name Callback name
--
PROCEDURE add_job_callback(p_job_type_id IN RAW,
                           p_callback_type IN NUMBER,
                           p_callback_name IN VARCHAR2);

-- Make a copy of the large parameters in the job specified by
-- p_source_job_id to the job specified by p_job_id
PROCEDURE copy_large_params(p_job_id IN RAW, p_source_job_id IN RAW);

--------- The following are callbacks from the credentials --------
--------- subsystem when credentials are changed, and -----------
--------- implement broken creds functionality ----------------

-- Process all applicable suspended/creds executions when target
-- credentials are set at the target, host or enterprise level
PROCEDURE target_creds_added(p_target_guid RAW,
                             p_host_guid RAW,
                             p_credential_set_name VARCHAR2,
                             p_target_type VARCHAR2,
                             p_user_name VARCHAR2);

-- Process all applicable suspended/creds executions when container
-- credentials are set
PROCEDURE container_creds_added(p_target_guid RAW,
                                p_container_location VARCHAR2,
                                p_credential_set_name VARCHAR2,
                                p_target_type VARCHAR2,
                                p_user_name VARCHAR2);

-- Process all applicable suspended/creds executions when overridden 
-- creds are set
PROCEDURE override_creds_added(p_job_id RAW,
                               p_creds MGMT_JOB_CRED_ARRAY);

-- Resume all suspended credential executions that do not
-- have any waiting rows
PROCEDURE resume_cred_execs;

-- Suspend all scheduled credential executions are blocked on
-- at least one non-available credential set
PROCEDURE suspend_cred_execs;

-- Process any applicable executions when target credentials
-- are deleted
PROCEDURE target_creds_deleted(p_target_guid RAW,
                               p_host_guid RAW,
                               p_credential_set_name VARCHAR2,
                               p_target_type VARCHAR2,
                               p_user_name VARCHAR2);

-- Process any applicable executions when container credentials
-- are deleted
PROCEDURE container_creds_deleted(p_target_guid RAW,
                                  p_container_location VARCHAR2,
                                  p_credential_set_name VARCHAR2,
                                  p_target_type VARCHAR2,
                                  p_user_name VARCHAR2);

-- Process executions, if any, when job credentials are deleted
PROCEDURE override_creds_deleted(p_job_id RAW,
                                 p_target_guid RAW,
                                 p_container_location VARCHAR2,
                                 p_credential_set_name VARCHAR2,
                                 p_target_type VARCHAR2);

-- Re-execute all submission/execution time credential sources. 
-- Called when 
-- an execution was suspended on missing credentials at submission
-- OR
-- to look up execution time parameter sources at submission time
--   for credential purposes
-- If p_insert_creds is 0, then the credential sources are evaluated,
-- but do not actually insert parameters. They are used to suspend
-- the execution
FUNCTION compute_cred_info(p_job_id RAW, 
                           p_execution_id RAW,
                           p_task_name VARCHAR2,
                           p_at_submit NUMBER,
                           p_insert_creds NUMBER) RETURN NUMBER;

------------------ END broken creds functionality ---------------------

-- Callback for group membership changes
PROCEDURE group_change_callback(p_assoc_def_name VARCHAR2,
                                p_source_target_name VARCHAR2,
                                p_source_target_type VARCHAR2,
                                p_assoc_target_name  VARCHAR2,
                                p_assoc_target_type  VARCHAR2,
                                p_scope_target_name  VARCHAR2,
                                p_scope_target_type  VARCHAR2);

--Insert targets at job level for a single execution multi-task target CA
--
--INPUT PARAMETERS
--
-- p_job_name name of the job in which targets need to be inserted
-- p_target name of target for which target CA is set up
-- p_target_type type of target for which target CA is set up
-- p_job_targets list of targets to insert
-- p_create boolean to indicate if it is a create operation or edit operation
PROCEDURE insert_single_exec_ca_targets(p_job_name VARCHAR2,
                                        p_target VARCHAR2,
                                        p_target_type VARCHAR2,
                                        p_job_targets MGMT_JOB_TARGET_LIST,
                                        p_create NUMBER);

PROCEDURE compute_mtjob_cred_info(p_job_id RAW, p_execution_id RAW,
                                  p_job_type_id RAW);                                        
                                        

-- for a particular job-type, add to the eligible target-types list any
-- cluster target-types whose members are already eligible
--
--INPUT PARAMETERS
--
-- p_job_type_id Job Type ID
PROCEDURE insert_cluster_target_types(p_job_type_id IN RAW);

FUNCTION get_step_trust(p_step_id NUMBER) RETURN NUMBER;

/**
 * Decrease the reference count for large parameter values. Called when a
 * reference to a large param with id p_old_id is removed or changed to p_new_id.
 * If the reference count is zero after decrement, the row is also removed.
 */
PROCEDURE decr_large_param_ref_count(p_old_id RAW,
                                     p_new_id RAW DEFAULT NULL);

END MGMT_JOB_ENGINE;
/

show errors;

