Rem drv: <create type="post_creation" pos="ip/dashboard_service/dashboard_service_outofbox_reports.sql-"/>
Rem
Rem $Header: jobs_post_creation.sql 01-jun-2007.00:45:21 ashugupt Exp $
Rem
Rem jobs_post_creation.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      jobs_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ashugupt    05/24/07 - constants for email notifications
Rem    ashugupt    06/01/07 - Backport ashugupt_bug-5220168 from main
Rem    lsatyapr    10/12/06 - Bug 5597503 - Add mgmt_job_exec_summary to
Rem                           delete_target exception
Rem    lsatyapr    10/24/06 - Backport lsatyapr_bug-5597503 from main
Rem    skini       07/11/05 - Add 102020 jobs_init 
Rem    scgrover    07/07/05 - add extended sql trace 
Rem    dsahrawa    07/05/05 - bug 4148622, command block rewrite 
Rem    gsbhatia    07/03/05 - New repmgr header impl 
Rem    rpinnama    05/12/05 - Call v102010/jobs_init to perform v102010 
Rem                           initialization 
Rem    dsahrawa    04/20/05 - use trt_pre_delete callback instead of post 
Rem                           delete cb 
Rem    pkantawa    04/06/05 - Add callback to check if jobs can be reassigned 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    kmanicka    09/21/04 - add user model callbacks for jobs and ca
Rem    skini       09/14/04 - Register sdk callback 
Rem    skini       08/18/04 - Target deletion 
Rem    aholser     02/05/04 - remove jobStepCount 
Rem    skini       12/07/03 - Add purge policy 
Rem    skini       06/27/03 - Logging for jobs
Rem    rpinnama    03/17/03 - Move dbms_job submission to job_dbms_jobs file
Rem    rpinnama    10/15/02 - Fix register_logging_module API
Rem    rpinnama    10/14/02 - Use log registration API
Rem    skini       08/27/02 - Implement event-based suspends
Rem    skini       07/03/02 - Move login assistant code to user_model
Rem    aholser     06/04/02 - change jobname for sql performance.
Rem    aholser     05/31/02 - add display name
Rem    rpinnama    05/16/02 - submit dbms_job to purge job entries.
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Created
Rem


--
-- Insert the module name for performance and error logging and initialize
-- the jobstep counter used by job dispatcher
-- 
BEGIN
  mgmt_log.register_logging_module (MGMT_JOB_ENGINE.JOB_DISPATCHER_NAME,
				    'Job Dispatcher');

  mgmt_log.register_logging_module ('JOB_PURGE',
				    'Job Purge',
				    'MGMT_JOB_ENGINE.apply_purge_policies()');

  mgmt_log.register_logging_module(MGMT_JOB_ENGINE.MODULE_NAME, 
                                              'Jobs');

  COMMIT;
END;
/

-- Insert pre-defined events
BEGIN
    MGMT_JOBS.add_event('bounceAgent', 
                        'MGMT_JOB_ENGINE.bounce_agent_callback');
END;
/
COMMIT;

-- Insert default purge policy of 30 days
BEGIN
    MGMT_JOBS.register_purge_policy('SYSPURGE_POLICY', 30, null);
END;
/
COMMIT;

-- Perform v102010 job initialization
@@&&EM_SQL_ROOT/core/v102010/jobs/jobs_init.sql
@@&&EM_SQL_ROOT/core/v102020/jobs/jobs_data_upgrade.sql
-- Insert the maximum allowed while iterations
INSERT INTO MGMT_PARAMETERS
       (parameter_name, parameter_value, parameter_comment, internal_flag)
VALUES ('EM_JOB_OUTPUT_MAX_LINES', '2000', 'Max lines of step output in the job notifications', 0); 
COMMIT; 

DECLARE
dummy INTEGER;
BEGIN
    SELECT count(1) INTO dummy
    FROM MGMT_TARGET_DELETE_EXCEPTIONS
    WHERE table_name='MGMT_JOB_EXEC_SUMMARY';
    IF dummy = 0 THEN
        INSERT INTO MGMT_TARGET_DELETE_EXCEPTIONS (table_name)
        VALUES ('MGMT_JOB_EXEC_SUMMARY');
        COMMIT;
    END IF;
END;
/

