Rem drv: <create type="types" pos="ecm/ecm_types.sql+"/>
Rem
Rem $Header: jobs_types.sql 24-may-2007.04:13:02 kmanicka Exp $
Rem
Rem jobs_types.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      jobs_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    kmanicka    07/10/06 - add trusted to MGMT_JOB_STEP_RECORD
Rem    kmanicka    07/10/06 - bug 5365979 add job_params to MGMT_JOB_STEP_RECORD
Rem    kmanicka    09/04/06 - Backport kmanicka_bug-5365979 from main
Rem    pkantawa    09/08/05 - Fix 4582672: Fix MGMT_PARAM_CRED_TGT_MET 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    nqureshi    06/21/05 - adding support for online help topic for 
Rem                           multitask job 
Rem    nqureshi    06/14/05 - adding new Types for Target props validation 
Rem    ashugupt    05/15/05 - Fix 4338761 
Rem    jvishen     05/19/05 - change broken CA job ID 
Rem    jvishen     04/12/05 - edit Multitask broken CA 
Rem    jvishen     03/28/05 - update mgmt_target_fixca_record 
Rem    pkantawa    03/22/05 - Fix 4148623: Remove old unused types 
Rem    jvishen     03/20/05 - update for broken ca links 
Rem    dsahrawa    02/24/05 - add mgmt_job_guid_list 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    nqureshi    02/01/05 - adding new type to hold job Notification info 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    nqureshi    01/06/05 - modying show_target_property 
Rem    nqureshi    12/22/04 - modfying MGMT_JOB_PRMTER_URI_INF_RECORD
Rem    jvishen     12/23/04 - change CA severity reasons from Strings to 
Rem                           Number 
Rem    pkantawa    12/13/04 - Return target name instead of display name 
Rem    jaysmith    11/18/04 - populate broken CA reason 
Rem    jvishen     10/29/04 - Object for target with broken credentials 
Rem                           Changed 
Rem    dsahrawa    10/01/04 - impl start grace periods 
Rem    pkantawa    10/14/04 - Add job type category to JobRunObjType 
Rem    pkantawa    10/08/04 - grabtrans 'ashugupt_edit_multi_task_page' 
Rem    pkantawa    10/07/04 - add types for target records used to get 
Rem                           timezones 
Rem    ashugupt    10/05/04 - added new types for fetching task metadata 
Rem    jvishen     09/28/04 - 
Rem    jvishen     09/21/04 - 
Rem    ashugupt    08/20/04 - adding guid to mgmt_credential_source_record 
Rem    nqureshi    08/07/04 - added new job types for data driven Parameters 
Rem                           page 
Rem    pkantawa    08/09/04 - grabtrans 'nqureshi_naim_parameter_2' 
Rem    ashugupt    08/03/04 - new sql types added for credential page 
Rem    dcawley     07/07/04 - Increase user name size 
Rem    ashugupt    07/07/04 - job system credential page changes 
Rem    dsahrawa    06/10/04 - skipped executions implementation 
Rem    jberesni    10/28/03 - JobRunObjType.scheduled_date=>scheduled_time
Rem    tzimmerm    10/24/03 - Replacing job ui PL/SQL 
Rem    tzimmerm    09/24/03 - Fix group links - rem exec submitted to 
Rem    tzimmerm    09/12/03 - Add execution row and table types 
Rem    skini       09/09/03 - Add timezone_region to schedule record 
Rem    tzimmerm    08/26/03 - Add exec_id to API for run links 
Rem    tzimmerm    08/21/03 - Modify job run API for Run Details links 
Rem    tzimmerm    08/19/03 - Add job run tmp table type defs 
Rem    skini       06/11/03 - Large parameter support
Rem    skini       04/15/03 - New type for paramsource
Rem    skini       02/21/03 - Change in param size to 4000
Rem    skini       09/17/02 - Add job lock record
Rem    rpinnama    09/18/02 - Make all types create or replace
Rem    skini       07/12/02 - Change in target_name column size
Rem    skini       06/14/02 - continue implementing blackouts
Rem    skini       06/12/02 - 
Rem    skini       06/07/02 - Changes to support TIMEZONE_SPECIFIED
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/14/02 - Created
Rem

-- The type that represents values of a vector parameter
CREATE OR REPLACE TYPE MGMT_JOB_VECTOR_PARAMS AS VARRAY(5000) OF varchar2(2000);
/

-- The type that represents an array of integers
CREATE OR REPLACE TYPE MGMT_JOB_INT_ARRAY AS VARRAY(5000) OF INTEGER;
/

CREATE OR REPLACE TYPE MGMT_JOB_TARGET_RECORD AS OBJECT
(
    target_name VARCHAR2(256), 
    target_type VARCHAR2(64)
); 
/

CREATE OR REPLACE TYPE MGMT_JOB_PARAM_RECORD AS OBJECT
( 
    param_name VARCHAR2(64),
    param_type NUMBER(1),
    scalar_value VARCHAR2(4000),
    vector_value MGMT_JOB_VECTOR_PARAMS
); 
/

CREATE OR REPLACE TYPE MGMT_JOB_TARGET_LIST AS TABLE 
       OF MGMT_JOB_TARGET_RECORD;
/

CREATE OR REPLACE TYPE MGMT_JOB_PARAM_LIST AS TABLE 
       OF MGMT_JOB_PARAM_RECORD;
/

CREATE OR REPLACE TYPE MGMT_JOB_STEP_RECORD AS OBJECT (
    job_id RAW(16),
    execution_id RAW(16),
    step_name VARCHAR2(64),
    step_type NUMBER(2),
    first_step NUMBER(1),
    command_name VARCHAR2(32),
    command_type NUMBER(1),
    command_class VARCHAR2(512),
    step_id INTEGER,
    iterate_param VARCHAR2(64),
    iterate_param_index NUMBER(6),
    step_params MGMT_JOB_PARAM_LIST,
    agent_bound INTEGER,
    job_params MGMT_JOB_PARAM_LIST,
    trusted INTEGER
);
/

CREATE OR REPLACE TYPE MGMT_JOB_STEP_LIST AS TABLE 
       OF MGMT_JOB_STEP_RECORD;
/

CREATE OR REPLACE TYPE MGMT_JOB_STEP_STATUS AS OBJECT (
    step_id INTEGER,
    status INTEGER
);
/

CREATE OR REPLACE TYPE MGMT_JOB_TARGET_LIST_ARRAY AS TABLE OF MGMT_JOB_TARGET_LIST;
/

CREATE OR REPLACE TYPE MGMT_JOB_TARGET_TYPE AS OBJECT (
    target_guid RAW(16)
);
/

CREATE OR REPLACE TYPE MGMT_JOB_GUID_LIST AS TABLE OF MGMT_JOB_TARGET_TYPE;
/

CREATE OR REPLACE TYPE MGMT_JOB_GUID_ARRAY AS TABLE OF RAW(16);
/

CREATE OR REPLACE TYPE MGMT_JOB_SCHEDULE_RECORD AS OBJECT 
(
    -- The frequency code for the schedule.
    frequency_code NUMBER,
    
    -- The schedule start time. Use SYSDATE if the job is to start 
    -- immediately. For daily, days of week and days of month schedules, 
    -- the start_time denotes when the job should start. Only the time part 
    -- is used, and the date part is ignored. 
    start_time DATE,

    -- For all periodic schedules, the last date (and time) to run the job. 
    -- For daily, day of week and day of month schedules, only the date 
    -- portion is used. For interval schedules, the time is taken into 
    -- account as well.
    end_time DATE,

    -- The grace period for starting the job specified in minutes. 
    -- If the job does not start between start_time and 
    -- start_time + start_grace_period it is skipped. The default of -1
    -- indicates an infinite grace period.
    start_grace_period NUMBER,

    -- The "execution time" for daily, day of week/month/year schedules. 
    -- Indicates the time of the day at which the job will execute. Hours 
    -- are specified in 24-hour format (0 to 23), and minutes is a number 
    -- between 0 and 59. 
    execution_hours NUMBER,
    execution_minutes NUMBER,

    -- The interval, in minutes for interval jobs.
    interval NUMBER,

    -- For days-of-year schedules, this indicates the "month" portion of each
    -- (month, day) pair in the schedule. The "days" portion is specified
    -- using "days", below.
    months MGMT_JOB_INT_ARRAY,

    -- For day of week/month jobs, the day(s) of the week,
    -- or month as the case may be.
    -- For days of week, this is a set of numbers from 1-7 indicating the days
    --    sunday through saturday, in that order.
    -- For days of month, this is a set of numbers from 1-31 indicating the 
    --    date of the month. A special constant called LAST_DAY (-1) 
    --    can be use for day-of-month schedules to indicate the last 
    --    day of the month.
    -- For days of the year, this is a set of numbers from 1-32 
    --    indicating the date of the month. A special constant called 
    --    LAST_DAY (-1) can be used for day-of-year schedules to indicate 
    --    the last day of the month. For day-of-year schedules, the 
    --    corresponding months are taken from the "months" field above 
    days MGMT_JOB_INT_ARRAY,

    -- Specifies which timezone the start and end times are specified in
    --    TIMEZONE_REPOSITORY: The timezone of the repository
    --    TIMEZONE_TARGET: The timezone of one of the targets in the 
    --        target list, whose index in the target list is specified 
    --        by timezone_target_index 
    --    TIMEZONE_SPECIFIED: The timezone offset is specified in the
    --       field timezone_offset
    timezone_info NUMBER,

    -- The index of the target in the target list(s) whose timezone the 
    -- times are specified in; only relevant when 
    -- timezone_info=TIMEZONE_TARGET
    timezone_target_index NUMBER,

    -- The actual timezone offset. Relevent only when
    -- timezone_info=TIMEZONE_SPECIFIED
    timezone_offset NUMBER,

    -- The actual timezone region. Relevent only when
    -- timezone_info=TIMEZONE_RGN_SPECIFIED
    timezone_region VARCHAR2(64)    
);
/

-- This object serves as one criterion in a purge policy
CREATE OR REPLACE TYPE MGMT_JOB_PURGE_CRITERION AS OBJECT (
    -- The criterion type. This could be CRITERION_TARGET, CRITERION_USER,
    -- CRITERION_JOBTYPE or CRITERION_JOBNAME
    criterion_type NUMBER,

    -- Set to true(1) if the sense of the condition is to be negated.
    -- For example, when used with targets, indicates purging of all
    -- jobs that do not contain the specified target(s).
    negated NUMBER,

    -- The possible values the criterion could take. For CRITERION_USER, 
    -- CRITERION_JOBTYPE and CRITERION_JOBNAME, the values are in the 
    -- criterion_values array. For CRITERION_TARGET, the target names are 
    -- in the criterion_values array, and the target types are in the 
    -- addl_criterion_values array. 
    criterion_values MGMT_JOB_VECTOR_PARAMS,
    addl_criterion_values MGMT_JOB_VECTOR_PARAMS
);
/
show errors;

CREATE OR REPLACE TYPE MGMT_JOB_PURGE_CRITERION_LIST AS TABLE OF 
       MGMT_JOB_PURGE_CRITERION;
/
show errors;


-- Internally used types
CREATE OR REPLACE TYPE MGMT_JOB_TARGET_WITH_INDEX AS OBJECT (
    target_name varchar2(256),
    target_type varchar2(64),
    container_path varchar2(4000),
    target_index NUMBER
);
/
CREATE OR REPLACE TYPE MGMT_JOB_TARGET_INDEX_LIST AS 
    TABLE OF MGMT_JOB_TARGET_WITH_INDEX;
/

CREATE OR REPLACE TYPE MGMT_JOB_LOCK_RECORD AS OBJECT (
   lock_guid RAW(16),
   lock_name VARCHAR2(32),
   lock_type NUMBER,
   lock_mode NUMBER,
   target_name VARCHAR2(256),
   target_type VARCHAR2(64),
   target_guid RAW(16)
);
/

CREATE OR REPLACE TYPE MGMT_JOB_LOCK_ARRAY AS TABLE OF MGMT_JOB_LOCK_RECORD;
/

CREATE OR REPLACE TYPE MGMT_JOB_PARAMSRC_RECORD AS OBJECT (
    source_id RAW(16),
    source_type VARCHAR2(32),
    source_data VARCHAR2(4000),
    override_user NUMBER(1),
    required NUMBER(1),
    encrypted NUMBER(1),
    parameter_names MGMT_JOB_VECTOR_PARAMS

);
/

CREATE OR REPLACE TYPE MGMT_JOB_PARAMSRC_ARRAY AS TABLE OF MGMT_JOB_PARAMSRC_RECORD;
/

-- -----------------------------------------------------------------------------
--  Job Run type definitions
-- -----------------------------------------------------------------------------
create or replace TYPE JobRunObjType as OBJECT
   (job_id              RAW(16)
   ,job_name            VARCHAR2(64)
   ,job_owner           VARCHAR2(256)
   ,job_type            VARCHAR2(32)
   ,scheduled_time      DATE
   ,frequency_code      NUMBER(2)
   ,timezone_region     VARCHAR2(64)
   ,timezone_info       NUMBER(2)
   ,target_name         VARCHAR2(256)
   ,target_type         VARCHAR2(64)
   ,type_display_name   VARCHAR2(128)
   ,target_count        NUMBER(5)
   ,status_bucket       NUMBER(2)
   ,status_bucket_count NUMBER(5)
   ,sample_exec_id      RAW(16)
   ,job_type_category   NUMBER(1)
   );
/

create or replace TYPE JobRunObjTbl as TABLE of JobRunObjType;
/

-- -----------------------------------------------------------------------------
--  job credentials metadata definitions
-- -----------------------------------------------------------------------------

REM Represents an record of credential column values
CREATE OR REPLACE TYPE MGMT_JOB_CRED_COL_VAL_RECORD AS OBJECT(
    col_value VARCHAR2(64),
    col_value_nlsid VARCHAR(64)
);
/

REM Represents an array of credential column values
CREATE OR REPLACE TYPE MGMT_JOB_CRED_COL_VAL_ARRAY AS 
    TABLE OF MGMT_JOB_CRED_COL_VAL_RECORD;
/

REM Represents a credentials type column
CREATE OR REPLACE TYPE MGMT_JOB_CRED_TYPE_COL_RECORD AS OBJECT (
    type_column_name VARCHAR2(64),
    type_column_display_name VARCHAR2(64),
    base_type_column_name VARCHAR2(64),
    type_column_nlsid VARCHAR2(64),
    type_column_value VARCHAR2(4000),
    default_value_index NUMBER(6),
    current_value_index NUMBER(6),
    key NUMBER(1),
    allowable_values MGMT_JOB_CRED_COL_VAL_ARRAY
);
/

REM Represents a credential set columns
CREATE OR REPLACE TYPE MGMT_JOB_CRED_SET_COL_RECORD AS OBJECT (
    set_column_name VARCHAR2(64),
    set_column_display_name VARCHAR2(64),
    type_column_name VARCHAR2(64),
    default_value_index NUMBER(6),
    current_value_index NUMBER(6),    
    allowable_values MGMT_JOB_CRED_COL_VAL_ARRAY
);
/

REM Represents an array of credential type columns
CREATE OR REPLACE TYPE MGMT_JOB_CRED_TYPE_COL_ARRAY AS 
    TABLE OF MGMT_JOB_CRED_TYPE_COL_RECORD;
/

REM Represents an array of credential set columns
CREATE OR REPLACE TYPE MGMT_JOB_CRED_SET_COL_ARRAY AS 
    TABLE OF MGMT_JOB_CRED_SET_COL_RECORD;
/

REM Represents a credential type record
CREATE OR REPLACE TYPE MGMT_JOB_CRED_TYPE_RECORD AS OBJECT (
    type_name VARCHAR2(64),
    type_display_name VARCHAR2(64),
    type_nlsid VARCHAR2(64),
    target_type VARCHAR2(64),
    target_type_meta_ver VARCHAR2(64),
    cred_type_cols MGMT_JOB_CRED_TYPE_COL_ARRAY

);
/

REM Represents a credential set record
CREATE OR REPLACE TYPE MGMT_JOB_CRED_SET_RECORD AS OBJECT (
    set_name VARCHAR2(64),
    set_display_name VARCHAR2(64),
    set_nlsid VARCHAR2(64),
    target_type VARCHAR2(64),
    target_type_meta_ver VARCHAR2(64),
    cred_set_cols MGMT_JOB_CRED_SET_COL_ARRAY

);
/

REM Represents an array of credential set
CREATE OR REPLACE TYPE MGMT_JOB_CRED_SET_ARRAY AS 
    TABLE OF MGMT_JOB_CRED_SET_RECORD;
/

REM Represents a credentials source
CREATE OR REPLACE TYPE MGMT_JOB_CRED_SOURCE_RECORD AS OBJECT (
    cred_set_name_var VARCHAR2(64),
    cred_set_target_type_var VARCHAR2(64),
    b_name_var NUMBER(1),
    b_target_type_var NUMBER(1),
    base_cred_type MGMT_JOB_CRED_TYPE_RECORD,
    derived_cred_type MGMT_JOB_CRED_TYPE_RECORD,
    base_cred_type_columns MGMT_JOB_VECTOR_PARAMS, 
    cred_set MGMT_JOB_CRED_SET_ARRAY,
    cred_column_param VARCHAR2(64),
    job_cred_set_name VARCHAR2(64),
    guid VARCHAR2(64)
);
/

REM Represents an array of credential source
CREATE OR REPLACE TYPE MGMT_JOB_CRED_SOURCE_ARRAY AS 
    TABLE OF MGMT_JOB_CRED_SOURCE_RECORD;
/

REM Represents a job credential
CREATE OR REPLACE TYPE MGMT_JOB_CREDENTIAL_RECORD AS OBJECT (
    cred_source MGMT_JOB_CRED_SOURCE_ARRAY,
    is_preferred NUMBER(1)
);
/

-- -----------------------------------------------------------------------------
--  SQL types for job credentials validation
--  These types are used by jobs ui package
-- -----------------------------------------------------------------------------

REM Represents one credential set data for a job task. The target type
REM here represents target type for the entire job.
REM The target type in MGMT_JOB_TARGET_RECORD object represents the target type 
REM of group or cluster if job is submitted for a whole group otherwise its same as
REM job type of entire job.
CREATE OR REPLACE TYPE MGMT_JOB_TGT_CRED_SET_RECORD AS OBJECT (
    cred_set_name VARCHAR2(64),
    target_type VARCHAR2(64),
    target_list MGMT_JOB_TARGET_LIST,
    task_name VARCHAR2(64),
    cred_set_nlsid VARCHAR2(64),
    cred_set_disp_name VARCHAR2(64)
);
/

REM Represents an array of job target credential set. Each job task may be associated
REM to multiple credential sets and this object holds the cred set data for each job task.
CREATE OR REPLACE TYPE MGMT_JOB_TGT_CRED_SET_ARRAY AS 
    TABLE OF MGMT_JOB_TGT_CRED_SET_RECORD;
/

REM Represents an array of job task credential set, each of which represents
REM credential set data for the task.
CREATE OR REPLACE TYPE MGMT_JOB_TASK_CRED_SET_ARRAY AS 
    TABLE OF MGMT_JOB_TGT_CRED_SET_ARRAY;
/



REM Represents a parameter DropDown values record added by nqureshi 
CREATE OR REPLACE TYPE MGMT_JOB_PRMETER_DRPDN_RECORD AS OBJECT (
    is_default NUMBER(1),
    value varchar2(32),
    option_text_nlsid VARCHAR2(32),    
    option_text_default VARCHAR2(256),
    param_order number(3)
);
/

REM Represents an array of One parameters DROPDOWN VALUES set
CREATE OR REPLACE TYPE MGMT_JOB_PRMETER_DRPDN_ARRAY AS 
    TABLE OF MGMT_JOB_PRMETER_DRPDN_RECORD;
/    
    
REM represent one row of parameters
    CREATE OR REPLACE TYPE MGMT_JOB_PARAMETER_RECORD AS OBJECT (
    job_type   VARCHAR2(32),    
    parameter_name VARCHAR2(64),
    show_in_create NUMBER(1),    
    show_in_results NUMBER(1),    
    label_nlsid VARCHAR2(32),    
    label_default VARCHAR2(256),    
    hint_nlsid VARCHAR2(32),    
    hint_default VARCHAR2(256),    
    display_mode NUMBER(2),    
    num_lines NUMBER(2),    
    default_text VARCHAR2(4000),    
    default_nlsid VARCHAR2(32),
    param_order number(3),
    ARRAY_PARAMETER_DROPDOWN MGMT_JOB_PRMETER_DRPDN_ARRAY,
    parameter_required number(1),
    parameter_encrypted number(1)
    );
/

    REM Represents an array of ALL PARAMETERS set
    CREATE OR REPLACE TYPE MGMT_JOB_PARAMETER_ARRAY AS 
        TABLE OF MGMT_JOB_PARAMETER_RECORD;
/


rem this will Hold the onr row  the MGMT_JOB_PARAMETER_URI_INFO
CREATE OR REPLACE TYPE MGMT_JOB_PRMTER_URI_INF_RECORD AS OBJECT (
    job_type   VARCHAR2(32),    
    uri        VARCHAR2(4000),    
    class      VARCHAR2(4000),    
    online_help_topic VARCHAR2(2000),
    online_task_help_topic VARCHAR2(2000),
    show_target_properties NUMBER(1)
);
/

rem this will Hold the one row  the MGMT_JOB_TYPE_URI_INFO
CREATE OR REPLACE TYPE MGMT_JOB_TYPE_URI_INFO_RECORD AS OBJECT  (    
job_type   VARCHAR2(32),    
uri_use    NUMBER(2),    
uri        VARCHAR2(4000),    
is_jsp     NUMBER(1),    
class      VARCHAR2(4000)
);
/


REM Represents an array of One parameters DROPDOWN VALUES set
CREATE OR REPLACE TYPE MGMT_JOB_TYPE_URI_INFO_ARRAY AS 
    TABLE OF MGMT_JOB_TYPE_URI_INFO_RECORD;
/

REM to hold the ONE ROW OF THE TARGET_PROPERTY
CREATE OR REPLACE TYPE MGMT_TARGET_TYPE_PROP_RECORD AS OBJECT  (    
property_name   VARCHAR2(32),    
property_display_name    VARCHAR2(255),    
property_display_nls_id    VARCHAR2(255)
);
/

REM Represents an array of One TARGET PROPERTY VALUES 
CREATE OR REPLACE TYPE MGMT_TARGET_TYPE_PROP_ARRAY AS 
    TABLE OF MGMT_TARGET_TYPE_PROP_RECORD;
/

REM The Super Type that will contain all the sub types 
create or replace type MGMT_JOB_PARAMETER_METADATA as Object 
(
    uri_info_metaData   MGMT_JOB_TYPE_URI_INFO_ARRAY ,
    parameter_uri_info_metaData  MGMT_JOB_PRMTER_URI_INF_RECORD ,
    parameter_metaData MGMT_JOB_PARAMETER_ARRAY
);
/
REM to hold the one row of the broken credential of a target
create or replace TYPE MGMT_TARGET_FIXCA_RECORD as object (
    target_name        VARCHAR2(256),
    target_type        VARCHAR2(64),
    policy_name_display VARCHAR2(128),
    column_label       VARCHAR2(64),
    column_label_nlsid VARCHAR2(64), 
    severity           NUMBER(2),
    ca                 VARCHAR2(64),
    current_owner      VARCHAR2(256),
    job_id             RAW(16),
    metric_key_value   VARCHAR2(1300),
    broken_reason      NUMBER(2),
    policy_type        NUMBER(2),
    job_type           VARCHAR2(32)
);
/
REM Represents an array of broken credentials of targets
CREATE OR REPLACE TYPE MGMT_TARGET_FIXCA_ARRAY AS
    TABLE OF MGMT_TARGET_FIXCA_RECORD;
/
 
REM holds the metadata info for a combination of job type and target type
CREATE OR REPLACE TYPE MGMT_PARAM_CRED_TGT_MET AS OBJECT
(
    job_type VARCHAR2(32),
    target_type VARCHAR2(64),
    parameter_metadata MGMT_JOB_PARAMETER_METADATA ,
    credential_metadata MGMT_JOB_CREDENTIAL_RECORD ,
    target_properties MGMT_TARGET_TYPE_PROP_ARRAY ,
    required_params SMP_EMD_STRING_ARRAY ,
    targets_required NUMBER(1)
);
/

REM Represents array of MGMT_PARAM_CRED_TGT_MET
CREATE OR REPLACE TYPE MGMT_PARAM_CRED_TGT_MET_ARR AS 
    TABLE OF MGMT_PARAM_CRED_TGT_MET;
/

-- -----------------------------------------------------------------------------
--  SQL types for fetching timezones of all targets of all tasks in a multi
--  task job
--  These types are used by jobs ui package
-- -----------------------------------------------------------------------------

REM Represents one set of target list for a task. The target type
REM here represents target type of the task.
CREATE OR REPLACE TYPE MGMT_JOB_TASK_TGT_RECORD AS OBJECT (
    target_list MGMT_JOB_TARGET_LIST,
    target_type VARCHAR2(64)
);
/

REM Represents an array of MGMT_JOB_TASK_TGT_RECORD - one for each task
CREATE OR REPLACE TYPE MGMT_JOB_TASK_TGT_ARRAY AS 
    TABLE OF MGMT_JOB_TASK_TGT_RECORD;
/


-- Internally used types
CREATE OR REPLACE TYPE MGMT_JOB_NOTIF_EMAIL_SCH_INFO AS OBJECT (
     email_address_count  NUMBER(3),
     schedule_count NUMBER(3),
     job_notify_status MGMT_INTEGER_ARRAY 
     );
/

CREATE OR REPLACE TYPE MGMT_JOB_SHORT_STR_ARR_TABLE AS TABLE OF MGMT_SHORT_STRING_ARRAY ;
/
CREATE OR REPLACE TYPE MGMT_JOB_TARGET_LIST_TABLE AS TABLE OF MGMT_JOB_TARGET_LIST ;
/

CREATE OR REPLACE TYPE MGMT_JOB_DNAME_TYPE_PROP_REC AS OBJECT
(
 target_display_name VARCHAR2(256),
 target_name VARCHAR2(64),
 target_type VARCHAR2(64),
 propName VARCHAR2(64)

);
/

CREATE OR REPLACE TYPE MGMT_JOB_DNAME_TYPE_PROP_TABLE AS TABLE OF  MGMT_JOB_DNAME_TYPE_PROP_REC;
/

show errors;



