Rem
Rem $Header: jobs_ui_execs_pkgdef.sql 11-jan-2005.17:10:45 pkantawa Exp $
Rem
Rem jobs_ui_execs_pkgdef.sql
Rem
Rem Copyright (c) 2003, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      jobs_ui_execs_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pkantawa    01/11/05 - Change executions queries 
Rem    pkantawa    12/13/04 - Return target name instead of display name 
Rem    rdabbott    01/30/04 - Fix 3256113: create 'active' bucket 
Rem    rdabbott    11/15/03 - hide runs_in_exec until used 
Rem    rdabbott    11/12/03 - fix 3241333: run details filters 
Rem    tzimmerm    10/27/03 - tzimmerm_bug-3209032 
Rem    tzimmerm    10/27/03 - 
Rem    tzimmerm    10/27/03 - 
Rem    tzimmerm    10/27/03 - 
Rem    tzimmerm    10/27/03 - Created
Rem
create or replace package MGMT_JOB_UI_EXECS
as
--------------------------------------
-- Implements an API for the job executions page UI:
-- filter criteria are passed in and strong 
-- ref cursor is returned

-- todo: delete these
TRUE_FLAG   CONSTANT integer := 1;
FALSE_FLAG  CONSTANT integer := 0;

CATEGORY_TARGETS            CONSTANT integer := MGMT_JOB_UI_RUNS.CATEGORY_TARGETS;
CATEGORY_GROUPS             CONSTANT integer := MGMT_JOB_UI_RUNS.CATEGORY_GROUPS;
CATEGORY_TARGETS_IN_GROUP   CONSTANT integer := MGMT_JOB_UI_RUNS.CATEGORY_TARGETS_IN_GROUP;
CATEGORY_SYS_TARGETLESS     CONSTANT integer := MGMT_JOB_UI_RUNS.CATEGORY_SYS_TARGETLESS;

TIMEFRAME_ALL   constant NUMBER(6) := MGMT_JOB_UI_RUNS.TIMEFRAME_ALL;


-- basic record and cursor types for the UI
-- 
TYPE jobexec_rowtype IS RECORD
        (job_id            MGMT_JOB.job_id%TYPE
        ,execution_id      MGMT_JOB_EXEC_SUMMARY.execution_id%TYPE
        ,job_name          MGMT_JOB.job_name%TYPE
        ,job_owner         MGMT_JOB.job_owner%TYPE
        ,job_type          MGMT_JOB.job_type%TYPE
        ,scheduled_start   MGMT_JOB_EXEC_SUMMARY.scheduled_time%TYPE
        ,frequency_code    MGMT_JOB_SCHEDULE.frequency_code%TYPE
        ,timezone_info     MGMT_JOB_SCHEDULE.timezone_info%TYPE
        ,timezone_region   MGMT_JOB_SCHEDULE.timezone_region%TYPE
        ,target_name       MGMT_TARGETS.target_name%TYPE
        ,target_type       MGMT_TARGETS.target_type%TYPE
        ,type_display_name MGMT_TARGETS.type_display_name%TYPE
        ,target_count      Integer
        ,status            MGMT_JOB_EXEC_SUMMARY.status%TYPE
        );

TYPE jobexec_cvtype IS REF CURSOR;

TYPE REF_CURSOR IS REF CURSOR;

--TYPE jobexec_cvtype IS REF CURSOR RETURN jobexec_rowtype;

-----------------------------------
-- generic API
--
PROCEDURE open_job_executions
            (job_name_IN    IN  varchar2
            ,Job_owner_IN   IN  varchar2
            ,job_type_IN    IN  varchar2
            ,target_name_IN IN  varchar2
            ,target_type_IN IN  varchar2  := '%'
            ,target_cat_IN  IN  integer   := -1
            ,days_IN        IN  integer   := TIMEFRAME_ALL
            ,status_IN      IN  integer   := MGMT_JOB_ENGINE.STATUS_BUCKET_ALL
            ,SYSTEM_JOB_IN  IN  integer   := 0
            ,ignore_access_IN IN integer  := FALSE_FLAG
            ,jobexec_CV IN OUT  jobexec_cvtype
            );


-- hide this until it's needed
--  PROCEDURE open_job_executions_in_run
--              (job_id_IN          IN      varchar2
--              ,sample_exec_id_IN  IN      varchar2
--              ,target_name_IN     IN      varchar2  := '%'
--              ,status_IN          IN      integer   := MGMT_JOB_ENGINE.STATUS_BUCKET_ALL
--              ,cursor             IN OUT  REF_CURSOR
--              );

end MGMT_JOB_UI_EXECS;
/


show errors;
/
