Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/jobs/jobs_ui_pkgdef.sql /st_emcore_10.2.0.4.2db11.2/1 2009/03/11 23:41:06 lsatyapr Exp $
Rem
Rem jobs_ui_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      jobs_ui_pkgdef.sql
Rem
Rem    DESCRIPTION
Rem      PL/SQL for the job UI
Rem
Rem    NOTES
Rem      reduce repository roundtrips for some pages
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rdabbott    07/28/07 - fix 6194784: expose concat fn
Rem    ashugupt    12/10/05 - Backport ashugupt_bug-4769107 from main 
Rem    ashugupt    11/29/05 - fix 4769107 
Rem    nqureshi    08/31/05 - bug 4585496 renaming get_job_type -> 
Rem                           get_job_details, adding few out parameters 
Rem    ashugupt    09/01/05 - Fix 4582689 
Rem    nqureshi    08/22/05 - adding procedure to get the jobType from the 
Rem                           executionId 
Rem    jvishen     08/08/05 - add owner column CA library
Rem    jvishen     07/13/05 - update get_task_breadcrumbs to get job or CA 
Rem    nqureshi    06/14/05 - adding DO_ACTIVE_JOB_VALIDATION
Rem    rdabbott    06/03/05 - fix 4284953: generate create like/submit name 
Rem                           suggestion 
Rem    rdabbott    05/11/05 - add 3rd value to get run status 
Rem    rdabbott    05/09/05 - rename get exec status -> get run status 
Rem    pkantawa    05/23/05 - Fix 4286126: Check if user has VIEW on all 
Rem                           submitted targets 
Rem    ashugupt    04/12/05 - added procedure get_execution_status 
Rem    pkantawa    04/27/05 - Remove nls entries from get_job_info 
Rem    pkantawa    04/11/05 - Return job status for regular and multi task 
Rem                           jobs 
Rem    nqureshi    03/29/05 - fixing 4259864 
Rem    pkantawa    03/22/05 - Fix 4148623: Remove dynamic sql 
Rem    nqureshi    03/21/05 - removing timezone list from get_job_info and 
Rem                           get_multitask_info 
Rem    jvishen     03/14/05 - update for broken CA 
Rem    ashugupt    03/10/05 - changing get_execution_details api to return 
Rem                           output_id 
Rem    pkantawa    03/01/05 - Add procedures for 'kill step' feature 
Rem    nqureshi    02/14/05 - fixing jobNotificationCount for Execution and 
Rem                           task Pages 
Rem    nqureshi    02/07/05 - integrating jobs Notification to Multi task job 
Rem    nqureshi    02/07/05 - fixing multy target job Sqlexception 
Rem    nqureshi    02/01/05 - adding new in/out parameter in get_job_info for 
Rem                           job Notification 
Rem    nqureshi    01/28/05 - modifying get_task_breadcrumbs 
Rem    ashugupt    01/18/05 - fetch info abt error codes in executions 
Rem    jvishen     01/11/05 - update get_run_details for CA 
Rem    pkantawa    01/11/05 - Remove timezone procedures 
Rem    pkantawa    01/07/05 - Return timezones in create job initialization 
Rem                           procedures 
Rem    nqureshi    12/13/04 - modifing procedure to display submitted targets 
Rem    pkantawa    12/09/04 - Get create text for create job 
Rem    pkantawa    11/30/04 - Add procedure for job activity segment 
Rem    jvishen     11/09/04 - Object for target with broken credentials 
Rem                           changed 
Rem    jvishen     10/29/04 - Object for target with broken credentials 
Rem                           Changed 
Rem    ashugupt    11/04/04 - added new fn to handle aggregate targets type 
Rem    nqureshi    11/02/04 - adding schedule info in get_run_details 
Rem                           ,get_execution_details etc .. 
Rem    nqureshi    10/28/04 - adding procedures for results UI 
Rem    pkantawa    10/25/04 - Changes to enter create UI in scope of a target 
Rem    jaysmith    10/22/04 - pass target type to get_multitask_job_info 
Rem    pkantawa    10/18/04 - Add function to check if an aggregate target 
Rem                           contains atleast one member of base type 
Rem    ashugupt    10/12/04 - multi task job changes 
Rem    jaysmith    10/13/04 - ca selection list 
Rem    pkantawa    10/12/04 - account for Multi Task jobs in queries 
Rem    pkantawa    10/08/04 - grabtrans 'ashugupt_edit_multi_task_page' 
Rem    pkantawa    10/07/04 - add procedure to get target timezone 
Rem    ashugupt    10/05/04 - added get_tasks_metadata 
Rem    pkantawa    10/05/04 - Update get_param_creds_info 
Rem    pkantawa    10/03/04 - Make task metadata fetching conditional 
Rem    pkantawa    09/30/04 - Add procedures to initialize task info 
Rem    jvishen     09/28/04 - Added to get Broken Creds for targets in a group 
Rem    jaysmith    09/09/04 - CA Library query 
Rem    pkantawa    09/16/04 - add uses_default_create_ui function 
Rem    pkantawa    09/14/04 - Take execId as input parameter in get_job_info 
Rem    pkantawa    09/13/04 - add get_multitask_job_info procedure 
Rem    pkantawa    08/30/04 - Make job type IN/OUT, add support for fetching 
Rem                           is_jsp flag 
Rem    skini       08/20/04 - Add schedule procedure 
Rem    skini       08/20/04 - Fixes and additions to get_job_data 
Rem    skini       08/16/04 - Change creds_cursor format 
Rem    skini       08/14/04 - Add procedure to get job data 
Rem    ashugupt    08/02/04 - Added new procedure to validate preferred 
Rem                           credentials 
Rem    xshen       11/04/03 - nested and composite group prefcreds validation 
Rem    xshen       10/14/03 - fix all homepage queries with last 7 days 
Rem    xshen       10/10/03 - allow viewing status of all jobs on target 
Rem                           sitemap for a user having view access to the 
Rem    rdabbott    10/09/03 - Fix 3149316: duplicate param for nested job 
Rem    rdabbott    10/08/03 - add get uri method 
Rem    xshen       09/24/03 - add library call 
Rem    xshen       09/15/03 - add pref cred validation calls 
Rem    tzimmerm    09/16/03 - Fix refresh merge issues 
Rem    tzimmerm    09/04/03 - Add job access & show only support
Rem    xshen       08/28/03 - add target rollup intg and library info calls
Rem    tzimmerm    08/26/03 - Add exec_id to API for run links 
Rem    tzimmerm    08/21/03 - Modify job run API for Run Details links 
Rem    tzimmerm    08/19/03 - Adding job run procedures 
Rem    rdabbott    12/09/02 - get job params
Rem    rdabbott    07/11/02 - Fix 2440315: handle target display names
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Restructured.
Rem    skini       04/18/02 - SMP_MGMT_JOB=>MGMT_JOB
Rem    rdabbott    04/16/02 - rdabbott_step_targets
Rem    rdabbott    04/08/02 - Created
Rem

----------------------------------------
CREATE OR REPLACE PACKAGE MGMT_JOB_UI AS
----------------------------------------
----------------------------------------

-- Module name used for logging
MODULE_NAME CONSTANT VARCHAR2(11) := MGMT_JOB_ENGINE.MODULE_NAME || '.ui';

-- type definition
TYPE CURSOR_TYPE IS REF CURSOR;

-- Will store values in format"target name:target type" as index
-- Used for making search for required pair faster
-- Fix 4769107 size should be 256+1+64
TYPE MGMT_TGT_NAME_TYPE_MAP IS TABLE OF NUMBER INDEX BY VARCHAR(321);

-- Get the targets for this step, if any
--  if p_return_display_names is false, return the target's internal name
FUNCTION get_step_targets     ( p_step_id NUMBER,
                                p_return_display_names BOOLEAN DEFAULT true 
                              ) RETURN SMP_EMD_STRING_ARRAY;

-- Get the targets for this step, if any, as a comma separated string
--  if p_return_display_names is false, return the target's internal name
FUNCTION get_step_targets_str ( p_step_id NUMBER,
                                p_return_display_names BOOLEAN DEFAULT true 
                              ) RETURN VARCHAR2;

-- Get the parameters for this job, filter as specified for this jobtype
PROCEDURE get_visible_params  ( p_job_id         RAW,
                                p_exec_id        RAW,
                                p_params_out OUT CURSOR_TYPE);

-- Get the URI for this uri_use
-- see emSDK/job/dtd/UriSource.java for uri_use constants
FUNCTION  get_display_uri     ( p_job_type IN VARCHAR2,
                                p_uri_use  IN NUMBER
                              ) RETURN VARCHAR2;

------------------------------------------------
-- Job Status Intg -> Target Home Pages Calls --
------------------------------------------------
PROCEDURE get_status_rollup_counts( p_target_name           IN VARCHAR2, 
                                    p_target_type           IN VARCHAR2,
                                    p_for_composite_members IN NUMBER DEFAULT 0,
                                    p_ignore_access         IN NUMBER DEFAULT 1,
                                    p_timeframe             IN NUMBER DEFAULT 7,
                                    p_status_cursor         OUT CURSOR_TYPE );  

--
-- gets status info of jobs submitted against an aggregate target of the 
-- specified type.  
-- also gets status info of jobs submitted against all members of the aggregate
--
-- INPUT PARAMETERS
--
-- p_target_name_in target name
-- p_target_type_in target type
-- p_ignore_access_in whether to ignore the user's access on jobs
-- p_timeframe_in  timeframe in which job status is required (e.g. last 7 days)
--
-- OUTPUT PARAMETERS
--
-- p_tgt_status_cursor_out status of jobs submitted against specified target
-- p_mbr_tgt_status_cursor_out status of jobs submitted against members 
--     of the aggregate
-- p_job_types array of job types that can be submitted against the target or
--     its members.  The job types that support default UI, and are editable
--     will be included in the list

PROCEDURE get_aggregate_job_activity( p_target_name_in            IN VARCHAR2, 
                                      p_target_type_in            IN VARCHAR2,
                                      p_ignore_access_in          IN NUMBER DEFAULT 1,
                                      p_timeframe_in              IN NUMBER DEFAULT 7,
                                      p_tgt_status_cursor_out     OUT CURSOR_TYPE, 
                                      p_mbr_tgt_status_cursor_out OUT CURSOR_TYPE,
                                      p_job_types_out             OUT SMP_EMD_STRING_ARRAY);  

----------------------------------------------------
-- End Job Status Intg -> Target Home Pages Calls --
----------------------------------------------------

------------------------------------------------
-- Preferred Credential Validation Calls      --
------------------------------------------------
-- Get a list of targets that do NOT 
-- have approprivate leveled credential set
-- For 4.1 this only handles:
-- A single group/composite target
-- A homogenous type of basic targets
PROCEDURE get_targets_prefcreds_not_set
  ( p_target_list   IN OUT MGMT_JOB_TARGET_LIST,
    p_target_type   IN VARCHAR2 DEFAULT NULL,
    p_cred_set_name IN VARCHAR2 );
------------------------------------------------
-- Preferred Credential Validation Calls      --
-- for new jobs UI                            --
------------------------------------------------
-- Get a list of targets that do NOT 
-- have appropriate preferred credential set.
-- This proc takes an array of object that
-- contains credential set data for each task
-- which in turn contains sets selected by user
-- This proc also takes in job owner user name
-- as input since we need to check the credential
-- sets of user who owns the job and not the 
-- current user.
PROCEDURE get_preferred_creds_not_set
  ( p_pref_cred_data IN OUT MGMT_JOB_TASK_CRED_SET_ARRAY,
    p_job_owner_user_name IN VARCHAR2 );

-- Private procedure that checks the preferred credentials
-- for list of targets
PROCEDURE pref_creds_set_targets
  ( p_target_list IN OUT MGMT_JOB_TARGET_LIST,
    p_pref_cred_set_data IN MGMT_JOB_TGT_CRED_SET_RECORD,
    p_em_user IN VARCHAR2);

-- Private helper that 'flattens' a aggregate 
-- into a member list.
-- For 4.1 this only handles:
--   Single 'true' group target
PROCEDURE get_flattened_aggr_targets
  ( p_target_list IN OUT MGMT_JOB_TARGET_list,
    p_target_type IN VARCHAR2,
    p_skip_target_list IN MGMT_JOB_TARGET_LIST DEFAULT NULL);
----------------------------------------------------
-- End Preferred Credential Validation Calls      --
----------------------------------------------------

------------------------
-- Library Calls      --
------------------------
PROCEDURE get_library_data( p_job_type       IN VARCHAR2,
                            p_job_name       IN VARCHAR2,
                            p_job_owner      IN VARCHAR2,
                            p_library_cursor OUT CURSOR_TYPE ); 

----------------------------
-- End Library Calls      --
----------------------------

------------------------
-- Corrective Action Library Calls      --
------------------------
PROCEDURE get_ca_library_data( p_job_name          IN VARCHAR2,
                               p_job_type          IN VARCHAR2,
                               p_job_owner         IN VARCHAR2,
                               p_target_type       IN VARCHAR2,
                               p_library_cursor    OUT CURSOR_TYPE ); 

PROCEDURE get_ca_select_from_lib_data( p_job_name          IN VARCHAR2,
                                       p_target_type       IN VARCHAR2,
                                       p_library_cursor    OUT CURSOR_TYPE ); 

----------------------------
-- End Corrective Action Library Calls      --
----------------------------

--------------------------
-- PL/SQL procedures to seed job UI
-------------------------

--
-- Modes in which get_job_info() can be called
--
JOB_INFO_MODE_CREATE CONSTANT NUMBER(1) := 1;
JOB_INFO_MODE_EDIT CONSTANT NUMBER(1) := 2;
JOB_INFO_MODE_CREATE_LIKE CONSTANT NUMBER(1) := 3;
JOB_INFO_MODE_VIEW CONSTANT NUMBER(1) := 4;

-- Cursor that returns target information
--    target name
--    target type
--    target GUID
--    display name
--    host name
--    timezone region
--    emd_url
--
TYPE TARGETS_CURSOR IS REF CURSOR;

-- Cursor that returns job credential information
--    credential GUID
--    container location
--    credential set name
--    user name
--    credential set column
--    credential value
--
TYPE CREDS_CURSOR IS REF CURSOR;

TYPE GRANT_CURSOR IS REF CURSOR;

--
-- Return all pieces of metadata and actual job data needed by the
-- job creation UI.
--
-- INPUT PARAMETERS
-- 
--    p_job_type The job type; passed in for create, set to 
--            right value in other modes
--    p_mode The mode: one of CREATE, CREATE_LIKE, VIEW, or EDIT
--    p_job_id The job whose information is to be retrieved.
--    p_exec_id The execution id of the job (in modes other than create)
--    p_initial_target_type The target type of target to seed create UI with
--    p_initial_target The target to seed the create UI with
--    p_initial_member_target_type The member target type of an aggregate target
--
-- OUTPUT PARAMETERS
--
--     p_job_name_out: The job name
--     p_job_owner_out: The job owner
--     p_description_out: The job description
--     p_initial_targets_out The initial target list to seed the create UI with
--     p_targets_out: The current target list of the job
--     p_params_out: The current job-level parameters
--     p_creds_out: Overridden credentials, if any. If null, preferred
--                  credentials were used for this job; information
--                  about what credential sets were chosen is 
--                  available in the parameters list
--     p_schedule_out: The job schedule
--     p_param_metadata_out: Parameter metadata for the job type
--     p_creds_metadata_out: Credential metadata for the job type
--     p_ttype_metadata_out: Target type metadata
--     p_superuser_list_out: A list of superusers
--     p_cluster_types_out: For the default/job target type, a list of 
--          associated cluster types
--     p_group_types_out: For the default/job target type, a list of
--          associated "group" types
--     p_access_list_out: Access information for the job
--     p_editable_by_curr_user_out: Is the job editable by the current user?
--     p_expired_out: Is the job an expired job?
--     p_jobtype_editable_out: Is the job type editable?
--     p_can_submit_to_group_out: Can the job be submitted against a group?
--     p_uses_default_ui_out: Does the job use the default framework create UI?
--     p_create_uri_out: The job type's create URI
--     p_is_jsp_out: The jsp flag of the job type
--     p_job_target_types_out: The list of target types supported by the job type
--                             If null, assume that the job type can be submitted
--                             against targets of all types
--     p_default_target_type_out: The default target type, assuming
--                                p_job_target_types_out is non-empty
--     p_create_text_nlsid: NLS Id of create instruction text
--     p_create_text_default: Default create instruction text
--     p_create_like_name_out suggested name for create like or submit from lib
--     p_jobCreate_Notif_out: Notification details
--     p_job_status_out: Job status 
--     p_ctx_type_out: Context type (active, library, etc)
--     p_has_view_on_targets: whether user has view on all submitted targets
--
-- EXCEPTIONS
--   INVALID_JOB_ERR The specified job does not exist
--
PROCEDURE get_job_info(p_job_type IN OUT VARCHAR2,
                       p_mode NUMBER,
                       p_job_id IN OUT VARCHAR2,
                       p_exec_id VARCHAR2,
                       p_initial_target_type VARCHAR2,
                       p_initial_target VARCHAR2,
                       p_initial_member_target_type VARCHAR2,
                       p_job_name_out OUT VARCHAR2,
                       p_job_owner_out OUT VARCHAR2,
                       p_description_out OUT VARCHAR2,
                       p_initial_targets_out OUT TARGETS_CURSOR,
                       p_targets_out OUT TARGETS_CURSOR,
                       p_params_out OUT MGMT_JOB_PARAM_LIST,
                       p_creds_out OUT CREDS_CURSOR,
                       p_schedule_out OUT MGMT_JOB_SCHEDULE_RECORD,
                       p_access_list_out OUT GRANT_CURSOR,
                       p_editable_by_curr_user_out OUT NUMBER,
                       p_expired_out OUT NUMBER,
                       p_param_metadata_out OUT MGMT_JOB_PARAMETER_METADATA,
                       p_creds_metadata_out OUT MGMT_JOB_CREDENTIAL_RECORD,
                       p_ttype_metadata_out OUT MGMT_TARGET_TYPE_PROP_ARRAY,
                       p_superuser_list_out OUT SMP_EMD_STRING_ARRAY,
                       p_cluster_types_out OUT SMP_EMD_STRING_ARRAY,
                       p_group_types_out OUT SMP_EMD_STRING_ARRAY,
                       p_jobtype_editable_out OUT NUMBER,
                       p_can_submit_to_group_out OUT NUMBER,
                       p_uses_default_ui_out OUT NUMBER,
                       p_create_uri_out OUT VARCHAR2,
                       p_is_jsp_out OUT NUMBER,
                       p_job_target_types_out OUT SMP_EMD_STRING_ARRAY,
                       p_default_target_type_out OUT VARCHAR2,
                       p_create_text_nlsid OUT VARCHAR2,
                       p_create_text_default OUT VARCHAR2,
                       p_create_like_name_out OUT VARCHAR2,
                       p_jobCreate_Notif_out OUT MGMT_JOB_NOTIF_EMAIL_SCH_INFO,
                       p_job_status_out OUT NUMBER,
                       p_ctx_type_out OUT NUMBER,
                       p_has_view_on_targets OUT NUMBER
                       );
                       
-- Obtain job info when the target type selection of the job changes
--
-- INPUT PARAMETERS
--      p_job_type The job type
--      p_new_target_type The new target type
--      p_fetch_param_creds_ttypes   1 if param, creds, target types 
--                                   should be fetched, 0 otherwise
PROCEDURE get_param_creds_info(p_job_type VARCHAR2,
                               p_new_target_type VARCHAR2,
                               p_fetch_param_creds_ttypes NUMBER,
                               p_cluster_types_out OUT SMP_EMD_STRING_ARRAY,
                               p_group_types_out OUT SMP_EMD_STRING_ARRAY,
                               p_param_metadata_out OUT MGMT_JOB_PARAMETER_METADATA,
                               p_creds_metadata_out OUT MGMT_JOB_CREDENTIAL_RECORD,
                               p_ttype_metadata_out OUT MGMT_TARGET_TYPE_PROP_ARRAY);
    
-- Return all target types that have Host Credentials defined
FUNCTION get_tgt_types_with_host_creds
    RETURN SMP_EMD_STRING_ARRAY;

--Return all job types that can run against given target type and use default UI
FUNCTION get_job_types_for_target_type(p_target_type VARCHAR2)
    RETURN SMP_EMD_STRING_ARRAY;
    
    
--
-- Return all pieces of metadata and actual job data needed by the
-- multi-task job creation UI.
--
--
-- INPUT PARAMETERS
-- 
--    p_job_id: The job whose information is to be retrieved.
--    p_mode: Edit,Create,Create-Like, View mode
--    p_target_type: target type used in context of corrective actions
--    p_target_list: list of tergets to get the targets info
--    p_initial_target_type The target type of target to seed create UI with
--    p_initial_target VARCHAR2 The target to seed the create UI with
--    p_initial_member_target_type VARCHAR2 The member target type of an aggregate target
--
-- OUTPUT PARAMETERS
--
--     p_default_target_type_out: The default target type of the job
--     p_job_target_types_out: The list of target types against which multi-task
--          job can be submitted
--     p_cluster_types_out: For the default/job target type, a list of 
--          associated cluster types
--     p_group_types_out: For the default/job target type, a list of
--          associated "group" types    
--     p_job_types_all_out: All job types that can use default UI and are editable
--     p_job_types_for_tgt_type_out : All job types that can use default
--          UI and are editable and can run on selected target type
--     p_super_user_list_out: A list of superusers - valid only for create action
--     p_access_list_out: Access information for the job - valid only for
--          edit/view/create-like actions
--     p_editable_by_curr_user_out: Is the job editable by the current user? 
--     p_expired_out: Is the job an expired job?
--     p_initial_targets_out The initial target list to seed the create UI with
--     p_targets_out The target list of the job
--     p_tasks_metadata Metadata for tasks of the job
--     p_create_like_name_out suggested name for create like or submit from lib
--     p_jobcreate_notif_out job notification information to be displayed in Access page
--     p_job_status_out Job status
--     p_has_view_on_targets: whether user has view on all submitted targets
-- EXCEPTIONS
--   INVALID_JOB_ERR The specified job does not exist
--
PROCEDURE get_multitask_job_info(p_job_id VARCHAR2,
                                 p_mode NUMBER,
                                 p_target_type VARCHAR2, 
                                 p_target_list MGMT_JOB_TARGET_LIST,
                                 p_initial_target_type VARCHAR2,
                                 p_initial_target VARCHAR2,
                                 p_initial_member_target_type VARCHAR2,
                                 p_default_target_type_out OUT VARCHAR2,
                                 p_job_target_types_out OUT SMP_EMD_STRING_ARRAY,
                                 p_cluster_types_out OUT SMP_EMD_STRING_ARRAY,
                                 p_group_types_out OUT SMP_EMD_STRING_ARRAY,
                                 p_job_types_all_out OUT SMP_EMD_STRING_ARRAY,
                                 p_job_types_for_tgt_type_out OUT SMP_EMD_STRING_ARRAY,
                                 p_superuser_list_out OUT SMP_EMD_STRING_ARRAY,
                                 p_access_list_out OUT GRANT_CURSOR,
                                 p_editable_by_curr_user_out OUT NUMBER,
                                 p_expired_out OUT NUMBER,
                                 p_initial_targets_out OUT TARGETS_CURSOR,
                                 p_targets_out OUT TARGETS_CURSOR,
                                 p_tasks_metadata IN OUT MGMT_PARAM_CRED_TGT_MET_ARR,
                                 p_create_like_name_out OUT VARCHAR2,
                                 p_jobcreate_notif_out OUT MGMT_JOB_NOTIF_EMAIL_SCH_INFO,
                                 p_job_status_out OUT NUMBER,
                                 p_ctx_type_out OUT NUMBER,
                                 p_has_view_on_targets OUT NUMBER
                                );

-- returns 1 or 0 depending on whether the job type uses default create ui or not
FUNCTION uses_default_create_ui( p_job_type VARCHAR2)
    RETURN NUMBER;
                    
                    

--
-- Return all pieces of metadata that is required when user changes target type
-- in multi-task job creation UI.
--
-- INPUT PARAMETERS
-- 
--    p_target_type: The new target type
--
-- OUTPUT PARAMETERS
--
--     p_job_types_for_tgt_type_out : All job types that can use default
--          UI and are editable and can run on selected target type
--     p_cluster_types_out: For the default/job target type, a list of 
--          associated cluster types
--     p_group_types_out: For the default/job target type, a list of
--          associated "group" types    
PROCEDURE change_multitask_target_type(p_target_type VARCHAR2,
                                       p_job_types_for_tgt_type_out OUT SMP_EMD_STRING_ARRAY,
                                       p_cluster_types_out OUT SMP_EMD_STRING_ARRAY,
                                       p_group_types_out OUT SMP_EMD_STRING_ARRAY);
                                       


--
-- Return task info for a single exec multi-task job
--
-- INPUT PARAMETERS
--
--      p_job_type     The job type
--      p_target_type  The target type
--      p_target_list  List of existing targets, if they exist
--      
--
-- OUTPUT PARAMETERS
--      p_cluster_types_out   Cluster target types
--      p_group_types_out     Group target types
--      p_job_target_types_out Target types supported by job type
--      p_targets_out         Targets info
PROCEDURE get_single_exec_task_info(p_job_type VARCHAR2,
                                    p_target_type IN OUT VARCHAR2,
                                    p_target_list MGMT_JOB_TARGET_LIST,
                                    p_cluster_types_out OUT SMP_EMD_STRING_ARRAY,
                                    p_group_types_out OUT SMP_EMD_STRING_ARRAY,
                                    p_job_target_types_out OUT SMP_EMD_STRING_ARRAY,
                                    p_targets_out OUT TARGETS_CURSOR,
                                    p_tasks_metadata IN OUT MGMT_PARAM_CRED_TGT_MET_ARR);
                                      


-- Get information about broken credentials of a target.
PROCEDURE  get_target_broken_creds(target_name_in IN VARCHAR2 DEFAULT NULL ,
		      target_type_in IN VARCHAR2 DEFAULT NULL,
                      language_code_in IN VARCHAR2,
                      country_code_in IN VARCHAR2,
                      policy_type_in IN NUMBER DEFAULT 1,
                      cred_arr_out out MGMT_TARGET_FIXCA_ARRAY  );


-- Get information about broken credentials of targets in a group.
PROCEDURE  get_target_group_broken_creds (group_name_in IN VARCHAR2,
                          language_code_in IN VARCHAR2,
                          country_code_in IN VARCHAR2,
                          cred_arr_out OUT MGMT_TARGET_FIXCA_ARRAY  );
 
-- Get task metadata array
PROCEDURE get_tasks_metadata(p_tasks_metadata IN OUT MGMT_PARAM_CRED_TGT_MET_ARR);

-- Get task metadata for single task along with cluster types and group types
PROCEDURE get_meta_group_cluster_info(p_job_type VARCHAR2,
                                      p_new_target_type VARCHAR2,
                                      p_fetch_metadata NUMBER,
                                      p_tasks_metadata OUT MGMT_PARAM_CRED_TGT_MET_ARR,
                                      p_cluster_types_out OUT SMP_EMD_STRING_ARRAY,
                                      p_group_types_out OUT SMP_EMD_STRING_ARRAY);

-- Computes allowable category values in search for jobs based on job type value
--
-- INPUT PARAMETERS
--      p_job_type the job type
--      p_category_a first possible value of category
--      p_category_b second possible value of category
--
PROCEDURE compute_jobtype_categories(p_job_type VARCHAR2,
                                     p_category_a IN OUT NUMBER,
                                     p_category_b IN OUT NUMBER);
                                   
--
-- Checks if the aggregate target has atleast one member of the base target type
-- Returns count if it finds atleast one, and 0 otherwise
--
-- INPUT PARAMETERS
--      p_aggregate_target aggregate target record
--      p_base_target_type base target type
--
-- RETURNS
--      count if it finds atleast one member of base type in the aggregate, 0 otherwise
--
FUNCTION check_aggregate_membership(p_aggregate_target MGMT_JOB_TARGET_RECORD,
                                    p_base_target_type VARCHAR2)
    RETURN NUMBER;

--gets initial target for the job.  Also modifies default target type to 
--comply with initial target.
--
-- INPUT PARAMETERS
--    p_initial_target_type The target type of target to seed create UI with
--    p_initial_target The target to seed the create UI with
--    p_initial_member_target_type The member target type of an aggregate target
--    p_job_target_types The list of target types supported by the job type
--                       If null, assume that the job type can be submitted
--                       against targets of all types
--    p_default_target_type_out: The default target type.  Will be modified, if
--              required, to comply with initial target type
--
-- OUTPUT PARAMETERS
--    p_initial_targets_out The initial target list to seed the create UI with

PROCEDURE get_initial_job_target(p_initial_target_type VARCHAR2,
                                  p_initial_target VARCHAR2,
                                  p_initial_member_target_type VARCHAR2,
                                  p_job_target_types SMP_EMD_STRING_ARRAY,
                                  p_default_target_type IN OUT VARCHAR2,
                                  p_initial_targets_out OUT TARGETS_CURSOR);



-- A cursor that returns step-level information for all
-- executions in the run
TYPE STEPS_CURSOR IS REF CURSOR;
-- A cursor that returns information about execution targets
--    execution_id, target_name, target_type
TYPE EXEC_TARGETS_CURSOR IS REF CURSOR;
-- A cursor that returns information about the job
--     job type, description, owner
TYPE JOB_INFO_CURSOR IS REF CURSOR;
-- A cursor that returns information about a task
--      status, start_time, end_time, job_type, owner
TYPE TASK_INFO_CURSOR IS REF CURSOR;
-- A cursor that returns information about job parameters
--      parameter_name parameter_type encrypted scalar_value vector_value
TYPE PARAMS_CURSOR IS REF CURSOR;

-- A cursor that returns information about jobs previous exec 
TYPE PREVIOUS_JOB_INFO IS REF CURSOR;

-- A cursor that returns information about jobs next exec 
TYPE NEXT_JOB_INFO IS REF CURSOR;



--
-- Return run details information for all executions that are
-- in the same run as the current execution
-- 
-- INPUT PARAMETERS
--     p_execution_id The execution id. Provide this if you are
--          on the run details page
--     p_target_name target Name to Search for 
--     p_status status to Search For

-- OUTPUT PARAMETERS
--     p_steps_cursor_out A cursor that returns all step-level
--       information. The rows are sorted by execution_id and step_id,
--       which means they are returned in chronological order for
--       each execution
--     p_exec_targets_cursor_out A cursor that returns all
--       execution-level targets for all executions in the run.
--       The rows are sorted by execution_id.
--     p_scheduled_time_out The scheduled time of the run
--     p_scheduled_time_zone The scheduled timezone of the run
--     p_job_info_out Basic information about the job
--          job_type, owner, description
--   
--    p_task_tgt_runs_cursor_out 
--    p_job_name_out job Name  
PROCEDURE get_run_details(
                          p_execution_id IN RAW,
                          p_target_name IN VARCHAR2,
                          p_status IN NUMBER,
                          p_steps_cursor_out OUT STEPS_CURSOR,
                          p_exec_targets_cursor_out OUT EXEC_TARGETS_CURSOR,
                          p_scheduled_time_out OUT DATE,
                          p_scheduled_time_zone OUT varchar2,
                          p_job_info_out OUT JOB_INFO_CURSOR,
                          p_task_tgt_runs_cursor_out  OUT TASK_INFO_CURSOR,
                          p_job_name_out OUT varchar2,
                          p_schedule_out OUT MGMT_JOB_SCHEDULE_RECORD,
                          p_job_category_out OUT NUMBER,
                          p_submitted_targets_string_out OUT VARCHAR2,
                          p_ca_reference_count OUT NUMBER,
                          p_is_corrective_action OUT NUMBER

                          );



--
-- Return run details information for all executions that are
-- in the same run as the current execution
-- 
-- INPUT PARAMETERS
--     p_execution_id The execution id. Provide this if you are
--          on the run details page
-- OUTPUT PARAMETERS
--     p_steps_cursor_out A cursor that returns all step-level
--       information. The rows are sorted by execution_id and step_id,
--       which means they are returned in chronological order for
--       each execution
--     p_exec_targets_cursor_out A cursor that returns all
--       execution-level targets for all executions in the run.
--       The rows are sorted by execution_id.
--     p_scheduled_time_out The scheduled time of the run
--     p_scheduled_time_zone The scheduled timezone of the run
--     p_job_info_out Basic information about the job
--          job_type, owner, description
--     p_error_output_ids additional "execution level" error messages to be 
--     to be displayed on UI
--   
--    p_task_tgt_runs_cursor_out 
--    p_job_name_out job Name  
--  No_of_executions_out number of executions

PROCEDURE get_execution_details(p_execution_id IN RAW,
                          p_steps_cursor_out OUT STEPS_CURSOR,
                          p_exec_targets_cursor_out OUT EXEC_TARGETS_CURSOR,
                          p_scheduled_time_out OUT DATE,
                          p_scheduled_time_zone OUT varchar2,
                          p_job_info_out OUT JOB_INFO_CURSOR,
                          p_task_params_out  out PARAMS_CURSOR,
                          p_task_tgt_runs_cursor_out  OUT TASK_INFO_CURSOR,
                          p_job_name_out OUT VARCHAR2,
                          No_of_executions_out OUT NUMBER,
                          p_schedule_out OUT MGMT_JOB_SCHEDULE_RECORD,
                          p_job_category_out OUT NUMBER,
                          isSingleStepJob_out OUT nocopy NUMBER,
                          p_uriSource_resInc_out OUT NUMBER,
                          p_ca_reference_count OUT NUMBER,
                          p_is_corrective_action OUT NUMBER,
                          p_status OUT NUMBER,
                          p_status_code OUT NUMBER,
                          p_status_code_category OUT NUMBER,
                          p_status_detail OUT NUMBER,
                          p_job_notification_count_out OUT NUMBER,
                          p_error_output_ids OUT SMP_EMD_STRING_ARRAY,
			  p_previous_job_info_out OUT PREVIOUS_JOB_INFO,
			  p_next_job_info_out OUT NEXT_JOB_INFO
                          ) ;


--
-- Return task details information 
-- 
-- INPUT PARAMETERS
--     p_task_step_id The step id of the task entry
--
-- OUTPUT PARAMETERS
--     p_steps_cursor_out A cursor that returns all step-level
--       information. The rows are sorted by execution_id and step_id,
--       which means they are returned in chronological order for
--       each execution

--     p_scheduled_time_out The scheduled time of the run
--     p_scheduled_time_zone The scheduled timezone of the run
--     p_job_info_out Basic information about the job
--          job_type, owner, description
--   
--    p_task_tgt_runs_cursor_out 
--    p_job_name_out job Name  
--
PROCEDURE get_task_details(p_task_step_id IN NUMBER,
                          p_steps_cursor_out OUT STEPS_CURSOR,
                          p_task_targets_cursor_out OUT EXEC_TARGETS_CURSOR,
                          p_scheduled_time_out OUT DATE,
                          p_scheduled_time_zone OUT varchar2,
                          p_job_info_out OUT JOB_INFO_CURSOR,
                          p_task_params_out  out PARAMS_CURSOR,
                          p_task_tgt_runs_cursor_out  OUT TASK_INFO_CURSOR,
                          p_job_name_out OUT VARCHAR2,
                          p_schedule_out OUT MGMT_JOB_SCHEDULE_RECORD,
                          p_job_category_out OUT NUMBER,
                          p_status OUT NUMBER,
                          p_status_code OUT NUMBER,
                          p_status_code_category OUT NUMBER,
                          p_status_detail OUT NUMBER,
                          p_error_output_ids OUT SMP_EMD_STRING_ARRAY,
                          p_is_corrective_action OUT NUMBER
                                                ) ;
                                       
-- INPUT PARAMETERS
--     p_task_step_id The step id of the task entry
--     p_target_name target name to search for
--     p_status status to search for 
--

-- OUTPUT PARAMETERS
--    isSingleStepJob_out flag to identify whether its a singlestep job .

--     p_scheduled_time_out The scheduled time of the run
--     p_scheduled_time_zone The scheduled timezone of the run
--     p_job_info_out Basic information about the job
--          job_type, owner, description
--     p_steps_cursor_out A cursor that returns all step-level
--       information. The rows are sorted by execution_id and step_id,
--       which means they are returned in chronological order for
--       each execution
--    p_job_name_out job Name  
--    No_of_executions_out number of executions

PROCEDURE get_single_step_job_details(p_execution_id IN RAW,
                          p_target_name IN VARCHAR2,
                          p_status IN NUMBER,
                          isSingleStepJob_out OUT NUMBER,
                          p_scheduled_time_out OUT DATE,
                          p_scheduled_time_zone_out OUT VARCHAR2,
                          p_job_info_out OUT TASK_INFO_CURSOR,
                          p_steps_cursor_out OUT STEPS_CURSOR,
                          p_job_name_out OUT VARCHAR2,
                          No_of_executions_out OUT NUMBER,
                          p_schedule_out OUT MGMT_JOB_SCHEDULE_RECORD,
                          p_uriSource_resInc_out OUT NUMBER,
                          p_job_category_out OUT NUMBER,
                          p_submitted_targets_string_out OUT VARCHAR2,
                          p_ca_reference_count OUT NUMBER,
                          p_is_corrective_action OUT NUMBER
                          ) ;

-- INPUT PARAMETERS
--     p_executionId  The execution id of the Job
--     p_task_step_id The step id of the task entry
--     p_job_name_out Job name to search for
--     p_task_bredcrums_out List of Breadcrumbs to show
--

-- OUTPUT PARAMETERS
--    isSingleStepJob_out flag to identify whether its a singlestep job .

--     p_scheduled_time_out The scheduled time of the run
--     p_scheduled_time_zone The scheduled timezone of the run
--     p_job_info_out Basic information about the job
--     No_of_executions_out total number of executions
PROCEDURE get_task_breadcrumbs(p_execution_id IN RAW,
                          p_task_step_id IN NUMBER,
                          job_name_out out varchar2,
                          p_task_bredcrums_out OUT TASK_INFO_CURSOR,
                          No_of_executions_out OUT NUMBER,
                          p_uriSource_resInc_out OUT NUMBER,
                          p_job_category_out OUT NUMBER,
                          isSingleStepJob_out OUT nocopy NUMBER,
                          p_execution_target OUT SMP_EMD_STRING_ARRAY,
                          p_is_corrective_action_out out NUMBER

                                                ) ;
-- INPUT PARAMETERS
--     p_executionId  The execution id of the Job
-- OUTPUT PARAMETERS
--     No_of_executions_out total number of executions

PROCEDURE get_execution_count(p_execution_id IN RAW,
                               No_of_executions_out OUT NUMBER
                                     ) ;
procedure get_results_schedule(p_job_id IN RAW,
                                p_schedule_out OUT MGMT_JOB_SCHEDULE_RECORD) ;

--function to check if the given target type is aggregate.
--return 1 if it is an aggregate, and 0 otherwise
FUNCTION is_aggregate_type(p_target_type IN VARCHAR2)
    RETURN NUMBER;

    -- Get the targetsName if Numbner of target ==1 else
--return the targets count against which job is submitted
-- p_job_id The job is of the Job
-- String will contain targets name is count ==1 else taregts count
procedure get_submitted_targets(p_job_id IN RAW, 
                                p_targets_info_out OUT VARCHAR2) ;

-- Get the custom data
procedure get_custom_data(p_job_id IN RAW,
                          p_target_count OUT NUMBER,
                          p_targets_info_out OUT VARCHAR2,                          
                          p_job_type OUT VARCHAR2,
                          p_delete_text_default OUT VARCHAR2,
                          p_delete_text_nlsid OUT VARCHAR2);

--
-- Procedure to validate if Kill step should be allowed for current user.
-- The output parameters are computed on a need basis.  If first parameter
-- indicates that the operation is not allowed, the others will not be computed.
--
-- INPUT PARAMETERS
--  p_step_id The step id
-- 
-- OUTPUT PARAMETERS
--  p_status_ok Whether the status is ok (1 if ok, 0 of not ok)
--  p_access_ok Whether the user has sufficient access (1 if ok, 0 if not ok, -1 if not computed)
--  p_agent_ok  Whether the step is, or is supposed to execute on an agent(1 if ok, 0 if not ok, -1 if not computed)
--
procedure allow_step_kill(p_step_id IN NUMBER,
                          p_status_ok OUT NUMBER,
                          p_access_ok OUT NUMBER,
                          p_agent_ok OUT NUMBER);
                          

--
-- Procedure to get details for killing the step
-- Current this will work only for two commands: remoteOp, fileTransfer
-- If command is remoteOp, the source agent information will be null
--
-- INPUT PARAMETERS
--  p_step_id The step id
--
-- OUTPUT PARAMETERS
--  p_source_info_valid Indicates whether source information is valid. 1-valid; 0-invalid
--  p_emd_url The URL of the agent
--  p_username Username to use to kill the step
--  p_password Password to use to kill the step
--  p_source_emd_url The URL of source agent
--  p_source_username The Username for source agent
--  p_source_password The Password for source agent


procedure get_step_kill_details(p_step_id IN NUMBER,
                                p_source_info_valid OUT NUMBER,
                                p_emd_url OUT VARCHAR2,
                                p_username OUT VARCHAR2,
                                p_password OUT VARCHAR2,
                                p_source_emd_url OUT VARCHAR2,
                                p_source_username OUT VARCHAR2,
                                p_source_password OUT VARCHAR2);
--
-- Procedure to get the status of job execution
--    bitwise or of the following
-- 8 means a future run is waiting
-- 4 means a later run is active
     -- todo: should this be any other run, rather than only later runs?
-- 2 means one or more executions in run is active 
-- 1 means one or more executions in job is active 
-- 0 means neither run nor any executions in job is active or waiting
--                              
PROCEDURE get_run_status(p_execution_id IN RAW,
                         p_status OUT NUMBER);





 -- Jobs will use this proecdure to do preSubmit repository validations
 -- currently its calling from MainJobBean and MultitaskJobBean any change in this procedure 
 -- must be reflected in both the java classes
 --  p_pref_cred_data  credentails records
--   p_job_owner_user_name job Owner Name
--   p_tgt_list_in   List of targets Types against which we want to validate
--   p_props_list_in    List of targets properties we want to check the existenance
--   p_job_target_type_in  targets Type of the job
--   p_target_name_array_out  return array of taregts display name and target properties
  
  Procedure  DO_ACTIVE_JOB_VALIDATION (
                             p_pref_cred_data IN OUT MGMT_JOB_TASK_CRED_SET_ARRAY,
                             p_job_owner_user_name IN VARCHAR2,
                             p_tgt_list_in   In MGMT_JOB_TARGET_LIST_TABLE ,
                             p_props_list_in   In MGMT_JOB_SHORT_STR_ARR_TABLE,
                             p_job_target_type_in in SMP_EMD_STRING_ARRAY,
                             p_target_name_array_out OUT MGMT_JOB_DNAME_TYPE_PROP_TABLE 
                             ) ;
---------------
---------------

---------------
-- private function
-- here only for pragma
---------------
FUNCTION get_job_num ( p_job_name VARCHAR2, p_prefix VARCHAR2 ) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES(get_job_num, RNDS, RNPS, WNDS, WNPS);

-- Procedure that will return jobType based on the execution Id
  Procedure get_job_details( p_execution_id IN RAW ,p_job_id_out OUT VARCHAR2,p_job_type_out OUT VARCHAR2, p_job_name_out OUT VARCHAR2,p_job_owner_out OUT VARCHAR2, p_job_status_out OUT NUMBER,p_scheduled_time_out OUT DATE );
 
FUNCTION concat_string_array ( p_arr   SMP_EMD_STRING_ARRAY,
                               p_delim VARCHAR2  ) RETURN VARCHAR2;

PROCEDURE get_output(p_output_ids_in IN MGMT_USER_GUID_ARRAY,output_out OUT PARAMS_CURSOR);

END MGMT_JOB_UI;
/
show errors


