Rem drv: <create type="views" pos="esm/esm_views.sql+"/>
Rem
Rem $Header: jobs_views.sql 01-jul-2005.18:43:44 gsbhatia Exp $
Rem
Rem jobs_views.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      jobs_views.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    dsahrawa    02/17/05 - add new step types 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    skini       10/28/04 - Fix view 
Rem    skini       10/20/04 - 
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/14/02 - Created
Rem

rem
rem  VIEW MGMT_JOB$EXECPLAN
rem
rem  PURPOSE
rem    The columns have the same meaning as those in the table
rem    MGMT_JOB_EXECPLAN. This view is to be used for debugging
rem    only; it should never be used by application code.
rem
rem  COLUMNS
rem
rem  NOTES
rem
rem
CREATE OR REPLACE VIEW MGMT_JOB$EXECPLAN(job_type, job_type_id, step_name,
       step_type, nested_job_type, nested_job_target_type, incoming_edge_type,
    origin_step_name, origin_step_type, num_children, stepset_name, iterate_param,
    command_name, restart_mode)
AS
SELECT job_type, e.job_type_id, step_name, 
    decode(step_type, 1, 'Step', 
                      2, 'Serial Stepset', 
                      3, 'Switch Stepset', 
                      4, 'Parallel Stepset',
                      5, 'Iterative Serial Stepset', 
                      6, 'Iterative Parallel Stepset', 
                      7, 'Nested Job', 
                      8, 'Param Source',
                      9, 'Param Source Retry',
                      10, 'Start Wait Step',
                      11, 'Grace Wait Step',
                      12, 'Flatten Targets Step', 'Unknown'),
    NVL(nested_job_type, '(NONE)'),
    nested_job_target_type,
    decode(incoming_edge_type, 1, 'Serial_Begin',
                               2, 'Serial_End',
                               3, 'Switch_Begin',
                               4, 'Parallel_Begin',
                               5, 'IterativeSerial_Begin',
                               6, 'IterativeParallel_Begin',
                               7, 'SuccessOf_End',
                               8, 'FailureOf_End',
                               9, 'AbortOf_End',
                               -1, '(None)', 'Unknown'),
    NVL(origin_step_name, '(NONE)'),
    decode(origin_step_type, 1, 'Step', 
                   2, 'Serial Stepset', 
                   3, 'Switch Stepset',
                   4, 'Parallel Stepset',
                   5, 'Iterative Serial Stepset', 
                   6, 'Iterative Parallel Stepset', 
                   7, 'Nested Job',
                   8, 'Param Source',
                   9, 'Param Source Retry',
                   10, 'Start Wait Step',
                   11, 'Grace Wait Step',
                   12, 'Flatten Targets Step', 'Unknown'),
    num_children,
    NVL(stepset_name, '(NONE)'),
    NVL(iterate_param, '(NONE)'),
    NVL(command_name, '(NONE)'),
    decode(restart_mode, 1, 'Failure', 2, 'Always', 'Unknown')
FROM MGMT_JOB_EXECPLAN e, MGMT_JOB_TYPE_INFO ji
WHERE ji.job_type_id=e.job_type_id;


