Rem drv: <create type="pkgdefs" pos="util/util_pkgdefs.sql+"/>
Rem
Rem $Header: license_pkgdefs.sql 19-jul-2006.01:42:34 acgopala Exp $
Rem
Rem license_pkgdefs.sql
Rem
Rem Copyright (c) 2004, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      license_pkgdefs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    acgopala    07/19/06 - Backport acgopala_bug5099434 from main 
Rem    acgopala    04/01/06 - Added procedure get_license_setup_data which will be used
Rem                           to featch target licensing information for Licensable targets as well as 
Rem                           All Targets(Licensable targets and all dependent targets) options
Rem    bram        06/01/06 - 
Rem    bram        07/12/06 - Backport bram_bug-5147069 from main 
Rem    bram        05/26/06 - Add formapp_license_assoc_create and formapp_license_assoc_delete
Rem    yxie        07/17/06 - XbranchMerge yxie_formsapp_license from main 
Rem    paachary    09/23/05 - Adding a new  API 
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    paachary    03/03/05 - Added 3 APIs (add_pack_definitions, add_licensable_target_types, add_packs) 
Rem                           to insert new records into mgmt_license_definitions, mgmt_licensable_target_types
Rem                           and mgmt_admin_license respectively. The API add_pack_definitions updates the mgmt_license_definitions table
Rem                           if a corresponding entry already exists.
Rem    bram        02/27/05 - Changed get_all_setup
Rem    pratagar    02/10/05 - Apply packs to target only when license state has
Rem                           changed
Rem    paachary    02/08/05 - Changed the package name from mgmt_license to em_license
Rem    gsbhatia    02/07/05 - updating repmgr header
Rem    pratagar    02/04/05 -
Rem    bram        02/03/05 - Grant/revoke License made Public
Rem    pratagar    01/30/05 - LicensingALL
Rem    sdantkal    01/26/05 -
Rem    ktlaw       01/11/05 - add repmgr header
Rem    bram        12/30/04 - Rac Licensing assoc addition and deletion
Rem    paachary    12/13/04 - Disabling host based licensing
Rem    paachary    12/06/04 - WebApp licensing (addition and deletion)
Rem    sdantkal    07/29/04 - standalone target types.
Rem    yaofeng     04/16/04 - yaofeng_bug-3548336
Rem    jpyang      03/19/04 - Created
Rem

CREATE OR REPLACE PACKAGE em_license AS

TYPE cursorType IS REF CURSOR;

-- Constants to handle errors
INVALID_TARGET_PACK_COMBI CONSTANT INTEGER := -20901;

-- Procedure
-- Purpose : To check whether a Target-Pack Combination is Licensed or Not
-- Input Parameters
-- p_target_guid : (optional) GUID of the Target to which the Pack License is granted
-- p_pack_label : Name of the Pack on which License is granted
-- OUTPUT Parameter
-- p_is_licensed : 'TRUE' if Licensed and 'FALSE' in case NOT
FUNCTION is_target_pack_licensed
(
    p_target_guid      IN VARCHAR2,
    p_pack_label       IN VARCHAR2,
    p_from_target_guid IN VARCHAR2 DEFAULT NULL
) RETURN VARCHAR2;

--
-- PROCEDURE: get_packs_data
--
-- PURPOSE:
--   returns cursor giving packs definitions
--
PROCEDURE get_packs_data
(
    pack_defs_cur_out        OUT cursorType
);
-- Purpose : To grant License on a Target(and its associates)-package Combination
-- Input Parameters
-- p_target_type : Target Type to which the Current Target Belongs To (Possible Values : oracle_ias, oracle_database)
-- p_target_name : (optional) Name of the Target to which the Pack License is granted
-- p_target_guid : (optional) GUID of the Target to which the Pack License is granted
-- p_pack_label : Name of the Pack on which License is granted
PROCEDURE grant_license
(
    p_target_type IN VARCHAR2,
    p_target_name IN VARCHAR2 DEFAULT NULL,
    p_target_guid IN VARCHAR2 DEFAULT NULL,
    p_pack_label  IN VARCHAR2
);
-- Purpose : To revoke License on a Target(and its associates)-package Combination
-- Input Parameters
-- p_target_type : Target Type to which the Current Target Belongs To
-- p_target_name : (optional) Name of the Target from which the Pack License is to be revoked
-- p_target_guid : (optional) GUID of the Target from which the Pack License is to be revoked
-- p_pack_label : Name of the Pack on which License is to be revoked
PROCEDURE revoke_license
(
    p_target_type   IN VARCHAR2,
    p_target_name   IN VARCHAR2 DEFAULT NULL,
    p_target_guid   IN VARCHAR2 DEFAULT NULL,
    p_pack_label    IN VARCHAR2
);
--
-- PROCEDURE: get_licenses_data
--
-- PURPOSE:
--   returns 3 cursors about licensing model in EM
--   1. setup_details_cur_out : administrator licensing setup page details
--   2. pack_defs_cur_out: licensable packs definition
--   3. licensable_types_cur_out licensable types list
--
PROCEDURE get_licenses_data
(
    setup_details_cur_out    OUT cursorType,
    pack_defs_cur_out        OUT cursorType,
    licensable_types_cur_out OUT cursorType
);

--
-- PROCEDURE: save_setup_data
--
-- PURPOSE: save super administrator set up data
--
PROCEDURE save_setup_data
(
    setup_details IN SMP_EMD_STRING_ARRAY
);

-- Purpose : To fetch the targetType, packs available data
-- Outout Parameters
-- licensable_types_cur_out : Cursor giving  targetType, packs available data

PROCEDURE get_target_packs
(
    licensable_types_cur_out OUT cursorType
);

-- Purpose : To fetch the targetType, packs available data
-- Outout Parameters
-- licensable_types_cur_out : Cursor giving  targetType, packs available data

PROCEDURE get_parent_target_packs
(
    licensable_types_cur_out OUT cursorType
);

-- Purpose : To fetch the licensed targets for a user.This is used to build the cache data.
-- Outout Parameters
-- licensable_types_cur_out : Cursor giving licensed targets for the current user.

PROCEDURE get_my_target_licenses
(
    p_license_info OUT cursorType
);

-- Purpose : To fetch the licensable targets and associated packs data
--: This is also used for Search functionality.
-- Input Parameters :
-- p_target_type_array : The target Type selected for view
-- p_target_name_array : The target Name given, if any
-- Outout Parameters
-- p_error_message     : Error Message
-- p_setup_details_cur_out : Cursor giving licensable targets and packs associated data
PROCEDURE get_setup_data
(
    p_target_type           IN varchar2,
    p_target_name           IN varchar2,
    p_error_message         OUT varchar2,
    p_setup_details_cur_out OUT cursorType
);

-- Purpose : Routine Called on Clicking Apply in Target-package Management Screen
-- Input Parameters
-- p_target_array
--   array of target info (type, name, license info (package, is_licensed (0,1)) and agree_access(0,1))
--   0 denotes the checkbox on screen is unselected
-- Out Parameters
-- p_error_message : array of error messages returned to front end, using which Frontend will commit or rollback
-- p_commit_indicator : This will indicate if changes are made in the database.
PROCEDURE apply_packs_to_target
(
    p_target_array       IN  MGMT_TARGET_LICENSE_ARRAY,
    p_error_message      OUT VARCHAR2_TABLE,
    p_commit_indicator   OUT varchar2
);

-- Purpose : To be used to fetch packs for a particular target.
--         : When we do not find the target pack information in the cache data
--         : we use this procedure to fetch the same from the database.
-- Input Parameters
-- p_target_type : Target Type to which the Current Target Belongs To
-- p_target_name : Name of the Target for which the packs are to be fetched
-- Out Parameters
-- p_license_info : cursor giving target ,packs information
PROCEDURE get_licenses_for_target
(
    p_target_type IN VARCHAR,
    p_target_name IN VARCHAR,
    p_license_info OUT cursorType
);

-- Purpose : To be used in "Add_Target" Call Back, to ensure that
--         : we grant license on all applicable packs to the newly added Target
-- Input Parameters
-- p_target_type : Target Type to which the Current Target Belongs To
-- p_target_name : Name of Target being added
-- p_target_guid : GUID of the Target being added
-- As per the new model (Disabling Host Based Licensing), if one target T1 on a host H1 is granted package P1
-- then, the license propogates to the host on which is it resides and
-- does not propogate to the other targets (siblings) hosted on the host H1.
-- For example, if databases D1 and D2 reside on host H1 and package P1 IS granted license on D1
-- In such a case, license on package P1 IS granted to only D1 and not to D2
PROCEDURE auto_license_target
(
   p_target_name VARCHAR2,
   p_target_type VARCHAR2,
   p_target_guid RAW
);

-- Purpose : To be used in "Remove_Target"from Repository Call Back, to ensure that
--         : all license related info related to Target being deleted is removed
-- Need to take care of IAS, DB and all Standalone IAS Dependent Types that can be individually licensed
-- Input Parameters
-- p_target_type : Target Type to which the Current Target Belongs To
-- p_target_name : Name of Target being removed
-- p_target_guid : GUID of the Target which is being removed
PROCEDURE auto_revoke_license_info
(
   p_target_name VARCHAR2,
   p_target_type VARCHAR2,
   p_target_guid RAW
);

-- Purpose : To be used to check whether given packs are available
--         : for a given target
-- Input Parameters
-- p_target_type : Target Type to which the Current Target Belongs To
-- p_target_name : Name of the Target for which the packs are to be checked
-- Out Parameters
-- p_is_licensed : The output parameter.The value returned is TRUE when the
--               : packs are available for the given target,else FALSE.

PROCEDURE check_packs_for_target
(
    p_target_type       IN  VARCHAR2,
    p_target_name       IN  VARCHAR2,
    p_pack_array        IN  VARCHAR2_TABLE,
    p_is_licensed       OUT VARCHAR2
);


-- PROCEDURE: webapp_license_assoc_create
-- Purpose : This is a Callback invoked when a new relationship between a Webapp and its key component is established
-- recalculate License Ino for WebApp, when a key component is added to it
-- Web App and the key component Targets they use, share a "depends on" association
-- IN PARAMETERS: see sdk_assoc_pkgdef
--                     p_assoc_def_name VARCHAR2,
--                     p_source_target_name VARCHAR2,
--                     p_source_target_type VARCHAR2,
--                     p_assoc_target_name  VARCHAR2,
--                     p_assoc_target_type  VARCHAR2,
--                     p_scope_target_name  VARCHAR2,
--                     p_scope_target_type  VARCHAR2;
-- OUT PARAMETER: none
--
PROCEDURE webapp_license_assoc_create
(
    p_assoc_def_name     VARCHAR2,
    p_source_target_name VARCHAR2,
    p_source_target_type VARCHAR2,
    p_assoc_target_name  VARCHAR2,
    p_assoc_target_type  VARCHAR2,
    p_scope_target_name  VARCHAR2,
    p_scope_target_type  VARCHAR2
);
-- PROCEDURE: formapp_license_assoc_create
-- Purpose : This is a Callback invoked when a new relationship between a formapp and its key component is established
-- Presently since webapp and formapp behave similarly formapp_license_assoc_create is a wrapper to webapp_license_assoc_create
PROCEDURE formapp_license_assoc_create
(
    p_assoc_def_name     VARCHAR2,
    p_source_target_name VARCHAR2,
    p_source_target_type VARCHAR2,
    p_assoc_target_name  VARCHAR2,
    p_assoc_target_type  VARCHAR2,
    p_scope_target_name  VARCHAR2,
    p_scope_target_type  VARCHAR2
);

-- PROCEDURE: webapp_license_assoc_delete
-- Purpose : This is a Callback invoked when an existing relationship between a Webapp and its key component is dropeed
-- recalculate License Ino for WebApp, as applicable
-- Web App and the key component Targets they use, share a "depends on" association
-- IN PARAMETERS: see sdk_assoc_pkgdef
--                     p_assoc_def_name VARCHAR2,
--                     p_source_target_name VARCHAR2,
--                     p_source_target_type VARCHAR2,
--                     p_assoc_target_name  VARCHAR2,
--                     p_assoc_target_type  VARCHAR2,
--                     p_scope_target_name  VARCHAR2,
--                     p_scope_target_type  VARCHAR2;
-- OUT PARAMETER: none
--
PROCEDURE webapp_license_assoc_delete
(
    p_assoc_def_name     VARCHAR2,
    p_source_target_name VARCHAR2,
    p_source_target_type VARCHAR2,
    p_assoc_target_name  VARCHAR2,
    p_assoc_target_type  VARCHAR2,
    p_scope_target_name  VARCHAR2,
    p_scope_target_type  VARCHAR2
);
-- PROCEDURE: formapp_license_assoc_delete
-- Purpose : This is a Callback invoked when a new relationship between a formapp and its key component is established
-- Presently since webapp and formapp behave similarly formapp_license_assoc_delete is a wrapper to webapp_license_assoc_delete
PROCEDURE formapp_license_assoc_delete
(
    p_assoc_def_name     VARCHAR2,
    p_source_target_name VARCHAR2,
    p_source_target_type VARCHAR2,
    p_assoc_target_name  VARCHAR2,
    p_assoc_target_type  VARCHAR2,
    p_scope_target_name  VARCHAR2,
    p_scope_target_type  VARCHAR2
);

-- PROCEDURE asm_license_assoc_create
-- Purpose : This is a Callback invoked when an existing relationship between an ASM and an
--           rac instance or a standalone database is created

-- IN PARAMETERS: see sdk_assoc_pkgdef
--                     p_assoc_def_name VARCHAR2,
--                     p_source_target_name VARCHAR2,
--                     p_source_target_type VARCHAR2,
--                     p_assoc_target_name  VARCHAR2,
--                     p_assoc_target_type  VARCHAR2,
--                     p_scope_target_name  VARCHAR2,
--                     p_scope_target_type  VARCHAR2;
-- OUT PARAMETER: none
--
PROCEDURE asm_license_assoc_create
(
    p_assoc_def_name     VARCHAR2,
    p_source_target_name VARCHAR2,
    p_source_target_type VARCHAR2,
    p_assoc_target_name  VARCHAR2,
    p_assoc_target_type  VARCHAR2,
    p_scope_target_name  VARCHAR2,
    p_scope_target_type  VARCHAR2
);


-- PROCEDURE: asm_license_assoc_delete
-- Purpose : This is a Callback invoked when an existing relationship between an ASM and an
--           rac instance or a standalone database is deleted

-- IN PARAMETERS: see sdk_assoc_pkgdef
--                     p_assoc_def_name VARCHAR2,
--                     p_source_target_name VARCHAR2,
--                     p_source_target_type VARCHAR2,
--                     p_assoc_target_name  VARCHAR2,
--                     p_assoc_target_type  VARCHAR2,
--                     p_scope_target_name  VARCHAR2,
--                     p_scope_target_type  VARCHAR2;
-- OUT PARAMETER: none
--
PROCEDURE asm_license_assoc_delete
(
    p_assoc_def_name     VARCHAR2,
    p_source_target_name VARCHAR2,
    p_source_target_type VARCHAR2,
    p_assoc_target_name  VARCHAR2,
    p_assoc_target_type  VARCHAR2,
    p_scope_target_name  VARCHAR2,
    p_scope_target_type  VARCHAR2
);
-- PROCEDURE: get_pack_definition_details
-- Purpose : This procedure is used to retreive the list of package definitions
--           and their corresponding targets types
-- OUT PARAMETER: em_license_def_array
--
PROCEDURE get_pack_definition_details
(
    l_pack_def_types OUT em_license_def_array
);

-- Purpose : To fetch the ALL targets and associated packs data
--: This is also used for Search functionality.
-- Input Parameters : p_target_type,p_target_name
-- Outout Parameters
-- p_error_message     : Error Message
-- p_setup_details_cur_out : Cursor giving licensable targets and packs associated data
PROCEDURE get_ALL_setup_data
(
    p_target_type       IN VARCHAR2,
    p_target_name       IN VARCHAR2,
    p_error_message         OUT varchar2,
    p_setup_details_cur_out OUT cursorType
);
-- Purpose : Routine Called on Clicking Apply in Target-package Management Screen when ALL target types are displayed
-- Input Parameters
-- p_target_array
--   array of target info (type, name, license info (package, is_licensed (0,1)) and agree_access(0,1))
--   0 denotes the checkbox on screen is unselected
-- Out Parameters
-- p_error_message : array of error messages returned to front end, using which Frontend will commit or rollback
-- p_commit_indicator : This will indicate if changes are made in the database.
PROCEDURE apply_packs_to_ALL_target
(
    p_target_array       IN  MGMT_TARGET_LICENSE_ARRAY,
    p_error_message      OUT VARCHAR2_TABLE,
    p_commit_indicator   OUT varchar2
);

-- Procedure : add_pack_definitions
-- Purpose  : To insert pack definitions into mgmt_license_definitions if the pack definition is new
--            or update an existing pack definition if pack definition needs to be changed.
-- Input Parameters
-- pack_label
-- target_type
-- pack_description
-- pack_display_label
-- pack_abbr

-- Output Parameters
PROCEDURE add_pack_definitions
(
    p_pack_label         mgmt_license_definitions.pack_label%TYPE,
    p_target_type        mgmt_license_definitions.target_type%TYPE,
    p_pack_display_label mgmt_license_definitions.pack_display_label%TYPE DEFAULT NULL,
    p_pack_description   mgmt_license_definitions.pack_description%TYPE,
    p_pack_abbr          mgmt_license_definitions.pack_abbr%TYPE
);

-- Procedure : add_licensable_target_types
-- Purpose  : To insert licensable target types into mgmt_licensable_target_types. Check if already present, else insert.
-- Input Parameters
-- pack_target_type
-- target_type

-- Output Parameters
PROCEDURE add_licensable_target_types
(
    p_pack_target_type    mgmt_licensable_target_types.pack_target_type%TYPE,
    p_target_type         mgmt_licensable_target_types.target_type%TYPE
);
-- Procedure:del_licensable_target_types
-- Purpose  :To delete licensable target types into mgmt_licensable_target_types. Check if already present, else delete.
-- Input Parameters : pack_target_type
--                    target_type
-- Output Parameters
PROCEDURE del_licensable_target_types
(
    p_pack_target_type    mgmt_licensable_target_types.pack_target_type%TYPE,
    p_target_type         mgmt_licensable_target_types.target_type%TYPE
);
-- Procedure : add_packs
-- Purpose  : To insert license packs into mgmt_admin_licenses. Check if already present, else insert.
-- Input Parameters
-- pack_name

-- Output Parameters
PROCEDURE add_packs
(
    p_pack_name    mgmt_admin_licenses.pack_name%TYPE
);

-- Procedure : get_license_setup_data
-- Purpose  : To get license packs information for targets.
-- Input Parameters
-- p_target_type       - search criteria for target type 
-- p_target_name       - serach criteria for target name 
-- p_all_targets_packs - flag indicating if user selected All Targets option OR Licensable Targets option
-- p_max_rows          - maximum no. of records to be retrieved
-- Output Parameters
-- p_error_message     - error message is any
-- p_columns_array     - the columns (license pack names) to be rendered on UI
-- p_target_array      - License Pack info for each target selected
PROCEDURE get_license_setup_data
(
    p_target_type  IN VARCHAR2,
    p_target_name  IN VARCHAR2,
    p_all_targets_packs IN VARCHAR2,
    p_max_rows IN NUMBER,
    p_error_message     OUT VARCHAR2,
    p_columns_array   OUT cursorType,
    p_target_array    OUT em_license_pack_array
);

END em_license;
/
