Rem drv: <create type="pkgdefs" pos="license/license_pkgdefs.sql+"/>
Rem
Rem $Header: license_rac_pkgdef.sql 01-jul-2005.17:27:40 gsbhatia Exp $
Rem
Rem license_rac_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      license_rac_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    paachary    02/08/05 - Changed the package name from mgmt_rac_license to em_rac_license
Rem    bram        12/30/04 - bram_rac_lictrans
Rem    bram        12/30/04 - Created
Rem

CREATE OR REPLACE PACKAGE em_rac_license
IS
TYPE cursorType IS REF CURSOR;


-- Function->get_cluster_guid
-- Purpose :Knowing the target_guid of a Cluster Node,find details about the outer cluster
-- Input Parameters
-- p_cluster_node_guid: GUID of the Cluster Node
-- p_target_type: Target Type of the cluster

FUNCTION get_cluster_guid
(
    p_cluster_node_guid IN mgmt_targets.target_guid%TYPE,
    p_target_type       IN mgmt_targets.target_type%TYPE
)
RETURN VARCHAR2;


-- Function->is_racmember
-- Purpose : To check if a target is associated with a rac cluster database
-- Input Parameters
-- p_target_type : Target Type to which the Target whose member needs to be checked
-- p_target_guid : GUID of the target,whose rac membership needs to be checked
-- OUTPUT Parameter 'TRUE' if associated with rac database,'FALSE' if not
FUNCTION  is_racmember
(
    p_target_type   mgmt_targets.target_type%TYPE DEFAULT NULL,
    p_target_guid   mgmt_targets.target_guid%TYPE
)
RETURN BOOLEAN ;


-- Procedure->get_asm_data
-- Purpose : To return the list of ASM associated with a cluster instance or a Standalone Database
-- Input Parameters
-- p_target_guid :Target GUID on which the ASM association needs to be retreived,this(target guid) could
--                either be a cluster instance or that of a standalone database
-- OUTPUT Parameter p_asm_cursor return the list of ASM guid for a given
--                  cluster instance or standalone database
PROCEDURE get_asm_data
(
    p_target_guid IN mgmt_targets.target_guid%TYPE,
    p_asm_cursor  OUT cursorType
);


--
-- PROCEDURE: grant_racdb_licenseinfo
--
-- PURPOSE:
-- 1)Procedure identifies the asscociated members of the cluster database
-- 2)Also grants license on the selected packs to the Cluster database and its members
-- Input Parameters
-- p_target_guid: Cluster Database GUID
-- p_pack_name:   License Pack to be applied
-- Output Parameter:None
PROCEDURE grant_racdb_licenseinfo
(
    p_target_guid IN mgmt_targets.target_guid%TYPE,
    p_pack_name   IN mgmt_licensed_targets.pack_name%TYPE
);
-- PROCEDURE: rac_license_assoc_create
-- Purpose : This  Callback is invoked when a association i.e if a cluser node, or cluster instance
--           or if a asm is created against a existing cluster db
-- Input Parameters
-- p_assoc_def_name
-- p_source_target_name -Target name of the Cluster Db from which the association needs to be remove
-- p_source_target_type -Target type of the Cluster Db  i.e rac_database
-- p_assoc_target_name  --Associate target name whose license info needs to be deleted
-- p_assoc_target_type  --Associate target type whose license info needs to be deleted
-- p_scope_target_name
-- p_scope_target_type
-- Output PARAMETER: none


PROCEDURE rac_license_assoc_create
(
    p_assoc_def_name     VARCHAR2,
    p_source_target_name VARCHAR2,
    p_source_target_type VARCHAR2,
    p_assoc_target_name  VARCHAR2,
    p_assoc_target_type  VARCHAR2,
    p_scope_target_name  VARCHAR2,
    p_scope_target_type  VARCHAR2
);
--
-- PROCEDURE: rac_license_assoc_delete
--
-- PURPOSE:
-- Procedure :This is a callback which is invoked when a assocciation is deleted to
--            a cluster db
-- Input Parameters
-- p_assoc_def_name     --Association def name for which this callback should be called (optional).
  --                      If assoc def name is not specified, then the callback is called
  --                      for associations of all types.
-- p_source_target_name -Target name of the Cluster Db from which the association needs to be remove
-- p_source_target_type -Target type of the Cluster Db  i.e rac_database
-- p_assoc_target_name  --Associate target name whose license info needs to be deleted
-- p_assoc_target_type  --Associate target type whose license info needs to be deleted
-- p_scope_target_name
-- p_scope_target_type
-- OUT PARAMETER: none
PROCEDURE rac_license_assoc_delete
(
    p_assoc_def_name     VARCHAR2,
    p_source_target_name VARCHAR2,
    p_source_target_type VARCHAR2,
    p_assoc_target_name  VARCHAR2,
    p_assoc_target_type  VARCHAR2,
    p_scope_target_name  VARCHAR2,
    p_scope_target_type  VARCHAR2
);
END em_rac_license;
/

