Rem drv: <create type="tables" pos="ip/ip_tables.sql+"/>
Rem
Rem $Header: license_tables.sql 07-sep-2007.00:58:07 ararora Exp $
Rem
Rem license_tables.sql
Rem
Rem Copyright (c) 2004, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      license_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ararora     09/07/07 - increase the size of pack_description
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    paachary    03/03/05 - Moved the tables added newly as part of 10GR2 to 
Rem                           emcore/source/oracle/sysman/emdrep/sql/core/v102010/license/license_tables.sql
Rem                           Any newly added tables should be added in the above path only.
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    sdantkal    02/08/05 - pack description size increased
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    bram        01/28/05 - Added Unique key for MGMT_LICENSE_DEFINITIONS
Rem    sdantkal    01/26/05 - add abbr column to mgmt_license_definition
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    bram        12/30/04 - Modified PK for mgmt_license_definitions
Rem    sdantkal    10/05/04 - remove_fk
Rem    sdantkal    10/05/04 - iot
Rem    sdantkal    09/28/04 - 
Rem    sdantkal    07/26/04 - 
Rem    yaofeng     04/23/04 - add primary keys 
Rem    yaofeng     04/16/04 - yaofeng_bug-3548336 
Rem    jpyang      03/16/04 - Created
Rem

rem
rem MGMT_LICENSE_DEFINITIONS
rem
rem PURPOSE
rem    Stores oracle license packs definition
rem 
rem COLUMNS
rem    PACK_LABEL internal of the pack
rem   
rem    db_diag = Database Diagnostics
rem    db_tuning = Database Tuning
rem    db_config = Database Configuration
rem    db_chgmgt = Database Change Management
rem    as_diag = Application Server Diagnostics
rem    as_config = Application Server Configuration
rem             
rem    TARGET_TYPE internal target type name that the pack is related
rem    PACK_DISPLAY_LABEL display name of pack (english)
rem    PACK_LABEL_NLSID resource bundle id for display name
rem    PACK_DESCRIPTION short description about functionality of the pack
rem    PACK_DESCRIPTION_NLSID resource bundle id for pack description
rem    PACK_ABBR  resource bundle id for pack abbreviation
rem
CREATE TABLE MGMT_LICENSE_DEFINITIONS (
    pack_label              VARCHAR2(64)         NOT NULL,
    target_type             VARCHAR2(64)         NOT NULL,
    pack_display_label      VARCHAR2(128)        DEFAULT ' ',
    pack_label_nlsid        VARCHAR2(64)         DEFAULT ' ',
    pack_description        VARCHAR2(1000)        DEFAULT ' ',
    pack_description_nlsid  VARCHAR2(64)         DEFAULT ' ',
    pack_abbr               VARCHAR2(5)          NOT NULL,
    CONSTRAINT MGMT_LICENSE_DEFINITIONS_PK PRIMARY KEY (pack_label,target_type),   
    CONSTRAINT MGMT_LICENSE_DEFINITIONS_UNQ UNIQUE(pack_abbr,target_type)
   )
  MONITORING;

rem
rem MGMT_ADMIN_LICENSES
rem
rem PURPOSE
rem    Stores super administrator's license pack selection
rem 
rem COLUMNS
rem    PACK_NAME internal name of licensed pack (pack_label)
rem
CREATE TABLE MGMT_ADMIN_LICENSES (
    pack_name VARCHAR2(64) NOT NULL,
    CONSTRAINT MGMT_ADMIN_LICENSES_PK PRIMARY KEY (pack_name))
   MONITORING;
 
rem
rem MGMT_LICENSABLE_TARGET_TYPES
rem
rem PURPOSE
rem    Stores all target types that are affected by licensing model
rem
rem COLUMNS
rem    pack_target_type target type which licensable target types get their 
rem                     from 
rem    types internal target type names that is licensable
rem
CREATE TABLE mgmt_licensable_target_types (
   pack_target_type VARCHAR2(64) NOT NULL,
   target_type    VARCHAR2(64)   NOT NULL,
   CONSTRAINT mgmt_licensable_types_pk PRIMARY KEY (pack_target_type, target_type))
  ORGANIZATION INDEX MONITORING;

Rem Calling the SQL from the migration path 
Rem emcore/source/oracle/sysman/emdrep/sql/core/v102010/license/license_tables.sql
Rem to create the tables added newly as a part of 10GR2.

@&EM_SQL_ROOT/core/v102010/license/license_tables.sql
@&EM_SQL_ROOT/core/10.2.0.4/license/license_tables.sql

