Rem drv: <create type="pkgdefs" pos="license/license_rac_pkgdef.sql+"/>
Rem
Rem $Header: mgmt_license_pkgdef.sql 01-jul-2005.17:28:07 gsbhatia Exp $
Rem
Rem mgmt_license_pkgdef.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      mgmt_license_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    paachary    02/13/05 - paachary_license_api
Rem    paachary    02/10/05 - Created
Rem

CREATE OR REPLACE PACKAGE mgmt_license
AS

-- Procedure : grant_license_with_validation
-- Purpose : This routine can be used to grant licenses on a set of user specified 
--           or all packs to a set of user specified or all targets 
--           belonging to the input licensable target type, as per business rules. 
-- Input Parameters :
--         p_target_type       = Target Type (mandatory field)
--         p_target_name_array = An array of target names
--         p_pack_name_array   = An array of pack names
-- Return Value: 
--         p_transctional_msg_array   = This array contains sucess and failure msgs.
--         p_return_status            = Returns a Number: 0 -> Any failure occured during processing.
--                                                        1 -> If the entire processing is a success.
PROCEDURE grant_license_with_validation
          (
              p_target_type            IN VARCHAR2,
              p_pack_list_array        IN SMP_EMD_STRING_ARRAY DEFAULT NULL,
              p_target_list_array      IN SMP_EMD_STRING_ARRAY DEFAULT NULL,
              p_transctional_msg_array OUT SMP_EMD_STRING_ARRAY,
              p_return_status          OUT NUMBER
          );

-- Procedure : revoke_license_with_validation
-- Purpose : This routine can be used to revoke licenses on a set of user specified 
--           or all packs from a set of user specified or all targets 
--           belonging to the input licensable target type, as per business rules. 
-- Input Parameters :
--         p_target_type       = Target Type (mandatory field)
--         p_target_name_array = An array of target names
--         p_pack_name_array   = An array of pack names
-- Return Value: 
--         p_transctional_msg_array   = This array contains sucess and failure msgs.
--         p_return_status            = Returns a Number: 0 -> Any failure occured during processing.
--                                                        1 -> If the entire processing is a success.
PROCEDURE revoke_license_with_validation
          (
              p_target_type            IN VARCHAR2,
              p_pack_list_array        IN SMP_EMD_STRING_ARRAY DEFAULT NULL,
              p_target_list_array      IN SMP_EMD_STRING_ARRAY DEFAULT NULL,
              p_transctional_msg_array OUT SMP_EMD_STRING_ARRAY,
              p_return_status          OUT NUMBER
          );

-- Procedure : grant_license_no_validation
-- Purpose : This routine can be used to grant licenses on a set of user specified 
--           or all packs to a set of user specified or all targets 
--           belonging to the input licensable target type. 
--           This routine does not follow business rules governing licesning rules 
-- Input Parameters :
--         p_target_type       = Target Type (mandatory field)
--         p_target_name_array = An array of target names
--         p_pack_name_array   = An array of pack names
-- Return Value: 
--         p_transctional_msg_array   = This array contains sucess and failure msgs.
--         p_return_status            = Returns a Number: 0 -> Any failure occured during processing.
--                                                        1 -> If the entire processing is a success.
PROCEDURE grant_license_no_validation
          (
              p_target_type            IN VARCHAR2,
              p_pack_list_array        IN SMP_EMD_STRING_ARRAY DEFAULT NULL,
              p_target_list_array      IN SMP_EMD_STRING_ARRAY DEFAULT NULL,
              p_transctional_msg_array OUT SMP_EMD_STRING_ARRAY,
              p_return_status          OUT NUMBER
          );

-- Procedure : revoke_license_no_validation
-- Purpose : This routine can be used to revoke licenses on a set of user specified 
--           or all packs from a set of user specified or all targets 
--           belonging to the input licensable target type. 
--           This routine does not follow business rules governing licesning rules 
-- Input Parameters :
--         p_target_type       = Target Type (mandatory field)
--         p_target_name_array = An array of target names
--         p_pack_name_array   = An array of pack names
-- Return Value: 
--         p_transctional_msg_array   = This array contains sucess and failure msgs.
--         p_return_status            = Returns a Number: 0 -> Any failure occured during processing.
--                                                        1 -> If the entire processing is a success.
PROCEDURE revoke_license_no_validation
          (
              p_target_type            IN VARCHAR2,
              p_pack_list_array        IN SMP_EMD_STRING_ARRAY DEFAULT NULL,
              p_target_list_array      IN SMP_EMD_STRING_ARRAY DEFAULT NULL,
              p_transctional_msg_array OUT SMP_EMD_STRING_ARRAY,
              p_return_status          OUT NUMBER
          );

END MGMT_LICENSE;
/

SHOW ERRORS;
