Rem drv: <create type="views" pos="jobs/jobs_views.sql+"/>
Rem
Rem $Header: mgmt_license_views.sql 01-jul-2005.18:43:46 gsbhatia Exp $
Rem
Rem mgmt_license_views.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      mgmt_license_views.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem     gsbhatia   07/01/05 - New repmgr header impl 
Rem     gsbhatia   06/26/05 - New repmgr header impl 
Rem     paachary   02/10/05 - 
Rem     gsbhatia   02/07/05 - updating repmgr header 
Rem     ktlaw      01/11/05 - add repmgr header 
Rem     sdantkal   12/03/04 - sdantkal_bug4033907
Rem     sdantkal   11/30/04 - Created
Rem

rem
rem  PURPOSE
rem
rem     The MGMT_LICENSE VIEW
rem
rem  COLUMNS
rem
rem     TARGET_NAME   - Name of the Target to which the Pack License is granted
rem     TARGET_TYPE   - Target Type to which the Current Target Belongs To
rem     PACK_NAME     - Name of the Pack on which License is granted          
rem     PARENT_TARGET_NAME -Name of the Parent of the given target
rem     PARENT_TARGET_TYPE -Target Type of the Parent of the given target
rem  NOTES
rem

CREATE OR REPLACE VIEW MGMT_LICENSE_VIEW 
(    TARGET_NAME, 
     TARGET_TYPE, 
     PACK_NAME, 
     PARENT_TARGET_NAME, 
     PARENT_TARGET_TYPE
) AS
SELECT a.target_name,
    a.target_type,
    b.pack_name,
    decode(c.target_name, a.target_name, null, c.target_name) 
    parent_target_name,
    decode(c.target_type, a.target_type, null, c.target_type) 
    parent_target_type
FROM mgmt_targets a, 
    mgmt_licensed_targets b,  
    mgmt_targets c
WHERE 
    b.target_guid=a.target_guid AND 
    b.from_target_guid=c.target_guid;
